/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.abduction;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.abduction.MaximumUniversalSetComputation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.Set;
import java.util.function.ToIntFunction;

public class Abducer {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final ToIntFunction<TermVariable> mCost;
    private final Set<TermVariable> mForbiddenVars;
    private final boolean mStrongQuantifierElimination;

    public Abducer(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this(iUltimateServiceProvider, managedScript, Collections.emptySet(), false);
    }

    public Abducer(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl) {
        this(iUltimateServiceProvider, managedScript, Collections.emptySet(), bl);
    }

    public Abducer(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Set<TermVariable> set) {
        this(iUltimateServiceProvider, managedScript, set, false);
    }

    public Abducer(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Set<TermVariable> set, boolean bl) {
        this(iUltimateServiceProvider, managedScript, termVariable -> 1, set, bl);
    }

    public Abducer(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, ToIntFunction<TermVariable> toIntFunction, Set<TermVariable> set, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Abducer.class);
        this.mScript = managedScript;
        this.mCost = toIntFunction;
        this.mForbiddenVars = set;
        this.mStrongQuantifierElimination = bl;
    }

    public Term abduce(Term term, Term term2) {
        Term term3 = this.solveAbductionProblem(SmtUtils.implies(this.mScript.getScript(), term, term2), term);
        assert (this.checkResult(term, term2, term3, false)) : "Abduction failed";
        return term3;
    }

    public Term abduceEquivalence(Term term, Term term2) {
        Term term3 = SmtUtils.binaryBooleanEquality(this.mScript.getScript(), term, term2);
        Term term4 = SmtUtils.or(this.mScript.getScript(), term, term2);
        Term term5 = this.solveAbductionProblem(term3, term4);
        assert (this.checkResult(term, term2, term5, true)) : "Abduction failed";
        return term5;
    }

    private Term solveAbductionProblem(Term term, Term term2) {
        Term term3 = this.tryEliminateForall(this.mForbiddenVars, term);
        Script.LBool lBool = SmtUtils.checkSatTerm(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), term2, term3));
        if (lBool != Script.LBool.SAT) {
            return null;
        }
        Term term4 = new MaximumUniversalSetComputation(this.mServices, this.mScript, term3, term2, this.mCost).getQuantifiedFormula();
        return SmtUtils.simplify(this.mScript, term4, term2, this.mServices, SIMPLIFICATION_TECHNIQUE);
    }

    private Term tryEliminateForall(Set<TermVariable> set, Term term) {
        Term term2 = SmtUtils.quantifier(this.mScript.getScript(), 1, set, term);
        if (this.mStrongQuantifierElimination) {
            return PartialQuantifierElimination.eliminate(this.mServices, this.mScript, term2, SIMPLIFICATION_TECHNIQUE);
        }
        return PartialQuantifierElimination.eliminateLight(this.mServices, this.mScript, term2);
    }

    private boolean checkResult(Term term, Term term2, Term term3, boolean bl) {
        Script.LBool lBool;
        if (term3 == null) {
            return true;
        }
        if (bl) {
            lBool = SmtUtils.checkSatTerm(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), term3, SmtUtils.binaryBooleanNotEquals(this.mScript.getScript(), term, term2)));
            assert (lBool != Script.LBool.SAT) : "Abduction failed: solution " + String.valueOf(term3) + " does not imply equivalence of " + String.valueOf(term) + " and " + String.valueOf(term2);
        } else {
            lBool = SmtUtils.checkSatTerm(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), term, term3, SmtUtils.not(this.mScript.getScript(), term2)));
            assert (lBool != Script.LBool.SAT) : "Abduction failed: premise " + String.valueOf(term) + " and solution " + String.valueOf(term3) + " do not imply conclusion " + String.valueOf(term2);
        }
        Script.LBool lBool2 = SmtUtils.checkSatTerm(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), term, term3));
        assert (lBool2 != Script.LBool.UNSAT) : "Abduction failed: LHS " + String.valueOf(term) + " and solution " + String.valueOf(term3) + " are inconsistent";
        return lBool != Script.LBool.SAT && lBool2 != Script.LBool.UNSAT;
    }
}

