/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespaceScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPNamespace
extends PlatformObject
implements ICPPNamespace,
ICPPInternalBinding {
    IASTName[] namespaceDefinitions;
    ICPPNamespaceScope scope;
    ICPPASTTranslationUnit tu;

    public CPPNamespace(ICPPASTNamespaceDefinition nsDef) {
        this.findAllDefinitions(nsDef);
        if (this.namespaceDefinitions.length == 0) {
            this.namespaceDefinitions = new IASTName[]{nsDef.getName()};
        }
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.namespaceDefinitions;
    }

    @Override
    public IASTNode getDefinition() {
        return this.tu != null ? this.tu : this.namespaceDefinitions[0];
    }

    private void findAllDefinitions(ICPPASTNamespaceDefinition namespaceDef) {
        NamespaceCollector collector = new NamespaceCollector(namespaceDef);
        namespaceDef.getTranslationUnit().accept(collector);
        IASTName[] iASTNameArray = this.namespaceDefinitions = collector.getNamespaces();
        int n = this.namespaceDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName namespaceDefinition = iASTNameArray[n2];
            namespaceDefinition.setBinding(this);
            ++n2;
        }
    }

    public IASTName[] getNamespaceDefinitions() {
        return this.namespaceDefinitions;
    }

    public CPPNamespace(CPPASTTranslationUnit unit) {
        this.tu = unit;
    }

    @Override
    public ICPPNamespaceScope getNamespaceScope() {
        if (this.scope == null) {
            this.scope = this.tu != null ? (ICPPNamespaceScope)this.tu.getScope() : new CPPNamespaceScope(this.namespaceDefinitions[0].getParent());
        }
        return this.scope;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.tu != null ? CharArrayUtils.EMPTY_CHAR_ARRAY : this.namespaceDefinitions[0].getSimpleID();
    }

    @Override
    public IScope getScope() {
        return this.tu != null ? null : CPPVisitor.getContainingScope(this.namespaceDefinitions[0]);
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() {
        return true;
    }

    @Override
    public void addDefinition(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.namespaceDefinitions == null) {
            this.namespaceDefinitions = new IASTName[]{name};
            return;
        }
        this.namespaceDefinitions = this.namespaceDefinitions.length > 0 && ((ASTNode)((Object)name)).getOffset() < ((ASTNode)((Object)this.namespaceDefinitions[0])).getOffset() ? ArrayUtil.prepend(IASTName.class, this.namespaceDefinitions, name) : ArrayUtil.append(IASTName.class, this.namespaceDefinitions, name);
    }

    @Override
    public void addDeclaration(IASTNode node) {
        this.addDefinition(node);
    }

    @Override
    public IBinding[] getMemberBindings() {
        if (this.namespaceDefinitions != null) {
            NamespaceMemberCollector collector = new NamespaceMemberCollector();
            IASTName[] iASTNameArray = this.namespaceDefinitions;
            int n = this.namespaceDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName namespaceDefinition = iASTNameArray[n2];
                IASTNode parent = namespaceDefinition.getParent();
                if (parent instanceof ICPPASTNamespaceDefinition) {
                    IASTDeclaration[] decls;
                    IASTDeclaration[] iASTDeclarationArray = decls = ((ICPPASTNamespaceDefinition)parent).getDeclarations();
                    int n3 = decls.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTDeclaration decl = iASTDeclarationArray[n4];
                        decl.accept(collector);
                        ++n4;
                    }
                }
                ++n2;
            }
            return collector.members.keyArray(IBinding.class);
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public boolean isInline() {
        ICPPNamespaceScope nsScope = this.getNamespaceScope();
        if (nsScope instanceof CPPNamespaceScope) {
            return ((CPPNamespaceScope)nsScope).isInlineNamepace();
        }
        return false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public String toString() {
        String[] names = this.getQualifiedName();
        if (names.length == 0) {
            return "<global namespace>";
        }
        StringBuilder buf = new StringBuilder();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (buf.length() != 0) {
                buf.append(Keywords.cpCOLONCOLON);
            }
            buf.append(name.isEmpty() ? "<anonymous>" : name);
            ++n2;
        }
        return buf.toString();
    }

    @Override
    public IBinding getOwner() {
        if (this.namespaceDefinitions != null && this.namespaceDefinitions.length > 0) {
            return CPPVisitor.findDeclarationOwner(this.namespaceDefinitions[0], false);
        }
        return null;
    }

    public static class CPPNamespaceProblem
    extends ProblemBinding
    implements ICPPNamespace,
    ICPPNamespaceScope {
        public CPPNamespaceProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        @Override
        public ICPPNamespaceScope getNamespaceScope() {
            return this;
        }

        @Override
        public IBinding[] getMemberBindings() {
            return IBinding.EMPTY_BINDING_ARRAY;
        }

        @Override
        public void addUsingDirective(ICPPUsingDirective usingDirective) {
        }

        @Override
        public ICPPUsingDirective[] getUsingDirectives() {
            return ICPPUsingDirective.EMPTY_ARRAY;
        }

        @Override
        public ICPPNamespaceScope[] getInlineNamespaces() {
            return ICPPNamespaceScope.EMPTY_NAMESPACE_SCOPE_ARRAY;
        }
    }

    private static class NamespaceCollector
    extends ASTVisitor {
        private ICPPASTNamespaceDefinition namespaceDef;
        private IASTName[] namespaces;

        public NamespaceCollector(ICPPASTNamespaceDefinition ns) {
            this.shouldVisitNamespaces = true;
            this.shouldVisitDeclarations = true;
            this.namespaceDef = ns;
        }

        @Override
        public int visit(ICPPASTNamespaceDefinition namespace) {
            ICPPASTNamespaceDefinition orig = this.namespaceDef;
            for (ICPPASTNamespaceDefinition candidate = namespace; candidate != null; candidate = (ICPPASTNamespaceDefinition)candidate.getParent()) {
                if (!CharArrayUtils.equals(orig.getName().getLookupKey(), candidate.getName().getLookupKey())) {
                    return 3;
                }
                if (orig.getParent() instanceof ICPPASTNamespaceDefinition) {
                    if (!(candidate.getParent() instanceof ICPPASTNamespaceDefinition)) {
                        return 3;
                    }
                    orig = (ICPPASTNamespaceDefinition)orig.getParent();
                    continue;
                }
                if (!(candidate.getParent() instanceof ICPPASTNamespaceDefinition)) break;
                return 3;
            }
            this.namespaces = ArrayUtil.append(IASTName.class, this.namespaces, namespace.getName());
            return 1;
        }

        @Override
        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof ICPPASTLinkageSpecification) {
                return 3;
            }
            return 1;
        }

        public IASTName[] getNamespaces() {
            return ArrayUtil.trim(IASTName.class, this.namespaces);
        }
    }

    private static class NamespaceMemberCollector
    extends ASTVisitor {
        public ObjectSet<IBinding> members = new ObjectSet(8);

        public NamespaceMemberCollector() {
            this.shouldVisitNamespaces = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarations = true;
        }

        @Override
        public int visit(IASTDeclarator declarator) {
            while (declarator.getNestedDeclarator() != null) {
                declarator = declarator.getNestedDeclarator();
            }
            IBinding binding = declarator.getName().resolveBinding();
            if (binding != null && !(binding instanceof IProblemBinding)) {
                this.members.put(binding);
            }
            return 1;
        }

        @Override
        public int visit(IASTDeclSpecifier declSpec) {
            IASTNode parent;
            if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                IBinding binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && (parent = declSpec.getParent()) instanceof IASTSimpleDeclaration) {
                if (((IASTSimpleDeclaration)parent).getDeclarators().length > 0) {
                    return 1;
                }
                IBinding binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            return 1;
        }

        @Override
        public int visit(ICPPASTNamespaceDefinition namespace) {
            IBinding binding = namespace.getName().resolveBinding();
            if (binding != null && !(binding instanceof IProblemBinding)) {
                this.members.put(binding);
            }
            return 1;
        }

        @Override
        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof ICPPASTUsingDeclaration) {
                IBinding binding = ((ICPPASTUsingDeclaration)declaration).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            if (declaration instanceof IASTFunctionDefinition) {
                return this.visit(((IASTFunctionDefinition)declaration).getDeclarator());
            }
            return 3;
        }
    }
}

