/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DivisibilityPredicateGenerator {
    private final Script mScript;
    private final IPredicateUnifier mPredicateUnifier;

    public DivisibilityPredicateGenerator(ManagedScript managedScript, IPredicateUnifier iPredicateUnifier) {
        this.mScript = managedScript.getScript();
        this.mPredicateUnifier = iPredicateUnifier;
    }

    public Collection<IPredicate> divisibilityPredicates(Collection<IPredicate> collection) {
        List list2;
        HashMap<List, Integer> hashMap = new HashMap<List, Integer>();
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
        for (IPredicate object : collection) {
            Integer n;
            for (List list2 : object.getVars()) {
                if (!this.isOffsetVar((IProgramVar)list2)) continue;
                int n2 = this.getSize((IProgramVar)list2);
                n = hashMap.put(list2, n2);
                assert (n == null || n == n2);
            }
            list2 = MultiDimensionalSelect.extractSelectDeep((Term)object.getFormula());
            for (IPredicate iPredicate : list2) {
                if (!this.isLengthArray(iPredicate.getArray())) continue;
                n = this.getDivisibilityTerm(iPredicate.toTerm(this.mScript), 4);
                IPredicate iPredicate2 = this.mPredicateUnifier.getOrConstructPredicate((Term)n);
                arrayList.add(iPredicate2);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            IPredicate iPredicate;
            list2 = this.getDivisibilityTerm((Term)((IProgramVar)entry.getKey()).getTermVariable(), (Integer)entry.getValue());
            iPredicate = this.mPredicateUnifier.getOrConstructPredicate((Term)list2);
            arrayList.add(iPredicate);
        }
        return arrayList;
    }

    private int getSize(IProgramVar iProgramVar) {
        return 4;
    }

    private boolean isOffsetVar(IProgramVar iProgramVar) {
        if (SmtSortUtils.isIntSort((Sort)iProgramVar.getTermVariable().getSort())) {
            return iProgramVar.getGloballyUniqueId().contains("offset");
        }
        return false;
    }

    private boolean isLengthArray(Term term) {
        if (term instanceof TermVariable) {
            TermVariable termVariable = (TermVariable)term;
            return termVariable.toString().contains("#length");
        }
        return false;
    }

    private Term getDivisibilityTerm(Term term, Integer n) {
        Term term2 = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.valueOf(n.intValue()));
        Term term3 = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ZERO);
        Term term4 = SmtUtils.binaryEquality((Script)this.mScript, (Term)this.mScript.term("mod", new Term[]{term, term2}), (Term)term3);
        return term4;
    }
}

