/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.util.LazyInt;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.CanonicalLatticeForMaps;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IntLattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.UpsideDownLattice;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SleepMap<L, S> {
    private final List<IIndependenceRelation<S, L>> mRelations;
    private final Map<L, Integer> mSleepMap;
    private final LazyInt mHash;

    private SleepMap(List<IIndependenceRelation<S, L>> list, Map<L, Integer> map) {
        assert (!list.isEmpty()) : "Sleep maps must have at least one independence relation.";
        this.mRelations = list;
        this.mSleepMap = map;
        this.mHash = new LazyInt(this.mSleepMap::hashCode);
    }

    public boolean contains(L l) {
        return this.mSleepMap.containsKey(l);
    }

    public int getPrice(L l) {
        if (this.contains(l)) {
            return this.mSleepMap.get(l);
        }
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.mHash.get();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SleepMap sleepMap = (SleepMap)object;
        return this.mRelations == sleepMap.mRelations && Objects.equals(this.mSleepMap, sleepMap.mSleepMap);
    }

    public SleepMap<L, S> computeSuccessor(S s, L l, Map<L, Integer> map, int n) {
        L l2;
        HashMap<L, Integer> hashMap = new HashMap<L, Integer>();
        for (Map.Entry<L, Integer> entry : this.mSleepMap.entrySet()) {
            l2 = entry.getKey();
            assert (!hashMap.containsKey(l2)) : "budget should not be computed twice";
            Integer n2 = map.get(l2);
            int n3 = n2 == null ? entry.getValue() : Integer.min(n2, entry.getValue());
            Integer n4 = this.minimumRelation(s, l, l2, n3, n);
            if (n4 == null) continue;
            assert (n4 <= n) : "computed price is not constrained by budget";
            hashMap.put(l2, n4);
        }
        for (Map.Entry<L, Integer> entry : map.entrySet()) {
            l2 = entry.getKey();
            if (this.mSleepMap.containsKey(l2)) continue;
            assert (!hashMap.containsKey(l2)) : "budget should not be computed twice";
            assert (!this.mSleepMap.containsKey(l2));
            int n5 = entry.getValue();
            Integer n6 = this.minimumRelation(s, l, l2, n5, n);
            if (n6 == null) continue;
            assert (n6 <= n) : "computed price is not constrained by budget";
            hashMap.put(l2, n6);
        }
        return new SleepMap<L, S>(this.mRelations, Map.copyOf(hashMap));
    }

    private Integer minimumRelation(S s, L l, L l2, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            if (this.mRelations.get(n3).isIndependent(s, l, l2) == IIndependenceRelation.Dependence.INDEPENDENT) {
                return n3;
            }
            ++n3;
        }
        return null;
    }

    public static <L, S> SleepMap<L, S> empty(List<IIndependenceRelation<S, L>> list) {
        return new SleepMap<L, S>(list, Collections.emptyMap());
    }

    public static final class Lattice<L, S>
    implements ILattice<SleepMap<L, S>> {
        private final List<IIndependenceRelation<S, L>> mRelations;
        private final ILattice<Map<L, Integer>> mMapLattice = new CanonicalLatticeForMaps((ILattice)new UpsideDownLattice((ILattice)new IntLattice()));

        public Lattice(List<IIndependenceRelation<S, L>> list) {
            this.mRelations = list;
        }

        public IPartialComparator.ComparisonResult compare(SleepMap<L, S> sleepMap, SleepMap<L, S> sleepMap2) {
            if (sleepMap.mRelations != this.mRelations || sleepMap2.mRelations != this.mRelations) {
                throw new IllegalArgumentException("Cannot compare maps with different relations");
            }
            return this.mMapLattice.compare(sleepMap.mSleepMap, sleepMap2.mSleepMap);
        }

        public SleepMap<L, S> infimum(SleepMap<L, S> sleepMap, SleepMap<L, S> sleepMap2) {
            if (sleepMap.mRelations != this.mRelations || sleepMap2.mRelations != this.mRelations) {
                throw new IllegalArgumentException("Cannot compute infimum for maps with different relations");
            }
            return new SleepMap(sleepMap.mRelations, (Map)this.mMapLattice.infimum(sleepMap.mSleepMap, sleepMap2.mSleepMap));
        }

        public SleepMap<L, S> supremum(SleepMap<L, S> sleepMap, SleepMap<L, S> sleepMap2) {
            if (sleepMap.mRelations != this.mRelations || sleepMap2.mRelations != this.mRelations) {
                throw new IllegalArgumentException("Cannot compute supremum for maps with different relations");
            }
            return new SleepMap(sleepMap.mRelations, (Map)this.mMapLattice.supremum(sleepMap.mSleepMap, sleepMap2.mSleepMap));
        }

        public SleepMap<L, S> getBottom() {
            return SleepMap.empty(this.mRelations);
        }

        public SleepMap<L, S> getTop() {
            throw new UnsupportedOperationException();
        }
    }
}

