/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TreeAutomatonBU<LETTER extends IRankedLetter, STATE>
implements ITreeAutomatonBU<LETTER, STATE> {
    private final Set<LETTER> mAlphabet;
    private final Map<STATE, Map<LETTER, Collection<TreeAutomatonRule<LETTER, STATE>>>> mChildrenMap = new HashMap<STATE, Map<LETTER, Collection<TreeAutomatonRule<LETTER, STATE>>>>();
    private final Set<STATE> mFinalStates;
    private final Map<LETTER, Collection<TreeAutomatonRule<LETTER, STATE>>> mLettersMap;
    private final Map<List<STATE>, Map<LETTER, Collection<TreeAutomatonRule<LETTER, STATE>>>> mParentsMap = new HashMap<List<STATE>, Map<LETTER, Collection<TreeAutomatonRule<LETTER, STATE>>>>();
    private final Set<TreeAutomatonRule<LETTER, STATE>> mRules;
    private final Map<STATE, Collection<TreeAutomatonRule<LETTER, STATE>>> mSourceMap;
    private final Set<STATE> mStates;

    public TreeAutomatonBU() {
        this.mAlphabet = new HashSet<LETTER>();
        this.mLettersMap = new HashMap<LETTER, Collection<TreeAutomatonRule<LETTER, STATE>>>();
        this.mSourceMap = new HashMap<STATE, Collection<TreeAutomatonRule<LETTER, STATE>>>();
        this.mRules = new HashSet<TreeAutomatonRule<LETTER, STATE>>();
        this.mFinalStates = new HashSet<STATE>();
        this.mStates = new HashSet<STATE>();
    }

    public void addFinalState(STATE STATE) {
        this.mFinalStates.add(STATE);
        this.addState(STATE);
    }

    public void addLetter(LETTER LETTER) {
        this.mAlphabet.add(LETTER);
    }

    @Override
    public void addRule(TreeAutomatonRule<LETTER, STATE> treeAutomatonRule) {
        Map<LETTER, Collection<TreeAutomatonRule<LETTER, STATE>>> map;
        Object object2;
        if (this.mRules.contains(treeAutomatonRule)) {
            return;
        }
        this.mRules.add(treeAutomatonRule);
        LETTER LETTER = treeAutomatonRule.getLetter();
        STATE STATE = treeAutomatonRule.getDest();
        List<STATE> list = treeAutomatonRule.getSource();
        assert (LETTER.getRank() == treeAutomatonRule.getSource().size());
        if (LETTER.getRank() != treeAutomatonRule.getSource().size()) {
            System.err.println(String.valueOf(LETTER) + " " + String.valueOf(treeAutomatonRule));
        }
        this.addLetter(LETTER);
        this.addState(STATE);
        for (Object object2 : list) {
            this.addState(object2);
        }
        if (!this.mChildrenMap.containsKey(STATE)) {
            this.mChildrenMap.put(STATE, new HashMap());
        }
        if (!(object2 = this.mChildrenMap.get(STATE)).containsKey(LETTER)) {
            object2.put(LETTER, new HashSet());
        }
        HashSet hashSet = (HashSet)object2.get(LETTER);
        hashSet.add(treeAutomatonRule);
        if (!this.mParentsMap.containsKey(list)) {
            this.mParentsMap.put(list, new HashMap());
        }
        if (!(map = this.mParentsMap.get(list)).containsKey(LETTER)) {
            map.put(LETTER, new HashSet());
        }
        Set set = (Set)map.get(LETTER);
        set.add(treeAutomatonRule);
        if (!this.mLettersMap.containsKey(LETTER)) {
            this.mLettersMap.put(LETTER, new HashSet());
        }
        HashSet hashSet2 = (HashSet)this.mLettersMap.get(LETTER);
        hashSet2.add(treeAutomatonRule);
        for (STATE STATE2 : list) {
            if (!this.mSourceMap.containsKey(STATE2)) {
                this.mSourceMap.put(STATE2, new HashSet());
            }
            HashSet hashSet3 = (HashSet)this.mSourceMap.get(STATE2);
            hashSet3.add(treeAutomatonRule);
        }
    }

    public void addState(STATE STATE) {
        this.mStates.add(STATE);
    }

    @Override
    public void complementFinals() {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (STATE STATE : this.mStates) {
            if (this.isFinalState(STATE)) continue;
            hashSet.add(STATE);
        }
        this.mFinalStates.clear();
        this.mFinalStates.addAll(hashSet);
    }

    public String DebugString() {
        StringBuilder stringBuilder3;
        StringBuilder stringBuilder2 = new StringBuilder();
        for (StringBuilder stringBuilder3 : this.mStates) {
            stringBuilder2.append(this.stateString(stringBuilder3));
            stringBuilder2.append(" ");
        }
        stringBuilder3 = new StringBuilder();
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.mRules) {
            stringBuilder3.append(String.format("%s%s ~~> %s\n", treeAutomatonRule.getLetter(), treeAutomatonRule.getSource(), this.stateString(treeAutomatonRule.getDest())));
        }
        return String.valueOf(stringBuilder2) + "\n" + String.valueOf(stringBuilder3);
    }

    public void extendAlphabet(Collection<LETTER> collection) {
        this.mAlphabet.addAll(collection);
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mAlphabet;
    }

    @Override
    public int getAmountOfRules() {
        return this.mRules.size();
    }

    public Set<STATE> getFinalStates() {
        return this.mFinalStates;
    }

    public Map<LETTER, Iterable<List<STATE>>> getPredecessors(STATE STATE) {
        if (!this.mChildrenMap.containsKey(STATE)) {
            return new HashMap();
        }
        HashMap hashMap = new HashMap();
        for (IRankedLetter iRankedLetter : this.mChildrenMap.get(STATE).keySet()) {
            HashSet<List<STATE>> hashSet = new HashSet<List<STATE>>();
            for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.mChildrenMap.get(STATE).get(iRankedLetter)) {
                hashSet.add(treeAutomatonRule.getSource());
            }
            hashMap.put(iRankedLetter, hashSet);
        }
        return hashMap;
    }

    public Iterable<List<STATE>> getPredecessors(STATE STATE, LETTER LETTER) {
        if (!this.mChildrenMap.containsKey(STATE) || !this.mChildrenMap.get(STATE).containsKey(LETTER)) {
            return new ArrayList<List<STATE>>();
        }
        HashSet<List<STATE>> hashSet = new HashSet<List<STATE>>();
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.mChildrenMap.get(STATE).get(LETTER)) {
            hashSet.add(treeAutomatonRule.getSource());
        }
        return hashSet;
    }

    public Iterable<TreeAutomatonRule<LETTER, STATE>> getRules() {
        return this.mRules;
    }

    @Override
    public Iterable<TreeAutomatonRule<LETTER, STATE>> getSuccessors(LETTER LETTER) {
        HashSet<TreeAutomatonRule<LETTER, STATE>> hashSet = new HashSet<TreeAutomatonRule<LETTER, STATE>>();
        for (List<STATE> list : this.getSourceCombinations()) {
            for (STATE STATE : this.getSuccessors(list, LETTER)) {
                hashSet.add(new TreeAutomatonRule<LETTER, STATE>(LETTER, list, STATE));
            }
        }
        return hashSet;
    }

    public Iterable<TreeAutomatonRule<LETTER, STATE>> getRulesBySource(STATE STATE) {
        return this.mSourceMap.get(STATE);
    }

    @Override
    public Set<STATE> getStates() {
        return this.mStates;
    }

    @Override
    public Iterable<TreeAutomatonRule<LETTER, STATE>> getSuccessors(List<STATE> list) {
        HashSet<TreeAutomatonRule<LETTER, STATE>> hashSet = new HashSet<TreeAutomatonRule<LETTER, STATE>>();
        for (IRankedLetter iRankedLetter : this.mParentsMap.get(list).keySet()) {
            hashSet.addAll(this.mParentsMap.get(list).get(iRankedLetter));
        }
        return hashSet;
    }

    @Override
    public Iterable<STATE> getSuccessors(List<STATE> list, LETTER LETTER) {
        if (!this.mParentsMap.containsKey(list) || !this.mParentsMap.get(list).containsKey(LETTER)) {
            return new HashSet();
        }
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.mParentsMap.get(list).get(LETTER)) {
            hashSet.add(treeAutomatonRule.getDest());
        }
        return hashSet;
    }

    @Override
    public boolean isFinalState(STATE STATE) {
        return this.mFinalStates.contains(STATE);
    }

    public <ST> TreeAutomatonBU<LETTER, ST> reconstruct(Map<STATE, ST> map) {
        TreeAutomatonBU treeAutomatonBU = new TreeAutomatonBU();
        treeAutomatonBU.extendAlphabet(this.mAlphabet);
        for (STATE object : this.mStates) {
            treeAutomatonBU.addState(map.get(object));
            if (!this.isFinalState(object)) continue;
            treeAutomatonBU.addFinalState(map.get(object));
        }
        for (TreeAutomatonRule treeAutomatonRule : this.mRules) {
            Object object2;
            ArrayList<ST> arrayList = new ArrayList<ST>();
            for (Object object2 : treeAutomatonRule.getSource()) {
                arrayList.add(map.get(object2));
            }
            object2 = map.get(treeAutomatonRule.getDest());
            treeAutomatonBU.addRule(new TreeAutomatonRule(treeAutomatonRule.getLetter(), arrayList, object2));
        }
        return treeAutomatonBU;
    }

    public void removeState(STATE STATE) {
        HashSet<TreeAutomatonRule<LETTER, STATE>> hashSet = new HashSet<TreeAutomatonRule<LETTER, STATE>>();
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.mRules) {
            if (!this.ruleContains(treeAutomatonRule, STATE)) continue;
            hashSet.add(treeAutomatonRule);
        }
        for (Map.Entry entry : this.mParentsMap.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                ((Collection)entry2.getValue()).removeAll(hashSet);
            }
        }
        for (Map.Entry entry : this.mChildrenMap.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                ((Collection)entry2.getValue()).removeAll(hashSet);
            }
        }
        for (Map.Entry entry : this.mLettersMap.entrySet()) {
            ((Collection)entry.getValue()).removeAll(hashSet);
        }
        for (Map.Entry entry : this.mSourceMap.entrySet()) {
            ((Collection)entry.getValue()).removeAll(hashSet);
        }
        this.mRules.removeAll(hashSet);
        this.mStates.remove(STATE);
        this.mFinalStates.remove(STATE);
    }

    @Override
    public int size() {
        return this.mStates.size();
    }

    @Override
    public String sizeInformation() {
        return this.size() + " nodes";
    }

    public String toString() {
        Object object42;
        Object object222;
        Object object322;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object322 : this.mAlphabet) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append('\"');
            stringBuilder.append(object322);
            stringBuilder.append('\"');
        }
        object322 = new StringBuilder();
        for (Object object222 : this.mStates) {
            if (((StringBuilder)object322).length() > 0) {
                ((StringBuilder)object322).append(" ");
            }
            ((StringBuilder)object322).append('\"');
            ((StringBuilder)object322).append(object222);
            ((StringBuilder)object322).append('\"');
        }
        object222 = new StringBuilder();
        for (Object object42 : this.mFinalStates) {
            if (((StringBuilder)object222).length() > 0) {
                ((StringBuilder)object222).append(" ");
            }
            ((StringBuilder)object222).append('\"');
            ((StringBuilder)object222).append(object42);
            ((StringBuilder)object222).append('\"');
        }
        object42 = new StringBuilder();
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.getRules()) {
            StringBuilder stringBuilder22;
            if (((StringBuilder)object42).length() > 0) {
                ((StringBuilder)object42).append("\n");
            }
            StringBuilder stringBuilder3 = new StringBuilder();
            for (StringBuilder stringBuilder22 : treeAutomatonRule.getSource()) {
                if (stringBuilder3.length() > 0) {
                    stringBuilder3.append(" ");
                }
                stringBuilder3.append('\"');
                stringBuilder3.append((Object)stringBuilder22);
                stringBuilder3.append('\"');
            }
            stringBuilder22 = new StringBuilder();
            stringBuilder22.append('\"');
            stringBuilder22.append(treeAutomatonRule.getDest());
            stringBuilder22.append('\"');
            StringBuilder stringBuilder4 = new StringBuilder();
            stringBuilder4.append('\"');
            stringBuilder4.append(treeAutomatonRule.getLetter());
            stringBuilder4.append('\"');
            ((StringBuilder)object42).append(String.format("\t\t((%s) %s %s)", stringBuilder3, stringBuilder4, stringBuilder22));
        }
        return String.format("TreeAutomaton(\n\talphabet = {%s},\n\tstates = {%s},\n\tfinalStates = {%s},\n\ttransitionTable = {\n%s\n\t}\n)", stringBuilder, object322, object222, object42);
    }

    private boolean ruleContains(TreeAutomatonRule<LETTER, STATE> treeAutomatonRule, STATE STATE) {
        if (treeAutomatonRule.getDest().equals(STATE)) {
            return true;
        }
        for (STATE STATE2 : treeAutomatonRule.getSource()) {
            if (!STATE2.equals(STATE)) continue;
            return true;
        }
        return false;
    }

    private String stateString(STATE STATE) {
        StringBuilder stringBuilder = new StringBuilder(STATE.toString());
        stringBuilder.append('\"');
        if (this.isFinalState(STATE)) {
            stringBuilder.append("*");
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        return null;
    }

    @Override
    public Iterable<List<STATE>> getSourceCombinations() {
        return this.mParentsMap.keySet();
    }
}

