/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizedState;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.MonolithicHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;

public class SelfloopDeterminizer
implements IStateDeterminizer<IIcfgTransition<?>, IPredicate> {
    IHoareTripleChecker mHoareTriplechecker;
    PowersetDeterminizer<IIcfgTransition<?>, IPredicate> mPowersetDeterminizer;
    INestedWordAutomaton<IIcfgTransition<?>, IPredicate> mInterpolantAutomaton;
    private final IDeterminizeStateFactory<IPredicate> mStateFactory;
    IPredicate mInterpolantAutomatonFinalState;
    DeterminizedState<IIcfgTransition<?>, IPredicate> mResultFinalState;
    public int mInternalSelfloop = 0;
    public int mInternalNonSelfloop = 0;
    public int mCallSelfloop = 0;
    public int mCallNonSelfloop = 0;
    public int mReturnSelfloop = 0;
    public int mReturnNonSelfloop = 0;

    public SelfloopDeterminizer(CfgSmtToolkit cfgSmtToolkit, TAPreferences tAPreferences, INestedWordAutomaton<IIcfgTransition<?>, IPredicate> iNestedWordAutomaton, IDeterminizeStateFactory<IPredicate> iDeterminizeStateFactory) {
        this.mHoareTriplechecker = new MonolithicHoareTripleChecker(cfgSmtToolkit);
        this.mInterpolantAutomaton = iNestedWordAutomaton;
        this.mStateFactory = iDeterminizeStateFactory;
        this.mPowersetDeterminizer = new PowersetDeterminizer(this.mInterpolantAutomaton, true, this.mStateFactory);
        for (IPredicate iPredicate : this.mInterpolantAutomaton.getStates()) {
            if (this.mInterpolantAutomatonFinalState == null) {
                if (!this.mInterpolantAutomaton.isFinal((Object)iPredicate)) continue;
                this.mInterpolantAutomatonFinalState = iPredicate;
                continue;
            }
            throw new IllegalArgumentException("Interpolant Automaton must have one final state");
        }
        this.mResultFinalState = new DeterminizedState(this.mInterpolantAutomaton);
        this.mResultFinalState.addPair((Object)((IPredicate)this.mInterpolantAutomaton.getEmptyStackState()), (Object)this.mInterpolantAutomatonFinalState, this.mInterpolantAutomaton);
    }

    public DeterminizedState<IIcfgTransition<?>, IPredicate> initialState() {
        return this.mPowersetDeterminizer.initialState();
    }

    public DeterminizedState<IIcfgTransition<?>, IPredicate> internalSuccessor(DeterminizedState<IIcfgTransition<?>, IPredicate> determinizedState, IIcfgTransition<?> iIcfgTransition) {
        IPredicate iPredicate;
        IncrementalPlicationChecker.Validity validity;
        if (determinizedState == this.mResultFinalState) {
            ++this.mInternalSelfloop;
            return this.mResultFinalState;
        }
        DeterminizedState determinizedState2 = this.mPowersetDeterminizer.internalSuccessor(determinizedState, iIcfgTransition);
        if (this.containsFinal(determinizedState2)) {
            ++this.mInternalNonSelfloop;
            return this.mResultFinalState;
        }
        if (determinizedState2.isSubsetOf(determinizedState) && (validity = this.mHoareTriplechecker.checkInternal(iPredicate = this.getState(determinizedState), (IInternalAction)iIcfgTransition, iPredicate)) == IncrementalPlicationChecker.Validity.VALID) {
            ++this.mInternalSelfloop;
            return determinizedState;
        }
        ++this.mInternalNonSelfloop;
        return determinizedState2;
    }

    public DeterminizedState<IIcfgTransition<?>, IPredicate> callSuccessor(DeterminizedState<IIcfgTransition<?>, IPredicate> determinizedState, IIcfgTransition<?> iIcfgTransition) {
        IPredicate iPredicate;
        IncrementalPlicationChecker.Validity validity;
        if (determinizedState == this.mResultFinalState) {
            ++this.mCallSelfloop;
            return this.mResultFinalState;
        }
        DeterminizedState determinizedState2 = this.mPowersetDeterminizer.callSuccessor(determinizedState, iIcfgTransition);
        if (this.containsFinal(determinizedState2)) {
            ++this.mCallNonSelfloop;
            return this.mResultFinalState;
        }
        if (determinizedState2.isSubsetOf(determinizedState) && (validity = this.mHoareTriplechecker.checkCall(iPredicate = this.getState(determinizedState), (ICallAction)((IIcfgCallTransition)iIcfgTransition), iPredicate)) == IncrementalPlicationChecker.Validity.VALID) {
            ++this.mCallSelfloop;
            return determinizedState;
        }
        ++this.mCallNonSelfloop;
        return determinizedState2;
    }

    public DeterminizedState<IIcfgTransition<?>, IPredicate> returnSuccessor(DeterminizedState<IIcfgTransition<?>, IPredicate> determinizedState, DeterminizedState<IIcfgTransition<?>, IPredicate> determinizedState2, IIcfgTransition<?> iIcfgTransition) {
        IPredicate iPredicate;
        IPredicate iPredicate2;
        IncrementalPlicationChecker.Validity validity;
        if (determinizedState == this.mResultFinalState) {
            ++this.mReturnSelfloop;
            return this.mResultFinalState;
        }
        if (determinizedState2 == this.mResultFinalState) {
            throw new AssertionError((Object)"I guess this never happens");
        }
        DeterminizedState determinizedState3 = this.mPowersetDeterminizer.returnSuccessor(determinizedState, determinizedState2, iIcfgTransition);
        if (this.containsFinal(determinizedState3)) {
            ++this.mReturnNonSelfloop;
            return this.mResultFinalState;
        }
        if (determinizedState3.isSubsetOf(determinizedState) && (validity = this.mHoareTriplechecker.checkReturn(iPredicate2 = this.getState(determinizedState), iPredicate = this.getState(determinizedState2), (IReturnAction)((IIcfgReturnTransition)iIcfgTransition), iPredicate2)) == IncrementalPlicationChecker.Validity.VALID) {
            ++this.mReturnSelfloop;
            return determinizedState;
        }
        ++this.mReturnNonSelfloop;
        return determinizedState3;
    }

    private boolean containsFinal(DeterminizedState<IIcfgTransition<?>, IPredicate> determinizedState) {
        for (IPredicate iPredicate : determinizedState.getDownStates()) {
            for (IPredicate iPredicate2 : determinizedState.getUpStates((Object)iPredicate)) {
                if (iPredicate2 != this.mInterpolantAutomatonFinalState) continue;
                return true;
            }
        }
        return false;
    }

    public int getMaxDegreeOfNondeterminism() {
        return 0;
    }

    public boolean useDoubleDeckers() {
        return true;
    }

    public IPredicate getState(DeterminizedState<IIcfgTransition<?>, IPredicate> determinizedState) {
        return (IPredicate)determinizedState.getContent(this.mStateFactory);
    }
}

