/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DisjunctiveAbstractState<STATE extends IAbstractState<STATE>>
implements IAbstractState<DisjunctiveAbstractState<STATE>> {
    private final Set<STATE> mStates;
    private final int mMaxSize;

    public DisjunctiveAbstractState() {
        this(Collections.emptySet());
    }

    public DisjunctiveAbstractState(int n, STATE STATE) {
        this(n, Collections.singleton(STATE));
    }

    public DisjunctiveAbstractState(STATE STATE) {
        this(1, Collections.singleton(STATE));
    }

    private DisjunctiveAbstractState(Set<STATE> set) {
        this(set.size(), set);
    }

    private DisjunctiveAbstractState(int n, Set<STATE> set) {
        assert (set != null);
        assert (this.haveSameVars(set));
        assert (set.stream().allMatch(iAbstractState -> !(iAbstractState instanceof DisjunctiveAbstractState))) : "Cannot nest AbstractMultiStates, use flatten() instead";
        assert (set.size() <= n) : "Set too large";
        this.mMaxSize = n;
        this.mStates = set;
    }

    private boolean haveSameVars(Set<STATE> set) {
        if (set.size() <= 1) {
            return true;
        }
        ImmutableSet<IProgramVarOrConst> immutableSet = ((IAbstractState)set.iterator().next()).getVariables();
        return set.stream().allMatch(iAbstractState -> immutableSet.equals(iAbstractState.getVariables()));
    }

    @Override
    public DisjunctiveAbstractState<STATE> addVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.map(iAbstractState -> iAbstractState.addVariable(iProgramVarOrConst));
    }

    @Override
    public DisjunctiveAbstractState<STATE> removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.map(iAbstractState -> iAbstractState.removeVariable(iProgramVarOrConst));
    }

    @Override
    public DisjunctiveAbstractState<STATE> addVariables(Collection<IProgramVarOrConst> collection) {
        return this.map(iAbstractState -> iAbstractState.addVariables(collection));
    }

    @Override
    public DisjunctiveAbstractState<STATE> removeVariables(Collection<IProgramVarOrConst> collection) {
        return this.map(iAbstractState -> iAbstractState.removeVariables(collection));
    }

    @Override
    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mStates.stream().anyMatch(iAbstractState -> iAbstractState.containsVariable(iProgramVarOrConst));
    }

    @Override
    public ImmutableSet<IProgramVarOrConst> getVariables() {
        if (this.mStates.isEmpty()) {
            return ImmutableSet.empty();
        }
        return ((IAbstractState)this.mStates.iterator().next()).getVariables();
    }

    @Override
    public DisjunctiveAbstractState<STATE> renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        return this.map(iAbstractState -> iAbstractState.renameVariables(map));
    }

    @Override
    public DisjunctiveAbstractState<STATE> patch(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        assert (this.mStates.size() != disjunctiveAbstractState.mStates.size()) : "Cannot apply symmetrical with differently sized multi-states";
        Set<STATE> set = DisjunctiveAbstractState.newSet(this.mStates.size());
        Iterator<STATE> iterator = this.mStates.iterator();
        Iterator<STATE> iterator2 = disjunctiveAbstractState.mStates.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            set.add(((IAbstractState)iterator.next()).patch((IAbstractState)iterator2.next()));
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, set);
    }

    @Override
    public boolean isEmpty() {
        return this.mStates.stream().anyMatch(iAbstractState -> iAbstractState.isEmpty());
    }

    @Override
    public boolean isBottom() {
        return this.mStates.isEmpty() || this.mStates.stream().allMatch(iAbstractState -> iAbstractState.isBottom());
    }

    @Override
    public boolean isEqualTo(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        if (disjunctiveAbstractState == null) {
            return false;
        }
        if (!disjunctiveAbstractState.getVariables().equals(this.getVariables())) {
            return false;
        }
        for (IAbstractState iAbstractState : this.mStates) {
            if (disjunctiveAbstractState.mStates.stream().anyMatch(iAbstractState::isEqualTo)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IAbstractState.SubsetResult isSubsetOf(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        if (disjunctiveAbstractState == null) {
            return IAbstractState.SubsetResult.NONE;
        }
        if (disjunctiveAbstractState.isBottom() && this.isBottom()) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        if (disjunctiveAbstractState.isBottom()) {
            return IAbstractState.SubsetResult.NONE;
        }
        if (this.isBottom()) {
            return IAbstractState.SubsetResult.STRICT;
        }
        if (!disjunctiveAbstractState.getVariables().equals(this.getVariables())) {
            return IAbstractState.SubsetResult.NONE;
        }
        if (disjunctiveAbstractState.mStates.isEmpty() && !this.mStates.isEmpty()) {
            return IAbstractState.SubsetResult.NONE;
        }
        IAbstractState.SubsetResult subsetResult = IAbstractState.SubsetResult.EQUAL;
        for (IAbstractState iAbstractState : this.mStates) {
            IAbstractState.SubsetResult subsetResult2 = IAbstractState.SubsetResult.NONE;
            for (IAbstractState iAbstractState2 : disjunctiveAbstractState.mStates) {
                subsetResult2 = iAbstractState.isSubsetOf(iAbstractState2).max(subsetResult2);
            }
            if ((subsetResult = subsetResult.min(subsetResult2)) == IAbstractState.SubsetResult.NONE) break;
        }
        return subsetResult;
    }

    @Override
    public Term getTerm(Script script) {
        return SmtUtils.or((Script)script, (Collection)this.mStates.stream().map((? super T iAbstractState) -> iAbstractState.getTerm(script)).collect(Collectors.toSet()));
    }

    @Override
    public String toLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('#').append(this.mStates.size());
        for (IAbstractState iAbstractState : this.mStates) {
            stringBuilder.append('{');
            String string = iAbstractState.toLogString();
            if (string == null || string.isEmpty()) {
                stringBuilder.append("__");
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append('}');
            stringBuilder.append(", ");
        }
        if (!this.mStates.isEmpty()) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    @Override
    public DisjunctiveAbstractState<STATE> intersect(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        assert (disjunctiveAbstractState != null && disjunctiveAbstractState.getVariables().equals(this.getVariables())) : "Cannot intersect incompatible states";
        return this.crossProduct((iAbstractState, iAbstractState2) -> iAbstractState.intersect(iAbstractState2), disjunctiveAbstractState, this.mStates.size() * disjunctiveAbstractState.mStates.size());
    }

    @Override
    public DisjunctiveAbstractState<STATE> union(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        assert (disjunctiveAbstractState != null && disjunctiveAbstractState.getVariables().equals(this.getVariables())) : "Cannot merge incompatible states";
        Set<STATE> set = this.newSet(this.mStates, disjunctiveAbstractState.mStates);
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, this.reduce(set));
    }

    public DisjunctiveAbstractState<STATE> saturatedUnion(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        assert (disjunctiveAbstractState != null && disjunctiveAbstractState.getVariables().equals(this.getVariables())) : "Cannot merge incompatible states";
        Set<STATE> set = this.newSet(this.mStates, disjunctiveAbstractState.mStates);
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, DisjunctiveAbstractState.reduceByTopologicalOrder(set, this.mMaxSize));
    }

    public <ACTION> DisjunctiveAbstractState<STATE> defineVariablesAfter(IVariableProvider<STATE, ACTION> iVariableProvider, ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return this.crossProduct((iAbstractState, iAbstractState2) -> iVariableProvider.defineVariablesAfter(ACTION, iAbstractState, iAbstractState2), disjunctiveAbstractState, this.mMaxSize);
    }

    public <ACTION> DisjunctiveAbstractState<STATE> createValidPostOpStateAfterLeaving(IVariableProvider<STATE, ACTION> iVariableProvider, ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        if (disjunctiveAbstractState == null) {
            return this.map(iAbstractState -> iVariableProvider.createValidPostOpStateAfterLeaving(ACTION, iAbstractState, null));
        }
        return this.crossProduct((iAbstractState, iAbstractState2) -> iVariableProvider.createValidPostOpStateAfterLeaving(ACTION, iAbstractState, iAbstractState2), disjunctiveAbstractState, this.mStates.size() * disjunctiveAbstractState.mStates.size());
    }

    @Override
    public DisjunctiveAbstractState<STATE> compact() {
        Object object22;
        Set<Object> set = DisjunctiveAbstractState.newSet(this.mStates.size());
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        for (Object object22 : this.mStates) {
            Object STATE = object22.compact();
            set.add(STATE);
            hashSet.addAll((Collection<IProgramVarOrConst>)STATE.getVariables());
        }
        if (this.mStates.equals(set)) {
            return this;
        }
        object22 = DisjunctiveAbstractState.newSet(this.mStates.size());
        for (Object object3 : set) {
            HashSet<IProgramVarOrConst> hashSet2 = new HashSet<IProgramVarOrConst>(hashSet);
            hashSet2.removeAll((Collection<?>)object3.getVariables());
            if (hashSet2.isEmpty()) {
                object22.add(object3);
                continue;
            }
            object22.add(object3.addVariables(hashSet2));
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, object22);
    }

    public <ACTION> DisjunctiveAbstractState<STATE> createValidPostOpStateBeforeLeaving(IVariableProvider<STATE, ACTION> iVariableProvider, ACTION ACTION) {
        return this.map(iAbstractState -> iVariableProvider.createValidPostOpStateBeforeLeaving(ACTION, iAbstractState));
    }

    public <ACTION> DisjunctiveAbstractState<STATE> apply(IAbstractTransformer<STATE, ACTION> iAbstractTransformer, ACTION ACTION) {
        return this.mapCollection(iAbstractState -> iAbstractTransformer.apply(iAbstractState, ACTION));
    }

    public <ACTION> DisjunctiveAbstractState<STATE> apply(IAbstractPostOperator<STATE, ACTION> iAbstractPostOperator, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, ACTION ACTION) {
        return this.crossProductCollection((iAbstractState, iAbstractState2) -> iAbstractPostOperator.apply(iAbstractState2, iAbstractState, ACTION), disjunctiveAbstractState, this.mMaxSize);
    }

    public DisjunctiveAbstractState<STATE> widen(IAbstractStateBinaryOperator<STATE> iAbstractStateBinaryOperator, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        Set<STATE> set = disjunctiveAbstractState.mStates.size() > 1 ? DisjunctiveAbstractState.reduceByOrderedMerge(disjunctiveAbstractState.mStates, 1) : disjunctiveAbstractState.mStates;
        Set<STATE> set2 = DisjunctiveAbstractState.newSet(this.mStates.size());
        for (IAbstractState iAbstractState : this.mStates) {
            for (IAbstractState iAbstractState2 : set) {
                set2.add(iAbstractStateBinaryOperator.apply(iAbstractState, iAbstractState2));
            }
        }
        if (set2.equals(this.mStates)) {
            return this;
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, DisjunctiveAbstractState.reduceByTopologicalOrder(set2, this.mMaxSize));
    }

    public static <STATE extends IAbstractState<STATE>> DisjunctiveAbstractState<STATE> createDisjunction(Collection<STATE> collection) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (IAbstractState iAbstractState : collection) {
            if (iAbstractState instanceof DisjunctiveAbstractState) {
                hashSet.addAll(((DisjunctiveAbstractState)iAbstractState).getStates());
                continue;
            }
            hashSet.add(iAbstractState);
        }
        return new DisjunctiveAbstractState(DisjunctiveAbstractState.reduce(hashSet, hashSet.size()));
    }

    public static <STATE extends IAbstractState<STATE>> DisjunctiveAbstractState<STATE> createDisjunction(Collection<STATE> collection, int n) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (IAbstractState iAbstractState : collection) {
            if (iAbstractState instanceof DisjunctiveAbstractState) {
                hashSet.addAll(((DisjunctiveAbstractState)iAbstractState).getStates());
                continue;
            }
            hashSet.add(iAbstractState);
        }
        return new DisjunctiveAbstractState(n, DisjunctiveAbstractState.reduce(hashSet, n));
    }

    public static <STATE extends IAbstractState<STATE>> STATE union(Collection<STATE> collection) {
        Set set2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (collection.size() == 1) {
            return (STATE)((IAbstractState)collection.iterator().next());
        }
        HashSet<Object> hashSet = new HashSet<Object>(collection.size());
        for (Set set2 : collection) {
            if (set2 instanceof DisjunctiveAbstractState) {
                hashSet.addAll(((DisjunctiveAbstractState)((Object)set2)).getStates());
                continue;
            }
            hashSet.add(set2);
        }
        set2 = DisjunctiveAbstractState.reduce(hashSet, 1);
        if (set2.isEmpty()) {
            return null;
        }
        assert (set2.size() == 1);
        return (STATE)((IAbstractState)set2.iterator().next());
    }

    public String toString() {
        return this.toLogString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.mMaxSize;
        n = 31 * n + this.mStates.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DisjunctiveAbstractState disjunctiveAbstractState = (DisjunctiveAbstractState)object;
        if (this.mMaxSize != disjunctiveAbstractState.mMaxSize) {
            return false;
        }
        return this.mStates.equals(disjunctiveAbstractState.mStates);
    }

    public Set<STATE> getStates() {
        return Collections.unmodifiableSet(this.mStates);
    }

    public STATE getSingleState(IAbstractStateBinaryOperator<STATE> iAbstractStateBinaryOperator) {
        return (STATE)((IAbstractState)this.mStates.stream().reduce(iAbstractStateBinaryOperator::apply).orElse(null));
    }

    private DisjunctiveAbstractState<STATE> crossProduct(BiFunction<STATE, STATE, STATE> biFunction, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, int n, IReduceUntil<STATE> iReduceUntil) {
        Set<STATE> set = DisjunctiveAbstractState.newSet(this.mStates.size() * disjunctiveAbstractState.mStates.size());
        for (IAbstractState iAbstractState : this.mStates) {
            for (IAbstractState iAbstractState2 : disjunctiveAbstractState.mStates) {
                set.add((IAbstractState)biFunction.apply(iAbstractState, iAbstractState2));
            }
        }
        if (set.equals(this.mStates)) {
            return this;
        }
        return new DisjunctiveAbstractState<STATE>(n, iReduceUntil.reduce(set, n));
    }

    private DisjunctiveAbstractState<STATE> crossProduct(BiFunction<STATE, STATE, STATE> biFunction, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, int n) {
        return this.crossProduct(biFunction, disjunctiveAbstractState, n, DisjunctiveAbstractState::reduce);
    }

    private DisjunctiveAbstractState<STATE> crossProductCollection(BiFunction<STATE, STATE, Collection<STATE>> biFunction, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, int n) {
        Set<STATE> set = DisjunctiveAbstractState.newSet(this.mStates.size() * disjunctiveAbstractState.mStates.size());
        for (IAbstractState iAbstractState : this.mStates) {
            for (IAbstractState iAbstractState2 : disjunctiveAbstractState.mStates) {
                set.addAll(biFunction.apply(iAbstractState, iAbstractState2));
            }
        }
        if (set.equals(this.mStates)) {
            return this;
        }
        return new DisjunctiveAbstractState<STATE>(n, this.reduce(set));
    }

    private DisjunctiveAbstractState<STATE> map(Function<STATE, STATE> function) {
        Set<STATE> set = DisjunctiveAbstractState.newSet(this.mStates.size());
        for (IAbstractState iAbstractState : this.mStates) {
            set.add((IAbstractState)function.apply(iAbstractState));
        }
        if (this.mStates.equals(set)) {
            return this;
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, set);
    }

    private DisjunctiveAbstractState<STATE> mapCollection(Function<STATE, Collection<STATE>> function) {
        Set<STATE> set = this.newSet();
        for (IAbstractState iAbstractState : this.mStates) {
            set.addAll(function.apply(iAbstractState));
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, DisjunctiveAbstractState.reduce(set, this.mMaxSize));
    }

    private Set<STATE> newSet() {
        return DisjunctiveAbstractState.newSet(this.mMaxSize);
    }

    private static <STATE> Set<STATE> newSet(int n) {
        return new LinkedHashSet(n, 1.0f);
    }

    @SafeVarargs
    private final Set<STATE> newSet(Set<STATE> ... setArray) {
        if (setArray == null || setArray.length == 0) {
            return this.newSet();
        }
        int n3 = Arrays.stream(setArray).map((? super T set) -> set.size()).reduce((n, n2) -> n + n2).get();
        Set<STATE> set2 = DisjunctiveAbstractState.newSet(n3);
        Arrays.stream(setArray).forEach(set2::addAll);
        return set2;
    }

    private Set<STATE> reduce(Set<STATE> set) {
        return DisjunctiveAbstractState.reduce(set, this.mMaxSize);
    }

    private static <STATE extends IAbstractState<STATE>> Set<STATE> reduce(Set<STATE> set, int n) {
        Set<STATE> set2 = DisjunctiveAbstractState.getMaximalElements(set);
        if (set2.size() <= n) {
            return set2;
        }
        return DisjunctiveAbstractState.reduceByOrderedMerge(set2, n);
    }

    private static <STATE extends IAbstractState<STATE>> Set<STATE> reduceByOrderedMerge(Set<STATE> set, int n) {
        IAbstractState iAbstractState = (IAbstractState)set.iterator().next();
        return iAbstractState.union(set, n);
    }

    private static <STATE extends IAbstractState<STATE>> Set<STATE> getMaximalElements(Set<STATE> set) {
        if (set.isEmpty() || set.size() == 1) {
            return set;
        }
        Set<STATE> set2 = DisjunctiveAbstractState.newSet(set.size());
        for (IAbstractState iAbstractState : set) {
            Iterator<STATE> iterator = set2.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                IAbstractState iAbstractState2 = (IAbstractState)iterator.next();
                IAbstractState.SubsetResult subsetResult = iAbstractState.isSubsetOf(iAbstractState2);
                IAbstractState.SubsetResult subsetResult2 = iAbstractState2.isSubsetOf(iAbstractState);
                if (subsetResult != IAbstractState.SubsetResult.NONE) {
                    bl = false;
                    break;
                }
                if (subsetResult2 == IAbstractState.SubsetResult.NONE) continue;
                iterator.remove();
            }
            if (!bl) continue;
            set2.add(iAbstractState);
        }
        assert (set2.stream().filter(IAbstractState::isBottom).count() <= 1L) : "There can be only one bottom element";
        return set2;
    }

    private static <STATE extends IAbstractState<STATE>> List<STATE> getTopologicalOrder(Set<STATE> set) {
        IPartialComparator iPartialComparator = (iAbstractState, iAbstractState2) -> {
            IAbstractState.SubsetResult subsetResult = iAbstractState.isSubsetOf(iAbstractState2);
            switch (subsetResult) {
                case EQUAL: {
                    return IPartialComparator.ComparisonResult.EQUAL;
                }
                case STRICT: {
                    return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
                }
            }
            IAbstractState.SubsetResult subsetResult2 = iAbstractState2.isSubsetOf(iAbstractState);
            switch (subsetResult2) {
                case EQUAL: {
                    throw new AssertionError((Object)"Equal is symmetric");
                }
                case STRICT: {
                    return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
                }
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        };
        PartialOrderCache partialOrderCache = new PartialOrderCache(iPartialComparator);
        set.forEach(arg_0 -> ((PartialOrderCache)partialOrderCache).addElement(arg_0));
        List list = partialOrderCache.getReverseTopologicalOrdering();
        assert (DisjunctiveAbstractState.hasDescendingOrder(list)) : "states are not in descending order";
        return list;
    }

    private static <STATE extends IAbstractState<STATE>> boolean hasDescendingOrder(List<STATE> list) {
        Iterator<STATE> iterator = list.iterator();
        IAbstractState iAbstractState = null;
        IAbstractState iAbstractState2 = null;
        block7: while (iterator.hasNext()) {
            iAbstractState2 = iAbstractState;
            iAbstractState = (IAbstractState)iterator.next();
            if (iAbstractState2 == null || iAbstractState == null) continue;
            IAbstractState.SubsetResult subsetResult = iAbstractState.isSubsetOf(iAbstractState2);
            switch (subsetResult) {
                case EQUAL: {
                    return false;
                }
                case NONE: {
                    break;
                }
                default: {
                    continue block7;
                }
            }
            IAbstractState.SubsetResult subsetResult2 = iAbstractState2.isSubsetOf(iAbstractState);
            switch (subsetResult2) {
                case EQUAL: 
                case STRICT: {
                    return false;
                }
            }
        }
        return true;
    }

    private static <STATE extends IAbstractState<STATE>> Set<STATE> reduceByTopologicalOrder(Set<STATE> set, int n) {
        Object object;
        if (set.size() <= n) {
            return set;
        }
        List<STATE> list = DisjunctiveAbstractState.getTopologicalOrder(set);
        Set<STATE> set2 = DisjunctiveAbstractState.newSet(n);
        Iterator<STATE> iterator = list.iterator();
        int n2 = 1;
        while (iterator.hasNext() && n2 < n) {
            object = (IAbstractState)iterator.next();
            set2.add(object);
            ++n2;
        }
        if (iterator.hasNext()) {
            object = new HashSet();
            iterator.forEachRemaining(((Set)object)::add);
            Set<STATE> set3 = DisjunctiveAbstractState.reduce(object, 1);
            set2.add((IAbstractState)set3.iterator().next());
        }
        assert (set2.size() <= n) : "reduceByTopologicalOrder left too many states";
        return set2;
    }

    private static interface IReduceUntil<STATE> {
        public Set<STATE> reduce(Set<STATE> var1, int var2);
    }
}

