/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.LexicographicCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.SymmetricHashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EquivalenceRelationIterator<E>
implements Iterable<Set<Doubleton<E>>> {
    private final IUltimateServiceProvider mServices;
    private final List<Set<Doubleton<E>>> mResult = new ArrayList<Set<Doubleton<E>>>();
    private final LinkedList<Boolean> mStack = new LinkedList();
    private SymmetricHashRelation<E> mCurrentRelation;
    private final List<Doubleton<E>> mNonDisjointDoubletons;
    private final ThreeValuedEquivalenceRelation<E> mEqualityInformation;
    private final IExternalOracle<E> mExternalOracle;

    public EquivalenceRelationIterator(IUltimateServiceProvider iUltimateServiceProvider, Collection<E> collection, ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation, IExternalOracle<E> iExternalOracle, List<Doubleton<E>> list) {
        boolean bl;
        this.mServices = iUltimateServiceProvider;
        this.mNonDisjointDoubletons = list;
        this.mEqualityInformation = threeValuedEquivalenceRelation;
        this.mExternalOracle = iExternalOracle;
        this.mCurrentRelation = new SymmetricHashRelation();
        do {
            if (this.mStack.size() != this.mNonDisjointDoubletons.size()) continue;
            this.addRelationToResult();
            if (this.mCurrentRelation.isEmpty()) break;
        } while (!(bl = this.advance()));
    }

    public EquivalenceRelationIterator(IUltimateServiceProvider iUltimateServiceProvider, Collection<E> collection, ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation, IExternalOracle<E> iExternalOracle) {
        this(iUltimateServiceProvider, collection, threeValuedEquivalenceRelation, iExternalOracle, EquivalenceRelationIterator.buildListOfNonDisjointDoubletons(collection, threeValuedEquivalenceRelation));
    }

    private boolean checkResultWithOldCombinationIterator(Collection<E> collection, ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation) {
        HashSet<Set<Doubleton<E>>> hashSet = new HashSet<Set<Doubleton<E>>>(this.mResult);
        HashSet hashSet2 = new HashSet();
        EquivalenceRelationIterator2 equivalenceRelationIterator2 = new EquivalenceRelationIterator2(collection, threeValuedEquivalenceRelation);
        for (Set set : equivalenceRelationIterator2) {
            hashSet2.add(set);
        }
        assert (hashSet.equals(hashSet2)) : "result of CombinationIterator and CombinationIterator2 is different " + hashSet.size() + " vs. " + hashSet2.size();
        return hashSet.equals(hashSet2);
    }

    private boolean advance() {
        if (this.mStack.size() == this.mNonDisjointDoubletons.size()) {
            boolean bl = this.remove1true();
            if (bl) {
                return true;
            }
            this.rebuildCurrentRelation();
            return this.tryToPush1False();
        }
        return this.tryToPush1True();
    }

    private boolean tryToPush1False() {
        Doubleton<E> doubleton = this.mNonDisjointDoubletons.get(this.mStack.size());
        if (this.mCurrentRelation.containsPair(doubleton.getOneElement(), doubleton.getOtherElement())) {
            boolean bl = this.remove1true();
            if (bl) {
                return true;
            }
            this.rebuildCurrentRelation();
            return this.tryToPush1False();
        }
        this.mStack.add(false);
        if (!this.mExternalOracle.isConsistent(this.mStack, this.mNonDisjointDoubletons)) {
            this.mStack.removeLast();
            if (this.mStack.isEmpty()) {
                return true;
            }
            boolean bl = this.remove1true();
            if (bl) {
                return true;
            }
            this.rebuildCurrentRelation();
            return this.tryToPush1False();
        }
        return false;
    }

    private boolean tryToPush1True() {
        Doubleton<E> doubleton = this.mNonDisjointDoubletons.get(this.mStack.size());
        if (this.mEqualityInformation.getEqualityStatus(doubleton.getOneElement(), doubleton.getOtherElement()) == EqualityStatus.NOT_EQUAL) {
            return false;
        }
        this.mStack.add(true);
        this.mCurrentRelation.addPair(doubleton.getOneElement(), doubleton.getOtherElement());
        Set set = this.mCurrentRelation.makeTransitive();
        boolean bl = this.containsNotEqualsPair(set);
        if (bl || !this.mExternalOracle.isConsistent(this.mStack, this.mNonDisjointDoubletons)) {
            boolean bl2 = this.remove1true();
            if (bl2) {
                return true;
            }
            this.rebuildCurrentRelation();
            return this.tryToPush1False();
        }
        return false;
    }

    private boolean containsNotEqualsPair(Set<Doubleton<E>> set) {
        for (Doubleton<E> doubleton : set) {
            if (this.mEqualityInformation.getEqualityStatus(doubleton.getOneElement(), doubleton.getOtherElement()) != EqualityStatus.NOT_EQUAL) continue;
            return true;
        }
        return false;
    }

    private void rebuildCurrentRelation() {
        this.mCurrentRelation = new SymmetricHashRelation();
        int n = 0;
        for (Boolean bl : this.mStack) {
            if (bl.booleanValue()) {
                Doubleton<E> doubleton = this.mNonDisjointDoubletons.get(n);
                this.mCurrentRelation.addPair(doubleton.getOneElement(), doubleton.getOtherElement());
            }
            ++n;
        }
        this.mCurrentRelation.makeTransitive();
    }

    private boolean remove1true() {
        while (!this.mStack.peekLast().booleanValue()) {
            this.mStack.removeLast();
            if (!this.mStack.isEmpty()) continue;
            return true;
        }
        this.mStack.removeLast();
        return false;
    }

    private void addRelationToResult() {
        this.mResult.add(this.mCurrentRelation.buildSetOfNonSymmetricDoubletons());
    }

    public int size() {
        return this.mResult.size();
    }

    @Override
    public Iterator<Set<Doubleton<E>>> iterator() {
        return this.mResult.iterator();
    }

    static <E> List<Doubleton<E>> buildListOfNonDisjointDoubletons(Collection<E> collection, ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation) {
        ArrayList<Doubleton<Doubleton>> arrayList = new ArrayList<Doubleton<Doubleton>>();
        ArrayList<E> arrayList2 = new ArrayList<E>(collection);
        int n = 0;
        while (n < arrayList2.size()) {
            if (threeValuedEquivalenceRelation.isRepresentative(arrayList2.get(n))) {
                int n2 = n + 1;
                while (n2 < arrayList2.size()) {
                    if (threeValuedEquivalenceRelation.isRepresentative(arrayList2.get(n2)) && threeValuedEquivalenceRelation.getEqualityStatus(arrayList2.get(n), arrayList2.get(n2)) != EqualityStatus.NOT_EQUAL) {
                        arrayList.add(new Doubleton(arrayList2.get(n), arrayList2.get(n2)));
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static <E> boolean isClosedUnderTransitivity(HashRelation<E, E> hashRelation) {
        for (Map.Entry entry : hashRelation.getSetOfPairs()) {
            for (Object e : hashRelation.getImage(entry.getValue())) {
                if (hashRelation.containsPair(entry.getKey(), e)) continue;
                return false;
            }
        }
        return true;
    }

    public static class DefaultExternalOracle<E>
    implements IExternalOracle<E> {
        @Override
        public boolean isConsistent(LinkedList<Boolean> linkedList, List<Doubleton<E>> list) {
            return true;
        }
    }

    private class EquivalenceRelationIterator2
    implements Iterable<Set<Doubleton<E>>> {
        private final List<Set<Doubleton<E>>> mResult = new ArrayList();

        public EquivalenceRelationIterator2(Collection<E> collection, ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation) {
            List list = EquivalenceRelationIterator.buildListOfNonDisjointDoubletons(collection, threeValuedEquivalenceRelation);
            int[] nArray = new int[list.size()];
            Arrays.fill(nArray, 2);
            LexicographicCounter lexicographicCounter = new LexicographicCounter(nArray);
            do {
                HashSet hashSet2;
                if (!EquivalenceRelationIterator.this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "iterating over LexicographicCounter " + String.valueOf(lexicographicCounter));
                }
                HashRelation hashRelation = new HashRelation();
                for (HashSet hashSet2 : collection) {
                    if (!threeValuedEquivalenceRelation.isRepresentative(hashSet2)) continue;
                    hashRelation.addPair(hashSet2, hashSet2);
                }
                hashSet2 = new HashSet();
                int n = 0;
                while (n < list.size()) {
                    if (lexicographicCounter.getCurrentValue()[n] == 1) {
                        Doubleton doubleton = list.get(n);
                        hashRelation.addPair(doubleton.getOneElement(), doubleton.getOtherElement());
                        hashRelation.addPair(doubleton.getOtherElement(), doubleton.getOneElement());
                        hashSet2.add(doubleton);
                    }
                    ++n;
                }
                if (EquivalenceRelationIterator.isClosedUnderTransitivity(hashRelation)) {
                    this.mResult.add(hashSet2);
                }
                lexicographicCounter.increment();
            } while (!lexicographicCounter.isZero());
        }

        public int size() {
            return this.mResult.size();
        }

        @Override
        public Iterator<Set<Doubleton<E>>> iterator() {
            return this.mResult.iterator();
        }
    }

    public static interface IExternalOracle<E> {
        public boolean isConsistent(LinkedList<Boolean> var1, List<Doubleton<E>> var2);
    }
}

