/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.counting.ConjunctGuards;
import de.uni_freiburg.informatik.ultimate.automata.counting.Counter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.FinalCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Guard;
import de.uni_freiburg.informatik.ultimate.automata.counting.InitialCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.TermType;
import de.uni_freiburg.informatik.ultimate.automata.counting.Transition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class Concatenation<LETTER, STATE, CRSF extends IStateFactory<STATE>>
implements IOperation<LETTER, STATE, CRSF> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final CountingAutomaton<LETTER, STATE> mFstOperand;
    private final CountingAutomaton<LETTER, STATE> mSndOperand;
    private final CountingAutomaton<LETTER, STATE> mResult;
    private final IIntersectionStateFactory<STATE> mStateFactory;

    public Concatenation(AutomataLibraryServices automataLibraryServices, IIntersectionStateFactory<STATE> iIntersectionStateFactory, CountingAutomaton<LETTER, STATE> countingAutomaton, CountingAutomaton<LETTER, STATE> countingAutomaton2) throws AutomataLibraryException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(this.getClass());
        this.mFstOperand = countingAutomaton;
        this.mSndOperand = countingAutomaton2;
        this.mStateFactory = iIntersectionStateFactory;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private CountingAutomaton<LETTER, STATE> computeResult() {
        ArrayList<Object> arrayList;
        Object object3;
        ArrayList arrayList2;
        Object object22;
        HashSet<LETTER> hashSet = new HashSet<LETTER>(this.mFstOperand.getAlphabet());
        ArrayList<Counter> arrayList4 = new ArrayList<Counter>();
        for (Counter object42 : this.mFstOperand.getCounter()) {
            arrayList4.add(object42.copyCounter());
        }
        for (Counter counter : this.mSndOperand.getCounter()) {
            arrayList4.add(counter.copyCounter());
        }
        HashSet<STATE> hashSet2 = new HashSet<STATE>(this.mFstOperand.getStates());
        hashSet2.addAll(this.mSndOperand.getStates());
        HashMap hashMap = new HashMap();
        HashMap<STATE, Object> hashMap2 = new HashMap<STATE, Object>();
        HashMap hashMap3 = new HashMap();
        for (Object object22 : this.mFstOperand.getStates()) {
            hashMap.put(object22, this.mFstOperand.getInitialConditions().get(object22).copyInitialCondition());
            hashMap2.put(object22, this.mFstOperand.getFinalConditions().get(object22).copyFinalCondition());
            arrayList2 = new ArrayList();
            for (Transition transition : this.mFstOperand.getTransitions().get(object22)) {
                arrayList2.add(transition.copyTransition());
            }
            hashMap3.put(object22, arrayList2);
        }
        for (Object object22 : this.mSndOperand.getStates()) {
            arrayList2 = new Guard();
            ((Guard)((Object)arrayList2)).changeTermType(TermType.FALSE);
            ArrayList<Guard> arrayList3 = new ArrayList<Guard>();
            arrayList3.add((Guard)((Object)arrayList2));
            object3 = new ArrayList<ArrayList<Guard>>();
            ((ArrayList)object3).add(arrayList3);
            arrayList = new InitialCondition((ArrayList<ArrayList<Guard>>)object3);
            hashMap.put(object22, arrayList);
            hashMap2.put(object22, this.mSndOperand.getFinalConditions().get(object22).copyFinalCondition());
            ArrayList<Transition<LETTER, STATE>> arrayList5 = new ArrayList<Transition<LETTER, STATE>>();
            for (Transition<LETTER, STATE> transition : this.mSndOperand.getTransitions().get(object22)) {
                arrayList5.add(transition.copyTransition());
            }
            hashMap3.put(object22, arrayList5);
        }
        for (Object object22 : this.mFstOperand.getStates()) {
            if (this.mFstOperand.getFinalConditions().get(object22).getCondition().get(0).get(0).getTermType() == TermType.FALSE) continue;
            arrayList2 = new ArrayList((Collection)hashMap3.get(object22));
            ArrayList<ArrayList<Guard>> arrayList6 = new ArrayList<ArrayList<Guard>>();
            for (Object object3 : this.mSndOperand.getStates()) {
                if (this.mSndOperand.getInitialConditions().get(object3).getCondition().get(0).get(0).getTermType() == TermType.FALSE) continue;
                for (Transition<LETTER, STATE> transition : this.mSndOperand.getTransitions().get(object3)) {
                    Transition<LETTER, STATE> transition2 = transition.copyTransition();
                    ConjunctGuards conjunctGuards = new ConjunctGuards(transition2.getGuards(), this.mFstOperand.getFinalConditions().get(object22).copyFinalCondition().getCondition());
                    ConjunctGuards conjunctGuards2 = new ConjunctGuards(conjunctGuards.getResult(), this.mSndOperand.getInitialConditions().get(object3).copyInitialCondition().getCondition());
                    Transition transition3 = new Transition(transition2.getLetter(), object22, transition2.getSucState(), conjunctGuards2.getResult(), transition2.getUpdates());
                    arrayList2.add(transition3);
                }
                if (this.mSndOperand.getFinalConditions().get(object3).getCondition().get(0).get(0).getTermType() == TermType.FALSE) continue;
                ConjunctGuards conjunctGuards = new ConjunctGuards(this.mFstOperand.getFinalConditions().get(object22).copyFinalCondition().getCondition(), this.mSndOperand.getInitialConditions().get(object3).copyInitialCondition().getCondition());
                ConjunctGuards conjunctGuards3 = new ConjunctGuards(conjunctGuards.getResult(), this.mSndOperand.getFinalConditions().get(object3).copyFinalCondition().getCondition());
                arrayList6.addAll(conjunctGuards3.getResult());
            }
            hashMap3.put(object22, arrayList2);
            if (arrayList6.size() == 0) {
                object3 = new Guard();
                ((Guard)object3).changeTermType(TermType.FALSE);
                arrayList = new ArrayList<Object>();
                arrayList.add(object3);
                arrayList6.add(arrayList);
            }
            object3 = new FinalCondition(arrayList6);
            hashMap2.put(object22, object3);
        }
        object22 = new CountingAutomaton<LETTER, STATE>(this.mServices, hashSet, hashSet2, arrayList4, hashMap, hashMap2, hashMap3);
        return object22;
    }

    @Override
    public CountingAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        return true;
    }
}

