/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import de.uni_freiburg.informatik.ultimate.automata.SetOfStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IGeneralizedNestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IGeneralizedNwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GeneralizedBuchiToBuchi<LETTER, STATE>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    private final IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final IBuchiIntersectStateFactory<STATE> mStateFactory;
    private final STATE mEmptyStackState;
    private final SetOfStates<STATE> mSetOfStates;
    private final int mAcceptanceSize;
    private final Map<STATE, TrackState<STATE>> mTrackStateMap;
    private final Map<TrackState<STATE>, STATE> mStateMap;

    public <SF extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> GeneralizedBuchiToBuchi(SF SF, IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iGeneralizedNwaOutgoingLetterAndTransitionProvider) {
        this.mOperand = iGeneralizedNwaOutgoingLetterAndTransitionProvider;
        this.mStateFactory = SF;
        this.mEmptyStackState = SF.createEmptyStackState();
        this.mSetOfStates = new SetOfStates<STATE>(this.mEmptyStackState);
        this.mAcceptanceSize = iGeneralizedNwaOutgoingLetterAndTransitionProvider.getAcceptanceSize();
        this.mTrackStateMap = new HashMap<STATE, TrackState<STATE>>();
        this.mStateMap = new HashMap<TrackState<STATE>, STATE>();
        this.constructInitialStates();
    }

    public <SF extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> GeneralizedBuchiToBuchi(SF SF, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        if (!(iNestedWordAutomaton instanceof IGeneralizedNestedWordAutomaton)) {
            throw new UnsupportedOperationException("Input automaton is not GBA");
        }
        this.mOperand = (IGeneralizedNwaOutgoingLetterAndTransitionProvider)((Object)iNestedWordAutomaton);
        this.mStateFactory = SF;
        this.mEmptyStackState = SF.createEmptyStackState();
        this.mSetOfStates = new SetOfStates<STATE>(this.mEmptyStackState);
        this.mAcceptanceSize = this.mOperand.getAcceptanceSize();
        this.mTrackStateMap = new HashMap<STATE, TrackState<STATE>>();
        this.mStateMap = new HashMap<TrackState<STATE>, STATE>();
        this.constructInitialStates();
    }

    public <SF extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> GeneralizedBuchiToBuchi(SF SF, IGeneralizedNestedWordAutomaton<LETTER, STATE> iGeneralizedNestedWordAutomaton) {
        if (!(iGeneralizedNestedWordAutomaton instanceof IGeneralizedNestedWordAutomaton)) {
            throw new UnsupportedOperationException("Input automaton is not GBA");
        }
        this.mOperand = iGeneralizedNestedWordAutomaton;
        this.mStateFactory = SF;
        this.mEmptyStackState = SF.createEmptyStackState();
        this.mSetOfStates = new SetOfStates<STATE>(this.mEmptyStackState);
        this.mAcceptanceSize = this.mOperand.getAcceptanceSize();
        this.mTrackStateMap = new HashMap<STATE, TrackState<STATE>>();
        this.mStateMap = new HashMap<TrackState<STATE>, STATE>();
        this.constructInitialStates();
    }

    private void constructInitialStates() {
        for (Object STATE : this.mOperand.getInitialStates()) {
            this.getOrConstructState(STATE, true, 0);
        }
    }

    private TrackState<STATE> getOrConstructState(STATE STATE, boolean bl, int n) {
        TrackState<STATE> trackState = new TrackState<STATE>(STATE, n);
        STATE STATE2 = this.mStateMap.get(trackState);
        if (STATE2 == null) {
            STATE2 = this.mStateFactory.intersectBuchi(STATE, STATE, n);
            trackState.setBuchiState(STATE2);
            this.mTrackStateMap.put(STATE2, trackState);
            this.mStateMap.put(trackState, STATE2);
            boolean bl2 = n == 0 && this.mOperand.getAcceptanceLabels(STATE).contains(0);
            this.mSetOfStates.addState(bl, bl2, STATE2);
        }
        return this.mTrackStateMap.get(STATE2);
    }

    private int getSuccTrack(TrackState<STATE> trackState, STATE STATE) {
        int n = (trackState.mTrack + 1) % this.mAcceptanceSize;
        if (this.mOperand.isFinal(STATE, trackState.mTrack)) {
            return n;
        }
        return trackState.mTrack;
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mOperand.getAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public int size() {
        return this.mSetOfStates.getStates().size();
    }

    @Override
    public String sizeInformation() {
        return this.mSetOfStates.getStates().size() + " states";
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mEmptyStackState;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        return this.mSetOfStates.getInitialStates();
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mSetOfStates.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mSetOfStates.isAccepting(STATE);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        TrackState<STATE> trackState = this.mTrackStateMap.get(STATE);
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(trackState.mState, LETTER)) {
            Object STATE2 = outgoingInternalTransition.getSucc();
            int n = this.getSuccTrack(trackState, STATE2);
            TrackState trackState2 = this.getOrConstructState(STATE2, false, n);
            arrayList.add(new OutgoingInternalTransition(LETTER, trackState2.mRes));
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        return new ArrayList<OutgoingCallTransition<LETTER, STATE>>();
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        return new ArrayList<OutgoingReturnTransition<LETTER, STATE>>();
    }

    private static class TrackState<STATE> {
        STATE mState;
        int mTrack;
        STATE mRes;

        TrackState(STATE STATE, int n) {
            this.mState = STATE;
            this.mTrack = n;
        }

        void setBuchiState(STATE STATE) {
            this.mRes = STATE;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TrackState trackState = (TrackState)object;
            return this.mState.equals(trackState.mState) && this.mTrack == trackState.mTrack;
        }

        public int hashCode() {
            int n = this.mState.hashCode();
            n = n * 31 + this.mTrack;
            return n;
        }

        public String toString() {
            return String.valueOf(this.mState) + "," + this.mTrack;
        }
    }
}

