/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.IntBlastingWrapper;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class BvToIntTranslation
extends TermTransformer {
    private final Script mScript;
    private static final String BITVEC_CONST_PATTERN = "bv\\d+";
    private final boolean mNutzTransformation;
    private final ManagedScript mMgdScript;
    private final TermVariable[] mFreeVars;
    private final TranslationConstrainer mTc;
    private final LinkedHashMap<Term, Term> mVariableMap;
    private final LinkedHashMap<Term, Term> mReversedVarMap;
    public final LinkedHashMap<Term, Term> mArraySelectConstraintMap;
    private final Set<TermVariable> mOverapproxVariables;
    private boolean mIsOverapproximation;

    public BvToIntTranslation(ManagedScript managedScript, LinkedHashMap<Term, Term> linkedHashMap, TranslationConstrainer translationConstrainer, TermVariable[] termVariableArray, boolean bl) {
        this.mMgdScript = managedScript;
        this.mScript = managedScript.getScript();
        this.mNutzTransformation = bl;
        this.mFreeVars = termVariableArray;
        this.mVariableMap = linkedHashMap != null ? linkedHashMap : new LinkedHashMap();
        this.mReversedVarMap = new LinkedHashMap();
        this.mArraySelectConstraintMap = new LinkedHashMap();
        this.mOverapproxVariables = new HashSet<TermVariable>();
        this.mIsOverapproximation = false;
        this.mTc = translationConstrainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(Term term) {
        block36: {
            Sort sort;
            block35: {
                sort = SmtSortUtils.getIntSort(this.mScript);
                if (term instanceof TermVariable) {
                    TermVariable[] termVariableArray = this.mFreeVars;
                    int n = this.mFreeVars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TermVariable termVariable = termVariableArray[n2];
                        if (term == termVariable && SmtSortUtils.isBitvecSort(term.getSort())) {
                            Term term2 = this.translateVars(term, true);
                            assert (SmtSortUtils.isIntSort(term2.getSort()));
                            this.mTc.varConstraint(term, term2);
                            this.setResult(term2);
                            return;
                        }
                        ++n2;
                    }
                    this.setResult(this.translateVars(term, true));
                    return;
                }
                if (!(term instanceof ApplicationTerm)) break block35;
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                if (applicationTerm.getParameters().length == 0 && SmtUtils.isConstant((Term)applicationTerm)) {
                    Term term3 = this.translateVars(term, true);
                    if (SmtSortUtils.isBitvecSort(term.getSort())) {
                        this.mTc.varConstraint(term, term3);
                    }
                    this.setResult(term3);
                    return;
                }
                if (this.mTc.mMode.equals((Object)TranslationConstrainer.ConstraintsForBitwiseOperations.NONE) && this.overaproxWithVars(applicationTerm)) {
                    Sort sort2 = this.translateSort(this.mScript, applicationTerm.getSort());
                    TermVariable termVariable = this.mMgdScript.constructFreshTermVariable("overaproxVar", sort2);
                    this.mOverapproxVariables.add(termVariable);
                    this.mIsOverapproximation = true;
                    this.setResult((Term)termVariable);
                    return;
                }
                if (!functionSymbol.isIntern()) break block36;
                switch (functionSymbol.getName()) {
                    case "bvor": {
                        Term term4 = BitvectorUtils.unfTerm(this.mScript, "bvsub", null, BitvectorUtils.unfTerm(this.mScript, "bvadd", null, applicationTerm.getParameters()), BitvectorUtils.unfTerm(this.mScript, "bvand", null, applicationTerm.getParameters()));
                        this.pushTerm(term4);
                        return;
                    }
                    case "bvxor": {
                        Term term5 = BitvectorUtils.unfTerm(this.mScript, "bvsub", null, BitvectorUtils.unfTerm(this.mScript, "bvsub", null, BitvectorUtils.unfTerm(this.mScript, "bvadd", null, applicationTerm.getParameters()), BitvectorUtils.unfTerm(this.mScript, "bvand", null, applicationTerm.getParameters())), BitvectorUtils.unfTerm(this.mScript, "bvand", null, applicationTerm.getParameters()));
                        this.pushTerm(term5);
                        return;
                    }
                    case "bvashr": {
                        this.pushTerm(this.bvashrAbbriviation(applicationTerm));
                        return;
                    }
                    case "sign_extend": {
                        this.pushTerm(this.signextendAbbriviation(applicationTerm));
                        return;
                    }
                    case "bvsrem": {
                        this.pushTerm(this.bvsremAbbriviation(applicationTerm));
                        return;
                    }
                    case "bvsdiv": {
                        this.pushTerm(this.bvsdivAbbriviation(applicationTerm));
                        return;
                    }
                }
                break block36;
            }
            if (term instanceof ConstantTerm) {
                BigInteger bigInteger;
                String string;
                if (!SmtSortUtils.isBitvecSort(term.getSort())) throw new UnsupportedOperationException("unexpected constant sort");
                ConstantTerm constantTerm = (ConstantTerm)term;
                assert (this.isBitVecSort(constantTerm.getSort()));
                if (constantTerm.getValue() instanceof String) {
                    string = (String)constantTerm.getValue();
                    if (string.startsWith("#b")) {
                        string = (String)constantTerm.getValue();
                        bigInteger = new BigInteger(string.substring(2), 2);
                    } else {
                        if (!string.startsWith("#x")) throw new UnsupportedOperationException("Unexpected constant type");
                        bigInteger = new BigInteger(string.substring(2), 16);
                    }
                } else {
                    bigInteger = (BigInteger)constantTerm.getValue();
                }
                string = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), sort);
                this.setResult((Term)string);
                return;
            }
        }
        super.convert(term);
    }

    private Term bvashrAbbriviation(ApplicationTerm applicationTerm) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term = SmtUtils.rational2Term(this.mScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term term2 = BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
        Term term3 = SmtUtils.binaryEquality(this.mScript, term2, term);
        Term term4 = BitvectorUtils.unfTerm(this.mScript, "bvlshr", null, applicationTerm.getParameters());
        Term term5 = BitvectorUtils.unfTerm(this.mScript, "bvnot", null, BitvectorUtils.unfTerm(this.mScript, "bvlshr", null, BitvectorUtils.unfTerm(this.mScript, "bvnot", null, applicationTerm.getParameters()[0]), applicationTerm.getParameters()[1]));
        Term term6 = SmtUtils.ite(this.mScript, term3, term4, term5);
        return term6;
    }

    private Term signextendAbbriviation(ApplicationTerm applicationTerm) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term = applicationTerm.getParameters()[0];
        int n = Integer.valueOf(applicationTerm.getSort().getIndices()[0]) - Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]);
        int n2 = 0;
        while (n2 < n) {
            term = BitvectorUtils.unfTerm(this.mScript, "concat", null, BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]), term);
            ++n2;
        }
        return term;
    }

    private Term bvsremAbbriviation(ApplicationTerm applicationTerm) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term = BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
        Term term2 = BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, applicationTerm.getParameters()[1]);
        Term term3 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term term4 = SmtUtils.rational2Term(this.mScript, Rational.ONE, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term term5 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, term3, term), SmtUtils.equality(this.mScript, term3, term2));
        Term term6 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, term4, term), SmtUtils.equality(this.mScript, term3, term2));
        Term term7 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, term3, term), SmtUtils.equality(this.mScript, term4, term2));
        Term term8 = BitvectorUtils.unfTerm(this.mScript, "bvurem", null, applicationTerm.getParameters());
        Term term9 = BitvectorUtils.unfTerm(this.mScript, "bvneg", null, BitvectorUtils.unfTerm(this.mScript, "bvurem", null, BitvectorUtils.unfTerm(this.mScript, "bvneg", null, applicationTerm.getParameters()[0]), applicationTerm.getParameters()[1]));
        Term term10 = BitvectorUtils.unfTerm(this.mScript, "bvneg", null, BitvectorUtils.unfTerm(this.mScript, "bvurem", null, applicationTerm.getParameters()[0], BitvectorUtils.unfTerm(this.mScript, "bvneg", null, applicationTerm.getParameters()[1])));
        Term term11 = BitvectorUtils.unfTerm(this.mScript, "bvneg", null, BitvectorUtils.unfTerm(this.mScript, "bvurem", null, BitvectorUtils.unfTerm(this.mScript, "bvneg", null, applicationTerm.getParameters()[0]), BitvectorUtils.unfTerm(this.mScript, "bvneg", null, applicationTerm.getParameters()[1])));
        Term term12 = SmtUtils.ite(this.mScript, term7, term10, term11);
        Term term13 = SmtUtils.ite(this.mScript, term6, term9, term12);
        Term term14 = SmtUtils.ite(this.mScript, term5, term8, term13);
        return term14;
    }

    private Term bvsdivAbbriviation(ApplicationTerm applicationTerm) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term term = BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, applicationTerm.getParameters()[0]);
        Term term2 = BitvectorUtils.unfTerm(this.mScript, "extract", bigIntegerArray, applicationTerm.getParameters()[1]);
        Term term3 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term term4 = SmtUtils.rational2Term(this.mScript, Rational.ONE, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term term5 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, term3, term), SmtUtils.equality(this.mScript, term3, term2));
        Term term6 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, term4, term), SmtUtils.equality(this.mScript, term3, term2));
        Term term7 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, term3, term), SmtUtils.equality(this.mScript, term4, term2));
        Term term8 = BitvectorUtils.unfTerm(this.mScript, "bvudiv", null, applicationTerm.getParameters());
        Term term9 = BitvectorUtils.unfTerm(this.mScript, "bvneg", null, BitvectorUtils.unfTerm(this.mScript, "bvudiv", null, BitvectorUtils.unfTerm(this.mScript, "bvneg", null, applicationTerm.getParameters()[0]), applicationTerm.getParameters()[1]));
        Term term10 = BitvectorUtils.unfTerm(this.mScript, "bvneg", null, BitvectorUtils.unfTerm(this.mScript, "bvudiv", null, applicationTerm.getParameters()[0], BitvectorUtils.unfTerm(this.mScript, "bvneg", null, applicationTerm.getParameters()[1])));
        Term term11 = BitvectorUtils.unfTerm(this.mScript, "bvudiv", null, BitvectorUtils.unfTerm(this.mScript, "bvneg", null, applicationTerm.getParameters()[0]), BitvectorUtils.unfTerm(this.mScript, "bvneg", null, applicationTerm.getParameters()[1]));
        Term term12 = SmtUtils.ite(this.mScript, term7, term10, term11);
        Term term13 = SmtUtils.ite(this.mScript, term6, term9, term12);
        Term term14 = SmtUtils.ite(this.mScript, term5, term8, term13);
        return term14;
    }

    private Term translateVars(Term term, boolean bl) {
        if (this.mVariableMap.containsKey(term)) {
            this.mReversedVarMap.put(this.mVariableMap.get(term), term);
            return this.mVariableMap.get(term);
        }
        Sort sort = term.getSort();
        if (SmtSortUtils.isArraySort(sort)) {
            TermVariable termVariable = this.mMgdScript.constructFreshTermVariable("arrayVar", IntBlastingWrapper.translateSort(this.mMgdScript.getScript(), sort));
            if (!(term instanceof TermVariable)) {
                termVariable = SmtUtils.termVariable2constant(this.mScript, termVariable, true);
            }
            if (bl) {
                this.mVariableMap.put(term, (Term)termVariable);
                this.mReversedVarMap.put((Term)termVariable, term);
            }
            return termVariable;
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            TermVariable termVariable = this.mMgdScript.constructFreshTermVariable("intVar", SmtSortUtils.getIntSort(this.mScript));
            if (!(term instanceof TermVariable)) {
                termVariable = SmtUtils.termVariable2constant(this.mScript, termVariable, true);
            }
            if (bl) {
                this.mVariableMap.put(term, (Term)termVariable);
                this.mReversedVarMap.put((Term)termVariable, term);
            }
            return termVariable;
        }
        return term;
    }

    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        if (term != quantifiedFormula.getSubformula()) {
            int n = 0;
            while (n < quantifiedFormula.getVariables().length) {
                if (SmtSortUtils.isBitvecSort(quantifiedFormula.getVariables()[n].getSort())) {
                    hashSet.add((TermVariable)this.mVariableMap.get(quantifiedFormula.getVariables()[n]));
                    hashSet2.add(this.mTc.getTvConstraint(quantifiedFormula.getVariables()[n], this.mVariableMap.get(quantifiedFormula.getVariables()[n])));
                } else if (SmtSortUtils.isArraySort(quantifiedFormula.getVariables()[n].getSort())) {
                    Term term2 = this.mVariableMap.get(quantifiedFormula.getVariables()[n]);
                    hashSet.add((TermVariable)term2);
                    Term term3 = this.mArraySelectConstraintMap.get(term2);
                    if (term3 != null) {
                        hashSet2.add(term3);
                    }
                    this.mArraySelectConstraintMap.remove(term2);
                } else {
                    hashSet.add(quantifiedFormula.getVariables()[n]);
                }
                ++n;
            }
            this.setResult(SmtUtils.quantifier(this.mScript, quantifiedFormula.getQuantifier(), hashSet, QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifiedFormula.getQuantifier(), term, QuantifierUtils.negateIfUniversal(this.mScript, quantifiedFormula.getQuantifier(), SmtUtils.and(this.mScript, hashSet2)))));
        } else {
            super.postConvertQuantifier(quantifiedFormula, term);
        }
    }

    private boolean overaproxWithVars(ApplicationTerm applicationTerm) {
        block17: {
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            if (!functionSymbol.isIntern()) break block17;
            switch (functionSymbol.getName()) {
                case "bvashr": 
                case "bvlshr": 
                case "bvor": 
                case "bvand": 
                case "bvshl": 
                case "bvxor": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void convertApplicationTerm(ApplicationTerm var1_1, Term[] var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[22] lbl150 : CaseStatement: default:\u000a, @NONE, blocks:[22] lbl150 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Term translateExtract(ApplicationTerm applicationTerm, Term term) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        BigInteger bigInteger = BigInteger.valueOf(2L);
        int n = Integer.parseInt(applicationTerm.getFunction().getIndices()[1]);
        int n2 = Integer.parseInt(applicationTerm.getFunction().getIndices()[0]);
        Term term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger.pow(n), (BigInteger)BigInteger.ONE), sort);
        Term term3 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger.pow(n2 - n + 1), (BigInteger)BigInteger.ONE), sort);
        return SmtUtils.mod(this.mScript, SmtUtils.unfTerm(this.mScript, "div", null, SmtSortUtils.getIntSort(this.mMgdScript), term, term2), term3);
    }

    private Term translateBvudiv(Term term, Term term2, Term term3) {
        Term term4;
        Term term5;
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (this.mNutzTransformation) {
            term5 = SmtUtils.mod(this.mScript, term2, term3);
            term4 = SmtUtils.mod(this.mScript, term, term3);
        } else {
            term5 = term2;
            term4 = term;
        }
        Term term6 = SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), term5, SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort));
        Term term7 = SmtUtils.unfTerm(this.mScript, "-", null, SmtSortUtils.getIntSort(this.mMgdScript), term3, SmtUtils.rational2Term(this.mScript, Rational.ONE, sort));
        Term term8 = SmtUtils.unfTerm(this.mScript, "div", null, SmtSortUtils.getIntSort(this.mMgdScript), term4, term5);
        return SmtUtils.ite(this.mScript, term6, term7, term8);
    }

    private Term translateBvurem(Term term, Term term2, Term term3) {
        Term term4;
        Term term5;
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (this.mNutzTransformation) {
            term5 = SmtUtils.mod(this.mScript, term2, term3);
            term4 = SmtUtils.mod(this.mScript, term, term3);
        } else {
            term5 = term2;
            term4 = term;
        }
        Term term6 = SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), term5, SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort));
        Term term7 = term;
        Term term8 = SmtUtils.mod(this.mScript, term4, term5);
        return SmtUtils.ite(this.mScript, term6, term7, term8);
    }

    private Term translateBvshl(Term term, Term term2, int n, Term term3) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (term2 instanceof ConstantTerm) {
            Term term4 = SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), term, this.pow2(term2));
            return SmtUtils.mod(this.mScript, term4, term3);
        }
        Term term5 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort);
        int n2 = n - 1;
        while (n2 >= 0) {
            if (n2 == 0) {
                var8_9 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)0L, (long)1L), sort);
                term5 = SmtUtils.ite(this.mScript, SmtUtils.binaryEquality(this.mScript, (Term)var8_9, term2), term, term5);
            } else {
                var8_9 = Rational.valueOf((long)n2, (long)1L);
                Term term6 = SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), term2, SmtUtils.rational2Term(this.mScript, var8_9, sort));
                int n3 = (int)Math.pow(2.0, n2);
                Term term7 = SmtUtils.mod(this.mScript, SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)n3, (long)1L), sort), term), term3);
                term5 = SmtUtils.ite(this.mScript, term6, term7, term5);
            }
            --n2;
        }
        return term5;
    }

    private Term translateBvlshr(Term term, Term term2, int n, Term term3) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (term2 instanceof ConstantTerm) {
            Term term4 = SmtUtils.unfTerm(this.mScript, "div", null, SmtSortUtils.getIntSort(this.mMgdScript), term, this.pow2(term2));
            return term4;
        }
        Term term5 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort);
        int n2 = n - 1;
        while (n2 >= 0) {
            if (n2 == 0) {
                var8_9 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)0L, (long)1L), sort);
                term5 = SmtUtils.ite(this.mScript, SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), new Term[]{var8_9, term2}), term, term5);
            } else {
                var8_9 = Rational.valueOf((long)n2, (long)1L);
                Term term6 = SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), term2, SmtUtils.rational2Term(this.mScript, var8_9, sort));
                int n3 = (int)Math.pow(2.0, n2);
                Term term7 = SmtUtils.unfTerm(this.mScript, "div", null, SmtSortUtils.getIntSort(this.mMgdScript), term, SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)n3, (long)1L), sort));
                term5 = SmtUtils.ite(this.mScript, term6, term7, term5);
            }
            --n2;
        }
        return term5;
    }

    private Term translateRelations(FunctionSymbol functionSymbol, Term[] termArray, Term term, int n) {
        block50: {
            Term[] termArray2 = new Term[termArray.length];
            Term[] termArray3 = termArray;
            termArray2 = termArray;
            if (!functionSymbol.isIntern()) break block50;
            switch (functionSymbol.getName()) {
                case "=": {
                    if (this.mNutzTransformation && SmtSortUtils.isNumericSort(termArray[0].getSort())) {
                        int n2 = 0;
                        while (n2 < termArray.length) {
                            termArray2[n2] = SmtUtils.mod(this.mScript, termArray[n2], term);
                            ++n2;
                        }
                    }
                    return SmtUtils.unfTerm(this.mScript, "=", null, SmtSortUtils.getIntSort(this.mMgdScript), termArray2);
                }
                case "distinct": {
                    if (this.mNutzTransformation) {
                        int n3 = 0;
                        while (n3 < termArray.length) {
                            termArray2[n3] = SmtUtils.mod(this.mScript, termArray[n3], term);
                            ++n3;
                        }
                    }
                    return SmtUtils.unfTerm(this.mScript, "distinct", null, SmtSortUtils.getIntSort(this.mMgdScript), termArray2);
                }
                case "bvult": {
                    if (this.mNutzTransformation) {
                        int n4 = 0;
                        while (n4 < termArray.length) {
                            termArray2[n4] = SmtUtils.mod(this.mScript, termArray[n4], term);
                            ++n4;
                        }
                    }
                    return SmtUtils.less(this.mScript, termArray2[0], termArray2[1]);
                }
                case "bvule": {
                    if (this.mNutzTransformation) {
                        int n5 = 0;
                        while (n5 < termArray.length) {
                            termArray2[n5] = SmtUtils.mod(this.mScript, termArray[n5], term);
                            ++n5;
                        }
                    }
                    return SmtUtils.leq(this.mScript, termArray2[0], termArray2[1]);
                }
                case "bvugt": {
                    if (this.mNutzTransformation) {
                        int n6 = 0;
                        while (n6 < termArray.length) {
                            termArray2[n6] = SmtUtils.mod(this.mScript, termArray[n6], term);
                            ++n6;
                        }
                    }
                    return SmtUtils.greater(this.mScript, termArray2[0], termArray2[1]);
                }
                case "bvuge": {
                    if (this.mNutzTransformation) {
                        int n7 = 0;
                        while (n7 < termArray.length) {
                            termArray2[n7] = SmtUtils.mod(this.mScript, termArray[n7], term);
                            ++n7;
                        }
                    }
                    return SmtUtils.geq(this.mScript, termArray2[0], termArray2[1]);
                }
                case "bvslt": {
                    int n8 = 0;
                    while (n8 < termArray.length) {
                        termArray3[n8] = this.uts(n, termArray[n8], this.mNutzTransformation);
                        ++n8;
                    }
                    return SmtUtils.less(this.mScript, termArray3[0], termArray3[1]);
                }
                case "bvsle": {
                    int n9 = 0;
                    while (n9 < termArray.length) {
                        termArray3[n9] = this.uts(n, termArray[n9], this.mNutzTransformation);
                        ++n9;
                    }
                    return SmtUtils.leq(this.mScript, termArray3[0], termArray3[1]);
                }
                case "bvsgt": {
                    int n10 = 0;
                    while (n10 < termArray.length) {
                        termArray3[n10] = this.uts(n, termArray[n10], this.mNutzTransformation);
                        ++n10;
                    }
                    return SmtUtils.greater(this.mScript, termArray3[0], termArray3[1]);
                }
                case "bvsge": {
                    int n11 = 0;
                    while (n11 < termArray.length) {
                        termArray3[n11] = this.uts(n, termArray[n11], this.mNutzTransformation);
                        ++n11;
                    }
                    return SmtUtils.geq(this.mScript, termArray3[0], termArray3[1]);
                }
            }
        }
        throw new UnsupportedOperationException("unexpected relation");
    }

    private final Term uts(int n, Term term, boolean bl) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        Term term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L), (BigInteger)BigInteger.ONE), sort);
        Term term3 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n - 1), (BigInteger)BigInteger.ONE), sort);
        if (bl) {
            Term term4 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n), (BigInteger)BigInteger.ONE), sort);
            Term term5 = SmtUtils.mod(this.mScript, SmtUtils.mod(this.mScript, term, term4), term3);
            return SmtUtils.unfTerm(this.mScript, "-", null, SmtSortUtils.getIntSort(this.mMgdScript), SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), term2, term5), SmtUtils.mod(this.mScript, term, term4));
        }
        Term term6 = SmtUtils.mod(this.mScript, term, term3);
        return SmtUtils.unfTerm(this.mScript, "-", null, SmtSortUtils.getIntSort(this.mMgdScript), SmtUtils.unfTerm(this.mScript, "*", null, SmtSortUtils.getIntSort(this.mMgdScript), term2, term6), term);
    }

    private Term pow2(Term term) {
        assert (term.getSort().isNumericSort());
        if (term instanceof ConstantTerm) {
            Term term2;
            Sort sort = SmtSortUtils.getIntSort(this.mScript);
            ConstantTerm constantTerm = (ConstantTerm)term;
            if (constantTerm.getValue() instanceof Rational) {
                Rational rational = (Rational)constantTerm.getValue();
                term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(rational.numerator().intValue()), (BigInteger)BigInteger.ONE), sort);
            } else {
                BigInteger bigInteger = (BigInteger)constantTerm.getValue();
                term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(bigInteger.intValue()), (BigInteger)BigInteger.ONE), sort);
            }
            return term2;
        }
        throw new UnsupportedOperationException("function pow2 not implemented");
    }

    private boolean isBitVecSort(Sort sort) {
        return sort.getName().equals("BitVec");
    }

    private Sort translateSort(Script script, Sort sort) {
        Sort sort2;
        if (this.isBitVecSort(sort)) {
            sort2 = SmtSortUtils.getIntSort(script);
        } else if (SmtSortUtils.isArraySort(sort)) {
            sort2 = IntBlastingWrapper.translateSort(this.mMgdScript.getScript(), sort);
        } else {
            throw new UnsupportedOperationException("Unsupported sort: " + String.valueOf(sort));
        }
        return sort2;
    }

    public LinkedHashMap<Term, Term> getVarMap() {
        return this.mVariableMap;
    }

    public LinkedHashMap<Term, Term> getReversedVarMap() {
        return this.mReversedVarMap;
    }

    public Set<TermVariable> getOverapproxVariables() {
        return this.mOverapproxVariables;
    }

    public boolean wasOverapproximation() {
        return this.mIsOverapproximation;
    }
}

