/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogieOutput;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DefaultLocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.ITerm2ExpressionSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Term2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.PathProgram;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Quad;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class PathProgramDumper {
    private final InputMode mInputMode;
    private final boolean FILTER_VARIABLES_OF_BOOGIE_INPUT = false;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ConstructionCache.IValueConstruction<IcfgLocation, String> mLoc2LabelVC = new ConstructionCache.IValueConstruction<IcfgLocation, String>(){
        private int mCounter = 0;

        public String constructValue(IcfgLocation icfgLocation) {
            String string = "loc" + String.valueOf(this.mCounter);
            ++this.mCounter;
            return string;
        }
    };
    private final ConstructionCache<IcfgLocation, String> mLoc2LabelId = new ConstructionCache(this.mLoc2LabelVC);
    private final PathProgram mPathProgram;
    private final IIcfg<?> mOriginalIcfg;
    private final Term2Expression mTerm2Expression;
    private final TypeSortTranslator mTypeSortTranslator;

    public PathProgramDumper(IIcfg<?> iIcfg, IUltimateServiceProvider iUltimateServiceProvider, IRun<? extends IAction, ?> iRun, String string, InputMode inputMode) {
        Map.Entry entry22;
        Object object;
        IcfgLocation icfgLocation2;
        Object object2;
        Object object3;
        Unit unit;
        Object object4;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mOriginalIcfg = iIcfg;
        this.mInputMode = inputMode;
        if (this.mInputMode == InputMode.BOOGIE) {
            if (!(iIcfg instanceof BoogieIcfgContainer)) {
                throw new UnsupportedOperationException("PathProgramDumper currently needs BoogieIcfgContainer");
            }
            this.mTerm2Expression = null;
            this.mTypeSortTranslator = ((BoogieIcfgContainer)iIcfg).getBoogie2SMT().getTypeSortTranslator();
        } else {
            object4 = this.constructFakeTypeSortTranslator(iIcfg.getCfgSmtToolkit().getManagedScript());
            unit = new Unit(PathProgramDumper.constructNewLocation(), new Declaration[0]);
            object3 = new BoogieDeclarations(unit, this.mLogger);
            object2 = new FakeBoogie2SmtSymbolTable(iIcfg.getCfgSmtToolkit().getManagedScript(), (TypeSortTranslator)object4, iIcfg.getCfgSmtToolkit().getSymbolTable(), (BoogieDeclarations)object3);
            this.mTerm2Expression = new Term2Expression(object4, (ITerm2ExpressionSymbolTable)object2, iIcfg.getCfgSmtToolkit().getManagedScript());
            this.mTypeSortTranslator = new TypeSortTranslator(iIcfg.getCfgSmtToolkit().getManagedScript().getScript(), iUltimateServiceProvider);
        }
        object4 = PathProgramDumper.extractTransitionsFromRun((Word<? extends IAction>)iRun.getWord());
        unit = PathProgram.constructPathProgram((String)"PathInvariantsPathProgram", iIcfg, (Set)object4, Collections.emptySet(), icfgLocation -> true);
        this.mPathProgram = unit.getPathProgram();
        object3 = new ArrayList();
        object2 = new HashSet();
        for (Map.Entry boogieIcfgContainer2 : this.mPathProgram.getProcedureEntryNodes().entrySet()) {
            Procedure procedure;
            Procedure procedure2;
            BoogieIcfgContainer boogieIcfgContainer;
            icfgLocation2 = (IcfgLocation)this.mPathProgram.getProcedureExitNodes().get(boogieIcfgContainer2.getKey());
            if (this.mInputMode == InputMode.BOOGIE) {
                boogieIcfgContainer = (BoogieIcfgContainer)iIcfg;
                object = this.constructNewImplementation((String)boogieIcfgContainer2.getKey(), (IcfgLocation)boogieIcfgContainer2.getValue(), icfgLocation2, boogieIcfgContainer, (Set)this.mPathProgram.getProcedureErrorNodes().get(boogieIcfgContainer2.getKey()));
            } else {
                object = this.constructNewImplementation((String)boogieIcfgContainer2.getKey(), (IcfgLocation)boogieIcfgContainer2.getValue(), icfgLocation2, (Set)this.mPathProgram.getProcedureErrorNodes().get(boogieIcfgContainer2.getKey()));
            }
            object3.add((Declaration)object.getFirst());
            object2.addAll((Collection)object.getSecond());
            if (this.mInputMode != InputMode.BOOGIE || (procedure2 = (Procedure)(boogieIcfgContainer = (BoogieIcfgContainer)iIcfg).getBoogieDeclarations().getProcSpecification().get(boogieIcfgContainer2.getKey())) == (procedure = (Procedure)boogieIcfgContainer.getBoogieDeclarations().getProcImplementation().get(boogieIcfgContainer2.getKey()))) continue;
            object3.add(procedure2);
        }
        if (this.mInputMode == InputMode.BOOGIE) {
            BoogieIcfgContainer boogieIcfgContainer = (BoogieIcfgContainer)iIcfg;
            for (Map.Entry entry22 : boogieIcfgContainer.getBoogieDeclarations().getProcSpecification().entrySet()) {
                if (((Procedure)entry22.getValue()).getBody() != null || boogieIcfgContainer.getProcedureEntryNodes().containsKey(entry22.getKey())) continue;
                object3.add((Declaration)entry22.getValue());
            }
            object3.addAll(0, boogieIcfgContainer.getBoogieDeclarations().getGlobalVarDeclarations());
            object3.addAll(0, boogieIcfgContainer.getBoogieDeclarations().getFunctionDeclarations());
            object3.addAll(0, boogieIcfgContainer.getBoogieDeclarations().getAxioms());
            object3.addAll(0, boogieIcfgContainer.getBoogieDeclarations().getConstDeclarations());
            object3.addAll(0, boogieIcfgContainer.getBoogieDeclarations().getTypeDeclarations());
        } else {
            object3.addAll(0, Arrays.asList(this.constructDeclarations((Set<IProgramVar>)object2)));
        }
        Unit unit2 = new Unit(PathProgramDumper.constructNewLocation(), object3.toArray(new Declaration[object3.size()]));
        entry22 = new File(string);
        this.mLogger.warn((Object)("Writing path program to file " + ((File)((Object)entry22)).getAbsolutePath()));
        try {
            object = new PrintWriter(new FileWriter((File)((Object)entry22)));
            icfgLocation2 = new BoogieOutput((PrintWriter)object);
            icfgLocation2.printBoogieProgram(unit2);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private TypeSortTranslator constructFakeTypeSortTranslator(ManagedScript managedScript) {
        TypeSortTranslator typeSortTranslator = new TypeSortTranslator(Collections.emptySet(), managedScript.getScript(), this.mServices);
        BoogiePrimitiveType boogiePrimitiveType = BoogieType.TYPE_INT;
        BoogieASTNode boogieASTNode = new BoogieASTNode(PathProgramDumper.constructNewLocation());
        typeSortTranslator.getSort((IBoogieType)boogiePrimitiveType, boogieASTNode);
        return typeSortTranslator;
    }

    private Pair<Procedure, Set<IProgramVar>> constructNewImplementation(String string, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, BoogieIcfgContainer boogieIcfgContainer, Set<IcfgLocation> set) {
        Procedure procedure = (Procedure)boogieIcfgContainer.getBoogieDeclarations().getProcImplementation().get(string);
        Body body = procedure.getBody();
        Triple<List<Statement>, Set<IProgramVar>, Set<IProgramVar>> triple = this.constructProcedureStatements(string, icfgLocation, icfgLocation2, set);
        List list = (List)triple.getFirst();
        VariableDeclaration[] variableDeclarationArray = body.getLocalVars();
        Body body2 = new Body(PathProgramDumper.constructNewLocation(), variableDeclarationArray, list.toArray(new Statement[list.size()]));
        Specification[] specificationArray = procedure.getSpecification() == null ? null : procedure.getSpecification();
        Procedure procedure2 = new Procedure(PathProgramDumper.constructNewLocation(), procedure.getAttributes(), procedure.getIdentifier(), procedure.getTypeParams(), procedure.getInParams(), procedure.getOutParams(), specificationArray, body2);
        return new Pair((Object)procedure2, (Object)((Set)triple.getThird()));
    }

    private Pair<Procedure, Set<IProgramVar>> constructNewImplementation(String string, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, Set<IcfgLocation> set) {
        Triple<List<Statement>, Set<IProgramVar>, Set<IProgramVar>> triple = this.constructProcedureStatements(string, icfgLocation, icfgLocation2, set);
        List list = (List)triple.getFirst();
        Set set2 = (Set)triple.getSecond();
        VariableDeclaration[] variableDeclarationArray = this.constructDeclarations(set2);
        Body body = new Body(PathProgramDumper.constructNewLocation(), variableDeclarationArray, list.toArray(new Statement[list.size()]));
        Attribute[] attributeArray = new Attribute[]{};
        String string2 = icfgLocation.getProcedure();
        String[] stringArray = new String[]{};
        VarList[] varListArray = new VarList[]{};
        VarList[] varListArray2 = new VarList[]{};
        VariableLHS[] variableLHSArray = new VariableLHS[((Set)triple.getThird()).size()];
        int n = 0;
        for (IProgramVar iProgramVar : (Set)triple.getThird()) {
            variableLHSArray[n] = new VariableLHS(PathProgramDumper.constructNewLocation(), this.translateIdentifier(iProgramVar));
            ++n;
        }
        ModifiesSpecification modifiesSpecification = new ModifiesSpecification(PathProgramDumper.constructNewLocation(), false, variableLHSArray);
        variableLHSArray = new Specification[]{modifiesSpecification};
        Procedure procedure = new Procedure(PathProgramDumper.constructNewLocation(), attributeArray, string2, stringArray, varListArray, varListArray2, (Specification[])variableLHSArray, body);
        return new Pair((Object)procedure, (Object)((Set)triple.getThird()));
    }

    private VariableDeclaration[] constructDeclarations(Set<IProgramVar> set) {
        VariableDeclaration[] variableDeclarationArray = new VariableDeclaration[set.size()];
        int n = 0;
        for (IProgramVar iProgramVar : set) {
            ASTType aSTType;
            String string;
            IdentifierExpression identifierExpression = this.translateVar(iProgramVar);
            Attribute[] attributeArray = new Attribute[]{};
            String[] stringArray = new String[]{identifierExpression.getIdentifier()};
            if (this.mInputMode == InputMode.BOOGIE) {
                if (SmtSortUtils.isIntSort((Sort)iProgramVar.getTermVariable().getSort())) {
                    string = "int";
                } else if (SmtSortUtils.isBoolSort((Sort)iProgramVar.getTermVariable().getSort())) {
                    string = "bool";
                } else {
                    throw new UnsupportedOperationException("Translation does not support sort " + iProgramVar.getTermVariable().getSort().getName());
                }
                aSTType = new PrimitiveType(PathProgramDumper.constructNewLocation(), string);
            } else {
                string = (BoogieType)this.mTypeSortTranslator.getType(iProgramVar.getTermVariable().getSort());
                aSTType = string.toASTType(PathProgramDumper.constructNewLocation());
            }
            string = new VarList(PathProgramDumper.constructNewLocation(), stringArray, aSTType);
            VarList[] varListArray = new VarList[]{string};
            variableDeclarationArray[n] = new VariableDeclaration(PathProgramDumper.constructNewLocation(), attributeArray, varListArray);
            ++n;
        }
        return variableDeclarationArray;
    }

    private String translateIdentifier(IProgramVar iProgramVar) {
        String string = ((IdentifierExpression)this.mTerm2Expression.translate((Term)iProgramVar.getTermVariable())).getIdentifier();
        if (string == null) {
            throw new AssertionError((Object)("unable to translate " + String.valueOf(iProgramVar)));
        }
        return string;
    }

    private IdentifierExpression translateVar(IProgramVar iProgramVar) {
        IdentifierExpression identifierExpression = (IdentifierExpression)this.mTerm2Expression.translate((Term)iProgramVar.getTermVariable());
        if (identifierExpression == null) {
            throw new AssertionError((Object)("unable to translateI " + String.valueOf(iProgramVar)));
        }
        return identifierExpression;
    }

    private static Specification[] filterModifiesSpecifications(Specification[] specificationArray, Set<String> set) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Specification[] specificationArray2 = specificationArray;
        int n = specificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Specification specification = specificationArray2[n2];
            if (specification instanceof ModifiesSpecification) {
                arrayList.add(PathProgramDumper.filter((ModifiesSpecification)specification, set));
            } else {
                arrayList.add(specification);
            }
            ++n2;
        }
        return arrayList.toArray(new Specification[arrayList.size()]);
    }

    private static ModifiesSpecification filter(ModifiesSpecification modifiesSpecification, Set<String> set) {
        ArrayList<VariableLHS> arrayList = new ArrayList<VariableLHS>();
        VariableLHS[] variableLHSArray = modifiesSpecification.getIdentifiers();
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLHS variableLHS = variableLHSArray[n2];
            if (set.contains(variableLHS.getIdentifier())) {
                arrayList.add(variableLHS);
            }
            ++n2;
        }
        return new ModifiesSpecification(modifiesSpecification.getLocation(), modifiesSpecification.isFree(), arrayList.toArray(new VariableLHS[arrayList.size()]));
    }

    private static Set<String> extractIdentifiers(Set<IProgramVar> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (IProgramVar iProgramVar : set) {
            if (iProgramVar instanceof IProgramOldVar) {
                hashSet.add(((IProgramOldVar)iProgramVar).getIdentifierOfNonOldVar());
                continue;
            }
            if (iProgramVar instanceof IProgramNonOldVar) {
                hashSet.add(((IProgramNonOldVar)iProgramVar).getIdentifier());
                continue;
            }
            if (iProgramVar instanceof ILocalProgramVar) {
                hashSet.add(((ILocalProgramVar)iProgramVar).getIdentifier());
                continue;
            }
            throw new IllegalArgumentException("unknown type of var " + String.valueOf(iProgramVar));
        }
        return hashSet;
    }

    private static VariableDeclaration[] filter(List<VariableDeclaration> list, Set<String> set) {
        ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
        for (VariableDeclaration variableDeclaration : list) {
            VariableDeclaration variableDeclaration2 = PathProgramDumper.filter(variableDeclaration, set);
            if (variableDeclaration2 == null) continue;
            arrayList.add(variableDeclaration2);
        }
        return arrayList.toArray(new VariableDeclaration[arrayList.size()]);
    }

    private static VariableDeclaration filter(VariableDeclaration variableDeclaration, Set<String> set) {
        ArrayList<VarList> arrayList = new ArrayList<VarList>();
        VarList[] varListArray = variableDeclaration.getVariables();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray[n2];
            String[] stringArray = PathProgramDumper.filter(varList.getIdentifiers(), set);
            if (stringArray.length > 0) {
                arrayList.add(new VarList(varList.getLocation(), stringArray, varList.getType()));
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new VariableDeclaration(variableDeclaration.getLocation(), new Attribute[0], arrayList.toArray(new VarList[arrayList.size()]));
    }

    private static String[] filter(String[] stringArray, Set<String> set) {
        Predicate<String> predicate = string -> set.contains(string);
        return (String[])Arrays.stream(stringArray).filter(predicate).toArray(String[]::new);
    }

    private Triple<List<Statement>, Set<IProgramVar>, Set<IProgramVar>> constructProcedureStatements(String string, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, Set<IcfgLocation> set) {
        ArrayDeque<IcfgLocation> arrayDeque = new ArrayDeque<IcfgLocation>();
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        arrayDeque.add(icfgLocation);
        hashSet.add(icfgLocation);
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>();
        HashSet<IProgramVar> hashSet3 = new HashSet<IProgramVar>();
        while (!arrayDeque.isEmpty()) {
            String string2;
            IcfgEdge icfgEdge2;
            IcfgLocation icfgLocation3 = (IcfgLocation)arrayDeque.remove();
            if (!icfgLocation3.getProcedure().equals(string)) {
                throw new AssertionError((Object)"added location from different procedure");
            }
            arrayList.add(this.constructLabel(icfgLocation3));
            if (set != null && set.contains(icfgLocation3)) {
                arrayList.add((Statement)new AssertStatement(PathProgramDumper.constructNewLocation(), (Expression)new BooleanLiteral(PathProgramDumper.constructNewLocation(), false)));
                assert (icfgLocation3.getOutgoingEdges().isEmpty()) : "error loc with outgoing transitions";
            }
            ArrayList<IcfgEdge> arrayList2 = new ArrayList<IcfgEdge>();
            for (IcfgEdge icfgEdge2 : icfgLocation3.getOutgoingEdges()) {
                if (icfgEdge2 instanceof Summary) {
                    if (((Summary)icfgEdge2).calledProcedureHasImplementation()) continue;
                    arrayList2.add(icfgEdge2);
                    continue;
                }
                arrayList2.add(icfgEdge2);
            }
            if (!icfgLocation3.getProcedure().equals(string) || arrayList2.isEmpty()) continue;
            if (arrayList2.size() == 1) {
                icfgEdge2 = (IcfgEdge)arrayList2.get(0);
                this.processTransition(arrayDeque, hashSet, arrayList, hashSet2, hashSet3, icfgEdge2);
                continue;
            }
            icfgEdge2 = new String[arrayList2.size()];
            int n = 0;
            while (n < arrayList2.size()) {
                string2 = this.constructLabelId(icfgLocation3, n);
                icfgEdge2[n] = string2;
                ++n;
            }
            if (!arrayList2.isEmpty()) {
                arrayList.add((Statement)new GotoStatement(PathProgramDumper.constructNewLocation(), (String[])icfgEdge2));
            }
            n = 0;
            while (n < arrayList2.size()) {
                string2 = (IcfgEdge)arrayList2.get(n);
                if (!(string2 instanceof Summary)) {
                    arrayList.add(this.constructLabel(icfgLocation3, n));
                    this.processTransition(arrayDeque, hashSet, arrayList, hashSet2, hashSet3, (IcfgEdge)string2);
                }
                ++n;
            }
        }
        return new Triple(arrayList, hashSet2, hashSet3);
    }

    private void processTransition(ArrayDeque<IcfgLocation> arrayDeque, Set<IcfgLocation> set, List<Statement> list, Set<IProgramVar> set2, Set<IProgramVar> set3, IcfgEdge icfgEdge) {
        Quad<List<Statement>, Set<IProgramVar>, Set<IProgramVar>, IcfgLocation> quad = this.constructTransitionStatements(icfgEdge);
        String string = icfgEdge.getPrecedingProcedure();
        list.addAll((Collection)quad.getFirst());
        set2.addAll((Collection)quad.getSecond());
        set3.addAll((Collection)quad.getThird());
        if (quad.getFourth() != null && ((IcfgLocation)quad.getFourth()).getProcedure().equals(string) && !set.contains(quad.getFourth()) && !this.isProcedureExit((IcfgLocation)quad.getFourth())) {
            arrayDeque.add((IcfgLocation)quad.getFourth());
            set.add((IcfgLocation)quad.getFourth());
        }
    }

    private String constructLabelId(IcfgLocation icfgLocation) {
        return (String)this.mLoc2LabelId.getOrConstruct((Object)icfgLocation);
    }

    private String constructLabelId(IcfgLocation icfgLocation, int n) {
        return (String)this.mLoc2LabelId.getOrConstruct((Object)icfgLocation) + "_" + n;
    }

    private Statement constructLabel(IcfgLocation icfgLocation) {
        return new Label(PathProgramDumper.constructNewLocation(), this.constructLabelId(icfgLocation));
    }

    private Statement constructLabel(IcfgLocation icfgLocation, int n) {
        return new Label(PathProgramDumper.constructNewLocation(), this.constructLabelId(icfgLocation, n));
    }

    private Quad<List<Statement>, Set<IProgramVar>, Set<IProgramVar>, IcfgLocation> constructTransitionStatements(IcfgEdge icfgEdge) {
        String string = icfgEdge.getPrecedingProcedure();
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>();
        IcfgLocation icfgLocation = this.addStatementsAndVariables(icfgEdge, arrayList, hashSet, hashSet2);
        while (icfgLocation != null && icfgLocation.getProcedure().equals(string) && PathProgramDumper.isBridgingLocation(icfgLocation) && !this.isProcedureExit(icfgLocation)) {
            icfgEdge = (IcfgEdge)icfgLocation.getOutgoingEdges().get(0);
            icfgLocation = this.addStatementsAndVariables(icfgEdge, arrayList, hashSet, hashSet2);
        }
        if (icfgLocation == null || this.isProcedureExit(icfgLocation)) {
            arrayList.add((Statement)new ReturnStatement(PathProgramDumper.constructNewLocation()));
        } else {
            String string2 = this.constructLabelId(icfgLocation);
            arrayList.add((Statement)new GotoStatement(PathProgramDumper.constructNewLocation(), new String[]{string2}));
        }
        return new Quad(arrayList, hashSet, hashSet2, (Object)icfgLocation);
    }

    private boolean isProcedureExit(IcfgLocation icfgLocation) {
        IcfgLocation icfgLocation2 = (IcfgLocation)this.mPathProgram.getProcedureExitNodes().get(icfgLocation.getProcedure());
        return icfgLocation.equals((Object)icfgLocation2);
    }

    private IcfgLocation addStatementsAndVariables(IcfgEdge icfgEdge, List<Statement> list, Set<IProgramVar> set, Set<IProgramVar> set2) {
        SimultaneousUpdate simultaneousUpdate;
        IcfgEdge icfgEdge2 = icfgEdge;
        if (this.mInputMode == InputMode.BOOGIE) {
            if (icfgEdge.getLabel() instanceof Call) {
                PathProgramDumper.addVars(icfgEdge2.getTransformula().getInVars().keySet(), set, set2);
                IIcfgReturnTransition<?, ?> iIcfgReturnTransition = this.getCorrespondingReturn((IAction)icfgEdge2, Program.PATH_PROGRAM);
                CallStatement callStatement = ((Call)icfgEdge.getLabel()).getCallStatement();
                list.add((Statement)callStatement);
                if (iIcfgReturnTransition == null) {
                    IIcfgReturnTransition<?, ?> iIcfgReturnTransition2 = this.getCorrespondingReturn((IAction)icfgEdge.getLabel(), Program.ORIGINAL_PROGRAM);
                    PathProgramDumper.addVars(iIcfgReturnTransition2.getTransformula().getOutVars().keySet(), set, set2);
                    return null;
                }
                PathProgramDumper.addVars(iIcfgReturnTransition.getTransformula().getOutVars().keySet(), set, set2);
                return iIcfgReturnTransition.getTarget();
            }
            if (icfgEdge.getLabel() instanceof Return) {
                throw new AssertionError((Object)"we should have stopped at procedure exit");
            }
            if (icfgEdge.getLabel() instanceof StatementSequence) {
                PathProgramDumper.addVars(icfgEdge2.getTransformula().getInVars().keySet(), set, set2);
                PathProgramDumper.addVars(icfgEdge2.getTransformula().getOutVars().keySet(), set, set2);
                StatementSequence statementSequence = (StatementSequence)icfgEdge.getLabel();
                list.addAll(statementSequence.getStatements());
                return (IcfgLocation)icfgEdge.getTarget();
            }
            if (!(icfgEdge.getLabel() instanceof Summary)) {
                throw new UnsupportedOperationException("unsupported edge " + icfgEdge2.getClass().getSimpleName());
            }
            PathProgramDumper.addVars(icfgEdge2.getTransformula().getInVars().keySet(), set, set2);
            PathProgramDumper.addVars(icfgEdge2.getTransformula().getOutVars().keySet(), set, set2);
            Summary summary = (Summary)icfgEdge.getLabel();
            if (summary.calledProcedureHasImplementation()) {
                throw new AssertionError((Object)"edges like this should have been omitted");
            }
            list.add((Statement)summary.getCallStatement());
            return (IcfgLocation)icfgEdge.getTarget();
        }
        PathProgramDumper.addVars(icfgEdge2.getTransformula().getInVars().keySet(), set, set2);
        PathProgramDumper.addVars(icfgEdge2.getTransformula().getOutVars().keySet(), set, set2);
        ManagedScript managedScript = this.mPathProgram.getCfgSmtToolkit().getManagedScript();
        UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)icfgEdge2.getTransformula(), (ManagedScript)managedScript, (IUltimateServiceProvider)this.mServices);
        Term term = this.renameInvarsToDefaultVars(managedScript, unmodifiableTransFormula);
        Expression expression = this.mTerm2Expression.translate(term);
        AssumeStatement assumeStatement = new AssumeStatement(PathProgramDumper.constructNewLocation(), expression);
        try {
            simultaneousUpdate = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)this.mServices, (TransFormula)icfgEdge2.getTransformula(), (ManagedScript)managedScript);
        }
        catch (SimultaneousUpdate.SimultaneousUpdateException simultaneousUpdateException) {
            throw new IllegalArgumentException(simultaneousUpdateException.getMessage());
        }
        HavocStatement havocStatement = new LeftHandSide[simultaneousUpdate.getDeterministicAssignment().size()];
        Expression[] expressionArray = new Expression[simultaneousUpdate.getDeterministicAssignment().size()];
        int n = 0;
        for (Map.Entry iProgramVar : simultaneousUpdate.getDeterministicAssignment().entrySet()) {
            havocStatement[n] = new VariableLHS(PathProgramDumper.constructNewLocation(), ((IdentifierExpression)this.mTerm2Expression.translate((Term)((IProgramVar)iProgramVar.getKey()).getTermVariable())).getIdentifier());
            expressionArray[n] = this.mTerm2Expression.translate((Term)iProgramVar.getValue());
            ++n;
        }
        AssignmentStatement assignmentStatement = new AssignmentStatement(PathProgramDumper.constructNewLocation(), (LeftHandSide[])havocStatement, expressionArray);
        expressionArray = new VariableLHS[simultaneousUpdate.getHavocedVars().size()];
        n = 0;
        for (IProgramVar iProgramVar : simultaneousUpdate.getHavocedVars()) {
            expressionArray[n] = new VariableLHS(PathProgramDumper.constructNewLocation(), this.translateIdentifier(iProgramVar));
            ++n;
        }
        havocStatement = new HavocStatement(PathProgramDumper.constructNewLocation(), (VariableLHS[])expressionArray);
        if (!SmtUtils.isTrueLiteral((Term)term)) {
            list.add((Statement)assumeStatement);
        }
        if (!simultaneousUpdate.getDeterministicAssignment().isEmpty()) {
            list.add((Statement)assignmentStatement);
        }
        if (!simultaneousUpdate.getHavocedVars().isEmpty()) {
            list.add((Statement)havocStatement);
        }
        return (IcfgLocation)icfgEdge.getTarget();
    }

    private Term renameInvarsToDefaultVars(ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula) {
        boolean bl = TransFormulaUtils.eachFreeVarIsInvar((TransFormula)unmodifiableTransFormula, (Term)unmodifiableTransFormula.getFormula());
        if (!bl) {
            throw new IllegalArgumentException("term contains non-Invar");
        }
        Map map = TransFormulaUtils.constructInvarsToDefaultvarsMap((TransFormula)unmodifiableTransFormula);
        return Substitution.apply((ManagedScript)managedScript, (Map)map, (Term)unmodifiableTransFormula.getFormula());
    }

    private IIcfgReturnTransition<?, ?> getCorrespondingReturn(IAction iAction, Program program) {
        IcfgLocation icfgLocation = switch (program) {
            case Program.ORIGINAL_PROGRAM -> (IcfgLocation)this.mOriginalIcfg.getProcedureExitNodes().get(iAction.getSucceedingProcedure());
            case Program.PATH_PROGRAM -> (IcfgLocation)this.mPathProgram.getProcedureExitNodes().get(iAction.getSucceedingProcedure());
            default -> throw new MatchException(null, null);
        };
        if (icfgLocation == null) {
            return null;
        }
        IIcfgReturnTransition iIcfgReturnTransition = null;
        for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
            IIcfgReturnTransition iIcfgReturnTransition2 = (IIcfgReturnTransition)icfgEdge;
            if (!iIcfgReturnTransition2.getCorrespondingCall().equals(iAction)) continue;
            if (iIcfgReturnTransition != null) {
                throw new AssertionError((Object)"several corresponding returns");
            }
            iIcfgReturnTransition = iIcfgReturnTransition2;
        }
        if (iIcfgReturnTransition == null) {
            throw new AssertionError((Object)"no corresponding return");
        }
        return iIcfgReturnTransition;
    }

    private static void addVars(Set<IProgramVar> set, Set<IProgramVar> set2, Set<IProgramVar> set3) {
        for (IProgramVar iProgramVar : set) {
            if (iProgramVar instanceof IProgramOldVar || iProgramVar instanceof IProgramNonOldVar) {
                set3.add(iProgramVar);
                continue;
            }
            if (iProgramVar instanceof ILocalProgramVar) {
                set2.add(iProgramVar);
                continue;
            }
            throw new IllegalArgumentException("unknown type of var " + String.valueOf(iProgramVar));
        }
    }

    private static boolean isBridgingLocation(IcfgLocation icfgLocation) {
        return icfgLocation.getIncomingEdges().size() == 1 && icfgLocation.getOutgoingEdges().size() == 1;
    }

    private static ILocation constructNewLocation() {
        return new DefaultLocation();
    }

    private static Set<? extends IcfgEdge> extractTransitionsFromRun(Word<? extends IAction> word) {
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        for (IAction iAction : word) {
            IcfgEdge icfgEdge = (IcfgEdge)iAction;
            hashSet.add(icfgEdge);
        }
        return hashSet;
    }

    private static final class FakeBoogie2SmtSymbolTable
    extends Boogie2SmtSymbolTable {
        private final IIcfgSymbolTable mIIcfgSymbolTable;

        public FakeBoogie2SmtSymbolTable(ManagedScript managedScript, TypeSortTranslator typeSortTranslator, IIcfgSymbolTable iIcfgSymbolTable, BoogieDeclarations boogieDeclarations) {
            super(boogieDeclarations, managedScript, typeSortTranslator);
            this.mIIcfgSymbolTable = iIcfgSymbolTable;
        }

        public IProgramVar getProgramVar(TermVariable termVariable) {
            return this.mIIcfgSymbolTable.getProgramVar(termVariable);
        }

        public BoogieASTNode getAstNode(IProgramVar iProgramVar) {
            return new BoogieASTNode(PathProgramDumper.constructNewLocation());
        }
    }

    public static enum InputMode {
        BOOGIE,
        ICFG;

    }

    private static enum Program {
        PATH_PROGRAM,
        ORIGINAL_PROGRAM;

    }
}

