/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphChangeType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.VertexValueContainer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GameGraphChanges<LETTER, STATE> {
    private final NestedMap2<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>, GameGraphChangeType> mChangedEdges = new NestedMap2();
    private final NestedMap2<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>, GameGraphChangeType> mChangedPushOverEdges = new NestedMap2();
    private final HashMap<Vertex<LETTER, STATE>, GameGraphChangeType> mChangedVertices;
    private final HashMap<Vertex<LETTER, STATE>, VertexValueContainer> mRememberedValues;
    private final HashSet<Vertex<LETTER, STATE>> mVerticesInvolvedInEdgeChanges = new HashSet();
    private final HashSet<Vertex<LETTER, STATE>> mVerticesInvolvedInPushOverEdgeChanges = new HashSet();

    public GameGraphChanges() {
        this.mChangedVertices = new HashMap();
        this.mRememberedValues = new HashMap();
    }

    public void addedEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        this.changedEdge(vertex, vertex2, GameGraphChangeType.ADDITION);
    }

    public void addedPushOverEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        this.changedPushOverEdge(vertex, vertex2, GameGraphChangeType.ADDITION);
    }

    public void addedVertex(Vertex<LETTER, STATE> vertex) {
        this.changedVertex(vertex, GameGraphChangeType.ADDITION);
    }

    public NestedMap2<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>, GameGraphChangeType> getChangedEdges() {
        return this.mChangedEdges;
    }

    public NestedMap2<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>, GameGraphChangeType> getChangedPushOverEdges() {
        return this.mChangedPushOverEdges;
    }

    public HashMap<Vertex<LETTER, STATE>, GameGraphChangeType> getChangedVertices() {
        return this.mChangedVertices;
    }

    public HashMap<Vertex<LETTER, STATE>, VertexValueContainer> getRememberedVertexValues() {
        return this.mRememberedValues;
    }

    public boolean hasBEffEntry(Vertex<LETTER, STATE> vertex) {
        return this.mRememberedValues.get(vertex) != null && VertexValueContainer.isValueValid(this.mRememberedValues.get(vertex).getBestNeighborMeasure());
    }

    public boolean hasCEntry(Vertex<LETTER, STATE> vertex) {
        return this.mRememberedValues.get(vertex) != null && VertexValueContainer.isValueValid(this.mRememberedValues.get(vertex).getNeighborCounter());
    }

    public boolean hasPmEntry(Vertex<LETTER, STATE> vertex) {
        return this.mRememberedValues.get(vertex) != null && VertexValueContainer.isValueValid(this.mRememberedValues.get(vertex).getProgressMeasure());
    }

    public boolean isAddedVertex(Vertex<LETTER, STATE> vertex) {
        GameGraphChangeType gameGraphChangeType = this.mChangedVertices.get(vertex);
        return gameGraphChangeType != null && gameGraphChangeType.equals((Object)GameGraphChangeType.ADDITION);
    }

    public boolean isVertexInvolvedInEdgeChanges(Vertex<LETTER, STATE> vertex) {
        return this.mVerticesInvolvedInEdgeChanges.contains(vertex);
    }

    public boolean isVertexInvolvedInPushOverEdgeChanges(Vertex<LETTER, STATE> vertex) {
        return this.mVerticesInvolvedInPushOverEdgeChanges.contains(vertex);
    }

    public void merge(GameGraphChanges<LETTER, STATE> gameGraphChanges, boolean bl) {
        Object object;
        Object object222;
        Object object2;
        Object object3;
        Object object4;
        Triple triple22;
        if (gameGraphChanges == null) {
            return;
        }
        NestedMap2<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>, GameGraphChangeType> nestedMap2 = gameGraphChanges.getChangedEdges();
        for (Triple triple22 : nestedMap2.entrySet()) {
            Vertex object72 = (Vertex)triple22.getFirst();
            Vertex vertex = (Vertex)triple22.getSecond();
            object4 = (GameGraphChangeType)((Object)triple22.getThird());
            object3 = this.mChangedEdges.get((Object)object72);
            object2 = null;
            if (object3 != null) {
                object2 = (GameGraphChangeType)((Object)this.mChangedEdges.get((Object)object72).get(vertex));
            }
            if (object2 == null || ((Enum)object2).equals((Object)GameGraphChangeType.NO_CHANGE)) {
                this.mChangedEdges.put((Object)object72, (Object)vertex, object4);
            } else if (object2 == GameGraphChangeType.ADDITION && object4 == GameGraphChangeType.REMOVAL || object2 == GameGraphChangeType.REMOVAL && object4 == GameGraphChangeType.ADDITION) {
                this.mChangedEdges.remove((Object)object72, (Object)vertex);
            }
            this.mVerticesInvolvedInEdgeChanges.add(object72);
            this.mVerticesInvolvedInEdgeChanges.add(vertex);
        }
        triple22 = gameGraphChanges.getChangedPushOverEdges();
        for (Object object222 : triple22.entrySet()) {
            Vertex vertex = (Vertex)object222.getFirst();
            object4 = (Vertex)object222.getSecond();
            object3 = (GameGraphChangeType)((Object)object222.getThird());
            object2 = this.mChangedPushOverEdges.get((Object)vertex);
            object = null;
            if (object2 != null) {
                object = (GameGraphChangeType)((Object)this.mChangedPushOverEdges.get((Object)vertex).get(object4));
            }
            if (object == null || ((Enum)object).equals((Object)GameGraphChangeType.NO_CHANGE)) {
                this.mChangedPushOverEdges.put((Object)vertex, object4, object3);
            } else if (object == GameGraphChangeType.ADDITION && object3 == GameGraphChangeType.REMOVAL || object == GameGraphChangeType.REMOVAL && object3 == GameGraphChangeType.ADDITION) {
                this.mChangedPushOverEdges.remove((Object)vertex, object4);
            }
            this.mVerticesInvolvedInPushOverEdgeChanges.add(vertex);
            this.mVerticesInvolvedInPushOverEdgeChanges.add((Vertex<LETTER, STATE>)object4);
        }
        object222 = gameGraphChanges.getChangedVertices();
        for (Map.Entry entry : ((HashMap)object222).entrySet()) {
            object4 = this.mChangedVertices.get(entry.getKey());
            if (object4 == null || object4.equals((Object)GameGraphChangeType.NO_CHANGE)) {
                this.mChangedVertices.put((Vertex)entry.getKey(), (GameGraphChangeType)((Object)entry.getValue()));
                continue;
            }
            if ((object4 != GameGraphChangeType.ADDITION || entry.getValue() != GameGraphChangeType.REMOVAL) && (object4 != GameGraphChangeType.REMOVAL || entry.getValue() != GameGraphChangeType.ADDITION)) continue;
            this.mChangedVertices.remove(entry.getKey());
        }
        HashMap<Vertex<LETTER, STATE>, VertexValueContainer> hashMap = gameGraphChanges.getRememberedVertexValues();
        for (Map.Entry entry : hashMap.entrySet()) {
            object3 = (Vertex)entry.getKey();
            object2 = (VertexValueContainer)entry.getValue();
            this.ensureVertexValueContainerIsInitiated((Vertex<LETTER, STATE>)object3);
            object = this.mRememberedValues.get(object3);
            if (!(!VertexValueContainer.isValueValid(((VertexValueContainer)object2).getProgressMeasure()) || bl && VertexValueContainer.isValueValid(((VertexValueContainer)object).getProgressMeasure()))) {
                ((VertexValueContainer)object).setProgressMeasure(((VertexValueContainer)object2).getProgressMeasure());
            }
            if (!(!VertexValueContainer.isValueValid(((VertexValueContainer)object2).getBestNeighborMeasure()) || bl && VertexValueContainer.isValueValid(((VertexValueContainer)object).getBestNeighborMeasure()))) {
                ((VertexValueContainer)object).setBestNeighborMeasure(((VertexValueContainer)object2).getBestNeighborMeasure());
            }
            if (!VertexValueContainer.isValueValid(((VertexValueContainer)object2).getNeighborCounter()) || bl && VertexValueContainer.isValueValid(((VertexValueContainer)object).getNeighborCounter())) continue;
            ((VertexValueContainer)object).setNeighborCounter(((VertexValueContainer)object2).getNeighborCounter());
        }
    }

    public void rememberBEffVertex(Vertex<LETTER, STATE> vertex, int n) {
        this.ensureVertexValueContainerIsInitiated(vertex);
        this.mRememberedValues.get(vertex).setBestNeighborMeasure(n);
    }

    public void rememberCVertex(Vertex<LETTER, STATE> vertex, int n) {
        this.ensureVertexValueContainerIsInitiated(vertex);
        this.mRememberedValues.get(vertex).setNeighborCounter(n);
    }

    public void rememberPmVertex(Vertex<LETTER, STATE> vertex, int n) {
        this.ensureVertexValueContainerIsInitiated(vertex);
        this.mRememberedValues.get(vertex).setProgressMeasure(n);
    }

    public void removedEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        this.changedEdge(vertex, vertex2, GameGraphChangeType.REMOVAL);
    }

    public void removedPushOverEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) {
        this.changedPushOverEdge(vertex, vertex2, GameGraphChangeType.REMOVAL);
    }

    public void removedVertex(Vertex<LETTER, STATE> vertex) {
        this.changedVertex(vertex, GameGraphChangeType.REMOVAL);
    }

    public String toString() {
        DuplicatorVertex duplicatorVertex;
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.lineSeparator();
        stringBuilder.append("GameGraphChanges ggc = (");
        stringBuilder.append(string + "\tchangedVertices = {");
        for (Map.Entry<Vertex<LETTER, STATE>, GameGraphChangeType> object : this.getChangedVertices().entrySet()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(object.getKey().getQ0()) + ", " + String.valueOf(object.getKey().getQ1()) + "), p:" + object.getKey().getPriority() + ">\t" + String.valueOf((Object)object.getValue()));
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + "\tchangedEdges = {");
        for (Triple triple : this.getChangedEdges().entrySet()) {
            stringBuilder.append(string + "\t\t(" + String.valueOf(((Vertex)triple.getFirst()).getQ0()) + ", " + String.valueOf(((Vertex)triple.getFirst()).getQ1()));
            if (triple.getFirst() instanceof DuplicatorVertex) {
                duplicatorVertex = (DuplicatorVertex)triple.getFirst();
                stringBuilder.append(", " + String.valueOf(duplicatorVertex.getLetter()));
            }
            stringBuilder.append(")\t--> (" + String.valueOf(((Vertex)triple.getSecond()).getQ0()) + ", " + String.valueOf(((Vertex)triple.getSecond()).getQ1()));
            if (triple.getSecond() instanceof DuplicatorVertex) {
                duplicatorVertex = (DuplicatorVertex)triple.getSecond();
                stringBuilder.append(", " + String.valueOf(duplicatorVertex.getLetter()));
            }
            stringBuilder.append(")\t" + String.valueOf(triple.getThird()));
        }
        stringBuilder.append(string + "\t}");
        stringBuilder.append(string + "\trememberedValues = {");
        for (Map.Entry<Vertex<LETTER, STATE>, Object> entry : this.getRememberedVertexValues().entrySet()) {
            stringBuilder.append(string + "\t\t(" + String.valueOf(entry.getKey().getQ0()) + ", " + String.valueOf(entry.getKey().getQ1()));
            if (entry.getKey() instanceof DuplicatorVertex) {
                duplicatorVertex = (DuplicatorVertex)entry.getKey();
                stringBuilder.append(", " + String.valueOf(duplicatorVertex.getLetter()));
            }
            stringBuilder.append(")\tPM:");
            stringBuilder.append(((VertexValueContainer)entry.getValue()).getProgressMeasure() + ", BNM:");
            stringBuilder.append(((VertexValueContainer)entry.getValue()).getBestNeighborMeasure() + ", NC:");
            stringBuilder.append(((VertexValueContainer)entry.getValue()).getNeighborCounter());
        }
        stringBuilder.append(string + "\t}");
        stringBuilder.append(string + ");");
        return stringBuilder.toString();
    }

    private void changedEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2, GameGraphChangeType gameGraphChangeType) {
        GameGraphChangeType gameGraphChangeType2 = (GameGraphChangeType)((Object)this.mChangedEdges.get(vertex, vertex2));
        if (gameGraphChangeType2 != null && (gameGraphChangeType2.equals((Object)GameGraphChangeType.ADDITION) && gameGraphChangeType.equals((Object)GameGraphChangeType.REMOVAL) || gameGraphChangeType2.equals((Object)GameGraphChangeType.REMOVAL) && gameGraphChangeType.equals((Object)GameGraphChangeType.ADDITION))) {
            this.mChangedEdges.remove(vertex, vertex2);
        } else {
            this.mChangedEdges.put(vertex, vertex2, (Object)gameGraphChangeType);
        }
        this.mVerticesInvolvedInEdgeChanges.add(vertex);
        this.mVerticesInvolvedInEdgeChanges.add(vertex2);
    }

    private void changedPushOverEdge(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2, GameGraphChangeType gameGraphChangeType) {
        GameGraphChangeType gameGraphChangeType2 = (GameGraphChangeType)((Object)this.mChangedPushOverEdges.get(vertex, vertex2));
        if (gameGraphChangeType2 != null && (gameGraphChangeType2.equals((Object)GameGraphChangeType.ADDITION) && gameGraphChangeType.equals((Object)GameGraphChangeType.REMOVAL) || gameGraphChangeType2.equals((Object)GameGraphChangeType.REMOVAL) && gameGraphChangeType.equals((Object)GameGraphChangeType.ADDITION))) {
            this.mChangedPushOverEdges.remove(vertex, vertex2);
        } else {
            this.mChangedPushOverEdges.put(vertex, vertex2, (Object)gameGraphChangeType);
        }
        this.mVerticesInvolvedInPushOverEdgeChanges.add(vertex);
        this.mVerticesInvolvedInPushOverEdgeChanges.add(vertex2);
    }

    private void changedVertex(Vertex<LETTER, STATE> vertex, GameGraphChangeType gameGraphChangeType) {
        GameGraphChangeType gameGraphChangeType2 = this.mChangedVertices.get(vertex);
        if (gameGraphChangeType2 != null && (gameGraphChangeType2.equals((Object)GameGraphChangeType.ADDITION) && gameGraphChangeType.equals((Object)GameGraphChangeType.REMOVAL) || gameGraphChangeType2.equals((Object)GameGraphChangeType.REMOVAL) && gameGraphChangeType.equals((Object)GameGraphChangeType.ADDITION))) {
            this.mChangedVertices.remove(vertex);
        } else {
            this.mChangedVertices.put(vertex, gameGraphChangeType);
        }
    }

    private void ensureVertexValueContainerIsInitiated(Vertex<LETTER, STATE> vertex) {
        if (this.mRememberedValues.get(vertex) == null) {
            this.mRememberedValues.put(vertex, new VertexValueContainer());
        }
    }
}

