/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.testgen;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.Req2CauseTrackingCDD;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.ReqEffectStore;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.ReqTestAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.ReqTestResultTest;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.TestStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReqTestResultUtil {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final IReqSymbolTable mReqSymbolTable;
    private final Map<PhaseEventAutomata, ReqEffectStore> mReqEffectStore;

    public ReqTestResultUtil(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, IReqSymbolTable iReqSymbolTable, Map<PhaseEventAutomata, ReqEffectStore> map) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mReqSymbolTable = iReqSymbolTable;
        this.mReqEffectStore = map;
    }

    public IResult convertTraceAbstractionResult(IResult iResult) {
        if (iResult instanceof CounterExampleResult) {
            return this.getTestSteps((CounterExampleResult)iResult);
        }
        if (!(iResult instanceof TimeoutResultAtElement)) {
            boolean cfr_ignored_0 = iResult instanceof PositiveResult;
        }
        return iResult;
    }

    private IResult getTestSteps(CounterExampleResult<?, ?, ?> counterExampleResult) {
        ArrayList<TestStep> arrayList = new ArrayList<TestStep>();
        IProgramExecution iProgramExecution = this.mServices.getBacktranslationService().translateProgramExecution(counterExampleResult.getProgramExecution());
        AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(iProgramExecution.getLength() - 1);
        IProgramExecution.ProgramState programState = null;
        ArrayList<IProgramExecution.ProgramState> arrayList2 = new ArrayList<IProgramExecution.ProgramState>();
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement2;
            if (iProgramExecution.getProgramState(n) != null) {
                programState = iProgramExecution.getProgramState(n);
            }
            if ((atomicTraceElement2 = iProgramExecution.getTraceElement(n)).getStep() == atomicTraceElement.getStep()) {
                if (programState == null) {
                    this.mLogger.error((Object)("Assertion did not contain state (but would have been neccessary for test generation):" + atomicTraceElement2.getStep().toString()));
                } else {
                    arrayList2.add(programState);
                    programState = null;
                }
            }
            ++n;
        }
        n = 0;
        while (n < arrayList2.size() - 1) {
            arrayList.add(this.getTestStepGraph(this.calcualteGraphStep(this.mReqEffectStore.keySet(), (IProgramExecution.ProgramState<Expression>)((IProgramExecution.ProgramState)arrayList2.get(n)), (IProgramExecution.ProgramState<Expression>)((IProgramExecution.ProgramState)arrayList2.get(n + 1))), (IProgramExecution.ProgramState<Expression>)((IProgramExecution.ProgramState)arrayList2.get(n)), (IProgramExecution.ProgramState<Expression>)((IProgramExecution.ProgramState)arrayList2.get(n + 1))));
            ++n;
        }
        TestStep testStep = this.getTestStepGraph(this.calcualteGraphStep(this.mReqEffectStore.keySet(), (IProgramExecution.ProgramState<Expression>)((IProgramExecution.ProgramState)arrayList2.get(arrayList2.size() - 1)), (IProgramExecution.ProgramState<Expression>)((IProgramExecution.ProgramState)arrayList2.get(arrayList2.size() - 1))), (IProgramExecution.ProgramState<Expression>)((IProgramExecution.ProgramState)arrayList2.get(arrayList2.size() - 1)), (IProgramExecution.ProgramState<Expression>)((IProgramExecution.ProgramState)arrayList2.get(arrayList2.size() - 1)));
        if (testStep.hasOutput()) {
            arrayList.add(testStep);
        }
        return new ReqTestResultTest(arrayList, ReqTestResultUtil.getTestAssertionName(atomicTraceElement.getStep()));
    }

    /*
     * WARNING - void declaration
     */
    private Map<PhaseEventAutomata, TestRelationNode> calcualteGraphStep(Set<PhaseEventAutomata> set, IProgramExecution.ProgramState<Expression> programState, IProgramExecution.ProgramState<Expression> programState2) {
        Set<String> set2;
        CDD cDD;
        int n;
        Expression[] expressionArray;
        Collection<Expression> collection;
        HashMap<PhaseEventAutomata, TestRelationNode> hashMap = new HashMap<PhaseEventAutomata, TestRelationNode>();
        for (PhaseEventAutomata phaseEventAutomata : set) {
            void object;
            collection = ReqTestResultUtil.getVariableValuation(this.mReqSymbolTable.getPcName(phaseEventAutomata), programState);
            expressionArray = collection.toArray(new Expression[collection.size()]);
            n = Integer.parseInt(((IntegerLiteral)expressionArray[0]).getValue());
            if (n < phaseEventAutomata.getPhases().size() / 2) continue;
            cDD = ((Phase)phaseEventAutomata.getPhases().get(n)).getStateInvariant();
            set2 = Req2CauseTrackingCDD.getCddVariables(cDD);
            Set set3 = Collections.emptySet();
            Set<String> set4 = Collections.emptySet();
            if (this.isInEffectPhase(phaseEventAutomata, programState)) {
                set2.removeAll(this.mReqEffectStore.get(phaseEventAutomata).getEffectVars());
                Set<String> set5 = this.mReqEffectStore.get(phaseEventAutomata).getEffectVars();
                set4 = this.mReqEffectStore.get(phaseEventAutomata).getEffectVars();
                set4.retainAll(this.mReqSymbolTable.getOutputVars());
            }
            if (this.endsInEffectEdge(phaseEventAutomata, programState2)) {
                Set<String> set6 = this.mReqEffectStore.get(phaseEventAutomata).getEffectVars();
                set4 = this.mReqEffectStore.get(phaseEventAutomata).getEffectVars();
                set4.retainAll(this.mReqSymbolTable.getOutputVars());
            }
            Set<String> set7 = Req2CauseTrackingCDD.getCddVariables(cDD);
            set7.retainAll(this.mReqSymbolTable.getInputVars());
            hashMap.put(phaseEventAutomata, new TestRelationNode(phaseEventAutomata, (Set<String>)object, set7, set4, !this.mReqEffectStore.get(phaseEventAutomata).getEffectEdges().isEmpty() && this.mReqEffectStore.get(phaseEventAutomata).getEffectPhaseIndexes().isEmpty()));
        }
        for (PhaseEventAutomata phaseEventAutomata : set) {
            collection = ReqTestResultUtil.getVariableValuation(this.mReqSymbolTable.getPcName(phaseEventAutomata), programState);
            expressionArray = collection.toArray(new Expression[collection.size()]);
            n = Integer.parseInt(((IntegerLiteral)expressionArray[0]).getValue());
            if (n < phaseEventAutomata.getPhases().size() / 2) continue;
            cDD = ((Phase)phaseEventAutomata.getPhases().get(n)).getStateInvariant();
            set2 = Req2CauseTrackingCDD.getCddVariables(cDD);
            if (this.isInEffectPhase(phaseEventAutomata, programState)) {
                set2.removeAll(this.mReqEffectStore.get(phaseEventAutomata).getEffectVars());
            }
            set2.removeAll(this.mReqSymbolTable.getConstVars());
            set2.removeAll(this.mReqSymbolTable.getInputVars());
            for (String string : set2) {
                this.calculateDeterminingReqs(string, programState).stream().forEach(phaseEventAutomata2 -> ((TestRelationNode)hashMap.get(phaseEventAutomata2)).addDeterminedReq(phaseEventAutomata));
                this.calculateEntryEffects(string, programState2).stream().forEach(phaseEventAutomata2 -> ((TestRelationNode)hashMap.get(phaseEventAutomata2)).addDeterminedReq(phaseEventAutomata));
            }
        }
        this.mLogger.info(hashMap);
        return hashMap;
    }

    private Set<PhaseEventAutomata> calculateDeterminingReqs(String string, IProgramExecution.ProgramState<Expression> programState) {
        HashSet<PhaseEventAutomata> hashSet = new HashSet<PhaseEventAutomata>();
        for (Map.Entry<PhaseEventAutomata, ReqEffectStore> entry : this.mReqEffectStore.entrySet()) {
            ReqEffectStore reqEffectStore = entry.getValue();
            if (!reqEffectStore.getEffectVars().contains(string) || !this.isInEffectPhase(entry.getKey(), programState)) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    private boolean isInEffectPhase(PhaseEventAutomata phaseEventAutomata, IProgramExecution.ProgramState<Expression> programState) {
        ReqEffectStore reqEffectStore = this.mReqEffectStore.get(phaseEventAutomata);
        if (reqEffectStore == null) {
            return false;
        }
        String string = this.mReqSymbolTable.getPcName(phaseEventAutomata);
        Collection<Expression> collection = ReqTestResultUtil.getVariableValuation(string, programState);
        for (Expression expression : collection) {
            if (!(expression instanceof IntegerLiteral)) continue;
            int n = Integer.parseInt(((IntegerLiteral)expression).getValue());
            if (!reqEffectStore.getEffectPhaseIndexes().contains(n)) continue;
            return true;
        }
        return false;
    }

    private Set<PhaseEventAutomata> calculateEntryEffects(String string, IProgramExecution.ProgramState<Expression> programState) {
        HashSet<PhaseEventAutomata> hashSet = new HashSet<PhaseEventAutomata>();
        for (Map.Entry<PhaseEventAutomata, ReqEffectStore> entry : this.mReqEffectStore.entrySet()) {
            ReqEffectStore reqEffectStore = entry.getValue();
            if (!reqEffectStore.getEffectVars().contains(string) || !this.endsInEffectEdge(entry.getKey(), programState)) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    private boolean endsInEffectEdge(PhaseEventAutomata phaseEventAutomata, IProgramExecution.ProgramState<Expression> programState) {
        ReqEffectStore reqEffectStore = this.mReqEffectStore.get(phaseEventAutomata);
        if (reqEffectStore == null) {
            return false;
        }
        String string = this.mReqSymbolTable.getPcName(phaseEventAutomata);
        Collection<Expression> collection = ReqTestResultUtil.getVariableValuation(string, programState);
        String string2 = this.mReqSymbolTable.getHistoryVarId(this.mReqSymbolTable.getPcName(phaseEventAutomata));
        Collection<Expression> collection2 = ReqTestResultUtil.getVariableValuation(string2, programState);
        for (Expression expression : collection2) {
            int n = Integer.parseInt(((IntegerLiteral)expression).getValue());
            for (Expression expression2 : collection) {
                int n2 = Integer.parseInt(((IntegerLiteral)expression2).getValue());
                if (reqEffectStore.getEffectEdges().stream().filter(pair -> (Integer)pair.getFirst() == n && (Integer)pair.getSecond() == n2).count() <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    private TestStep getTestStepGraph(Map<PhaseEventAutomata, TestRelationNode> map, IProgramExecution.ProgramState<Expression> programState, IProgramExecution.ProgramState<Expression> programState2) {
        String string;
        Collection<TestRelationNode> collection;
        Collection<TestRelationNode> collection2 = collection = map.values();
        Collection<Object> collection3 = new ArrayList<Expression>();
        HashMap<IdentifierExpression, Collection<Expression>> hashMap = new HashMap<IdentifierExpression, Collection<Expression>>();
        HashMap<IdentifierExpression, Collection<Expression>> hashMap2 = new HashMap<IdentifierExpression, Collection<Expression>>();
        HashMap<IdentifierExpression, Collection<Expression>> hashMap3 = new HashMap<IdentifierExpression, Collection<Expression>>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (TestRelationNode testRelationNode : collection2) {
            if (testRelationNode.isBoundResponse()) {
                hashSet2.addAll(testRelationNode.getOutputs());
            } else {
                hashSet.addAll(testRelationNode.getOutputs());
            }
            hashSet3.addAll(testRelationNode.getInputs());
        }
        for (TestRelationNode testRelationNode : programState.getVariables()) {
            string = ((IdentifierExpression)testRelationNode).getIdentifier();
            if (testRelationNode instanceof IdentifierExpression && hashSet3.contains(string)) {
                hashMap.put((IdentifierExpression)testRelationNode, programState.getValues((Object)testRelationNode));
            }
            if (testRelationNode instanceof IdentifierExpression && this.mReqSymbolTable.getDeltaVarName().equals(string)) {
                collection3 = programState.getValues((Object)testRelationNode);
            }
            if (!(testRelationNode instanceof IdentifierExpression) || !hashSet.contains(string)) continue;
            hashMap2.put((IdentifierExpression)testRelationNode, programState.getValues((Object)testRelationNode));
        }
        for (TestRelationNode testRelationNode : programState2.getVariables()) {
            string = ((IdentifierExpression)testRelationNode).getIdentifier();
            if (!(testRelationNode instanceof IdentifierExpression) || !hashSet2.contains(string)) continue;
            hashMap3.put((IdentifierExpression)testRelationNode, programState2.getValues((Object)testRelationNode));
        }
        return new TestStep(hashMap, hashMap2, hashMap3, collection3);
    }

    private TestStep getTestStep(IProgramExecution.ProgramState<Expression> programState) {
        HashMap<IdentifierExpression, Collection<Expression>> hashMap = new HashMap<IdentifierExpression, Collection<Expression>>();
        HashMap<IdentifierExpression, Collection<Expression>> hashMap2 = new HashMap<IdentifierExpression, Collection<Expression>>();
        Collection<Object> collection = new ArrayList<Expression>();
        for (Expression expression : programState.getVariables()) {
            String string = ((IdentifierExpression)expression).getIdentifier();
            if (expression instanceof IdentifierExpression && this.mReqSymbolTable.getInputVars().contains(string)) {
                hashMap.put((IdentifierExpression)expression, programState.getValues((Object)expression));
                continue;
            }
            if (expression instanceof IdentifierExpression && this.mReqSymbolTable.getDeltaVarName().equals(string)) {
                collection = programState.getValues((Object)expression);
                continue;
            }
            if (!(expression instanceof IdentifierExpression) || !this.mReqSymbolTable.getOutputVars().contains(string) || !this.isSetByEffect(string, programState)) continue;
            hashMap2.put((IdentifierExpression)expression, programState.getValues((Object)expression));
        }
        return new TestStep(hashMap, hashMap2, Collections.emptyMap(), collection);
    }

    private static Collection<Expression> getVariableValuation(String string, IProgramExecution.ProgramState<Expression> programState) {
        Expression expression2 = programState.getVariables().stream().filter(expression -> ((IdentifierExpression)expression).getIdentifier().equals(string)).findFirst().orElse(null);
        if (expression2 == null) {
            return Collections.emptySet();
        }
        return programState.getValues((Object)expression2);
    }

    private boolean isSetByEffect(String string, IProgramExecution.ProgramState<Expression> programState) {
        String string2 = ReqTestAnnotator.getTrackingVar(string);
        for (Expression expression : programState.getVariables()) {
            if (!((IdentifierExpression)expression).getIdentifier().equals(string2)) continue;
            for (Expression expression2 : programState.getValues((Object)expression)) {
                if (expression2 instanceof BooleanLiteral) {
                    return ((BooleanLiteral)expression2).getValue();
                }
                this.mLogger.error((Object)("Unsuspected Value for tracking Variable for var: " + string));
            }
        }
        return false;
    }

    private static String getTestAssertionName(Object object) {
        NamedAttribute[] namedAttributeArray;
        if (object instanceof AssertStatement && (namedAttributeArray = ((AssertStatement)object).getAttributes()) != null && namedAttributeArray.length > 0) {
            NamedAttribute[] namedAttributeArray2 = namedAttributeArray;
            int n = namedAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                NamedAttribute namedAttribute = namedAttributeArray2[n2];
                if (namedAttribute.getName().startsWith("testgen_")) {
                    return namedAttribute.getName();
                }
                ++n2;
            }
        }
        return "None";
    }

    public static class TestRelationNode {
        private final PhaseEventAutomata mReq;
        private final Set<PhaseEventAutomata> mDetermined;
        private final Set<String> mVarName;
        private final Set<String> mInputs;
        private final Set<String> mOutputs;
        private final boolean mIsBoundResponse;

        public TestRelationNode(PhaseEventAutomata phaseEventAutomata, Set<String> set, Set<String> set2, Set<String> set3, boolean bl) {
            this.mReq = phaseEventAutomata;
            this.mVarName = set;
            this.mDetermined = new HashSet<PhaseEventAutomata>();
            this.mInputs = set2;
            this.mOutputs = set3;
            this.mIsBoundResponse = bl;
        }

        public void addDeterminedReq(PhaseEventAutomata phaseEventAutomata) {
            this.mDetermined.add(phaseEventAutomata);
        }

        public Set<String> getOutputs() {
            return this.mOutputs;
        }

        public Set<PhaseEventAutomata> getDetermined() {
            return this.mDetermined;
        }

        public PhaseEventAutomata getReq() {
            return this.mReq;
        }

        public Set<String> getInputs() {
            return this.mInputs;
        }

        public boolean isBoundResponse() {
            return this.mIsBoundResponse;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.mInputs.toString());
            stringBuilder.append("--input-->");
            stringBuilder.append(this.mReq.getName());
            if (this.mIsBoundResponse) {
                stringBuilder.append(" -<><><><>-internal-(");
            } else {
                stringBuilder.append(" ----------internal-(");
            }
            stringBuilder.append(this.mVarName.toString());
            stringBuilder.append(" )--------output-( ");
            stringBuilder.append(this.mOutputs.toString());
            stringBuilder.append(" )---------------> ");
            stringBuilder.append(this.mDetermined.toString());
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

