/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.models.annotation;

import java.util.Set;

public enum Spec {
    UNKNOWN(Group.GENERIC, "unknown kind of specification holds", "unknown kind of specification may be violated"),
    LTL(Group.GENERIC, "LTL property holds", "LTL property may be violated"),
    ARRAY_INDEX(Group.PROGRAM, "array index is always in bounds", "array index can be out of bounds"),
    PRE_CONDITION(Group.PROGRAM, "procedure precondition always holds", "procedure precondition can be violated"),
    POST_CONDITION(Group.PROGRAM, "procedure postcondition always holds", "procedure postcondition can be violated"),
    INVARIANT(Group.PROGRAM, "loop invariant is valid", "loop invariant can be violated"),
    ASSERT(Group.PROGRAM, "assertion always holds", "assertion can be violated"),
    DIVISION_BY_ZERO(Group.PROGRAM, "division by zero can never occur", "possible division by zero"),
    INTEGER_OVERFLOW(Group.PROGRAM, "integer overflow can never occur", "integer overflow possible"),
    MEMORY_DEREFERENCE(Group.PROGRAM, "pointer dereference always succeeds", "pointer dereference may fail"),
    MEMORY_LEAK(Group.PROGRAM, "all allocated memory was freed", "not all allocated memory was freed"),
    MEMORY_FREE(Group.PROGRAM, "free always succeeds", "free of unallocated memory possible"),
    MALLOC_NONNEGATIVE(Group.PROGRAM, "input of malloc is always non-negative", "input of malloc can be negative"),
    ILLEGAL_POINTER_ARITHMETIC(Group.PROGRAM, "pointer arithmetic is always legal", "comparison of incompatible pointers"),
    ERROR_FUNCTION(Group.PROGRAM, "call to the error function is unreachable", "a call to the error function is reachable"),
    WITNESS_INVARIANT(Group.PROGRAM, "invariant of correctness witness holds", "invariant of correctness witness can be violated"),
    UINT_OVERFLOW(Group.PROGRAM, "there are no unsigned integer over- or underflows", "an unsigned integer over- or underflow may occur"),
    UNDEFINED_BEHAVIOR(Group.PROGRAM, "there is no undefined behavior", "undefined behavior may occur"),
    SUFFICIENT_THREAD_INSTANCES(Group.PROGRAM, "petrification did provide enough thread instances (tool internal message)", "petrification did not provide enough thread instances (tool internal message)"),
    UNSUPPORTED_FEATURE(Group.PROGRAM, "there are no unsupported features in the program", "unsupported features may occur in the program"),
    DATA_RACE(Group.PROGRAM, "there are no data races", "the program contains a data race"),
    CHC_SATISFIABILITY(Group.PROGRAM, "the set of constraint Horn clauses is satisfiable", "the set of constraint Horn clauses is unsatisfiable"),
    RTINCONSISTENT(Group.REQUIREMENT, "rt-consistent", "rt-inconsistent"),
    VACUOUS(Group.REQUIREMENT, "non-vacuous", "vacuous"),
    CONSISTENCY(Group.REQUIREMENT, "consistent", "inconsistent"),
    INCOMPLETE(Group.REQUIREMENT, "complete", "incomplete"),
    COMPLEMENT(Group.REQUIREMENT, "complements of each other", "not complements of each other"),
    REDUNDANCY(Group.REQUIREMENT, "non-redundant", "redundant");

    private static final String FALLBACK_POSITIVE_MESSAGE = "a specification is correct but has no positive message";
    private static final String FALLBACK_NEGATIVE_MESSAGE = "a specification may be violated but has no negative message";
    private final Group mGroup;
    private final String mDefaultPosMsg;
    private final String mDefaultNegMsg;

    private Spec(Group group) {
        this(group, null, null);
    }

    private Spec(Group group, String string2, String string3) {
        this.mGroup = group;
        this.mDefaultPosMsg = string2;
        this.mDefaultNegMsg = string3;
    }

    public boolean isInGroup(Group group) {
        return this.mGroup == group;
    }

    public boolean isInGroups(Set<Group> set) {
        return set.contains((Object)this.mGroup);
    }

    private String getDefaultMessage(String string, String string2) {
        return string == null ? String.format("%s: %s", new Object[]{string2, this}) : string;
    }

    public String getDefaultPositiveMessage() {
        return this.getDefaultMessage(this.mDefaultPosMsg, FALLBACK_POSITIVE_MESSAGE);
    }

    public String getDefaultNegativeMessage() {
        return this.getDefaultMessage(this.mDefaultNegMsg, FALLBACK_NEGATIVE_MESSAGE);
    }

    public static enum Group {
        GENERIC,
        PROGRAM,
        REQUIREMENT;

    }
}

