/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.ErrorManager;
import com.github.jhoenicke.javacup.action_part;
import com.github.jhoenicke.javacup.action_production;
import com.github.jhoenicke.javacup.lalr_state;
import com.github.jhoenicke.javacup.lookaheads;
import com.github.jhoenicke.javacup.lr_item;
import com.github.jhoenicke.javacup.non_terminal;
import com.github.jhoenicke.javacup.parse_action_table;
import com.github.jhoenicke.javacup.parse_reduce_table;
import com.github.jhoenicke.javacup.production;
import com.github.jhoenicke.javacup.production_part;
import com.github.jhoenicke.javacup.symbol;
import com.github.jhoenicke.javacup.symbol_part;
import com.github.jhoenicke.javacup.terminal;
import com.github.jhoenicke.javacup.terminal_set;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Grammar {
    private final ArrayList<terminal> _terminals;
    private final ArrayList<non_terminal> _nonterminals;
    private final ArrayList<production> _productions;
    private final ArrayList<production> _actions;
    private production _start_production;
    private final HashMap<Collection<lr_item>, lalr_state> _kernels_to_lalr = new HashMap();
    private final ArrayList<lalr_state> _lalr_states = new ArrayList();
    private int _num_conflicts = 0;
    private parse_action_table action_table;
    private parse_reduce_table reduce_table;
    private int next_nt = 0;

    public Grammar() {
        this._terminals = new ArrayList();
        this._nonterminals = new ArrayList();
        this._productions = new ArrayList();
        this._actions = new ArrayList();
        this._terminals.add(terminal.error);
        this._terminals.add(terminal.EOF);
        this._nonterminals.add(non_terminal.START_nt);
    }

    public non_terminal get_nonterminal(int n) {
        return this._nonterminals.get(n);
    }

    public terminal get_terminal(int n) {
        return this._terminals.get(n);
    }

    public production get_action(int n) {
        return this._actions.get(n);
    }

    public production get_production(int n) {
        return this._productions.get(n);
    }

    public production start_production() {
        return this._start_production;
    }

    public int num_terminals() {
        return this._terminals.size();
    }

    public int num_non_terminals() {
        return this._nonterminals.size();
    }

    public int num_productions() {
        return this._productions.size();
    }

    public int num_actions() {
        return this._actions.size();
    }

    public Iterable<terminal> terminals() {
        return this._terminals;
    }

    public Iterable<non_terminal> non_terminals() {
        return this._nonterminals;
    }

    public Iterable<production> productions() {
        return this._productions;
    }

    public Iterable<production> actions() {
        return this._actions;
    }

    public int num_conflicts() {
        return this._num_conflicts;
    }

    public terminal add_terminal(String string, String string2) {
        terminal terminal2 = new terminal(string, string2, this._terminals.size());
        this._terminals.add(terminal2);
        return terminal2;
    }

    public non_terminal add_non_terminal(String string, String string2) {
        non_terminal non_terminal2 = new non_terminal(string, string2, this._nonterminals.size());
        this._nonterminals.add(non_terminal2);
        return non_terminal2;
    }

    public non_terminal star_symbol(symbol symbol2) {
        if (symbol2._star_symbol == null) {
            this.plus_symbol(symbol2);
            String string = symbol2._stack_type == null ? null : symbol2._stack_type + "[]";
            symbol2._star_symbol = this.add_non_terminal(symbol2._name + "*", string);
        }
        return symbol2._star_symbol;
    }

    public non_terminal plus_symbol(symbol symbol2) {
        if (symbol2._plus_symbol == null) {
            String string = symbol2._stack_type == null ? null : symbol2._stack_type + "[]";
            symbol2._plus_symbol = this.add_non_terminal(symbol2._name + "+", string);
        }
        return symbol2._plus_symbol;
    }

    public non_terminal opt_symbol(symbol symbol2) {
        if (symbol2._opt_symbol == null) {
            symbol2._opt_symbol = this.add_non_terminal(symbol2._name + "?", symbol2._stack_type);
        }
        return symbol2._opt_symbol;
    }

    public void set_start_symbol(non_terminal non_terminal2) {
        String string;
        symbol_part[] symbol_partArray = new symbol_part[2];
        action_part action_part2 = null;
        if (non_terminal2.stack_type() != null) {
            symbol_partArray[0] = new symbol_part(non_terminal2, "CUP$rhs");
            string = "CUP$rhs";
        } else {
            symbol_partArray[0] = new symbol_part(non_terminal2);
            string = "null";
        }
        symbol_partArray[1] = new symbol_part(terminal.EOF);
        action_part2 = new action_part("RESULT = " + string + ";\n/* ACCEPT */\nparser.done_parsing();");
        this._start_production = new production(0, 0, non_terminal.START_nt, symbol_partArray, -1, action_part2, null);
        this._productions.add(this._start_production);
        this._actions.add(this._start_production);
        non_terminal.START_nt.note_use();
    }

    private non_terminal create_anon_nonterm(String string) {
        return this.add_non_terminal("NT$" + this.next_nt++, string);
    }

    public production build_production(non_terminal non_terminal2, List<production_part> list, terminal terminal2) {
        production_part production_part2;
        if (this._start_production == null) {
            this.set_start_symbol(non_terminal2);
        }
        assert (this._start_production != null);
        assert (non_terminal2 != null) : "Attempt to construct a production with a null LHS";
        non_terminal2.note_use();
        if (terminal2 != null) {
            terminal2.note_use();
        }
        Iterator<production_part> iterator = list.iterator();
        action_part action_part2 = null;
        while (iterator.hasNext()) {
            production_part2 = iterator.next();
            if (production_part2 instanceof action_part) {
                if (action_part2 != null) {
                    action_part2.add_code_string(((action_part)production_part2).code_string());
                    iterator.remove();
                    continue;
                }
                action_part2 = (action_part)production_part2;
                continue;
            }
            action_part2 = null;
        }
        production_part2 = null;
        if (list.size() > 0 && list.get(list.size() - 1) instanceof action_part) {
            production_part2 = (action_part)list.remove(list.size() - 1);
        }
        symbol_part[] symbol_partArray = new symbol_part[list.size()];
        int n = -1;
        int n2 = 0;
        while (n2 < symbol_partArray.length) {
            production_part production_part3 = list.get(n2);
            if (production_part3 instanceof action_part) {
                non_terminal object2 = this.create_anon_nonterm(non_terminal2.stack_type());
                object2.note_use();
                symbol_partArray[n2] = new symbol_part(object2);
                n = n2;
            } else {
                symbol_partArray[n2] = (symbol_part)production_part3;
            }
            ++n2;
        }
        int n3 = this._actions.size();
        if (symbol_partArray.length == 1 && production_part2 == null) {
            n3 = -1;
        }
        for (production production2 : non_terminal2.productions()) {
            if (!(production_part2 == null ? production2.action() == null : production2.action() != null && ((action_part)production_part2).code_string().equals(production2.action().code_string())) || production2.rhs_length() != symbol_partArray.length || !this.productions_match(production2, symbol_partArray)) continue;
            n3 = production2.action_index();
            break;
        }
        production production3 = new production(this._productions.size(), n3, non_terminal2, symbol_partArray, n, (action_part)production_part2, terminal2);
        this._productions.add(production3);
        if (n3 == this._actions.size()) {
            this._actions.add(production3);
        }
        n = -1;
        n2 = 0;
        while (n2 < symbol_partArray.length) {
            production_part production_part3 = list.get(n2);
            if (production_part3 instanceof action_part) {
                action_production action_production2 = new action_production(this._productions.size(), this._actions.size(), production3, (non_terminal)symbol_partArray[n2].the_symbol, (action_part)production_part3, n2, n);
                this._productions.add(action_production2);
                this._actions.add(action_production2);
                n = n2;
            }
            ++n2;
        }
        return production3;
    }

    private boolean productions_match(production production2, symbol_part[] symbol_partArray) {
        int n = 0;
        while (n < symbol_partArray.length) {
            if (symbol_partArray[n].label == null) {
                if (production2.rhs((int)n).label != null) {
                    return false;
                }
            } else {
                if (!symbol_partArray[n].label.equals(production2.rhs((int)n).label)) {
                    return false;
                }
                if (symbol_partArray[n].the_symbol.stack_type() == null ? production2.rhs((int)n).the_symbol.stack_type() != null : !symbol_partArray[n].the_symbol.stack_type().equals(production2.rhs((int)n).the_symbol.stack_type())) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public lalr_state get_lalr_state(Map<lr_item, terminal_set> map) {
        Set<lr_item> set = map.keySet();
        lalr_state lalr_state2 = this._kernels_to_lalr.get(set);
        if (lalr_state2 != null) {
            lalr_state2.propagate_lookaheads(map);
        } else {
            lalr_state2 = new lalr_state(map, this._lalr_states.size());
            this._lalr_states.add(lalr_state2);
            this._kernels_to_lalr.put(set, lalr_state2);
        }
        return lalr_state2;
    }

    public Collection<lalr_state> lalr_states() {
        return this._lalr_states;
    }

    public void compute_nullability() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (non_terminal non_terminal2 : this._nonterminals) {
                bl |= non_terminal2.check_nullable();
            }
        }
    }

    public void compute_first_sets() {
        boolean bl = true;
        for (non_terminal non_terminal2 : this._nonterminals) {
            non_terminal2._first_set = new terminal_set(this);
        }
        while (bl) {
            bl = false;
            for (non_terminal non_terminal2 : this._nonterminals) {
                for (production production2 : non_terminal2.productions()) {
                    terminal_set terminal_set2 = production2.first_set(this);
                    bl |= non_terminal2._first_set.add(terminal_set2);
                }
            }
        }
    }

    public lalr_state build_machine() {
        assert (this._start_production != null) : "Attempt to build viable prefix recognizer using a null production";
        TreeMap<lr_item, terminal_set> treeMap = new TreeMap<lr_item, terminal_set>();
        terminal_set terminal_set2 = new terminal_set(this);
        terminal_set2.add(terminal.EOF);
        lr_item lr_item2 = this._start_production.item();
        treeMap.put(lr_item2, terminal_set2);
        lalr_state lalr_state2 = this.get_lalr_state(treeMap);
        int n = 0;
        while (n < this._lalr_states.size()) {
            lalr_state lalr_state3 = this._lalr_states.get(n);
            lalr_state3.compute_closure(this);
            lalr_state3.compute_successors(this);
            ++n;
        }
        return lalr_state2;
    }

    public void dump_grammar() {
        System.err.println("===== Terminals =====");
        int n = 0;
        for (terminal object : this.terminals()) {
            System.err.print("[" + object.index() + "]" + object.name() + " ");
            if (++n % 5 != 0) continue;
            System.err.println();
        }
        System.err.println();
        System.err.println();
        System.err.println("===== Non terminals =====");
        n = 0;
        for (non_terminal non_terminal2 : this.non_terminals()) {
            System.err.print("[" + non_terminal2.index() + "]" + non_terminal2.name() + " ");
            if (++n % 5 != 0) continue;
            System.err.println();
        }
        System.err.println();
        System.err.println();
        System.err.println("===== Productions =====");
        for (production production2 : this.productions()) {
            System.err.println("[" + production2.index() + "] " + String.valueOf(production2));
        }
        System.err.println();
    }

    public void dump_machine() {
        System.err.println("===== Viable Prefix Recognizer =====");
        for (lalr_state lalr_state2 : this.lalr_states()) {
            System.err.println(lalr_state2);
            System.err.println("-------------------");
        }
    }

    public void dump_tables() {
        System.err.println(this.action_table);
        System.err.println(this.reduce_table);
    }

    public void report_reduce_reduce(lalr_state lalr_state2, Map.Entry<lr_item, lookaheads> entry, Map.Entry<lr_item, lookaheads> entry2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("*** Reduce/Reduce conflict found in state #").append(lalr_state2.index()).append("\n").append("  between ").append(entry.getKey().toString()).append("\n").append("  and     ").append(entry2.getKey().toString()).append("\n").append("  under symbols: {");
        String string = "";
        int n = 0;
        while (n < this.num_terminals()) {
            if (entry.getValue().contains(n) && entry2.getValue().contains(n)) {
                stringBuilder.append(string).append(this.get_terminal(n).name());
                string = ", ";
            }
            ++n;
        }
        stringBuilder.append("}\n  Resolved in favor of the first production.\n");
        ++this._num_conflicts;
        ErrorManager.getManager().emit_warning(stringBuilder.toString());
    }

    public void report_shift_reduce(lalr_state lalr_state2, production production2, symbol symbol2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("*** Shift/Reduce conflict found in state #").append(lalr_state2.index()).append("\n");
        stringBuilder.append("  between ").append(production2).append("(*)\n");
        for (lr_item lr_item2 : lalr_state2.items().keySet()) {
            if (lr_item2.dot_at_end() || !lr_item2.symbol_after_dot().equals(symbol2)) continue;
            stringBuilder.append("  and     ").append(lr_item2).append("\n");
        }
        stringBuilder.append("  under symbol ").append(symbol2).append("\n");
        stringBuilder.append("  Resolved in favor of shifting.\n");
        ++this._num_conflicts;
        ErrorManager.getManager().emit_warning(stringBuilder.toString());
    }

    public void build_tables(boolean bl) {
        this.action_table = new parse_action_table(this);
        this.reduce_table = new parse_reduce_table(this);
        for (lalr_state lalr_state2 : this.lalr_states()) {
            lalr_state2.build_table_entries(this, this.action_table, this.reduce_table, bl);
        }
    }

    public void check_tables() {
        boolean[] blArray = new boolean[this._productions.size()];
        int n = 0;
        while (n < this.lalr_states().size()) {
            int n2 = 0;
            while (n2 < this.num_terminals()) {
                int n3 = this.action_table.table[n][n2];
                if (parse_action_table.isReduce(n3)) {
                    blArray[parse_action_table.index((int)n3)] = true;
                }
                ++n2;
            }
            ++n;
        }
        for (production production2 : this.actions()) {
            if (blArray[production2.action_index()]) continue;
            ErrorManager.getManager().emit_warning("*** Production \"" + production2.toString() + "\" never reduced");
        }
    }

    public parse_action_table action_table() {
        return this.action_table;
    }

    public parse_reduce_table reduce_table() {
        return this.reduce_table;
    }

    public void add_star_production(non_terminal non_terminal2, non_terminal non_terminal3, symbol symbol2) {
        ArrayList<production_part> arrayList = new ArrayList<production_part>(2);
        arrayList.add(new symbol_part(non_terminal3));
        arrayList.add(new symbol_part(symbol2));
        if (symbol2.stack_type() != null) {
            arrayList.add(new action_part("CUP$STAR2"));
        }
        this.build_production(non_terminal2, arrayList, null);
    }

    public void add_wildcard_rules(symbol symbol2) {
        ArrayList<production_part> arrayList;
        if (symbol2._opt_symbol != null) {
            arrayList = new ArrayList<production_part>(1);
            if (symbol2.stack_type() != null) {
                arrayList.add(new action_part("RESULT=null;"));
            }
            this.build_production(symbol2._opt_symbol, arrayList, null);
            arrayList = new ArrayList(1);
            arrayList.add(new symbol_part(symbol2));
            this.build_production(symbol2._opt_symbol, arrayList, null);
        }
        if (symbol2._star_symbol != null) {
            assert (symbol2._plus_symbol != null);
            arrayList = new ArrayList(1);
            if (symbol2.stack_type() != null) {
                arrayList.add(new action_part("CUP$STAR0"));
            }
            this.build_production(symbol2._star_symbol, arrayList, null);
            arrayList = new ArrayList(1);
            arrayList.add(new symbol_part(symbol2._plus_symbol));
            this.build_production(symbol2._star_symbol, arrayList, null);
        }
        if (symbol2._plus_symbol != null) {
            arrayList = new ArrayList(1);
            arrayList.add(new symbol_part(symbol2));
            if (symbol2.stack_type() != null) {
                arrayList.add(new action_part("CUP$STAR1"));
            }
            this.build_production(symbol2._plus_symbol, arrayList, null);
            this.add_star_production(symbol2._plus_symbol, symbol2._plus_symbol, symbol2);
        }
    }

    public void add_wildcard_rules() {
        for (symbol symbol2 : this.terminals()) {
            this.add_wildcard_rules(symbol2);
        }
        for (symbol symbol2 : this.non_terminals()) {
            this.add_wildcard_rules(symbol2);
        }
    }
}

