/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.BitfieldInformation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ResultWithSideEffects;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class StructHandler {
    private final MemoryHandler mMemoryHandler;
    private final TypeSizeAndOffsetComputer mTypeSizeAndOffsetComputer;
    private final ExpressionTranslation mExpressionTranslation;
    private final ITypeHandler mTypeHandler;
    private final LocationFactory mLocationFactory;

    public StructHandler(MemoryHandler memoryHandler, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, ExpressionTranslation expressionTranslation, ITypeHandler iTypeHandler, LocationFactory locationFactory) {
        this.mMemoryHandler = memoryHandler;
        this.mTypeSizeAndOffsetComputer = typeSizeAndOffsetComputer;
        this.mExpressionTranslation = expressionTranslation;
        this.mTypeHandler = iTypeHandler;
        this.mLocationFactory = locationFactory;
    }

    public Result handleFieldReference(IDispatcher iDispatcher, ExpressionResultTransformer expressionResultTransformer, IASTFieldReference iASTFieldReference) {
        Expression expression;
        Object object;
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTFieldReference);
        String string = iASTFieldReference.getFieldName().toString();
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTFieldReference.getFieldOwner());
        LRValue lRValue = null;
        ArrayList<ExpressionResult> arrayList = expressionResult.getNeighbourUnionFields() == null ? new ArrayList<ExpressionResult>() : new ArrayList<ExpressionResult>(expressionResult.getNeighbourUnionFields());
        ICType iCType = iASTFieldReference.isPointerDereference() ? ((CPointer)expressionResult.getLrValue().getUnderlyingType()).getPointsToType() : expressionResult.getLrValue().getUnderlyingType();
        CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType.getUnderlyingType();
        ICType iCType2 = cStructOrUnion.getFieldType(string);
        int n = cStructOrUnion.getBitfieldWidth(string);
        if (iASTFieldReference.isPointerDereference()) {
            object = expressionResultTransformer.switchToRValue(expressionResult, cACSLLocation, (IASTNode)iASTFieldReference);
            expression = ((ExpressionResult)object).getLrValue().getValue();
            expressionResult = new ExpressionResult(((ResultWithSideEffects)object).getStatements(), LRValueFactory.constructHeapLValue(this.mTypeHandler, expression, ((ExpressionResult)object).getLrValue().getCType(), null), ((ResultWithSideEffects)object).getDeclarations(), ((ResultWithSideEffects)object).getAuxVars(), ((ResultWithSideEffects)object).getOverapprs());
        }
        if (expressionResult.getLrValue() instanceof HeapLValue) {
            object = (HeapLValue)expressionResult.getLrValue();
            expression = ((HeapLValue)object).getAddress();
            Expression expression2 = MemoryHandler.getPointerBaseAddress(expression, cACSLLocation);
            Expression expression3 = MemoryHandler.getPointerOffset(expression, cACSLLocation);
            TypeSizeAndOffsetComputer.Offset offset = this.mTypeSizeAndOffsetComputer.constructOffsetForField((ILocation)cACSLLocation, cStructOrUnion, string);
            if (offset.isBitfieldOffset()) {
                throw new UnsupportedOperationException("Bitfield reference");
            }
            Expression expression4 = this.mExpressionTranslation.constructArithmeticExpression(cACSLLocation, 4, expression3, this.mExpressionTranslation.getCTypeOfPointerComponents(), offset.getAddressOffsetAsExpression(cACSLLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
            StructConstructor structConstructor = MemoryHandler.constructPointerFromBaseAndOffset(expression2, expression4, cACSLLocation);
            BitfieldInformation bitfieldInformation = StructHandler.constructBitfieldInformation(n);
            lRValue = LRValueFactory.constructHeapLValue(this.mTypeHandler, (Expression)structConstructor, iCType2, bitfieldInformation);
            if (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION) {
                arrayList.addAll(this.computeNeighbourFieldsOfUnionField(cACSLLocation, string, arrayList, cStructOrUnion, (LRValue)object));
            }
        } else if (expressionResult.getLrValue() instanceof RValue) {
            object = (RValue)expressionResult.getLrValue();
            expression = ExpressionFactory.constructStructAccessExpression((ILocation)cACSLLocation, (Expression)((RValue)object).getValue(), (String)string);
            lRValue = new RValue(expression, iCType2);
        } else {
            object = (LocalLValue)expressionResult.getLrValue();
            expression = ExpressionFactory.constructStructAccessLhs((ILocation)cACSLLocation, (LeftHandSide)((LocalLValue)object).getLhs(), (String)string);
            BitfieldInformation bitfieldInformation = StructHandler.constructBitfieldInformation(n);
            lRValue = new LocalLValue((LeftHandSide)expression, iCType2, bitfieldInformation);
            if (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION) {
                arrayList.addAll(this.computeNeighbourFieldsOfUnionField(cACSLLocation, string, arrayList, cStructOrUnion, (LRValue)object));
            }
        }
        return new ExpressionResult(expressionResult.getStatements(), lRValue, expressionResult.getDeclarations(), expressionResult.getAuxVars(), expressionResult.getOverapprs(), arrayList);
    }

    private static BitfieldInformation constructBitfieldInformation(int n) {
        if (n != -1) {
            return new BitfieldInformation(n);
        }
        return null;
    }

    private List<ExpressionResult> computeNeighbourFieldsOfUnionField(ILocation iLocation, String string, List<ExpressionResult> list, CStructOrUnion cStructOrUnion, LRValue lRValue) {
        assert (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION);
        ArrayList<Object> arrayList = list == null ? new ArrayList() : new ArrayList<ExpressionResult>(list);
        String[] stringArray = cStructOrUnion.getFieldIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (!string2.equals(string)) {
                ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
                if (lRValue instanceof LocalLValue) {
                    var12_12 = ExpressionFactory.constructStructAccessLhs((ILocation)iLocation, (LeftHandSide)((LocalLValue)lRValue).getLhs(), (String)string2);
                    expressionResultBuilder.setLrValue(new LocalLValue((LeftHandSide)var12_12, cStructOrUnion.getFieldType(string2), null));
                } else {
                    assert (lRValue instanceof HeapLValue);
                    var12_12 = this.mTypeSizeAndOffsetComputer.constructOffsetForField(iLocation, cStructOrUnion, string2);
                    if (((TypeSizeAndOffsetComputer.Offset)var12_12).isBitfieldOffset()) {
                        throw new UnsupportedOperationException("Bitfield union neighbor");
                    }
                    Expression expression = ((HeapLValue)lRValue).getAddress();
                    Expression expression2 = this.mExpressionTranslation.constructArithmeticIntegerExpression(iLocation, 4, MemoryHandler.getPointerOffset(expression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), ((TypeSizeAndOffsetComputer.Offset)var12_12).getAddressOffsetAsExpression(iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
                    StructConstructor structConstructor = MemoryHandler.constructPointerFromBaseAndOffset(MemoryHandler.getPointerBaseAddress(expression, iLocation), expression2, iLocation);
                    expressionResultBuilder.setLrValue(LRValueFactory.constructHeapLValue(this.mTypeHandler, (Expression)structConstructor, cStructOrUnion.getFieldType(string2), null));
                }
                arrayList.add(expressionResultBuilder.build());
            }
            ++n2;
        }
        return arrayList;
    }

    public Result readFieldInTheStructAtAddress(ILocation iLocation, int n, Expression expression, CStructOrUnion cStructOrUnion, boolean bl) {
        Expression expression2 = this.computeStructFieldAddress(iLocation, n, expression, cStructOrUnion);
        ICType iCType = cStructOrUnion.getFieldTypes()[n];
        ExpressionResult expressionResult = bl ? this.mMemoryHandler.getReadUnchecked(expression2, iCType) : this.mMemoryHandler.getReadCall(expression2, iCType);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.setLrValue(new RValue(expressionResult.getLrValue().getValue(), iCType));
        return expressionResultBuilder.build();
    }

    public Expression computeStructFieldAddress(ILocation iLocation, int n, Expression expression, CStructOrUnion cStructOrUnion) {
        Expression expression2 = MemoryHandler.getPointerBaseAddress(expression, iLocation);
        Expression expression3 = MemoryHandler.getPointerOffset(expression, iLocation);
        Expression expression4 = this.computeStructFieldOffset(iLocation, n, expression3, cStructOrUnion);
        return MemoryHandler.constructPointerFromBaseAndOffset(expression2, expression4, iLocation);
    }

    private Expression computeStructFieldOffset(ILocation iLocation, int n, Expression expression, CStructOrUnion cStructOrUnion) {
        if (cStructOrUnion == null) {
            throw new IncorrectSyntaxException(iLocation, "Incorrect or unexpected field owner!");
        }
        TypeSizeAndOffsetComputer.Offset offset = this.mTypeSizeAndOffsetComputer.constructOffsetForField(iLocation, cStructOrUnion, n);
        if (offset.isBitfieldOffset()) {
            throw new UnsupportedOperationException("Bitfield read");
        }
        return this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, expression, this.mTypeSizeAndOffsetComputer.getSizeT(), offset.getAddressOffsetAsExpression(iLocation), this.mTypeSizeAndOffsetComputer.getSizeT());
    }
}

