/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.CongruenceClosureSmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.RemoveWeqCcElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceEdgeLabel;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqSettings;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;

public class WeqCcManager<NODE extends IEqNodeIdentifier<NODE>> {
    private final IPartialComparator<WeqCongruenceClosure<NODE>> mWeqCcComparator;
    private final CcManager<NODE> mCcManager;
    private final ManagedScript mMgdScript;
    private final ILogger mLogger;
    private final WeqCongruenceClosure<NODE> mTautologicalWeqCc;
    private final WeqCongruenceClosure<NODE> mInconsistentWeqCc;
    private final NestedMap2<Sort, Integer, NODE> mDimensionToWeqVariableNode;
    private final BidirectionalMap<Term, Term> mWeqVarsToWeqPrimedVars;
    private final AbstractNodeAndFunctionFactory<NODE, Term> mNodeAndFunctionFactory;
    private final WeqSettings mSettings;
    private final boolean mBenchmarkMode = false;
    private BenchmarkWithCounters mBenchmark;
    final boolean mDebug;
    final boolean mSkipSolverChecks = true;
    private final Set<NODE> mNonTheoryLiteralNodes;

    public WeqCcManager(ILogger iLogger, IPartialComparator<WeqCongruenceClosure<NODE>> iPartialComparator, IPartialComparator<CongruenceClosure<NODE>> iPartialComparator2, ManagedScript managedScript, AbstractNodeAndFunctionFactory<NODE, Term> abstractNodeAndFunctionFactory, WeqSettings weqSettings, boolean bl, Set<NODE> set) {
        this.mCcManager = new CcManager(iLogger, iPartialComparator2);
        this.mMgdScript = managedScript;
        this.mLogger = iLogger;
        this.mDebug = bl;
        this.mSettings = weqSettings;
        this.mWeqCcComparator = iPartialComparator;
        this.mDimensionToWeqVariableNode = new NestedMap2();
        this.mWeqVarsToWeqPrimedVars = new BidirectionalMap();
        this.mNodeAndFunctionFactory = abstractNodeAndFunctionFactory;
        this.mNonTheoryLiteralNodes = set;
        this.mBenchmark = null;
        this.mTautologicalWeqCc = new WeqCongruenceClosure(this);
        set.forEach(this.mTautologicalWeqCc::addElementRec);
        this.mTautologicalWeqCc.freezeAndClose();
        this.mInconsistentWeqCc = new WeqCongruenceClosure(true);
    }

    public WeqCongruenceClosure<NODE> getEmptyWeqCc(boolean bl) {
        if (bl) {
            WeqCongruenceClosure weqCongruenceClosure = new WeqCongruenceClosure(this);
            this.mNonTheoryLiteralNodes.forEach(iEqNodeIdentifier -> {
                boolean bl = weqCongruenceClosure.addElement(iEqNodeIdentifier, false);
            });
            return weqCongruenceClosure;
        }
        return this.mTautologicalWeqCc;
    }

    public WeqCongruenceClosure<NODE> getInconsistentWeqCc(boolean bl) {
        if (bl) {
            return new WeqCongruenceClosure(true);
        }
        return this.mInconsistentWeqCc;
    }

    public WeqCongruenceClosure<NODE> addNode(NODE NODE, WeqCongruenceClosure<NODE> weqCongruenceClosure, boolean bl, boolean bl2) {
        WeqCongruenceClosure<NODE> weqCongruenceClosure2;
        if (weqCongruenceClosure.hasElement(NODE)) {
            return weqCongruenceClosure;
        }
        if (bl) {
            weqCongruenceClosure.addElement(NODE, bl2);
            weqCongruenceClosure2 = weqCongruenceClosure;
        } else {
            WeqCongruenceClosure<NODE> weqCongruenceClosure3 = this.unfreeze(weqCongruenceClosure);
            weqCongruenceClosure3.addElement(NODE, bl2);
            weqCongruenceClosure3.freezeAndClose();
            weqCongruenceClosure2 = weqCongruenceClosure3;
        }
        assert (bl2 || weqCongruenceClosure.sanityCheck());
        return weqCongruenceClosure2;
    }

    public CongruenceClosure<NODE> addNode(NODE NODE, CongruenceClosure<NODE> congruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure, boolean bl, boolean bl2) {
        return this.mCcManager.addElement(congruenceClosure, NODE, weqCongruenceClosure, bl, bl2);
    }

    WeqCongruenceClosure<NODE> unfreeze(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        this.bmStart(WeqCcBmNames.UNFREEZE);
        assert (weqCongruenceClosure.isFrozen());
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.copyWeqCc(weqCongruenceClosure, true);
        assert (!weqCongruenceClosure2.isFrozen());
        assert (weqCongruenceClosure2.sanityCheck());
        this.bmEnd(WeqCcBmNames.UNFREEZE);
        return weqCongruenceClosure2;
    }

    void bmStart(WeqCcBmNames weqCcBmNames) {
    }

    void bmEnd(WeqCcBmNames weqCcBmNames) {
    }

    public WeakEquivalenceEdgeLabel<NODE> filterRedundantICcs(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel) {
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2 = new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceEdgeLabel.getWeqGraph(), this.filterRedundantCcs(weakEquivalenceEdgeLabel.getDisjuncts()));
        return weakEquivalenceEdgeLabel2;
    }

    public WeakEquivalenceEdgeLabel<NODE> filterRedundantCcs(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel) {
        Set set = this.mCcManager.filterRedundantCcs(weakEquivalenceEdgeLabel.getDisjuncts());
        return new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceEdgeLabel.getWeqGraph(), set);
    }

    private Set<WeqCongruenceClosure<NODE>> filterRedundantWeqCcs(Set<WeqCongruenceClosure<NODE>> set) {
        this.bmStart(WeqCcBmNames.FILTERREDUNDANT);
        PartialOrderCache partialOrderCache = new PartialOrderCache(this.mWeqCcComparator);
        Set set2 = partialOrderCache.getMaximalRepresentatives(set);
        this.bmEnd(WeqCcBmNames.FILTERREDUNDANT);
        return set2;
    }

    public Set<CongruenceClosure<NODE>> filterRedundantCcs(Set<CongruenceClosure<NODE>> set) {
        return this.mCcManager.filterRedundantCcs(set);
    }

    public Set<CongruenceClosure<NODE>> filterRedundantCcs(Set<CongruenceClosure<NODE>> set, PartialOrderCache<CongruenceClosure<NODE>> partialOrderCache) {
        return this.mCcManager.filterRedundantCcs(set, partialOrderCache);
    }

    public IPartialComparator<CongruenceClosure<NODE>> getCcComparator() {
        return this.mCcManager.getCcComparator();
    }

    public WeqCongruenceClosure<NODE> reportEquality(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, NODE NODE2, boolean bl) {
        this.bmStart(WeqCcBmNames.REPORTEQUALITY);
        if (bl) {
            weqCongruenceClosure.reportEquality(NODE, NODE2, false);
            this.bmEnd(WeqCcBmNames.REPORTEQUALITY);
            return weqCongruenceClosure;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.unfreeze(weqCongruenceClosure);
        weqCongruenceClosure2.reportEquality(NODE, NODE2, false);
        weqCongruenceClosure2.freezeAndClose();
        assert (this.checkReportEqualityResult(weqCongruenceClosure, NODE, NODE2, weqCongruenceClosure2, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.REPORTEQUALITY);
        return weqCongruenceClosure2;
    }

    private CongruenceClosure<NODE> reportEquality(CongruenceClosure<NODE> congruenceClosure, NODE NODE, NODE NODE2, boolean bl) {
        CongruenceClosure congruenceClosure2 = this.mCcManager.reportEquality(NODE, NODE2, congruenceClosure, bl);
        assert (this.checkReportEqualityResult(congruenceClosure, NODE, NODE2, congruenceClosure2, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        return congruenceClosure2;
    }

    public WeqCongruenceClosure<NODE> reportDisequality(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, NODE NODE2, boolean bl) {
        this.bmStart(WeqCcBmNames.REPORTDISEQUALITY);
        if (bl) {
            weqCongruenceClosure.reportDisequality(NODE, NODE2);
            this.bmEnd(WeqCcBmNames.REPORTDISEQUALITY);
            return weqCongruenceClosure;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.unfreeze(weqCongruenceClosure);
        weqCongruenceClosure2.reportDisequality(NODE, NODE2);
        weqCongruenceClosure2.freezeAndClose();
        assert (this.checkReportDisequalityResult(weqCongruenceClosure, NODE, NODE2, weqCongruenceClosure2, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.REPORTDISEQUALITY);
        return weqCongruenceClosure2;
    }

    public WeqCongruenceClosure<NODE> reportWeakEquivalence(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, NODE NODE2, NODE NODE3, boolean bl) {
        if (this.mSettings.isDeactivateWeakEquivalences() || NODE.dependsOnUntrackedArray() || NODE2.dependsOnUntrackedArray()) {
            assert (weqCongruenceClosure.getWeakEquivalenceGraph().getNumberOfEdgesStatistic() == 0);
            return weqCongruenceClosure;
        }
        this.bmStart(WeqCcBmNames.REPORTWEQ);
        if (bl) {
            weqCongruenceClosure.reportWeakEquivalence(NODE, NODE2, NODE3, false);
            this.bmEnd(WeqCcBmNames.REPORTWEQ);
            return weqCongruenceClosure;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.unfreeze(weqCongruenceClosure);
        weqCongruenceClosure2.reportWeakEquivalence(NODE, NODE2, NODE3, false);
        weqCongruenceClosure2.freezeAndClose();
        assert (this.checkReportWeakEquivalenceResult(weqCongruenceClosure, NODE, NODE2, NODE3, weqCongruenceClosure2));
        this.bmEnd(WeqCcBmNames.REPORTWEQ);
        return weqCongruenceClosure2;
    }

    public WeqCongruenceClosure<NODE> reportContainsConstraint(NODE NODE, Set<NODE> set, WeqCongruenceClosure<NODE> weqCongruenceClosure, boolean bl) {
        this.bmStart(WeqCcBmNames.REPORTCONTAINS);
        if (bl) {
            weqCongruenceClosure.reportContainsConstraint(NODE, set);
            this.bmEnd(WeqCcBmNames.REPORTCONTAINS);
            return weqCongruenceClosure;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.unfreeze(weqCongruenceClosure);
        weqCongruenceClosure2.reportContainsConstraint(NODE, set);
        weqCongruenceClosure2.freezeAndClose();
        this.bmEnd(WeqCcBmNames.REPORTCONTAINS);
        return weqCongruenceClosure2;
    }

    public WeqCongruenceClosure<NODE> reportContainsConstraint(NODE NODE, Collection<SetConstraint<NODE>> collection, WeqCongruenceClosure<NODE> weqCongruenceClosure, boolean bl) {
        this.bmStart(WeqCcBmNames.REPORTCONTAINS);
        if (bl) {
            weqCongruenceClosure.reportContainsConstraint(NODE, collection);
            this.bmEnd(WeqCcBmNames.REPORTCONTAINS);
            return weqCongruenceClosure;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.unfreeze(weqCongruenceClosure);
        weqCongruenceClosure2.reportContainsConstraint(NODE, collection);
        weqCongruenceClosure2.freezeAndClose();
        this.bmEnd(WeqCcBmNames.REPORTCONTAINS);
        return weqCongruenceClosure2;
    }

    public WeqCongruenceClosure<NODE> projectAway(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE) {
        this.bmStart(WeqCcBmNames.PROJECTAWAY);
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.closeIfNecessary(weqCongruenceClosure);
        WeqCongruenceClosure<NODE> weqCongruenceClosure3 = this.unfreezeIfNecessary(weqCongruenceClosure2);
        assert (weqCongruenceClosure3.isClosed());
        RemoveWeqCcElement.removeSimpleElement(weqCongruenceClosure3, NODE);
        weqCongruenceClosure3.freezeAndClose();
        assert (this.checkProjectAwayResult(weqCongruenceClosure, NODE, weqCongruenceClosure3, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.PROJECTAWAY);
        return weqCongruenceClosure3;
    }

    public WeqCongruenceClosure<NODE> closeIfNecessary(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        if (weqCongruenceClosure.isClosed()) {
            return weqCongruenceClosure;
        }
        if (weqCongruenceClosure.isFrozen()) {
            WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.unfreeze(weqCongruenceClosure);
            weqCongruenceClosure2.extAndTriangleClosure(false);
            return weqCongruenceClosure2;
        }
        weqCongruenceClosure.extAndTriangleClosure(false);
        return weqCongruenceClosure;
    }

    public WeqCongruenceClosure<NODE> meet(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2, boolean bl) {
        this.bmStart(WeqCcBmNames.MEET);
        if (bl) {
            WeqCongruenceClosure<NODE> weqCongruenceClosure3 = null;
            if (this.mDebug) {
                weqCongruenceClosure3 = this.copyWeqCc(weqCongruenceClosure, false);
            }
            weqCongruenceClosure.meet(weqCongruenceClosure2);
            if (this.mDebug) assert (this.checkMeetResult(weqCongruenceClosure3, weqCongruenceClosure2, weqCongruenceClosure, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
            this.bmEnd(WeqCcBmNames.MEET);
            return weqCongruenceClosure;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure4 = this.unfreeze(weqCongruenceClosure);
        WeqCongruenceClosure<NODE> weqCongruenceClosure5 = weqCongruenceClosure4.meet(weqCongruenceClosure2);
        WeqCongruenceClosure<NODE> weqCongruenceClosure6 = this.mSettings.closeAllEqConstraints() || this.mSettings.closeAfterInplaceMeet() ? this.closeIfNecessary(weqCongruenceClosure5) : weqCongruenceClosure5;
        weqCongruenceClosure6.freezeIfNecessary();
        assert (this.checkMeetResult(weqCongruenceClosure, weqCongruenceClosure2, weqCongruenceClosure6, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.MEET);
        return weqCongruenceClosure6;
    }

    public CongruenceClosure<NODE> meet(CongruenceClosure<NODE> congruenceClosure, CongruenceClosure<NODE> congruenceClosure2, boolean bl) {
        return this.meet(congruenceClosure, congruenceClosure2, null, bl);
    }

    public CongruenceClosure<NODE> meet(CongruenceClosure<NODE> congruenceClosure, CongruenceClosure<NODE> congruenceClosure2, IRemovalInfo<NODE> iRemovalInfo, boolean bl) {
        CongruenceClosure<NODE> congruenceClosure3 = null;
        if (this.mDebug && bl) {
            congruenceClosure3 = this.mCcManager.copyNoRemInfo(congruenceClosure);
        } else if (this.mDebug && !bl) {
            congruenceClosure3 = congruenceClosure;
        }
        CongruenceClosure congruenceClosure4 = this.mCcManager.meet(congruenceClosure, congruenceClosure2, iRemovalInfo, bl);
        if (this.mDebug) assert (this.checkMeetResult(congruenceClosure3, congruenceClosure2, congruenceClosure4, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        return congruenceClosure4;
    }

    public CongruenceClosure<NODE> join(CongruenceClosure<NODE> congruenceClosure, CongruenceClosure<NODE> congruenceClosure2, boolean bl) {
        CongruenceClosure congruenceClosure3 = this.mCcManager.join(congruenceClosure, congruenceClosure2, bl);
        assert (this.checkJoinResult(congruenceClosure, congruenceClosure2, congruenceClosure3, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        return congruenceClosure3;
    }

    public CongruenceClosure<NODE> widen(CongruenceClosure<NODE> congruenceClosure, CongruenceClosure<NODE> congruenceClosure2, boolean bl) {
        CongruenceClosure congruenceClosure3 = this.mCcManager.widen(congruenceClosure, congruenceClosure2, bl);
        assert (this.checkJoinResult(congruenceClosure, congruenceClosure2, congruenceClosure3, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        return congruenceClosure3;
    }

    public WeqCongruenceClosure<NODE> join(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2, boolean bl) {
        return this.merge(weqCongruenceClosure, weqCongruenceClosure2, bl, WeqCongruenceClosure::join);
    }

    public WeqCongruenceClosure<NODE> widen(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2, boolean bl) {
        return this.merge(weqCongruenceClosure, weqCongruenceClosure2, bl, WeqCongruenceClosure::widen);
    }

    private WeqCongruenceClosure<NODE> merge(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2, boolean bl, BinaryOperator<WeqCongruenceClosure<NODE>> binaryOperator) {
        this.bmStart(WeqCcBmNames.JOIN);
        WeqCongruenceClosure<NODE> weqCongruenceClosure3 = this.closeIfNecessary(weqCongruenceClosure);
        weqCongruenceClosure3.freezeIfNecessary();
        WeqCongruenceClosure<NODE> weqCongruenceClosure4 = this.closeIfNecessary(weqCongruenceClosure2);
        weqCongruenceClosure4.freezeIfNecessary();
        if (weqCongruenceClosure3.isInconsistent(false)) {
            this.bmEnd(WeqCcBmNames.JOIN);
            return weqCongruenceClosure4;
        }
        if (weqCongruenceClosure4.isInconsistent(false)) {
            this.bmEnd(WeqCcBmNames.JOIN);
            return weqCongruenceClosure3;
        }
        if (weqCongruenceClosure3.isTautological() || weqCongruenceClosure4.isTautological()) {
            this.bmEnd(WeqCcBmNames.JOIN);
            return this.getEmptyWeqCc(bl);
        }
        WeqCongruenceClosure weqCongruenceClosure5 = (WeqCongruenceClosure)binaryOperator.apply(weqCongruenceClosure3, weqCongruenceClosure4);
        assert (weqCongruenceClosure5 != weqCongruenceClosure3 && weqCongruenceClosure5 != weqCongruenceClosure4) : "join should construct a new object";
        if (!bl) {
            weqCongruenceClosure5.freezeAndClose();
        }
        assert (this.checkJoinResult(weqCongruenceClosure3, weqCongruenceClosure4, weqCongruenceClosure5, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.JOIN);
        return weqCongruenceClosure5;
    }

    public CongruenceClosure<NODE> renameVariablesCc(CongruenceClosure<NODE> congruenceClosure, Map<Term, Term> map, boolean bl) {
        return this.mCcManager.transformElements(congruenceClosure, iEqNodeIdentifier -> iEqNodeIdentifier.renameVariables(map), bl);
    }

    public WeqCongruenceClosure<NODE> renameVariables(WeqCongruenceClosure<NODE> weqCongruenceClosure, Map<Term, Term> map, boolean bl) {
        this.bmStart(WeqCcBmNames.RENAMEVARS);
        assert (DataStructureUtils.intersection(new HashSet<Term>(map.values()), new HashSet(weqCongruenceClosure.getCongruenceClosure().getAllElements())).isEmpty());
        if (bl) {
            assert (!weqCongruenceClosure.isFrozen());
            weqCongruenceClosure.transformElementsAndFunctions(iEqNodeIdentifier -> iEqNodeIdentifier.renameVariables(map));
            this.bmEnd(WeqCcBmNames.RENAMEVARS);
            return weqCongruenceClosure;
        }
        WeqCongruenceClosure<IEqNodeIdentifier> weqCongruenceClosure2 = this.unfreeze(weqCongruenceClosure);
        weqCongruenceClosure2.transformElementsAndFunctions(iEqNodeIdentifier -> iEqNodeIdentifier.renameVariables(map));
        weqCongruenceClosure2.freezeOmitPropagations();
        this.bmEnd(WeqCcBmNames.RENAMEVARS);
        return weqCongruenceClosure2;
    }

    public boolean isStrongerThan(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2) {
        this.bmStart(WeqCcBmNames.ISSTRONGERTHAN);
        if (!weqCongruenceClosure.isFrozen() && !weqCongruenceClosure2.isFrozen()) {
            this.alignElements(weqCongruenceClosure, weqCongruenceClosure2, true);
            this.closeIfNecessary(weqCongruenceClosure);
            this.closeIfNecessary(weqCongruenceClosure2);
            boolean bl = weqCongruenceClosure.isStrongerThan(weqCongruenceClosure2);
            this.bmEnd(WeqCcBmNames.ISSTRONGERTHAN);
            return bl;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure3 = this.copyWeqCc(weqCongruenceClosure, true);
        WeqCongruenceClosure<NODE> weqCongruenceClosure4 = this.copyWeqCc(weqCongruenceClosure2, true);
        this.alignElements(weqCongruenceClosure3, weqCongruenceClosure4, true);
        WeqCongruenceClosure<NODE> weqCongruenceClosure5 = this.closeIfNecessary(weqCongruenceClosure3);
        WeqCongruenceClosure<NODE> weqCongruenceClosure6 = this.closeIfNecessary(weqCongruenceClosure4);
        int n = 0;
        while (!weqCongruenceClosure3.getAllElements().equals(weqCongruenceClosure4.getAllElements())) {
            if (++n > 2) {
                throw new AssertionError((Object)"not expecting to do many iterations here --> check");
            }
            this.alignElements(weqCongruenceClosure3, weqCongruenceClosure4, true);
            weqCongruenceClosure5 = this.closeIfNecessary(weqCongruenceClosure3);
            weqCongruenceClosure6 = this.closeIfNecessary(weqCongruenceClosure4);
        }
        weqCongruenceClosure5.freezeIfNecessary();
        weqCongruenceClosure6.freezeIfNecessary();
        boolean bl = weqCongruenceClosure3.isStrongerThan(weqCongruenceClosure4);
        this.bmEnd(WeqCcBmNames.ISSTRONGERTHAN);
        return bl;
    }

    public Pair<WeqCongruenceClosure<NODE>, WeqCongruenceClosure<NODE>> alignElements(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2, boolean bl) {
        assert (!bl || !weqCongruenceClosure.isFrozen());
        assert (!bl || !weqCongruenceClosure2.isFrozen());
        if (bl) {
            this.bmStart(WeqCcBmNames.ALIGN_ELEMENTS);
            while (!weqCongruenceClosure.getAllElements().containsAll(weqCongruenceClosure2.getAllElements()) || !weqCongruenceClosure2.getAllElements().containsAll(weqCongruenceClosure.getAllElements())) {
                this.addAllElements(weqCongruenceClosure, weqCongruenceClosure2.getAllElements(), null, true);
                this.addAllElements(weqCongruenceClosure2, weqCongruenceClosure.getAllElements(), null, true);
            }
            this.bmEnd(WeqCcBmNames.ALIGN_ELEMENTS);
            return new Pair(weqCongruenceClosure, weqCongruenceClosure2);
        }
        this.bmStart(WeqCcBmNames.ALIGN_ELEMENTS);
        WeqCongruenceClosure<NODE> weqCongruenceClosure3 = this.copyWeqCc(weqCongruenceClosure, true);
        WeqCongruenceClosure<NODE> weqCongruenceClosure4 = this.copyWeqCc(weqCongruenceClosure2, true);
        while (!weqCongruenceClosure3.getAllElements().containsAll(weqCongruenceClosure4.getAllElements()) || !weqCongruenceClosure4.getAllElements().containsAll(weqCongruenceClosure3.getAllElements())) {
            this.addAllElements(weqCongruenceClosure3, weqCongruenceClosure4.getAllElements(), null, true);
            this.addAllElements(weqCongruenceClosure4, weqCongruenceClosure3.getAllElements(), null, true);
        }
        weqCongruenceClosure.freezeIfNecessary();
        weqCongruenceClosure2.freezeIfNecessary();
        this.bmEnd(WeqCcBmNames.ALIGN_ELEMENTS);
        return new Pair(weqCongruenceClosure3, weqCongruenceClosure4);
    }

    public CongruenceClosure<NODE> getEmptyCc(boolean bl) {
        return this.mCcManager.getEmptyCc(bl);
    }

    public WeakEquivalenceEdgeLabel<NODE> getSingletonEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, CongruenceClosure<NODE> congruenceClosure) {
        return new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceGraph, Collections.singleton(congruenceClosure));
    }

    public List<NODE> getAllWeqVarsNodeForFunction(NODE NODE) {
        if (!NODE.getSort().isArraySort()) {
            return Collections.emptyList();
        }
        MultiDimensionalSort multiDimensionalSort = new MultiDimensionalSort(NODE.getSort());
        ArrayList arrayList = multiDimensionalSort.getIndexSorts();
        ArrayList<NODE> arrayList2 = new ArrayList<NODE>(multiDimensionalSort.getDimension());
        int n = 0;
        while (n < multiDimensionalSort.getDimension()) {
            arrayList2.add(this.getWeqVariableNodeForDimension(n, (Sort)arrayList.get(n)));
            ++n;
        }
        return arrayList2;
    }

    public Map<Term, Term> getWeqPrimedVarsToWeqVars() {
        return this.mWeqVarsToWeqPrimedVars.inverse();
    }

    public Map<Term, Term> getWeqVarsToWeqPrimedVars() {
        return this.mWeqVarsToWeqPrimedVars;
    }

    public Set<NODE> getAllWeqPrimedAndUnprimedNodes() {
        return DataStructureUtils.union(this.getAllWeqNodes(), this.getAllWeqPrimedNodes());
    }

    public Set<NODE> getAllWeqPrimedNodes() {
        HashSet<NODE> hashSet = new HashSet<NODE>();
        for (Triple triple : this.mDimensionToWeqVariableNode.entrySet()) {
            hashSet.add(this.mNodeAndFunctionFactory.getExistingNode((Term)this.mWeqVarsToWeqPrimedVars.get((Object)((IEqNodeIdentifier)triple.getThird()).getTerm())));
        }
        return hashSet;
    }

    public NODE getWeqVariableNodeForDimension(int n, Sort sort) {
        IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)this.mDimensionToWeqVariableNode.get((Object)sort, (Object)n);
        if (iEqNodeIdentifier == null) {
            TermVariable termVariable = this.mMgdScript.constructFreshTermVariable("weq" + n, sort);
            TermVariable termVariable2 = this.mMgdScript.constructFreshTermVariable("weqPrime" + n, sort);
            this.mWeqVarsToWeqPrimedVars.put((Object)termVariable, (Object)termVariable2);
            iEqNodeIdentifier = this.getEqNodeAndFunctionFactory().getOrConstructNode((Term)termVariable);
            this.mDimensionToWeqVariableNode.put((Object)sort, (Object)n, (Object)iEqNodeIdentifier);
        }
        return (NODE)iEqNodeIdentifier;
    }

    public TermVariable getWeqVariableForDimension(int n, Sort sort) {
        return (TermVariable)this.getWeqVariableNodeForDimension(n, sort).getTerm();
    }

    public Set<TermVariable> getAllWeqVariables() {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        this.mDimensionToWeqVariableNode.entrySet().forEach(triple -> {
            boolean bl = hashSet.add((TermVariable)((IEqNodeIdentifier)triple.getThird()).getTerm());
        });
        return hashSet;
    }

    public Set<NODE> getAllWeqNodes() {
        HashSet<IEqNodeIdentifier> hashSet = new HashSet<IEqNodeIdentifier>();
        for (Triple triple : this.mDimensionToWeqVariableNode.entrySet()) {
            hashSet.add((IEqNodeIdentifier)triple.getThird());
        }
        return hashSet;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public AbstractNodeAndFunctionFactory<NODE, Term> getEqNodeAndFunctionFactory() {
        return this.mNodeAndFunctionFactory;
    }

    private boolean checkReportWeakEquivalenceResult(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, NODE NODE2, NODE NODE3, WeqCongruenceClosure<NODE> weqCongruenceClosure2) {
        return true;
    }

    private boolean checkReportEqualityResult(CongruenceClosure<NODE> congruenceClosure, NODE NODE, NODE NODE2, CongruenceClosure<NODE> congruenceClosure2, Term term) {
        return this.checkReportEqualityResult(CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure, term), NODE.getTerm(), NODE2.getTerm(), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure2, term));
    }

    private boolean checkReportEqualityResult(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, NODE NODE2, WeqCongruenceClosure<NODE> weqCongruenceClosure2, Term term) {
        return this.checkReportEqualityResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure, term), NODE.getTerm(), NODE2.getTerm(), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure2, term));
    }

    private boolean checkReportEqualityResult(Term term, Term term2, Term term3, Term term4) {
        this.mMgdScript.lock((Object)this);
        Script script = this.mMgdScript.getScript();
        Term term5 = SmtUtils.and((Script)script, (Term[])new Term[]{term, this.mMgdScript.term((Object)this, "=", new Term[]{term2, term3})});
        boolean bl = this.checkImplicationHolds(script, term5, term4) && this.checkImplicationHolds(script, term4, term5);
        this.mMgdScript.unlock((Object)this);
        return bl;
    }

    private boolean checkReportDisequalityResult(CongruenceClosure<NODE> congruenceClosure, NODE NODE, NODE NODE2, CongruenceClosure<NODE> congruenceClosure2, Term term) {
        return this.checkReportDisequalityResult(CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure, term), NODE.getTerm(), NODE2.getTerm(), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure2, term));
    }

    private boolean checkReportDisequalityResult(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, NODE NODE2, WeqCongruenceClosure<NODE> weqCongruenceClosure2, Term term) {
        return this.checkReportDisequalityResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure, term), NODE.getTerm(), NODE2.getTerm(), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure2, term));
    }

    private boolean checkReportDisequalityResult(Term term, Term term2, Term term3, Term term4) {
        this.mMgdScript.lock((Object)this);
        Script script = this.mMgdScript.getScript();
        Term term5 = SmtUtils.and((Script)script, (Term[])new Term[]{term, this.mMgdScript.term((Object)this, "distinct", new Term[]{term2, term3})});
        boolean bl = this.checkImplicationHolds(script, term5, term4) && this.checkImplicationHolds(script, term4, term5);
        this.mMgdScript.unlock((Object)this);
        return bl;
    }

    private boolean checkProjectAwayResult(WeqCongruenceClosure<NODE> weqCongruenceClosure, NODE NODE, WeqCongruenceClosure<NODE> weqCongruenceClosure2, Term term) {
        return this.checkProjectAwayResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure, term), NODE.getTerm(), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure2, term));
    }

    private boolean checkProjectAwayResult(Term term, Term term2, Term term3) {
        this.mMgdScript.lock((Object)this);
        Script script = this.mMgdScript.getScript();
        Term term4 = term2 instanceof TermVariable ? SmtUtils.quantifier((Script)script, (int)0, Collections.singleton((TermVariable)term2), (Term)term) : term;
        boolean bl = this.checkImplicationHolds(script, term4, term3);
        this.mMgdScript.unlock((Object)this);
        return bl;
    }

    private boolean checkMeetResult(CongruenceClosure<NODE> congruenceClosure, CongruenceClosure<NODE> congruenceClosure2, CongruenceClosure<NODE> congruenceClosure3, Term term) {
        return this.checkMeetResult(CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure, term), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure2, term), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure3, term));
    }

    boolean checkMeetResult(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2, WeqCongruenceClosure<NODE> weqCongruenceClosure3, Term term) {
        return this.checkMeetResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure, term), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure2, term), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure3, term));
    }

    private boolean checkMeetResult(Term term, Term term2, Term term3) {
        this.mMgdScript.lock((Object)this);
        Script script = this.mMgdScript.getScript();
        Term term4 = SmtUtils.and((Script)script, (Term[])new Term[]{term, term2});
        boolean bl = this.checkImplicationHolds(script, term4, term3) && this.checkImplicationHolds(script, term3, term4);
        this.mMgdScript.unlock((Object)this);
        return bl;
    }

    private boolean checkJoinResult(CongruenceClosure<NODE> congruenceClosure, CongruenceClosure<NODE> congruenceClosure2, CongruenceClosure<NODE> congruenceClosure3, Term term) {
        return this.checkJoinResult(CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure, term), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure2, term), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), congruenceClosure3, term));
    }

    private boolean checkJoinResult(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2, WeqCongruenceClosure<NODE> weqCongruenceClosure3, Term term) {
        return this.checkJoinResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure, term), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure2, term), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqCongruenceClosure3, term));
    }

    private boolean checkJoinResult(Term term, Term term2, Term term3) {
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.echo((Object)this, new QuotedObject("WeqCcManager.checkJoinResult (begin)"));
        Script script = this.mMgdScript.getScript();
        Term term4 = SmtUtils.or((Script)script, (Term[])new Term[]{term, term2});
        boolean bl = this.checkImplicationHolds(script, term4, term3);
        this.mMgdScript.echo((Object)this, new QuotedObject("WeqCcManager.checkJoinResult (end)"));
        this.mMgdScript.unlock((Object)this);
        return bl;
    }

    private boolean checkImplicationHolds(Script script, Term term, Term term2) {
        return true;
    }

    private Script.LBool isStrongerThan(Script script, Term term, Term term2) {
        TermVariable termVariable2;
        assert (this.mMgdScript.isLockOwner((Object)this));
        this.mMgdScript.push((Object)this, 1);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        hashSet.addAll(Arrays.asList(term2.getFreeVars()));
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (TermVariable termVariable2 : hashSet) {
            this.mMgdScript.declareFun((Object)this, termVariable2.getName(), new Sort[0], termVariable2.getSort());
            Term term3 = this.mMgdScript.term((Object)this, termVariable2.getName(), new Term[0]);
            hashMap.put(termVariable2, term3);
        }
        this.mMgdScript.assertTerm((Object)this, Substitution.apply((ManagedScript)this.mMgdScript, hashMap, (Term)term));
        this.mMgdScript.assertTerm((Object)this, SmtUtils.not((Script)script, (Term)Substitution.apply((ManagedScript)this.mMgdScript, hashMap, (Term)term2)));
        termVariable2 = this.mMgdScript.checkSat((Object)this);
        this.mMgdScript.pop((Object)this, 1);
        return termVariable2;
    }

    private boolean checkFilterDisjunctionResult(Set<CongruenceClosure<NODE>> set, Set<CongruenceClosure<NODE>> set2, Term term) {
        if (!set.stream().anyMatch(congruenceClosure -> congruenceClosure.isInconsistent(false)) && !set2.stream().anyMatch(congruenceClosure -> congruenceClosure.isInconsistent(false))) {
            HashSet hashSet = new HashSet();
            set.stream().forEach(congruenceClosure -> {
                boolean bl = hashSet.addAll(congruenceClosure.getAllElements());
            });
            HashSet hashSet2 = new HashSet();
            set2.stream().forEach(congruenceClosure -> {
                boolean bl = hashSet2.addAll(congruenceClosure.getAllElements());
            });
            Set set3 = DataStructureUtils.difference(hashSet2, hashSet);
            if (!set3.isEmpty()) {
                assert (false);
                return false;
            }
        }
        return true;
    }

    private static <NODE extends IEqNodeIdentifier<NODE>> Term disjunctionToTerm(Script script, Set<CongruenceClosure<NODE>> set, Term term) {
        if (set.isEmpty()) {
            return script.term("false", new Term[0]);
        }
        HashSet<Term> hashSet = new HashSet<Term>();
        for (CongruenceClosure<NODE> congruenceClosure : set) {
            hashSet.add(CongruenceClosureSmtUtils.congruenceClosureToTerm(script, congruenceClosure, term));
        }
        return SmtUtils.or((Script)script, hashSet);
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> Term weqCcToTerm(Script script, WeqCongruenceClosure<NODE> weqCongruenceClosure, Term term) {
        if (weqCongruenceClosure.isInconsistent(false)) {
            return script.term("false", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>(CongruenceClosureSmtUtils.congruenceClosureToCube(script, weqCongruenceClosure.getCongruenceClosure(), term));
        List<Term> list = weqCongruenceClosure.getWeakEquivalenceGraph().getWeakEquivalenceConstraintsAsTerms(script);
        arrayList.addAll(list);
        Term term2 = SmtUtils.and((Script)script, (Term[])arrayList.toArray(new Term[arrayList.size()]));
        assert (weqCongruenceClosure.getManager().getSettings().omitSanitycheckFineGrained1() || weqCongruenceClosure.getManager().getAllWeqVariables().stream().allMatch(termVariable -> !Arrays.asList(term2.getFreeVars()).contains(termVariable)));
        return term2;
    }

    public WeqCongruenceClosure<NODE> getWeqCongruenceClosure(CongruenceClosure<NODE> congruenceClosure, WeakEquivalenceGraph<NODE> weakEquivalenceGraph, boolean bl) {
        CongruenceClosure congruenceClosure2 = this.mCcManager.unfreezeIfNecessary(congruenceClosure);
        this.addAllElementsCc(congruenceClosure2, weakEquivalenceGraph.getAppearingNonWeqVarNodes(), null, true);
        WeqCongruenceClosure weqCongruenceClosure = new WeqCongruenceClosure(congruenceClosure2, weakEquivalenceGraph, this);
        this.mNonTheoryLiteralNodes.forEach(iEqNodeIdentifier -> {
            boolean bl = weqCongruenceClosure.addElement(iEqNodeIdentifier, false);
        });
        if (!bl) {
            weqCongruenceClosure.freezeAndClose();
        }
        return weqCongruenceClosure;
    }

    public CongruenceClosure<NODE> getSingleEqualityCc(NODE NODE, NODE NODE2, boolean bl, CongruenceClosure<NODE> congruenceClosure) {
        return this.mCcManager.getSingleEqualityCc(NODE, NODE2, bl);
    }

    public CongruenceClosure<NODE> getSingleDisequalityCc(NODE NODE, NODE NODE2, boolean bl, CongruenceClosure<NODE> congruenceClosure) {
        return this.mCcManager.getSingleDisequalityCc(NODE, NODE2, bl);
    }

    public CongruenceClosure<NODE> getSingleEqualityCc(NODE NODE, NODE NODE2, boolean bl) {
        return this.mCcManager.getSingleEqualityCc(NODE, NODE2, bl);
    }

    public CongruenceClosure<NODE> getSingleDisequalityCc(NODE NODE, NODE NODE2, boolean bl) {
        return this.mCcManager.getSingleDisequalityCc(NODE, NODE2, bl);
    }

    public CongruenceClosure<NODE> copyCcNoRemInfo(CongruenceClosure<NODE> congruenceClosure) {
        CongruenceClosure congruenceClosure2 = this.mCcManager.copyNoRemInfo(congruenceClosure);
        assert (congruenceClosure2.isFrozen() == congruenceClosure.isFrozen());
        return congruenceClosure2;
    }

    public CongruenceClosure<NODE> copyCcNoRemInfoUnfrozen(CongruenceClosure<NODE> congruenceClosure) {
        return this.mCcManager.copyNoRemInfoUnfrozen(congruenceClosure);
    }

    public CongruenceClosure<NODE> projectToElements(CongruenceClosure<NODE> congruenceClosure, Set<NODE> set, IRemovalInfo<NODE> iRemovalInfo, boolean bl) {
        assert (!congruenceClosure.isInconsistent(false)) : "catch this outside";
        CongruenceClosure congruenceClosure2 = this.mCcManager.projectToElements(congruenceClosure, set, iRemovalInfo);
        assert (congruenceClosure2.isFrozen()) : "projectToElements always freezes, right?.. (because it cannot work inplace)";
        if (bl) {
            congruenceClosure2 = this.mCcManager.unfreeze(congruenceClosure2);
        }
        return congruenceClosure2;
    }

    public WeqCongruenceClosure<NODE> addAllElements(WeqCongruenceClosure<NODE> weqCongruenceClosure, Set<NODE> set, IRemovalInfo<NODE> iRemovalInfo, boolean bl) {
        this.bmStart(WeqCcBmNames.ADDALLNODES);
        if (bl) {
            for (IEqNodeIdentifier iEqNodeIdentifier : set) {
                if (weqCongruenceClosure.isInconsistent(false)) {
                    return weqCongruenceClosure;
                }
                this.addNode(iEqNodeIdentifier, weqCongruenceClosure, true, false);
            }
            this.bmEnd(WeqCcBmNames.ADDALLNODES);
            return weqCongruenceClosure;
        }
        WeqCongruenceClosure<Object> weqCongruenceClosure2 = this.unfreeze(weqCongruenceClosure);
        for (IEqNodeIdentifier iEqNodeIdentifier : set) {
            if (weqCongruenceClosure.isInconsistent(false)) {
                return weqCongruenceClosure;
            }
            weqCongruenceClosure2 = this.addNode(iEqNodeIdentifier, weqCongruenceClosure, false, false);
        }
        assert (weqCongruenceClosure2.isFrozen());
        this.bmEnd(WeqCcBmNames.ADDALLNODES);
        return weqCongruenceClosure2;
    }

    public CongruenceClosure<NODE> addAllElementsCc(CongruenceClosure<NODE> congruenceClosure, Set<NODE> set, IRemovalInfo<NODE> iRemovalInfo, boolean bl) {
        return this.mCcManager.addAllElements(congruenceClosure, set, iRemovalInfo, bl);
    }

    CongruenceClosure<NODE> computeWeqConstraintForIndex(List<NODE> list, boolean bl) {
        CongruenceClosure<NODE> congruenceClosure = this.getEmptyCc(true);
        int n = 0;
        while (n < list.size()) {
            IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)list.get(n);
            NODE NODE = this.getWeqVariableNodeForDimension(n, iEqNodeIdentifier.getTerm().getSort());
            this.reportEquality(congruenceClosure, NODE, iEqNodeIdentifier, true);
            ++n;
        }
        if (!bl) {
            congruenceClosure.freezeAndClose();
        }
        return congruenceClosure;
    }

    public WeakEquivalenceEdgeLabel<NODE> getEdgeLabelForIndex(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, NODE NODE) {
        return this.getSingletonEdgeLabel(weakEquivalenceGraph, this.computeWeqConstraintForIndex(Collections.singletonList(NODE), !weakEquivalenceGraph.isFrozen()));
    }

    public WeakEquivalenceEdgeLabel<NODE> meetEdgeLabels(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2, boolean bl) {
        this.bmStart(WeqCcBmNames.MEETEDGELABELS);
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel3 = weakEquivalenceEdgeLabel.meet(weakEquivalenceEdgeLabel2, bl);
        assert (!bl || weakEquivalenceEdgeLabel3 == weakEquivalenceEdgeLabel) : "if inplace is set, we must return the original object";
        assert (bl || this.isStrongerThanPrecise(weakEquivalenceEdgeLabel3, weakEquivalenceEdgeLabel));
        assert (bl || this.isStrongerThanPrecise(weakEquivalenceEdgeLabel3, weakEquivalenceEdgeLabel2));
        this.bmEnd(WeqCcBmNames.MEETEDGELABELS);
        return weakEquivalenceEdgeLabel3;
    }

    boolean checkMeetWeqLabels(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel3) {
        Script script = this.mMgdScript.getScript();
        this.mMgdScript.lock((Object)this);
        List<Term> list = weakEquivalenceEdgeLabel.toDnf(script);
        Term term = SmtUtils.or((Script)script, list);
        List<Term> list2 = weakEquivalenceEdgeLabel2.toDnf(script);
        Term term2 = SmtUtils.or((Script)script, list2);
        List<Term> list3 = weakEquivalenceEdgeLabel3.toDnf(script);
        Term term3 = SmtUtils.or((Script)script, list3);
        Term term4 = SmtUtils.and((Script)script, (Term[])new Term[]{term, term2});
        boolean bl = this.checkImplicationHolds(script, term4, term3);
        assert (bl);
        boolean bl2 = this.checkImplicationHolds(script, term3, term4);
        assert (bl2);
        this.mMgdScript.unlock((Object)this);
        return bl && bl2;
    }

    public void freezeIfNecessary(CongruenceClosure<NODE> congruenceClosure) {
        this.mCcManager.freezeIfNecessary(congruenceClosure);
    }

    public boolean isStrongerThan(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2) {
        boolean bl = this.mSettings.isPreciseWeqLabelComparison() ? this.isStrongerThanPrecise(weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2) : this.isStrongerThan(weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2, this::isStrongerThan);
        assert (this.checkIsStrongerThanResult(weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2, bl));
        return bl;
    }

    boolean isStrongerThanPrecise(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2) {
        Script script = this.mMgdScript.getScript();
        this.mMgdScript.lock((Object)this);
        Term term = SmtUtils.or((Script)script, weakEquivalenceEdgeLabel.toDnf(script));
        term = SmtUtils.and((Script)script, (Term[])new Term[]{term, this.getNonTheoryLiteralDisequalitiesIfNecessary()});
        Term term2 = SmtUtils.or((Script)script, weakEquivalenceEdgeLabel2.toDnf(script));
        Script.LBool lBool = this.isStrongerThan(script, term, term2);
        assert (lBool != Script.LBool.UNKNOWN) : "TODO: solve this problem.. implement a fallback??";
        boolean bl = lBool == Script.LBool.UNSAT;
        this.mMgdScript.unlock((Object)this);
        return bl;
    }

    private boolean checkIsStrongerThanResult(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2, boolean bl) {
        return true;
    }

    public boolean isStrongerThan(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2, BiPredicate<CongruenceClosure<NODE>, CongruenceClosure<NODE>> biPredicate) {
        this.bmStart(WeqCcBmNames.ISLABELSTRONGERTHAN);
        for (CongruenceClosure<NODE> congruenceClosure : weakEquivalenceEdgeLabel.getDisjuncts()) {
            boolean bl = false;
            for (CongruenceClosure<NODE> congruenceClosure2 : weakEquivalenceEdgeLabel2.getDisjuncts()) {
                if (!biPredicate.test(congruenceClosure, congruenceClosure2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.bmEnd(WeqCcBmNames.ISLABELSTRONGERTHAN);
            return false;
        }
        this.bmEnd(WeqCcBmNames.ISLABELSTRONGERTHAN);
        return true;
    }

    public boolean isStrongerThan(CongruenceClosure<NODE> congruenceClosure, CongruenceClosure<NODE> congruenceClosure2) {
        return this.mCcManager.isStrongerThan(congruenceClosure, congruenceClosure2);
    }

    public boolean isEquivalentCc(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2) {
        return this.isStrongerThan(weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2) && this.isStrongerThan(weakEquivalenceEdgeLabel2, weakEquivalenceEdgeLabel);
    }

    public boolean isStrongerThan(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, WeakEquivalenceGraph<NODE> weakEquivalenceGraph2) {
        this.bmStart(WeqCcBmNames.ISWEQGRAPHSTRONGERTHAN);
        assert (weakEquivalenceGraph.getBaseWeqCc().isClosed() && weakEquivalenceGraph2.getBaseWeqCc().isClosed());
        boolean bl = weakEquivalenceGraph.isStrongerThan(weakEquivalenceGraph2);
        this.bmEnd(WeqCcBmNames.ISWEQGRAPHSTRONGERTHAN);
        return bl;
    }

    private void freezeIfNecessary(WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        if (!weakEquivalenceGraph.isFrozen()) {
            weakEquivalenceGraph.freeze();
        }
    }

    public WeakEquivalenceGraph<NODE> join(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, WeakEquivalenceGraph<NODE> weakEquivalenceGraph2, boolean bl) {
        this.bmStart(WeqCcBmNames.WEQGRAPHJOIN);
        this.freezeIfNecessary(weakEquivalenceGraph);
        this.freezeIfNecessary(weakEquivalenceGraph2);
        WeakEquivalenceGraph<NODE> weakEquivalenceGraph3 = weakEquivalenceGraph.join(weakEquivalenceGraph2);
        if (!bl) {
            weakEquivalenceGraph3.freeze();
        }
        this.bmEnd(WeqCcBmNames.WEQGRAPHJOIN);
        return weakEquivalenceGraph3;
    }

    public WeqCongruenceClosure<NODE> copyWeqCc(WeqCongruenceClosure<NODE> weqCongruenceClosure, boolean bl) {
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = new WeqCongruenceClosure<NODE>(weqCongruenceClosure);
        if (!bl) {
            weqCongruenceClosure2.freezeAndClose();
        }
        return weqCongruenceClosure2;
    }

    public CongruenceClosure<NODE> copyCc(CongruenceClosure<NODE> congruenceClosure, boolean bl) {
        return this.mCcManager.getCopy(congruenceClosure, bl);
    }

    public WeakEquivalenceEdgeLabel<NODE> copy(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, boolean bl, boolean bl2) {
        return this.copy(weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel.getWeqGraph(), bl, bl2);
    }

    public WeakEquivalenceEdgeLabel<NODE> copy(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, boolean bl) {
        return this.copy(weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel.getWeqGraph(), bl);
    }

    public WeqCongruenceClosure<NODE> unfreezeIfNecessary(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        if (weqCongruenceClosure.isFrozen()) {
            return this.unfreeze(weqCongruenceClosure);
        }
        return weqCongruenceClosure;
    }

    public WeakEquivalenceEdgeLabel<NODE> copy(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceGraph<NODE> weakEquivalenceGraph, boolean bl) {
        return this.copy(weakEquivalenceEdgeLabel, weakEquivalenceGraph, false, bl);
    }

    public WeakEquivalenceEdgeLabel<NODE> copy(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceGraph<NODE> weakEquivalenceGraph, boolean bl, boolean bl2) {
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2 = new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceGraph, weakEquivalenceEdgeLabel, bl);
        if (!bl2) {
            weakEquivalenceEdgeLabel2.freeze();
        }
        return weakEquivalenceEdgeLabel2;
    }

    public WeakEquivalenceGraph<NODE> unfreeze(WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        return new WeakEquivalenceGraph<NODE>(weakEquivalenceGraph.getBaseWeqCc(), weakEquivalenceGraph);
    }

    public WeakEquivalenceEdgeLabel<NODE> unfreeze(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel) {
        return this.copy(weakEquivalenceEdgeLabel, true);
    }

    public static boolean areAssertsEnabled() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return bl;
    }

    public boolean checkEquivalence(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCongruenceClosure<NODE> weqCongruenceClosure2) {
        return true;
    }

    public Term getNonTheoryLiteralDisequalitiesIfNecessary() {
        return this.mMgdScript.getScript().term("true", new Term[0]);
    }

    public WeqSettings getSettings() {
        return this.mSettings;
    }

    public int getDimensionOfWeqVar(NODE NODE) {
        for (Triple triple : this.mDimensionToWeqVariableNode.entrySet()) {
            if (!((IEqNodeIdentifier)triple.getThird()).equals(NODE)) continue;
            return (Integer)triple.getSecond();
        }
        throw new AssertionError((Object)("weq var unknown: " + String.valueOf(NODE)));
    }

    public BenchmarkWithCounters getBenchmark() {
        return this.mBenchmark;
    }

    public CcManager<NODE> getCcManager() {
        return this.mCcManager;
    }

    public void replaceElement(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, NODE NODE, NODE NODE2) {
        Function<IEqNodeIdentifier, IEqNodeIdentifier> function = iEqNodeIdentifier3 -> iEqNodeIdentifier3.equals(NODE2) ? NODE : iEqNodeIdentifier3;
        weakEquivalenceEdgeLabel.transformElements(function);
    }

    public WeakEquivalenceEdgeLabel<NODE> reportEquality(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, NODE NODE, NODE NODE2, boolean bl) {
        if (bl) {
            for (CongruenceClosure<NODE> congruenceClosure : weakEquivalenceEdgeLabel.getDisjuncts()) {
                this.reportEquality(congruenceClosure, NODE, NODE2, true);
            }
            return weakEquivalenceEdgeLabel;
        }
        HashSet hashSet = new HashSet();
        for (CongruenceClosure<NODE> congruenceClosure : weakEquivalenceEdgeLabel.getDisjuncts()) {
            this.freezeIfNecessary(congruenceClosure);
            CongruenceClosure<NODE> congruenceClosure2 = this.reportEquality(congruenceClosure, NODE, NODE2, false);
            if (congruenceClosure2.isInconsistent()) continue;
            hashSet.add(congruenceClosure2);
        }
        return new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceEdgeLabel.getWeqGraph(), hashSet);
    }

    public boolean isDebugMode() {
        return this.mDebug;
    }

    static enum WeqCcBmNames {
        FILTERREDUNDANT,
        UNFREEZE,
        COPY,
        MEET,
        JOIN,
        ISSTRONGERTHAN,
        ADDNODE,
        REPORTEQUALITY,
        REPORTDISEQUALITY,
        REPORTWEQ,
        REPORTCONTAINS,
        PROJECTAWAY,
        RENAMEVARS,
        ADDALLNODES,
        MEETEDGELABELS,
        ISLABELSTRONGERTHAN,
        ISWEQGRAPHSTRONGERTHAN,
        WEQGRAPHJOIN,
        FREEZE_AND_CLOSE,
        FREEZEONLY,
        EXT_AND_TRIANGLE_CLOSURE,
        ALIGN_ELEMENTS;


        static String[] getNames() {
            String[] stringArray = new String[WeqCcBmNames.values().length];
            int n = 0;
            while (n < WeqCcBmNames.values().length) {
                stringArray[n] = WeqCcBmNames.values()[n].name();
                ++n;
            }
            return stringArray;
        }
    }
}

