/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc.eldarica;

import ap.api.SimpleAPI;
import ap.basetypes.Tree;
import ap.parameters.GlobalSettings;
import ap.parser.IAtom;
import ap.parser.IFormula;
import ap.parser.ITerm;
import ap.terfor.preds.Predicate;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.Derivation;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.IChcScript;
import de.uni_freiburg.informatik.ultimate.lib.chc.eldarica.Backtranslator;
import de.uni_freiburg.informatik.ultimate.lib.chc.eldarica.Translator;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.FunctionDefinition;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.ModelDescription;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lazabs.GlobalParameters;
import lazabs.Main;
import lazabs.horn.Util;
import lazabs.horn.bottomup.HornClauses;
import lazabs.horn.bottomup.SimpleWrapper;
import scala.Function0;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.runtime.AbstractFunction0;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public class EldaricaChcScript
implements IChcScript,
AutoCloseable {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final Script mScript;
    private final SimpleAPI mPrincess;
    private final long mDefaultQueryTimeout;
    private boolean mProduceModels = false;
    private boolean mProduceDerivations = false;
    private boolean mProduceUnsatCores = false;
    private Translator mTranslator;
    private java.util.Map<HornClauses.Clause, HornClause> mClauseMap;
    private Script.LBool mLastResult = null;
    private Lazy<ModelDescription> mLastModel;
    private Lazy<Derivation> mLastDerivation;
    private Lazy<Set<HornClause>> mLastUnsatCore;

    public EldaricaChcScript(IUltimateServiceProvider iUltimateServiceProvider, Script script) {
        this(iUltimateServiceProvider, script, -1L);
    }

    public EldaricaChcScript(IUltimateServiceProvider iUltimateServiceProvider, Script script, long l) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass());
        this.mScript = script;
        this.mPrincess = SimpleAPI.apply((boolean)SimpleAPI.apply$default$1(), (boolean)SimpleAPI.apply$default$2(), (boolean)SimpleAPI.apply$default$3(), (String)SimpleAPI.apply$default$4(), (boolean)SimpleAPI.apply$default$5(), (String)SimpleAPI.apply$default$6(), (File)SimpleAPI.apply$default$7(), (boolean)SimpleAPI.apply$default$8(), (boolean)SimpleAPI.apply$default$9(), (Option)SimpleAPI.apply$default$10(), (GlobalSettings)SimpleAPI.apply$default$11());
        this.mDefaultQueryTimeout = l;
    }

    @Override
    public Script getScript() {
        return this.mScript;
    }

    @Override
    public Script.LBool solve(HcSymbolTable hcSymbolTable, java.util.List<HornClause> list) {
        return this.solve(hcSymbolTable, list, -1L);
    }

    @Override
    public Script.LBool solve(HcSymbolTable hcSymbolTable, java.util.List<HornClause> list, long l) {
        this.reset();
        this.setupTimeout(l);
        List<HornClauses.Clause> list2 = this.translateSystem(list);
        try {
            this.mLogger.info((Object)"starting eldarica solver...");
            Either either = SimpleWrapper.solveLazily(list2, (scala.collection.immutable.Map)SimpleWrapper.solve$default$2(), (boolean)SimpleWrapper.solve$default$3(), (boolean)SimpleWrapper.solve$default$4(), (boolean)SimpleWrapper.solve$default$6());
            this.mLogger.info((Object)"eldarica has returned successfully.");
            Backtranslator backtranslator = this.mTranslator.createBacktranslator(this.mScript);
            if (either.isLeft()) {
                this.mLastResult = Script.LBool.SAT;
                if (this.mProduceModels) {
                    Function0 function0 = (Function0)either.left().get();
                    this.mLastModel = new Lazy(() -> this.translateModel(backtranslator, (Map<Predicate, IFormula>)((Map)function0.apply())));
                }
            } else {
                this.mLastResult = Script.LBool.UNSAT;
                if (this.mProduceDerivations || this.mProduceUnsatCores) {
                    Function0 function0 = (Function0)either.right().get();
                    java.util.Map<HornClauses.Clause, HornClause> map = this.mClauseMap;
                    if (this.mProduceDerivations) {
                        this.mLastDerivation = new Lazy(() -> EldaricaChcScript.translateDerivation(backtranslator, map, (Tree<Tuple2<IAtom, HornClauses.Clause>>)((Util.Dag)function0.apply()).toTree()));
                    }
                    if (this.mProduceUnsatCores) {
                        this.mLastUnsatCore = new Lazy(() -> EldaricaChcScript.extractUnsatCore(map, (Tree<Tuple2<IAtom, HornClauses.Clause>>)((Util.Dag)function0.apply()).toTree()));
                    }
                }
            }
        }
        catch (Main.TimeoutException$ timeoutException$) {
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass(), "solving CHC system");
            }
            this.mLogger.warn("Eldarica timed out, returning UNKNOWN: %s", new Object[]{timeoutException$});
            this.mLastResult = Script.LBool.UNKNOWN;
        }
        return this.mLastResult;
    }

    private List<HornClauses.Clause> translateSystem(Collection<HornClause> collection) {
        ArrayList<HornClauses.Clause> arrayList = new ArrayList<HornClauses.Clause>(collection.size());
        for (HornClause hornClause : collection) {
            HornClauses.Clause clause = this.mTranslator.translateClause(hornClause);
            this.mClauseMap.put(clause, hornClause);
            arrayList.add(clause);
        }
        return EldaricaChcScript.toList(arrayList);
    }

    @Override
    public boolean supportsModelProduction() {
        return true;
    }

    @Override
    public void produceModels(boolean bl) {
        this.mProduceModels = bl;
    }

    @Override
    public Optional<Model> getModel() {
        if (this.mLastResult != Script.LBool.SAT) {
            throw new UnsupportedOperationException("No model available: last query was " + String.valueOf(this.mLastResult));
        }
        if (this.mLastModel == null) {
            return Optional.empty();
        }
        return Optional.of((Model)this.mLastModel.get());
    }

    private ModelDescription translateModel(Backtranslator backtranslator, Map<Predicate, IFormula> map) {
        HashSet<FunctionDefinition> hashSet = new HashSet<FunctionDefinition>();
        for (Map.Entry<Predicate, IFormula> entry : EldaricaChcScript.ofMap(map).entrySet()) {
            HcPredicateSymbol hcPredicateSymbol = backtranslator.translatePredicate(entry.getKey());
            PredicateContext predicateContext = new PredicateContext(this.mScript, hcPredicateSymbol);
            Term term = backtranslator.translateFormula(entry.getValue(), predicateContext);
            hashSet.add(new FunctionDefinition(hcPredicateSymbol.getFunctionSymbol(), predicateContext.getParameters(), term));
        }
        return new ModelDescription(hashSet);
    }

    @Override
    public boolean supportsDerivationProduction() {
        return true;
    }

    @Override
    public void produceDerivations(boolean bl) {
        this.mProduceDerivations = bl;
    }

    @Override
    public Optional<Derivation> getDerivation() {
        if (this.mLastResult != Script.LBool.UNSAT) {
            throw new UnsupportedOperationException("No derivation available: last query was " + String.valueOf(this.mLastResult));
        }
        if (this.mLastDerivation == null) {
            return Optional.empty();
        }
        return Optional.of((Derivation)this.mLastDerivation.get());
    }

    private static Derivation translateDerivation(Backtranslator backtranslator, java.util.Map<HornClauses.Clause, HornClause> map, Tree<Tuple2<IAtom, HornClauses.Clause>> tree2) {
        Object object22;
        IAtom iAtom = (IAtom)((Tuple2)tree2.d())._1();
        HcPredicateSymbol hcPredicateSymbol = backtranslator.translatePredicate(iAtom.pred());
        ArrayList<Term> arrayList = new ArrayList<Term>(iAtom.args().length());
        int n = 0;
        for (Object object22 : EldaricaChcScript.ofList(iAtom.args())) {
            Sort sort = hcPredicateSymbol.getParameterSorts().get(n);
            Term term = backtranslator.translateTerm((ITerm)object22, sort, null);
            arrayList.add(term);
            ++n;
        }
        object22 = EldaricaChcScript.ofList(tree2.children()).stream().map(tree -> EldaricaChcScript.translateDerivation(backtranslator, map, (Tree<Tuple2<IAtom, HornClauses.Clause>>)tree)).collect(Collectors.toList());
        return new Derivation(hcPredicateSymbol, arrayList, map.get(((Tuple2)tree2.d())._2()), (java.util.List<Derivation>)object22);
    }

    @Override
    public boolean supportsUnsatCores() {
        return true;
    }

    @Override
    public void produceUnsatCores(boolean bl) {
        this.mProduceUnsatCores = bl;
    }

    @Override
    public Optional<Set<HornClause>> getUnsatCore() {
        if (this.mLastResult != Script.LBool.UNSAT) {
            throw new UnsupportedOperationException("No UNSAT core available: last query was " + String.valueOf(this.mLastResult));
        }
        if (this.mLastUnsatCore == null) {
            return Optional.empty();
        }
        return Optional.of((Set)this.mLastUnsatCore.get());
    }

    private static Set<HornClause> extractUnsatCore(java.util.Map<HornClauses.Clause, HornClause> map, Tree<Tuple2<IAtom, HornClauses.Clause>> tree) {
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.add(tree);
        HashSet<HornClause> hashSet = new HashSet<HornClause>();
        while (!arrayDeque.isEmpty()) {
            Tree tree2 = (Tree)arrayDeque.pop();
            HornClauses.Clause clause = (HornClauses.Clause)((Tuple2)tree2.d())._2();
            hashSet.add(map.get(clause));
            arrayDeque.addAll(EldaricaChcScript.ofList(tree2.children()));
        }
        return hashSet;
    }

    private void reset() {
        this.mClauseMap = new HashMap<HornClauses.Clause, HornClause>();
        this.mTranslator = new Translator(this.mPrincess);
        this.mLastModel = null;
        this.mLastDerivation = null;
        this.mLastUnsatCore = null;
    }

    @Override
    public void close() throws Exception {
        this.mPrincess.shutDown();
    }

    private void setupTimeout(long l) {
        final Option<Integer> option = this.determineTimeout(l);
        this.mLogger.info("setting eldarica timeout (in ms) to %s", new Object[]{option});
        GlobalParameters.get().timeout_$eq(option);
        final IProgressMonitorService iProgressMonitorService = this.mServices.getProgressMonitorService();
        final long l2 = System.currentTimeMillis();
        GlobalParameters.get().timeoutChecker_$eq((Function0)new AbstractFunction0<BoxedUnit>(){

            public BoxedUnit apply() {
                if (!iProgressMonitorService.continueProcessing() || option.isDefined() && System.currentTimeMillis() - l2 > (long)((Integer)option.get()).intValue()) {
                    EldaricaChcScript.throwUnchecked((Throwable)new Main.TimeoutException$());
                }
                return BoxedUnit.UNIT;
            }
        });
    }

    private Option<Integer> determineTimeout(long l) {
        long l2 = this.mServices.getProgressMonitorService().remainingTime();
        long l3 = l <= 0L ? this.mDefaultQueryTimeout : l;
        long l4 = l3 <= 0L ? l2 : Long.min(l3, l2);
        return l4 < 0L ? Option.empty() : Option.apply((Object)((int)l4));
    }

    private static <T extends Throwable> void throwUnchecked(Throwable throwable) throws T {
        throw throwable;
    }

    private static <X> List<X> toList(java.util.List<X> list) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(list.iterator()).asScala()).toList();
    }

    private static <X> java.util.List<X> ofList(Seq<X> seq) {
        return (java.util.List)JavaConverters.seqAsJavaListConverter(seq).asJava();
    }

    private static <K, V> java.util.Map<K, V> ofMap(Map<K, V> map) {
        return (java.util.Map)JavaConverters.mapAsJavaMapConverter(map).asJava();
    }

    private static class PredicateContext
    implements Backtranslator.IBoundVariableContext {
        private final Script mScript;
        private final HcPredicateSymbol mPredicate;

        public PredicateContext(Script script, HcPredicateSymbol hcPredicateSymbol) {
            this.mScript = script;
            this.mPredicate = hcPredicateSymbol;
        }

        public TermVariable getBoundVariable(int n) {
            Sort sort = this.mPredicate.getParameterSorts().get(n);
            return this.mScript.variable("~~" + String.valueOf(this.mPredicate.getFunctionSymbol()) + "~" + n, sort);
        }

        public TermVariable[] getParameters() {
            return (TermVariable[])IntStream.range(0, this.mPredicate.getArity()).mapToObj(this::getBoundVariable).toArray(TermVariable[]::new);
        }
    }
}

