/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize;

import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize.LocalizeException;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize.LocalizeWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.BindSelExpr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.OperatorName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.ApplExprVisitor;
import net.sourceforge.czt.z.visitor.ZNameVisitor;

public class CollectFunctionsVisitor
implements ZNameVisitor,
TermVisitor,
ApplExprVisitor {
    private static final Set<String> ALL_BASE_FUNCTIONS = new HashSet<String>();
    private static final Set<String> ALL_RELATIONS;
    private final Map<String, String> declarations;
    private final Map<String, String> extFunctions = new HashMap<String, String>();
    private final Set<String> baseFunctions = new HashSet<String>();
    private final Set<String> relations = new HashSet<String>();

    static {
        ALL_BASE_FUNCTIONS.add(ZString.PLUS);
        ALL_BASE_FUNCTIONS.add(ZString.MINUS);
        ALL_BASE_FUNCTIONS.add(ZString.MULT);
        ALL_BASE_FUNCTIONS.add("div");
        ALL_RELATIONS = new HashSet<String>();
        ALL_RELATIONS.add(ZString.LEQ);
        ALL_RELATIONS.add(ZString.LESS);
        ALL_RELATIONS.add(ZString.GEQ);
        ALL_RELATIONS.add(ZString.GREATER);
    }

    public CollectFunctionsVisitor(Map<String, String> map) {
        this.declarations = map;
    }

    public Object visitTerm(Term term) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = term.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof Term) {
                ((Term)object).accept((Visitor)this);
            }
            ++n2;
        }
        return null;
    }

    public Object visitZName(ZName zName) {
        OperatorName operatorName = zName.getOperatorName();
        if (operatorName != null) {
            String string = operatorName.getWord().replaceAll(ZString.ARG_TOK, "");
            if (ALL_RELATIONS.contains(string)) {
                this.relations.add(LocalizeWriter.operatorFor(string));
            }
        } else {
            String string = zName.getWord();
            if (this.declarations.containsKey(string) && !this.extFunctions.containsKey(zName.toString())) {
                this.extFunctions.put(zName.toString(), this.declarations.get(string));
            }
        }
        return null;
    }

    public Object visitApplExpr(ApplExpr applExpr) {
        ZName zName = null;
        if (applExpr.getLeftExpr() instanceof RefExpr) {
            zName = ((RefExpr)applExpr.getLeftExpr()).getZName();
        } else if (applExpr.getLeftExpr() instanceof BindSelExpr) {
            zName = ((BindSelExpr)applExpr.getLeftExpr()).getZName();
        } else if (applExpr.getLeftExpr() instanceof ApplExpr) {
            applExpr.getLeftExpr().accept((Visitor)this);
            applExpr.getRightExpr().accept((Visitor)this);
            return null;
        }
        String string = zName.toString();
        String string2 = zName.getWord();
        if (this.declarations.containsKey(string2) && !this.extFunctions.containsKey(string)) {
            this.extFunctions.put(string, this.declarations.get(string2));
        } else if (!this.extFunctions.containsKey(string)) {
            String string3 = string.replaceAll(ZString.ARG_TOK, "");
            if (ALL_BASE_FUNCTIONS.contains(string3)) {
                this.baseFunctions.add(string3);
            } else {
                throw new LocalizeException("Unknown function symbol (function symbol not declared or only used in query): " + string);
            }
        }
        applExpr.getRightExpr().accept((Visitor)this);
        return null;
    }

    public Map<String, String> getExtFunctions() {
        return this.extFunctions;
    }

    public Set<String> getBaseFunctions() {
        return this.baseFunctions;
    }

    public Set<String> getRelations() {
        return this.relations;
    }
}

