/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LiveIcfgUtils {
    private LiveIcfgUtils() {
    }

    public static <LOC extends IcfgLocation> void applyFutureLiveOptimization(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg) {
        HashRelation<IcfgLocation, IProgramVar> hashRelation = LiveIcfgUtils.computeFutureLiveVariables(iUltimateServiceProvider, iIcfg);
        LiveIcfgUtils.updateTransFormulas(iUltimateServiceProvider, iIcfg, hashRelation);
    }

    private static <LOC extends IcfgLocation> Set<IcfgEdge> collectEdges(Map<DebugIdentifier, LOC> map) {
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        for (Map.Entry<DebugIdentifier, LOC> entry : map.entrySet()) {
            hashSet.addAll(((IcfgLocation)entry.getValue()).getIncomingEdges());
        }
        return hashSet;
    }

    private static <LOC extends IcfgLocation> HashRelation<IcfgLocation, IProgramVar> computeFutureLiveVariables(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg) {
        HashRelation hashRelation = new HashRelation();
        ArrayDeque<IcfgEdge> arrayDeque = new ArrayDeque<IcfgEdge>();
        LiveIcfgUtils.initializeMapAndWorklist(iIcfg, arrayDeque, (HashRelation<IcfgLocation, IProgramVar>)hashRelation);
        LiveIcfgUtils.doFixpointIteration(iUltimateServiceProvider, iIcfg, arrayDeque, (HashRelation<IcfgLocation, IProgramVar>)hashRelation);
        return hashRelation;
    }

    private static <LOC extends IcfgLocation> void updateTransFormulas(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, HashRelation<IcfgLocation, IProgramVar> hashRelation) {
        int n = 0;
        for (Map.Entry entry : iIcfg.getProgramPoints().entrySet()) {
            Object object2;
            String string = (String)entry.getKey();
            HashSet<Object> hashSet = new HashSet<Object>();
            Set set = hashRelation.getImage((Object)((IcfgLocation)iIcfg.getProcedureEntryNodes().get(string)));
            List list = (List)iIcfg.getCfgSmtToolkit().getInParams().get(string);
            for (Object object2 : list) {
                if (!set.contains(object2)) continue;
                hashSet.add(object2);
            }
            object2 = LiveIcfgUtils.collectEdges((Map)entry.getValue());
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3;
                IcfgEdge icfgEdge = (IcfgEdge)iterator.next();
                IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getTarget();
                Set set2 = hashRelation.getImage((Object)icfgLocation);
                UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge.getTransformula();
                HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>(unmodifiableTransFormula.getOutVars().keySet());
                hashSet2.removeAll(set2);
                hashSet2.removeAll(hashSet);
                LiveIcfgUtils.removeHavocedVariables((TransFormula)unmodifiableTransFormula, hashSet2);
                UnmodifiableTransFormula unmodifiableTransFormula2 = hashSet2.iterator();
                while (unmodifiableTransFormula2.hasNext()) {
                    object3 = (IProgramVar)unmodifiableTransFormula2.next();
                    if (!object3.isGlobal()) continue;
                    unmodifiableTransFormula2.remove();
                }
                if (hashSet2.isEmpty()) continue;
                n += hashSet2.size();
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    object3 = TransFormulaBuilder.constructCopy((ManagedScript)iIcfg.getCfgSmtToolkit().getManagedScript(), (TransFormula)unmodifiableTransFormula, Collections.emptySet(), hashSet2, Collections.emptyMap());
                    unmodifiableTransFormula2 = LiveIcfgUtils.eliminateAuxVars(iUltimateServiceProvider, (UnmodifiableTransFormula)object3, iIcfg.getCfgSmtToolkit().getManagedScript());
                } else {
                    unmodifiableTransFormula2 = TransFormulaBuilder.constructCopy((ManagedScript)iIcfg.getCfgSmtToolkit().getManagedScript(), (TransFormula)unmodifiableTransFormula, Collections.emptySet(), hashSet2, Collections.emptyMap());
                }
                object3 = (CodeBlock)icfgEdge;
                ((CodeBlock)((Object)object3)).setTransitionFormula(unmodifiableTransFormula2);
            }
        }
        iUltimateServiceProvider.getLoggingService().getLogger(LiveIcfgUtils.class).log(ILogger.LogLevel.INFO, String.format("Removed %s outVars from TransFormulas that were not future-live.", n));
    }

    public static void removeHavocedVariables(TransFormula transFormula, Set<IProgramVar> set) {
        Iterator<IProgramVar> iterator = set.iterator();
        while (iterator.hasNext()) {
            IProgramVar iProgramVar = iterator.next();
            if (!transFormula.isHavocedOut(iProgramVar)) continue;
            iterator.remove();
        }
    }

    private static UnmodifiableTransFormula eliminateAuxVars(IUltimateServiceProvider iUltimateServiceProvider, UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript) {
        HashSet hashSet = new HashSet(unmodifiableTransFormula.getAuxVars());
        if (hashSet.isEmpty()) {
            return unmodifiableTransFormula;
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), false, unmodifiableTransFormula.getNonTheoryConsts(), false, (Collection)unmodifiableTransFormula.getBranchEncoders(), false);
        Term term = TransFormulaUtils.tryAuxVarEliminationLight((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)unmodifiableTransFormula.getFormula(), hashSet);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(hashSet, managedScript);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    private static <LOC extends IcfgLocation> void initializeMapAndWorklist(IIcfg<LOC> iIcfg, ArrayDeque<IcfgEdge> arrayDeque, HashRelation<IcfgLocation, IProgramVar> hashRelation) {
        for (Map.Entry entry : iIcfg.getProgramPoints().entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                IcfgLocation icfgLocation = (IcfgLocation)entry2.getValue();
                for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                    Set set = icfgEdge.getTransformula().getInVars().keySet();
                    hashRelation.addAllPairs((Object)icfgLocation, set);
                }
                arrayDeque.addAll(icfgLocation.getIncomingEdges());
            }
        }
    }

    private static <LOC extends IcfgLocation> void doFixpointIteration(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, ArrayDeque<IcfgEdge> arrayDeque, HashRelation<IcfgLocation, IProgramVar> hashRelation) {
        while (!arrayDeque.isEmpty()) {
            boolean bl;
            if (!iUltimateServiceProvider.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(LiveIcfgUtils.class, String.format("doing live variable analysis", new Object[0]));
            }
            IcfgEdge icfgEdge = arrayDeque.removeFirst();
            IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getSource();
            IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
            Set set = hashRelation.getImage((Object)icfgLocation2);
            if (icfgEdge instanceof IIcfgInternalTransition || icfgEdge instanceof IIcfgSummaryTransition) {
                bl = hashRelation.addAllPairs((Object)icfgLocation, (Collection)DataStructureUtils.difference((Set)set, icfgEdge.getTransformula().getOutVars().keySet()));
            } else if (icfgEdge instanceof IIcfgCallTransition || icfgEdge instanceof IIcfgReturnTransition) {
                boolean bl2 = false;
                for (IProgramVar iProgramVar : set) {
                    if (!iProgramVar.isGlobal()) continue;
                    bl2 |= hashRelation.addPair((Object)icfgLocation, (Object)iProgramVar);
                }
                bl = bl2;
            } else {
                throw new AssertionError((Object)("Unsupported kind of edge " + icfgEdge.getClass().getSimpleName()));
            }
            if (!bl) continue;
            arrayDeque.addAll(icfgLocation.getIncomingEdges());
        }
    }
}

