/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IndexedStatement;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefBaseAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVar;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class UseCollector
extends RCFGEdgeVisitor {
    private HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> mUse;
    private final IAnnotationProvider<ReachDefStatementAnnotation> mAnnotationProvider;
    private final String mKey;

    UseCollector(IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider, String string) {
        this.mAnnotationProvider = iAnnotationProvider;
        this.mKey = string;
    }

    HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> collect(IcfgEdge icfgEdge) {
        if (this.mUse == null) {
            this.mUse = new HashMap();
            this.visit(icfgEdge);
        }
        return this.mUse;
    }

    protected void visit(StatementSequence statementSequence) {
        super.visit(statementSequence);
        List list = statementSequence.getStatements();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Statement statement : list) {
            ReachDefBaseAnnotation reachDefBaseAnnotation = this.getAnnotation(statement);
            if (reachDefBaseAnnotation == null) continue;
            this.unionUse(reachDefBaseAnnotation);
        }
    }

    private ReachDefBaseAnnotation getAnnotation(Statement statement) {
        if (this.mKey == null) {
            return this.mAnnotationProvider.getAnnotation((IElement)statement);
        }
        return this.mAnnotationProvider.getAnnotation((IElement)statement, this.mKey);
    }

    private void unionUse(ReachDefBaseAnnotation reachDefBaseAnnotation) {
        if (reachDefBaseAnnotation == null) {
            return;
        }
        HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> hashMap = reachDefBaseAnnotation.getUse();
        if (hashMap == null || hashMap == this.mUse) {
            return;
        }
        for (Map.Entry<ScopedBoogieVar, HashSet<IndexedStatement>> entry : hashMap.entrySet()) {
            for (IndexedStatement indexedStatement : entry.getValue()) {
                this.addUse(entry.getKey(), indexedStatement.getStatement(), indexedStatement.getKey());
            }
        }
    }

    private void addUse(ScopedBoogieVar scopedBoogieVar, Statement statement, String string) {
        HashSet<IndexedStatement> hashSet = this.mUse.get(scopedBoogieVar);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.mUse.put(scopedBoogieVar, hashSet);
        }
        hashSet.add(new IndexedStatement(statement, string));
    }
}

