/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.TransitionType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.NwaGameGraphGeneration;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class SummarizeEdge<LETTER, STATE> {
    public static final int NO_PRIORITY = -1;
    private final Map<Pair<STATE, Boolean>, SpoilerNwaVertex<LETTER, STATE>> mChoiceToDestination;
    private final Map<Pair<STATE, Boolean>, DuplicatorNwaVertex<LETTER, STATE>> mChoiceToDuplicatorAux;
    private final Map<Pair<STATE, Boolean>, SpoilerNwaVertex<LETTER, STATE>> mChoiceToSpoilerAux;
    private final Map<Pair<STATE, Boolean>, Set<SpoilerNwaVertex<LETTER, STATE>>> mChoiceToSpoilerInvokers;
    private final DuplicatorNwaVertex<LETTER, STATE> mDuplicatorAux;
    private final Set<Pair<STATE, Boolean>> mDuplicatorChoices;
    private final NwaGameGraphGeneration<LETTER, STATE> mGraphGeneration;
    private final STATE mSpoilerChoice;
    private final SpoilerNwaVertex<LETTER, STATE> mSrc;

    public SummarizeEdge(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex, STATE STATE, Set<Pair<STATE, Boolean>> set, NwaGameGraphGeneration<LETTER, STATE> nwaGameGraphGeneration) {
        this.mGraphGeneration = nwaGameGraphGeneration;
        this.mSrc = spoilerNwaVertex;
        this.mSpoilerChoice = STATE;
        this.mDuplicatorChoices = set;
        this.mDuplicatorAux = new DuplicatorNwaVertex<Object, Object>(2, false, STATE, null, null, TransitionType.SUMMARIZE_ENTRY, this);
        this.mChoiceToDestination = new HashMap<Pair<STATE, Boolean>, SpoilerNwaVertex<LETTER, STATE>>();
        this.mChoiceToSpoilerAux = new HashMap<Pair<STATE, Boolean>, SpoilerNwaVertex<LETTER, STATE>>();
        this.mChoiceToDuplicatorAux = new HashMap<Pair<STATE, Boolean>, DuplicatorNwaVertex<LETTER, STATE>>();
        this.mChoiceToSpoilerInvokers = new HashMap<Pair<STATE, Boolean>, Set<SpoilerNwaVertex<LETTER, STATE>>>();
        this.initInternalMaps();
    }

    public void addToGameGraph() {
        this.mGraphGeneration.addDuplicatorVertex(this.mDuplicatorAux);
        this.mGraphGeneration.addEdge(this.mSrc, this.mDuplicatorAux);
        for (Pair<STATE, Boolean> pair : this.mDuplicatorChoices) {
            SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex = this.mChoiceToSpoilerAux.get(pair);
            DuplicatorNwaVertex<LETTER, STATE> duplicatorNwaVertex = this.mChoiceToDuplicatorAux.get(pair);
            this.mGraphGeneration.addSpoilerVertex(spoilerNwaVertex);
            this.mGraphGeneration.addDuplicatorVertex(duplicatorNwaVertex);
            this.mGraphGeneration.addEdge(this.mDuplicatorAux, spoilerNwaVertex);
            this.mGraphGeneration.addEdge(spoilerNwaVertex, duplicatorNwaVertex);
            this.mGraphGeneration.addEdge(duplicatorNwaVertex, this.mChoiceToDestination.get(pair));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SummarizeEdge)) {
            return false;
        }
        SummarizeEdge summarizeEdge = (SummarizeEdge)object;
        if (this.mDuplicatorChoices == null ? summarizeEdge.mDuplicatorChoices != null : !this.mDuplicatorChoices.equals(summarizeEdge.mDuplicatorChoices)) {
            return false;
        }
        if (this.mSpoilerChoice == null ? summarizeEdge.mSpoilerChoice != null : !this.mSpoilerChoice.equals(summarizeEdge.mSpoilerChoice)) {
            return false;
        }
        return !(this.mSrc == null ? summarizeEdge.mSrc != null : !this.mSrc.equals(summarizeEdge.mSrc));
    }

    public SpoilerNwaVertex<LETTER, STATE> getDestination(Pair<STATE, Boolean> pair) {
        return this.mChoiceToDestination.get(pair);
    }

    public Collection<SpoilerNwaVertex<LETTER, STATE>> getDestinations() {
        return this.mChoiceToDestination.values();
    }

    public Set<Pair<STATE, Boolean>> getDuplicatorChoices() {
        return this.mDuplicatorChoices;
    }

    public int getPriority(Pair<STATE, Boolean> pair) {
        return this.mChoiceToSpoilerAux.get(pair).getPriority();
    }

    public SpoilerVertex<LETTER, STATE> getSource() {
        return this.mSrc;
    }

    public STATE getSpoilerChoice() {
        return this.mSpoilerChoice;
    }

    public Set<SpoilerNwaVertex<LETTER, STATE>> getSpoilerInvokers(Pair<STATE, Boolean> pair) {
        return this.mChoiceToSpoilerInvokers.get(pair);
    }

    public int hashCode() {
        return Objects.hash(this.mDuplicatorChoices, this.mSpoilerChoice, this.mSrc);
    }

    public void setAllPriorities(int n) {
        for (SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex : this.mChoiceToSpoilerAux.values()) {
            spoilerNwaVertex.setPriority(n);
        }
    }

    public void setPriority(Pair<STATE, Boolean> pair, int n) {
        this.mChoiceToSpoilerAux.get(pair).setPriority(n);
    }

    private void initInternalMaps() {
        for (Pair<STATE, Boolean> pair : this.mDuplicatorChoices) {
            Object object = pair.getFirst();
            boolean bl = (Boolean)pair.getSecond();
            SpoilerNwaVertex spoilerNwaVertex = new SpoilerNwaVertex(-1, bl, null, object, this);
            this.mChoiceToSpoilerAux.put(pair, spoilerNwaVertex);
            DuplicatorNwaVertex<Object, Object> duplicatorNwaVertex = new DuplicatorNwaVertex<Object, Object>(2, bl, null, object, null, TransitionType.SUMMARIZE_EXIT, this);
            this.mChoiceToDuplicatorAux.put(pair, duplicatorNwaVertex);
            SpoilerVertex<LETTER, Object> spoilerVertex = this.mGraphGeneration.getSpoilerVertex(this.mSpoilerChoice, object, bl, null, null);
            if (spoilerVertex instanceof SpoilerNwaVertex) {
                this.mChoiceToDestination.put(pair, (SpoilerNwaVertex)spoilerVertex);
            }
            AGameGraph<LETTER, Object> aGameGraph = this.mGraphGeneration.getGameGraph();
            for (Vertex<LETTER, Object> vertex : aGameGraph.getPredecessors(spoilerVertex)) {
                Set<Vertex<LETTER, STATE>> set;
                if (!(vertex instanceof DuplicatorNwaVertex)) {
                    throw new IllegalStateException("Expected cast to be possible, something seems to be wrong with the game graph.");
                }
                DuplicatorNwaVertex duplicatorNwaVertex2 = (DuplicatorNwaVertex)vertex;
                if (!duplicatorNwaVertex2.getTransitionType().equals((Object)TransitionType.RETURN) || (set = aGameGraph.getPredecessors(duplicatorNwaVertex2)) == null) continue;
                for (Vertex<LETTER, STATE> vertex2 : set) {
                    if (!(vertex2 instanceof SpoilerNwaVertex)) {
                        throw new IllegalStateException("Expected cast to be possible, something seems to be wrong with the game graph.");
                    }
                    SpoilerNwaVertex spoilerNwaVertex2 = (SpoilerNwaVertex)vertex2;
                    Set<SpoilerNwaVertex<LETTER, STATE>> set2 = this.mChoiceToSpoilerInvokers.get(pair);
                    if (set2 == null) {
                        set2 = new HashSet<SpoilerNwaVertex<LETTER, STATE>>();
                    }
                    set2.add(spoilerNwaVertex2);
                    this.mChoiceToSpoilerInvokers.put(pair, set2);
                }
            }
        }
    }
}

