/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BoogieUtils {
    public static final String AUXILIARY_LABEL = "auxiliary_label";

    private BoogieUtils() {
    }

    public static NamedAttribute constructAuxiliaryLabelAttribute(ILocation iLocation) {
        return new NamedAttribute(iLocation, AUXILIARY_LABEL, new Expression[0]);
    }

    public static Label constuctAuxiliaryLabel(ILocation iLocation, String string) {
        return new Label(iLocation, string, new NamedAttribute[]{BoogieUtils.constructAuxiliaryLabelAttribute(iLocation)});
    }

    public static Label constuctAuxiliaryLabel(ILocation iLocation, String string, NamedAttribute[] namedAttributeArray) {
        NamedAttribute[] namedAttributeArray2 = Arrays.copyOf(namedAttributeArray, namedAttributeArray.length + 1);
        namedAttributeArray2[namedAttributeArray.length] = BoogieUtils.constructAuxiliaryLabelAttribute(iLocation);
        return new Label(iLocation, string, namedAttributeArray2);
    }

    public static boolean containsOuterBreak(Statement[] statementArray) {
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            boolean bl = BoogieUtils.containsOuterBreak(statement);
            if (bl) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsOuterBreak(Statement statement) {
        Statement statement2 = statement;
        Objects.requireNonNull(statement2);
        Statement statement3 = statement2;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BreakStatement.class, AssignmentStatement.class, AssumeStatement.class, HavocStatement.class, IfStatement.class, WhileStatement.class, AssertStatement.class, CallStatement.class, JoinStatement.class, ForkStatement.class, GotoStatement.class, Label.class, ReturnStatement.class, AtomicStatement.class}, (Object)((Object)statement3), 0)) {
            case 0 -> {
                BreakStatement var2_2 = (BreakStatement)statement3;
                yield true;
            }
            case 1 -> {
                AssignmentStatement var3_3 = (AssignmentStatement)statement3;
                yield false;
            }
            case 2 -> {
                AssumeStatement var4_4 = (AssumeStatement)statement3;
                yield false;
            }
            case 3 -> {
                HavocStatement var5_5 = (HavocStatement)statement3;
                yield false;
            }
            case 4 -> {
                IfStatement var6_6 = (IfStatement)statement3;
                yield BoogieUtils.containsOuterBreak(var6_6);
            }
            case 5 -> {
                WhileStatement var7_7 = (WhileStatement)statement3;
                yield false;
            }
            case 6 -> {
                AssertStatement var8_8 = (AssertStatement)statement3;
                yield false;
            }
            case 7 -> {
                CallStatement var9_9 = (CallStatement)statement3;
                yield false;
            }
            case 8 -> {
                JoinStatement var10_10 = (JoinStatement)statement3;
                yield false;
            }
            case 9 -> {
                ForkStatement var11_11 = (ForkStatement)statement3;
                yield false;
            }
            case 10 -> {
                GotoStatement var12_12 = (GotoStatement)statement3;
                yield false;
            }
            case 11 -> {
                Label var13_13 = (Label)statement3;
                yield false;
            }
            case 12 -> {
                ReturnStatement var14_14 = (ReturnStatement)statement3;
                yield false;
            }
            case 13 -> {
                AtomicStatement var15_15 = (AtomicStatement)statement3;
                yield BoogieUtils.containsOuterBreak(var15_15.getBody());
            }
            default -> throw new UnsupportedOperationException("Statement " + String.valueOf(((Object)((Object)statement)).getClass()) + " not supported");
        };
    }

    private static boolean containsOuterBreak(IfStatement ifStatement) {
        boolean bl = BoogieUtils.containsOuterBreak(ifStatement.getThenPart());
        if (bl) {
            return true;
        }
        return BoogieUtils.containsOuterBreak(ifStatement.getElsePart());
    }

    public static Map<String, Integer> countGotoTargets(Statement[] statementArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        BoogieUtils.countGotoTargets(hashMap, statementArray);
        return hashMap;
    }

    private static void countGotoTargets(Map<String, Integer> map, Statement[] statementArray) {
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            BoogieUtils.countGotoTargets(map, statement);
            ++n2;
        }
    }

    private static void countGotoTargets(Map<String, Integer> map, Statement statement) {
        Statement statement2 = statement;
        Objects.requireNonNull(statement2);
        Statement statement3 = statement2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BreakStatement.class, AssignmentStatement.class, AssumeStatement.class, HavocStatement.class, AssertStatement.class, CallStatement.class, JoinStatement.class, ForkStatement.class, Label.class, ReturnStatement.class, IfStatement.class, WhileStatement.class, AtomicStatement.class, GotoStatement.class}, (Object)((Object)statement3), 0)) {
            case 0: {
                BreakStatement breakStatement = (BreakStatement)statement3;
                return;
            }
            case 1: {
                AssignmentStatement assignmentStatement = (AssignmentStatement)statement3;
                return;
            }
            case 2: {
                AssumeStatement assumeStatement = (AssumeStatement)statement3;
                return;
            }
            case 3: {
                HavocStatement havocStatement = (HavocStatement)statement3;
                return;
            }
            case 4: {
                AssertStatement assertStatement = (AssertStatement)statement3;
                return;
            }
            case 5: {
                CallStatement callStatement = (CallStatement)statement3;
                return;
            }
            case 6: {
                JoinStatement joinStatement = (JoinStatement)statement3;
                return;
            }
            case 7: {
                ForkStatement forkStatement = (ForkStatement)statement3;
                return;
            }
            case 8: {
                Label label = (Label)statement3;
                return;
            }
            case 9: {
                ReturnStatement returnStatement = (ReturnStatement)statement3;
                return;
            }
            case 10: {
                IfStatement ifStatement = (IfStatement)statement3;
                BoogieUtils.countGotoTargets(map, ifStatement.getThenPart());
                BoogieUtils.countGotoTargets(map, ifStatement.getElsePart());
                return;
            }
            case 11: {
                WhileStatement whileStatement = (WhileStatement)statement3;
                BoogieUtils.countGotoTargets(map, whileStatement.getBody());
                return;
            }
            case 12: {
                AtomicStatement atomicStatement = (AtomicStatement)statement3;
                BoogieUtils.countGotoTargets(map, atomicStatement.getBody());
                return;
            }
            case 13: {
                GotoStatement gotoStatement = (GotoStatement)statement3;
                String[] stringArray = gotoStatement.getLabels();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Integer n3 = map.getOrDefault(string, 0);
                    map.put(string, n3 + 1);
                    ++n2;
                }
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
    }
}

