/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AbsIntBenchmark<ACTION>
implements ICsvProviderProvider<Object> {
    private final Map<Integer, Integer> mAction2Visits = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> mAction2Merges = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> mAction2Widen = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> mAction2Fixpoints = new HashMap<Integer, Integer>();
    private int mLastAction;
    @SimpleCsvProvider.CsvColumn(value="MaxVariables")
    private int mMaxVariables = 0;
    @SimpleCsvProvider.CsvColumn(value="PostApplication")
    private int mPostApplication = 0;
    private int mEvaluationRecursions = 0;
    private int mEvaluationMaxRecursionDepth = 0;
    private int mInverseEvaluationRecursions = 0;
    private int mInverseEvaluationMaxRecursionDepth = 0;

    public ICsvProvider<Object> createCsvProvider() {
        return SimpleCsvProvider.constructCsvProviderReflectively((Object)this);
    }

    void addIteration(ACTION ACTION) {
        this.mLastAction = ACTION.hashCode();
        this.addOrIncrement(this.mAction2Visits);
    }

    void addMerge() {
        this.addOrIncrement(this.mAction2Merges);
    }

    void addWiden() {
        this.addOrIncrement(this.mAction2Widen);
    }

    void addFixpoint() {
        this.addOrIncrement(this.mAction2Fixpoints);
    }

    void addMaxVariables(int n) {
        if (n > this.mMaxVariables) {
            this.mMaxVariables = n;
        }
    }

    void countPostApplication() {
        ++this.mPostApplication;
    }

    public void recordEvaluationRecursionDepth(int n) {
        if (n > this.mEvaluationMaxRecursionDepth) {
            this.mEvaluationMaxRecursionDepth = n;
        }
        ++this.mEvaluationRecursions;
    }

    public void recordInverseEvaluationRecursionDepth(int n) {
        if (n > this.mInverseEvaluationMaxRecursionDepth) {
            this.mInverseEvaluationMaxRecursionDepth = n;
        }
        ++this.mInverseEvaluationRecursions;
    }

    private void addOrIncrement(Map<Integer, Integer> map) {
        Integer n = map.get(this.mLastAction);
        if (n == null) {
            map.put(this.mLastAction, 1);
        } else {
            map.put(this.mLastAction, n + 1);
        }
    }

    public String toString() {
        Optional<Integer> optional;
        if (this.mAction2Visits.isEmpty()) {
            return "No benchmarks available";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Integer> optional2 = this.mAction2Visits.entrySet().stream().map(entry -> (Integer)entry.getValue()).reduce((n, n2) -> n + n2);
        stringBuilder.append("Visited ").append(this.mAction2Visits.size()).append(" different actions ").append(optional2.get()).append(" times. ");
        if (this.mAction2Merges.isEmpty()) {
            stringBuilder.append("Never merged. ");
        } else {
            optional = this.mAction2Merges.entrySet().stream().map(entry -> (Integer)entry.getValue()).reduce((n, n2) -> n + n2);
            stringBuilder.append("Merged at ").append(this.mAction2Merges.size()).append(" different actions ").append(optional.get()).append(" times. ");
        }
        if (this.mAction2Widen.isEmpty()) {
            stringBuilder.append("Never widened. ");
        } else {
            optional = this.mAction2Widen.entrySet().stream().map(entry -> (Integer)entry.getValue()).reduce((n, n2) -> n + n2);
            stringBuilder.append("Widened at ").append(this.mAction2Widen.size()).append(" different actions ").append(optional.get()).append(" times. ");
        }
        if (this.mEvaluationRecursions > 0) {
            stringBuilder.append("Performed ").append(this.mEvaluationRecursions).append(" root evaluator evaluations with a maximum evaluation depth of ").append(this.mEvaluationMaxRecursionDepth).append(". ");
        }
        if (this.mInverseEvaluationRecursions > 0) {
            stringBuilder.append("Performed ").append(this.mInverseEvaluationRecursions).append(" inverse root evaluator evaluations with a maximum inverse evaluation depth of ").append(this.mInverseEvaluationMaxRecursionDepth).append(". ");
        }
        if (this.mAction2Fixpoints.isEmpty()) {
            stringBuilder.append("Never found a fixpoint.");
        } else {
            optional = this.mAction2Fixpoints.entrySet().stream().map(entry -> (Integer)entry.getValue()).reduce((n, n2) -> n + n2);
            stringBuilder.append("Found ").append(optional.get()).append(" fixpoints after ").append(this.mAction2Fixpoints.size()).append(" different actions.");
        }
        stringBuilder.append(" Largest state had " + this.mMaxVariables + " variables.");
        return stringBuilder.toString();
    }
}

