/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.Derivation;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.IChcScript;
import de.uni_freiburg.informatik.ultimate.lib.chc.results.ChcSatResult;
import de.uni_freiburg.informatik.ultimate.lib.chc.results.ChcUnsatResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.TreeAutomizerCEGAR;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TreeAutomizerChcScript
implements IChcScript {
    private static final String DUMMY_FILENAME = TreeAutomizerChcScript.class.getSimpleName();
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final TAPreferences mPrefs;
    private final ILogger mLogger;
    private boolean mProduceUnsatCores = false;
    private Script.LBool mLastResult = null;
    private Set<HornClause> mUnsatCore;

    public TreeAutomizerChcScript(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, TAPreferences tAPreferences) {
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
        this.mPrefs = tAPreferences;
        this.mLogger = this.mServices.getLoggingService().getLogger(TreeAutomizerChcScript.class);
    }

    public Script getScript() {
        return this.mMgdScript.getScript();
    }

    public Script.LBool solve(HcSymbolTable hcSymbolTable, List<HornClause> list) {
        return this.solve(this.mServices, hcSymbolTable, list);
    }

    public Script.LBool solve(HcSymbolTable hcSymbolTable, List<HornClause> list, long l) {
        IProgressAwareTimer iProgressAwareTimer = this.mServices.getProgressMonitorService().getChildTimer(l);
        IUltimateServiceProvider iUltimateServiceProvider = this.mServices.getProgressMonitorService().registerChildTimer(this.mServices, iProgressAwareTimer);
        return this.solve(iUltimateServiceProvider, hcSymbolTable, list);
    }

    private Script.LBool solve(IUltimateServiceProvider iUltimateServiceProvider, HcSymbolTable hcSymbolTable, List<HornClause> list) {
        this.reset();
        HornAnnot hornAnnot = new HornAnnot(DUMMY_FILENAME, this.mMgdScript, hcSymbolTable, list, true, null);
        TreeAutomizerCEGAR treeAutomizerCEGAR = new TreeAutomizerCEGAR(iUltimateServiceProvider, hornAnnot, this.mPrefs, this.mLogger);
        try {
            IResult iResult = treeAutomizerCEGAR.iterate();
            this.mLastResult = this.resultToLBool(iResult);
            return this.mLastResult;
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new IllegalStateException(automataLibraryException);
        }
    }

    private Script.LBool resultToLBool(IResult iResult) {
        if (iResult instanceof ChcSatResult) {
            return Script.LBool.SAT;
        }
        if (iResult instanceof ChcUnsatResult) {
            if (this.mProduceUnsatCores) {
                this.mUnsatCore = ((ChcUnsatResult)iResult).getUnsatCore();
            }
            return Script.LBool.UNSAT;
        }
        if (iResult instanceof TimeoutResult) {
            return Script.LBool.UNKNOWN;
        }
        throw new IllegalArgumentException("Unknown result type: " + String.valueOf(iResult.getClass()));
    }

    public boolean supportsModelProduction() {
        return false;
    }

    public void produceModels(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public Optional<Model> getModel() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsDerivationProduction() {
        return false;
    }

    public void produceDerivations(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public Optional<Derivation> getDerivation() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsUnsatCores() {
        return true;
    }

    public void produceUnsatCores(boolean bl) {
        this.mProduceUnsatCores = bl;
    }

    public Optional<Set<HornClause>> getUnsatCore() {
        if (this.mLastResult != Script.LBool.UNSAT) {
            throw new UnsupportedOperationException("No UNSAT core available: last query was " + String.valueOf(this.mLastResult));
        }
        return Optional.ofNullable(this.mUnsatCore);
    }

    private void reset() {
        this.mUnsatCore = null;
    }
}

