/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder.cfg.CfgBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import java.io.IOException;

public class IcfgBuilderObserver
implements IUnmanagedObserver {
    private IIcfg<BoogieIcfgLocation> mGraphroot;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;

    public IcfgBuilderObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public IIcfg<BoogieIcfgLocation> getRoot() {
        return this.mGraphroot;
    }

    public boolean process(IElement iElement) throws IOException {
        if (!(iElement instanceof Unit)) {
            this.mLogger.info((Object)"No WrapperNode. Let Ultimate process with next node");
            return true;
        }
        Unit unit = (Unit)iElement;
        CfgBuilder cfgBuilder = new CfgBuilder(unit, this.mServices);
        try {
            this.mGraphroot = cfgBuilder.createIcfg(unit);
            assert (IcfgUtils.areReachableProgramPointsRegistered(this.mGraphroot));
            assert (IcfgUtils.areLoopLocationsRegistered(this.mGraphroot));
            assert (IcfgUtils.areLocationsOfInterestRegistered(this.mGraphroot));
            this.mServices.getBacktranslationService().addTranslator(cfgBuilder.getBacktranslator());
        }
        catch (SMTLIBException sMTLIBException) {
            String string = sMTLIBException.getMessage();
            if ("Cannot create quantifier in quantifier-free logic".equals(string) || "Sort Array not declared".equals(string) || "Unsupported non-linear arithmetic".equals(string)) {
                this.mLogger.warn((Object)("Unsupported syntax: " + sMTLIBException.getMessage()));
            }
            throw sMTLIBException;
        }
        return false;
    }

    public void finish() {
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public boolean performedChanges() {
        return false;
    }
}

