/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public interface IAbstractState<STATE extends IAbstractState<STATE>> {
    public static final /* synthetic */ boolean $assertionsDisabled;

    public STATE addVariable(IProgramVarOrConst var1);

    public STATE removeVariable(IProgramVarOrConst var1);

    public STATE addVariables(Collection<IProgramVarOrConst> var1);

    public STATE removeVariables(Collection<IProgramVarOrConst> var1);

    public boolean containsVariable(IProgramVarOrConst var1);

    public ImmutableSet<IProgramVarOrConst> getVariables();

    default public STATE renameVariable(IProgramVarOrConst iProgramVarOrConst, IProgramVarOrConst iProgramVarOrConst2) {
        return this.renameVariables(Collections.singletonMap(iProgramVarOrConst, iProgramVarOrConst2));
    }

    public STATE renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> var1);

    public STATE patch(STATE var1);

    public STATE intersect(STATE var1);

    public STATE union(STATE var1);

    default public Set<STATE> union(Set<STATE> set, int n) {
        assert (set.size() > n);
        assert (n >= 1);
        assert (set.contains(this));
        int n2 = set.size() - n;
        while (n2 > 0) {
            Iterator<STATE> iterator = set.iterator();
            IAbstractState iAbstractState = (IAbstractState)iterator.next();
            iterator.remove();
            IAbstractState iAbstractState2 = (IAbstractState)iterator.next();
            iterator.remove();
            if (set.add(iAbstractState.union(iAbstractState2))) {
                --n2;
                continue;
            }
            n2 -= 2;
        }
        assert (set.size() <= n);
        return set;
    }

    public boolean isEmpty();

    public boolean isBottom();

    public boolean isEqualTo(STATE var1);

    public SubsetResult isSubsetOf(STATE var1);

    public STATE compact();

    public Term getTerm(Script var1);

    public String toLogString();

    public static enum SubsetResult {
        EQUAL,
        NON_STRICT,
        STRICT,
        NONE;


        public SubsetResult min(SubsetResult subsetResult) {
            switch (this) {
                case EQUAL: {
                    if (subsetResult != EQUAL) break;
                    return this;
                }
                case NON_STRICT: {
                    if (subsetResult != NON_STRICT && subsetResult != EQUAL) break;
                    return this;
                }
                case STRICT: {
                    if (subsetResult == NONE) break;
                    return this;
                }
                case NONE: {
                    return this;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case " + String.valueOf((Object)this));
                }
            }
            return subsetResult;
        }

        public SubsetResult max(SubsetResult subsetResult) {
            switch (this) {
                case EQUAL: {
                    return this;
                }
                case NON_STRICT: {
                    if (subsetResult == EQUAL) break;
                    return this;
                }
                case STRICT: {
                    if (subsetResult != NONE && subsetResult != STRICT) break;
                    return this;
                }
                case NONE: {
                    if (subsetResult != NONE) break;
                    return this;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case " + String.valueOf((Object)this));
                }
            }
            return subsetResult;
        }
    }
}

