/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicCallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.PredicateTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Objects;

public class TransferringHoareTripleChecker
implements IHoareTripleChecker {
    private final IHoareTripleChecker mUnderlying;
    private final IPredicateUnifier mUnifier;
    private final TransferrerWithVariableCache mTransferrer;
    private final PredicateTransferrer mPredicateTransferrer;

    public TransferringHoareTripleChecker(IHoareTripleChecker iHoareTripleChecker, TransferrerWithVariableCache transferrerWithVariableCache, PredicateTransferrer predicateTransferrer, IPredicateUnifier iPredicateUnifier) {
        this.mUnderlying = Objects.requireNonNull(iHoareTripleChecker);
        this.mTransferrer = Objects.requireNonNull(transferrerWithVariableCache);
        this.mPredicateTransferrer = Objects.requireNonNull(predicateTransferrer);
        this.mUnifier = iPredicateUnifier;
    }

    public void releaseLock() {
        this.mUnderlying.releaseLock();
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        IPredicate iPredicate3 = this.transfer(iPredicate);
        IPredicate iPredicate4 = this.transfer(iPredicate2);
        BasicInternalAction basicInternalAction = new BasicInternalAction(iInternalAction.getPrecedingProcedure(), iInternalAction.getSucceedingProcedure(), this.mTransferrer.transferTransFormula(iInternalAction.getTransformula()));
        return this.mUnderlying.checkInternal(iPredicate3, basicInternalAction, iPredicate4);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        IPredicate iPredicate3 = this.transfer(iPredicate);
        IPredicate iPredicate4 = this.transfer(iPredicate2);
        BasicCallAction basicCallAction = new BasicCallAction(iCallAction.getPrecedingProcedure(), iCallAction.getSucceedingProcedure(), this.mTransferrer.transferTransFormula(iCallAction.getLocalVarsAssignment()));
        return this.mUnderlying.checkCall(iPredicate3, basicCallAction, iPredicate4);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        IPredicate iPredicate4 = this.transfer(iPredicate);
        IPredicate iPredicate5 = this.transfer(iPredicate2);
        IPredicate iPredicate6 = this.transfer(iPredicate3);
        BasicReturnAction basicReturnAction = new BasicReturnAction(iReturnAction.getPrecedingProcedure(), iReturnAction.getSucceedingProcedure(), this.mTransferrer.transferTransFormula(iReturnAction.getAssignmentOfReturn()), this.mTransferrer.transferTransFormula(iReturnAction.getLocalVarsAssignmentOfCall()));
        return this.mUnderlying.checkReturn(iPredicate4, iPredicate5, basicReturnAction, iPredicate6);
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mUnderlying.getStatistics();
    }

    private IPredicate transfer(IPredicate iPredicate) {
        return this.mUnifier.getOrConstructPredicate(this.mPredicateTransferrer.transferPredicate(iPredicate));
    }
}

