/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PDOMProjectIndexLocationConverter
implements IIndexLocationConverter {
    private static final String EXTERNAL = "<EXT>";
    private static final String WS = "<WS>";
    private final IWorkspaceRoot fRoot;
    private final String fFullPathPrefix;
    private final boolean fIgnoreExternal;
    final Map<String, IIndexFileLocation> fromInternalFormatCache = new HashMap<String, IIndexFileLocation>();

    public PDOMProjectIndexLocationConverter(IProject project) {
        this(project, false);
    }

    public PDOMProjectIndexLocationConverter(IProject project, boolean ignoreWSExternal) {
        this.fRoot = (IWorkspaceRoot)project.getParent();
        this.fFullPathPrefix = project.getFullPath().toString() + "/";
        this.fIgnoreExternal = ignoreWSExternal;
    }

    @Override
    public IIndexFileLocation fromInternalFormat(String raw) {
        IIndexFileLocation cachedResult = this.fromInternalFormatCache.get(raw);
        if (cachedResult != null) {
            return cachedResult;
        }
        Object fullPath = null;
        URI uri = null;
        if (raw.startsWith(EXTERNAL)) {
            try {
                uri = new URI(raw.substring(EXTERNAL.length()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            fullPath = raw.startsWith(WS) ? raw.substring(WS.length()) : this.fFullPathPrefix + raw;
            Path path = new Path((String)fullPath);
            if (path.segmentCount() > 1) {
                IFile member = this.fRoot.getFile((IPath)path);
                uri = member.getLocationURI();
            }
        }
        if (uri == null) {
            return null;
        }
        IndexFileLocation location = new IndexFileLocation(uri, (String)fullPath);
        this.fromInternalFormatCache.put(raw, location);
        return location;
    }

    @Override
    public String toInternalFormat(IIndexFileLocation location) {
        String fullPath = location.getFullPath();
        if (fullPath != null) {
            if (fullPath.startsWith(this.fFullPathPrefix)) {
                return fullPath.substring(this.fFullPathPrefix.length());
            }
            return WS + fullPath;
        }
        if (this.fIgnoreExternal) {
            return null;
        }
        return EXTERNAL + location.getURI().toString();
    }
}

