/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetSuccessorProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetRun;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.NumberOfConditions;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.PetriNetUnfolder;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.PetriNetUnfolderBase;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;

public final class FinitePrefix<LETTER, STATE>
extends UnaryNetOperation<LETTER, STATE, IPetriNet2FiniteAutomatonStateFactory<STATE>> {
    private final IPetriNetSuccessorProvider<LETTER, STATE> mOperand;
    private final BranchingProcess<LETTER, STATE> mResult;
    private final PetriNetUnfolderBase.Statistics mUnfoldingStatistics;
    private final PetriNetRun<LETTER, STATE> mAcceptingRun;
    private final PetriNetUnfolder<LETTER, STATE> mUnf;

    public FinitePrefix(AutomataLibraryServices automataLibraryServices, IPetriNetSuccessorProvider<LETTER, STATE> iPetriNetSuccessorProvider) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        this(automataLibraryServices, iPetriNetSuccessorProvider, false);
    }

    public FinitePrefix(AutomataLibraryServices automataLibraryServices, IPetriNetSuccessorProvider<LETTER, STATE> iPetriNetSuccessorProvider, boolean bl) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices);
        this.mOperand = iPetriNetSuccessorProvider;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        PetriNetUnfolder<LETTER, STATE> petriNetUnfolder = new PetriNetUnfolder<LETTER, STATE>(this.mServices, iPetriNetSuccessorProvider, PetriNetUnfolder.EventOrderEnum.ERV, bl, false);
        this.mUnf = petriNetUnfolder;
        this.mAcceptingRun = (PetriNetRun)petriNetUnfolder.getAcceptingRun();
        this.mUnfoldingStatistics = petriNetUnfolder.getUnfoldingStatistics();
        this.mResult = petriNetUnfolder.getFinitePrefix();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Finished " + this.getOperationName());
        stringBuilder.append(" ");
        stringBuilder.append("Result " + this.mResult.sizeInformation() + ".");
        stringBuilder.append(" ");
        stringBuilder.append(this.mUnfoldingStatistics.prettyprintCutOffInformation());
        stringBuilder.append(" ");
        stringBuilder.append(this.mUnfoldingStatistics.prettyprintCoRelationInformation());
        stringBuilder.append(" ");
        stringBuilder.append(this.mUnfoldingStatistics.prettyprintPossibleExtensionsMaximalSize());
        stringBuilder.append(" ");
        stringBuilder.append(this.mUnfoldingStatistics.prettyprintNumberOfEventComparisons());
        stringBuilder.append(" ");
        stringBuilder.append(this.mUnfoldingStatistics.prettyprintPossibleExtensionCandidatesInformation());
        stringBuilder.append(" ");
        stringBuilder.append(this.mUnfoldingStatistics.prettyprintCoRelationMaximalDegree());
        stringBuilder.append(" ");
        stringBuilder.append(this.mUnfoldingStatistics.prettyprintConditionPerPlaceMax());
        stringBuilder.append(" ");
        return stringBuilder.toString();
    }

    @Override
    protected IPetriNetSuccessorProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public BranchingProcess<LETTER, STATE> getResult() {
        return this.mResult;
    }

    public PetriNetRun<LETTER, STATE> getAcceptingRun() {
        return this.mAcceptingRun;
    }

    @Override
    public boolean checkResult(IPetriNet2FiniteAutomatonStateFactory<STATE> iPetriNet2FiniteAutomatonStateFactory) throws AutomataLibraryException {
        return this.mUnf.checkResult(iPetriNet2FiniteAutomatonStateFactory);
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        int n = new NumberOfConditions(this.mServices, this.getResult()).getResult();
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_CONDITIONS, n);
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_CO_RELATION_QUERIES_YES, this.mUnfoldingStatistics.getCoRelationQueriesYes());
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_CO_RELATION_QUERIES_NO, this.mUnfoldingStatistics.getCoRelationQueriesNo());
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_CUT_OFF_EVENTS, this.mUnfoldingStatistics.getCutOffEvents());
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_NON_CUT_OFF_EVENTS, this.mUnfoldingStatistics.getNonCutOffEvents());
        automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_EVENT_COMPARISONS, this.mUnfoldingStatistics.getNumberOfConfigurationComparisons());
        automataOperationStatistics.addKeyValuePair(StatisticsType.FOATA_NORMAL_FORM_COMPARISONS, this.mUnfoldingStatistics.getNumberOfFoataBasedConfigurationComparisons());
        if (this.mOperand instanceof IPetriNet) {
            automataOperationStatistics.addKeyValuePair(StatisticsType.NUMBER_UNREACHABLE_TRANSITIONS, this.mUnfoldingStatistics.unreachableTransitionsInOperand());
        }
        automataOperationStatistics.addKeyValuePair(StatisticsType.POSSIBLE_EXTENSIONS_SIZE_MAX, this.mUnfoldingStatistics.getMaximalSizeOfPossibleExtensions());
        automataOperationStatistics.addKeyValuePair(StatisticsType.EXTENSION_CANDIDATES_TOTAL, this.mUnfoldingStatistics.getNumberOfExtensionCandidates());
        automataOperationStatistics.addKeyValuePair(StatisticsType.EXTENSION_CANDIDATES_USELESS, this.mUnfoldingStatistics.getNumberOfUselessExtensionCandidates());
        automataOperationStatistics.addKeyValuePair(StatisticsType.CO_RELATION_MAX_DEGREE, this.mUnfoldingStatistics.computeCoRelationMaximalDegree());
        automataOperationStatistics.addKeyValuePair(StatisticsType.CONDITION_PER_PLACE_MAX, this.mUnfoldingStatistics.computeConditionPerPlaceMax());
        return automataOperationStatistics;
    }
}

