/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.IInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.PartialOrderMode;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.PartialOrderReductionFacade;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceBuilder;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.List;
import java.util.Set;

public class PartialOrderAbstractionProvider<L extends IIcfgTransition<?>>
implements IInitialAbstractionProvider<L, NestedWordAutomaton<L, IPredicate>> {
    private final IInitialAbstractionProvider<L, ? extends INwaOutgoingLetterAndTransitionProvider<L, IPredicate>> mUnderlying;
    private final IUltimateServiceProvider mServices;
    private final IEmptyStackStateFactory<IPredicate> mStateFactory;
    private final PredicateFactory mPredicateFactory;
    private final PartialOrderMode mPartialOrderMode;
    private final PartialOrderReductionFacade.OrderType mOrderType;
    private final long mDfsOrderSeed;
    private final Statistics mStatistics = new Statistics();

    public PartialOrderAbstractionProvider(IInitialAbstractionProvider<L, ? extends INwaOutgoingLetterAndTransitionProvider<L, IPredicate>> iInitialAbstractionProvider, IUltimateServiceProvider iUltimateServiceProvider, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, PredicateFactory predicateFactory, PartialOrderMode partialOrderMode, PartialOrderReductionFacade.OrderType orderType, long l) {
        this.mUnderlying = iInitialAbstractionProvider;
        this.mServices = iUltimateServiceProvider;
        this.mStateFactory = iEmptyStackStateFactory;
        this.mPredicateFactory = predicateFactory;
        this.mPartialOrderMode = partialOrderMode;
        this.mOrderType = orderType;
        this.mDfsOrderSeed = l;
    }

    @Override
    public <LOC extends IcfgLocation> NestedWordAutomaton<L, IPredicate> getInitialAbstraction(IIcfg<LOC> iIcfg, Set<LOC> set) throws AutomataLibraryException {
        INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider = this.mUnderlying.getInitialAbstraction(iIcfg, set);
        IIndependenceRelation iIndependenceRelation = ((IndependenceBuilder.PredicateActionIndependenceBuilder)((IndependenceBuilder.PredicateActionIndependenceBuilder)((IndependenceBuilder.PredicateActionIndependenceBuilder)IndependenceBuilder.semantic(this.mServices, iIcfg.getCfgSmtToolkit().getManagedScript(), false, false).withSyntacticCheck()).cached()).threadSeparated()).build();
        PartialOrderReductionFacade<L> partialOrderReductionFacade = new PartialOrderReductionFacade<L>(this.mServices, this.mPredicateFactory, iIcfg, set, this.mPartialOrderMode, this.mOrderType, this.mDfsOrderSeed, List.of(iIndependenceRelation), null, null);
        NestedWordAutomaton nestedWordAutomaton = partialOrderReductionFacade.constructReduction(iNwaOutgoingLetterAndTransitionProvider, this.mStateFactory);
        this.mStatistics.reportPORStatistics(partialOrderReductionFacade);
        return nestedWordAutomaton;
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    private class Statistics
    extends AbstractStatisticsDataProvider {
        private static final String POR_STATISTICS = "Partial Order Reduction statistics";
        private static final String UNDERLYING_STATISTICS = "Statistics of underlying abstraction provider";

        public Statistics() {
            this.forward(UNDERLYING_STATISTICS, PartialOrderAbstractionProvider.this.mUnderlying::getStatistics);
        }

        private void reportPORStatistics(PartialOrderReductionFacade<?> partialOrderReductionFacade) {
            StatisticsData statisticsData = new StatisticsData();
            statisticsData.aggregateBenchmarkData(partialOrderReductionFacade.getStatistics());
            this.include(POR_STATISTICS, () -> statisticsData);
        }
    }
}

