/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Collections;
import java.util.Set;

public class PowersetLattice<T>
implements ILattice<Set<T>> {
    private final Set<T> mTop;

    public PowersetLattice(Set<T> set) {
        assert (set != null) : "full set must not be null";
        this.mTop = set;
    }

    public PowersetLattice() {
        this.mTop = null;
    }

    @Override
    public IPartialComparator.ComparisonResult compare(Set<T> set, Set<T> set2) {
        assert (this.mTop == null || this.mTop.containsAll(set) && this.mTop.containsAll(set2)) : "set with unexpected elements";
        if (set.equals(set2)) {
            return IPartialComparator.ComparisonResult.EQUAL;
        }
        if (set2.containsAll(set)) {
            return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
        }
        if (set.containsAll(set2)) {
            return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
        }
        return IPartialComparator.ComparisonResult.INCOMPARABLE;
    }

    @Override
    public Set<T> getBottom() {
        return Collections.emptySet();
    }

    @Override
    public Set<T> getTop() {
        if (this.mTop == null) {
            throw new UnsupportedOperationException("set lattice has no top element unless domain is finite");
        }
        return this.mTop;
    }

    @Override
    public Set<T> supremum(Set<T> set, Set<T> set2) {
        assert (this.mTop == null || this.mTop.containsAll(set) && this.mTop.containsAll(set2)) : "set with unexpected elements";
        return DataStructureUtils.union(set, set2);
    }

    @Override
    public Set<T> infimum(Set<T> set, Set<T> set2) {
        assert (this.mTop == null || this.mTop.containsAll(set) && this.mTop.containsAll(set2)) : "set with unexpected elements";
        return DataStructureUtils.intersection(set, set2);
    }
}

