/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Map;

public class MatchInOutVars
extends TransitionPreprocessor {
    public static final String DESCRIPTION = "Add a corresponding inVars and outVars";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula) throws TermException {
        this.addMissingInVars(managedScript, modifiableTransFormula);
        this.addMissingOutVars(managedScript, modifiableTransFormula);
        return modifiableTransFormula;
    }

    private void addMissingInVars(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula) {
        for (Map.Entry entry : modifiableTransFormula.getOutVars().entrySet()) {
            if (modifiableTransFormula.getInVars().containsKey(entry.getKey())) continue;
            String string = SmtUtils.removeSmtQuoteCharacters((String)((IProgramVar)entry.getKey()).getGloballyUniqueId());
            TermVariable termVariable = managedScript.constructFreshTermVariable(string, ((TermVariable)entry.getValue()).getSort());
            modifiableTransFormula.addInVar((IProgramVar)entry.getKey(), termVariable);
        }
    }

    private void addMissingOutVars(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula) {
        for (Map.Entry entry : modifiableTransFormula.getInVars().entrySet()) {
            if (modifiableTransFormula.getOutVars().containsKey(entry.getKey())) continue;
            String string = SmtUtils.removeSmtQuoteCharacters((String)((IProgramVar)entry.getKey()).getGloballyUniqueId());
            TermVariable termVariable = managedScript.constructFreshTermVariable(string, ((TermVariable)entry.getValue()).getSort());
            modifiableTransFormula.addOutVar((IProgramVar)entry.getKey(), termVariable);
        }
    }

    private static boolean eachInVarHasOutVar(ModifiableTransFormula modifiableTransFormula) {
        for (Map.Entry entry : modifiableTransFormula.getInVars().entrySet()) {
            if (modifiableTransFormula.getOutVars().containsKey(entry.getKey())) continue;
            assert (false) : "no outVar for inVar " + String.valueOf(entry.getKey());
            return false;
        }
        return true;
    }
}

