/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.DebuggingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.AbsIntPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AbsIntHoareTripleChecker<STATE extends IAbstractState<STATE>, ACTION extends IIcfgTransition<?>>
implements IHoareTripleChecker {
    private static final int MAX_DISJUNCTS = 1;
    private static final boolean ACCEPT_REJECTION_DUE_TO_IMPRECISION = true;
    private static final boolean REDUCE_STATES = true;
    private static final String MSG_BOTTOM_WAS_LOST = "Bottom was lost";
    private static final String MSG_IS_SUBSET_OF_IS_UNSOUND = "isSubsetOf is unsound";
    private static final String MSG_TRACKED_VARIABLES_DIFFER = "Tracked variables differ";
    private static final String MSG_INVALID_HOARE_TRIPLE_CHECK = "Invalid AbsInt hoare triple check";
    private final ILogger mLogger;
    private final IAbstractPostOperator<STATE, ACTION> mPostOp;
    private final IAbstractDomain<STATE, ACTION> mDomain;
    private final IPredicateUnifier mPredicateUnifier;
    private final HoareTripleCheckerStatisticsGenerator mBenchmark;
    private final IPredicate mTruePred;
    private final IPredicate mFalsePred;
    private final DisjunctiveAbstractState<STATE> mTopState;
    private final DisjunctiveAbstractState<STATE> mBottomState;
    private final IVariableProvider<STATE, ACTION> mVarProvider;
    private final IncrementalHoareTripleChecker mHtcSmt;
    private final IUltimateServiceProvider mServices;
    private final CfgSmtToolkit mCsToolkit;
    private final ManagedScript mManagedScript;
    private final IHoareTripleChecker mHtcSd;
    private final boolean mOnlyAbsInt;
    private final boolean mUseHierachicalPre;

    public AbsIntHoareTripleChecker(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, IAbstractDomain<STATE, ACTION> iAbstractDomain, IVariableProvider<STATE, ACTION> iVariableProvider, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mDomain = Objects.requireNonNull(iAbstractDomain);
        this.mUseHierachicalPre = this.mDomain.useHierachicalPre();
        this.mPostOp = Objects.requireNonNull(this.mDomain.getPostOperator());
        this.mPredicateUnifier = Objects.requireNonNull(iPredicateUnifier);
        this.mVarProvider = Objects.requireNonNull(iVariableProvider.createNewVariableProvider(cfgSmtToolkit));
        this.mCsToolkit = Objects.requireNonNull(cfgSmtToolkit);
        this.mManagedScript = Objects.requireNonNull(this.mCsToolkit.getManagedScript());
        this.mBenchmark = new HoareTripleCheckerStatisticsGenerator();
        this.mTruePred = this.mPredicateUnifier.getTruePredicate();
        this.mFalsePred = this.mPredicateUnifier.getFalsePredicate();
        this.mTopState = new DisjunctiveAbstractState(1, this.mDomain.createTopState());
        this.mBottomState = new DisjunctiveAbstractState(1, this.mDomain.createBottomState());
        this.mHtcSmt = new IncrementalHoareTripleChecker(this.mCsToolkit, false);
        this.mHtcSd = HoareTripleCheckerUtils.constructSdHoareTripleChecker((ILogger)this.mLogger, (CfgSmtToolkit)this.mCsToolkit, (IPredicateUnifier)this.mPredicateUnifier);
        this.mOnlyAbsInt = bl;
    }

    public void releaseLock() {
    }

    public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        if (this.mOnlyAbsInt) {
            return this.checkInternalAbsInt(iPredicate, iInternalAction, iPredicate2);
        }
        IncrementalPlicationChecker.Validity validity = this.mHtcSd.checkInternal(iPredicate, iInternalAction, iPredicate2);
        if (AbsIntHoareTripleChecker.isFinalResult(validity)) {
            return validity;
        }
        IncrementalPlicationChecker.Validity validity2 = this.checkInternalAbsInt(iPredicate, iInternalAction, iPredicate2);
        if (validity2 == IncrementalPlicationChecker.Validity.VALID) {
            return validity2;
        }
        IncrementalPlicationChecker.Validity validity3 = this.mHtcSmt.checkInternal(iPredicate, iInternalAction, iPredicate2);
        this.mHtcSmt.releaseLock();
        return validity3;
    }

    public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        if (this.mOnlyAbsInt) {
            return this.checkCallAbsInt(iPredicate, iCallAction, iPredicate2);
        }
        IncrementalPlicationChecker.Validity validity = this.mHtcSd.checkCall(iPredicate, iCallAction, iPredicate2);
        this.mHtcSd.releaseLock();
        if (AbsIntHoareTripleChecker.isFinalResult(validity)) {
            return validity;
        }
        IncrementalPlicationChecker.Validity validity2 = this.checkCallAbsInt(iPredicate, iCallAction, iPredicate2);
        if (validity2 == IncrementalPlicationChecker.Validity.VALID) {
            return validity2;
        }
        IncrementalPlicationChecker.Validity validity3 = this.mHtcSmt.checkCall(iPredicate, iCallAction, iPredicate2);
        this.mHtcSmt.releaseLock();
        return validity3;
    }

    public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        if (this.mOnlyAbsInt) {
            return this.checkReturnAbsInt(iPredicate, iPredicate2, iReturnAction, iPredicate3);
        }
        IncrementalPlicationChecker.Validity validity = this.mHtcSd.checkReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
        if (AbsIntHoareTripleChecker.isFinalResult(validity)) {
            return validity;
        }
        IncrementalPlicationChecker.Validity validity2 = this.checkReturnAbsInt(iPredicate, iPredicate2, iReturnAction, iPredicate3);
        if (validity2 == IncrementalPlicationChecker.Validity.VALID) {
            return validity2;
        }
        IncrementalPlicationChecker.Validity validity3 = this.mHtcSmt.checkReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
        this.mHtcSmt.releaseLock();
        return validity3;
    }

    private static boolean isFinalResult(IncrementalPlicationChecker.Validity validity) {
        return validity != IncrementalPlicationChecker.Validity.UNKNOWN && validity != IncrementalPlicationChecker.Validity.NOT_CHECKED;
    }

    private IncrementalPlicationChecker.Validity checkInternalAbsInt(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        this.mBenchmark.continueEdgeCheckerTime();
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState = this.getState(iPredicate);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = this.getState(iPredicate2);
        ACTION ACTION = this.getAction((IAction)iInternalAction);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState3 = this.createValidPostOpStateAfterLeaving(ACTION, disjunctiveAbstractState, null);
        DisjunctiveAbstractState disjunctiveAbstractState4 = disjunctiveAbstractState2.compact();
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState5 = this.reducePreState(disjunctiveAbstractState3, disjunctiveAbstractState4, ACTION);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Pre : " + disjunctiveAbstractState5.toLogString()));
            this.mLogger.debug((Object)("Act : " + String.valueOf(ACTION)));
            this.mLogger.debug((Object)("Post: " + disjunctiveAbstractState4.toLogString()));
        }
        IncrementalPlicationChecker.Validity validity = this.checkInternalTransitionWithValidState(disjunctiveAbstractState5, ACTION, disjunctiveAbstractState4);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)AbsIntHoareTripleChecker.getMsgResult(validity));
        }
        assert (this.assertValidity(disjunctiveAbstractState3, null, ACTION, disjunctiveAbstractState2, validity)) : "Invalid AbsInt hoare triple check";
        this.mLogger.debug((Object)"--");
        IncrementalPlicationChecker.Validity validity2 = validity;
        this.mBenchmark.stopEdgeCheckerTime();
        return validity2;
    }

    private static String getMsgResult(IncrementalPlicationChecker.Validity validity) {
        return "Result: " + String.valueOf(validity);
    }

    private Set<IProgramVarOrConst> getVars(ACTION ACTION) {
        return this.mVarProvider.getRequiredVars(ACTION);
    }

    private IncrementalPlicationChecker.Validity checkCallAbsInt(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        this.mBenchmark.continueEdgeCheckerTime();
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState = this.getState(iPredicate);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = this.getState(iPredicate2);
        ACTION ACTION = this.getAction((IAction)iCallAction);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState3 = this.createValidPostOpStateBeforeLeaving(ACTION, disjunctiveAbstractState);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState4 = this.createValidPostOpStateAfterLeaving(ACTION, disjunctiveAbstractState, null);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState5 = this.reducePreState(disjunctiveAbstractState3, disjunctiveAbstractState2, ACTION);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState6 = this.reducePreState(disjunctiveAbstractState4, disjunctiveAbstractState2, ACTION);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("PSBL: " + disjunctiveAbstractState5.toLogString()));
            this.mLogger.debug((Object)("PSAL: " + disjunctiveAbstractState6.toLogString()));
            this.mLogger.debug((Object)("Act : " + String.valueOf(ACTION)));
            this.mLogger.debug((Object)("Post: " + disjunctiveAbstractState2.toLogString()));
        }
        IncrementalPlicationChecker.Validity validity = this.checkScopeChangingTransitionWithValidState(disjunctiveAbstractState5, disjunctiveAbstractState6, ACTION, disjunctiveAbstractState2);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)AbsIntHoareTripleChecker.getMsgResult(validity));
        }
        assert (this.assertValidity(disjunctiveAbstractState3, null, ACTION, disjunctiveAbstractState2, validity)) : "Invalid AbsInt hoare triple check";
        this.mLogger.debug((Object)"--");
        this.mBenchmark.stopEdgeCheckerTime();
        return validity;
    }

    private IncrementalPlicationChecker.Validity checkReturnAbsInt(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        this.mBenchmark.continueEdgeCheckerTime();
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState = this.getState(iPredicate);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = this.getState(iPredicate2);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState3 = this.getState(iPredicate3);
        ACTION ACTION = this.getAction((IAction)iReturnAction);
        ACTION ACTION2 = this.getCorrespondingCall(ACTION);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState4 = this.createValidPostOpStateBeforeLeaving(ACTION, disjunctiveAbstractState);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState5 = this.createValidPostOpStateBeforeLeaving(ACTION2, disjunctiveAbstractState2);
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState6 = this.mUseHierachicalPre ? this.createValidPostOpStateHierachicalPre(disjunctiveAbstractState4, disjunctiveAbstractState5) : this.createValidPostOpStateAfterLeaving(ACTION, disjunctiveAbstractState4, disjunctiveAbstractState5);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("PreBL: " + disjunctiveAbstractState4.toLogString()));
            this.mLogger.debug((Object)("PreH : " + disjunctiveAbstractState5.toLogString()));
            this.mLogger.debug((Object)("PreAL: " + disjunctiveAbstractState6.toLogString()));
            this.mLogger.debug((Object)("Act  : (" + ACTION.getPrecedingProcedure() + ") " + String.valueOf(ACTION) + " (" + ACTION.getSucceedingProcedure() + ")"));
            this.mLogger.debug((Object)("Post : " + disjunctiveAbstractState3.toLogString()));
        }
        IncrementalPlicationChecker.Validity validity = this.checkScopeChangingTransitionWithValidState(disjunctiveAbstractState4, disjunctiveAbstractState6, ACTION, disjunctiveAbstractState3);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)AbsIntHoareTripleChecker.getMsgResult(validity));
        }
        assert (this.assertValidity(disjunctiveAbstractState4, disjunctiveAbstractState6, ACTION, disjunctiveAbstractState3, validity)) : "Invalid AbsInt hoare triple check";
        this.mLogger.debug((Object)"--");
        IncrementalPlicationChecker.Validity validity2 = validity;
        this.mBenchmark.stopEdgeCheckerTime();
        return validity2;
    }

    private ACTION getCorrespondingCall(ACTION ACTION) {
        assert (ACTION instanceof IIcfgReturnTransition);
        IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)ACTION;
        return (ACTION)iIcfgReturnTransition.getCorrespondingCall();
    }

    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        return this.mBenchmark;
    }

    private IncrementalPlicationChecker.Validity checkInternalTransitionWithValidState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        if (disjunctiveAbstractState.isBottom()) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        DisjunctiveAbstractState disjunctiveAbstractState3 = disjunctiveAbstractState.apply(this.mPostOp, ACTION);
        return this.comparePostAndCalculatedPost(ACTION, disjunctiveAbstractState2, disjunctiveAbstractState3);
    }

    private IncrementalPlicationChecker.Validity checkScopeChangingTransitionWithValidState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState3) {
        if (disjunctiveAbstractState.isBottom()) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        if (disjunctiveAbstractState2.isBottom()) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        DisjunctiveAbstractState disjunctiveAbstractState4 = disjunctiveAbstractState2.apply(this.mPostOp, disjunctiveAbstractState, ACTION);
        return this.comparePostAndCalculatedPost(ACTION, disjunctiveAbstractState3, disjunctiveAbstractState4);
    }

    private IncrementalPlicationChecker.Validity comparePostAndCalculatedPost(ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Calculated post: " + disjunctiveAbstractState2.toLogString()));
        }
        if (disjunctiveAbstractState2.isBottom() && disjunctiveAbstractState.isBottom()) {
            return this.trackPost(IncrementalPlicationChecker.Validity.VALID, ACTION);
        }
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState3 = this.synchronizeState(disjunctiveAbstractState, disjunctiveAbstractState2);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Synchronized calculated post: " + disjunctiveAbstractState2.toLogString()));
        }
        assert (disjunctiveAbstractState3.isBottom() || disjunctiveAbstractState.getVariables().equals((Object)disjunctiveAbstractState3.getVariables())) : "Tracked variables differ";
        IAbstractState.SubsetResult subsetResult = disjunctiveAbstractState3.isSubsetOf(disjunctiveAbstractState);
        assert (this.assertIsSubsetOf(disjunctiveAbstractState3, disjunctiveAbstractState, subsetResult)) : "isSubsetOf is unsound";
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Inclusion (NO): " + String.valueOf(subsetResult)));
        }
        if (subsetResult != IAbstractState.SubsetResult.NONE) {
            return this.trackPost(IncrementalPlicationChecker.Validity.VALID, ACTION);
        }
        IAbstractState.SubsetResult subsetResult2 = disjunctiveAbstractState.isSubsetOf(disjunctiveAbstractState3);
        assert (this.assertIsSubsetOf(disjunctiveAbstractState, disjunctiveAbstractState3, subsetResult2)) : "isSubsetOf is unsound";
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Exclusion (ON): " + String.valueOf(subsetResult2)));
        }
        if (subsetResult2 == IAbstractState.SubsetResult.NONE) {
            assert (!disjunctiveAbstractState3.isBottom()) : "Nothing is a subset of bottom";
            return this.trackPost(IncrementalPlicationChecker.Validity.INVALID, ACTION);
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    private IncrementalPlicationChecker.Validity trackPost(IncrementalPlicationChecker.Validity validity, ACTION ACTION) {
        if (ACTION instanceof ICallAction) {
            return this.trackPost(validity, InCaReCounter::incCa);
        }
        if (ACTION instanceof IReturnAction) {
            return this.trackPost(validity, InCaReCounter::incRe);
        }
        return this.trackPost(validity, InCaReCounter::incIn);
    }

    private IncrementalPlicationChecker.Validity trackPost(IncrementalPlicationChecker.Validity validity, Consumer<InCaReCounter> consumer) {
        if (validity == IncrementalPlicationChecker.Validity.UNKNOWN) {
            consumer.accept(this.mBenchmark.getSolverCounterUnknown());
        } else if (validity == IncrementalPlicationChecker.Validity.VALID) {
            consumer.accept(this.mBenchmark.getSolverCounterUnsat());
        } else if (validity == IncrementalPlicationChecker.Validity.INVALID) {
            consumer.accept(this.mBenchmark.getSolverCounterSat());
        }
        return validity;
    }

    private DisjunctiveAbstractState<STATE> getState(IPredicate iPredicate) {
        if (iPredicate instanceof AbsIntPredicate) {
            Set set = ((AbsIntPredicate)iPredicate).getAbstractStates();
            if (set.size() <= 1) {
                return DisjunctiveAbstractState.createDisjunction((Collection)set);
            }
            HashSet hashSet = new HashSet();
            set.stream().forEach(iAbstractState -> {
                boolean bl = hashSet.addAll(iAbstractState.getVariables());
            });
            Set set2 = set.stream().map(iAbstractState -> AbsIntUtil.synchronizeVariables((IAbstractState)iAbstractState, (Set)hashSet)).collect(Collectors.toSet());
            return DisjunctiveAbstractState.createDisjunction(set2);
        }
        if (iPredicate.equals(this.mTruePred)) {
            return this.mTopState;
        }
        if (iPredicate.equals(this.mFalsePred)) {
            return this.mBottomState;
        }
        throw new UnsupportedOperationException("Cannot handle non-absint predicates: " + iPredicate.hashCode() + " (" + String.valueOf(iPredicate.getClass()) + ")");
    }

    private ACTION getAction(IAction iAction) {
        return (ACTION)((IIcfgTransition)iAction);
    }

    private DisjunctiveAbstractState<STATE> synchronizeState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        DisjunctiveAbstractState disjunctiveAbstractState3 = this.unifyBottom(disjunctiveAbstractState2);
        if (disjunctiveAbstractState3 == this.mBottomState) {
            return disjunctiveAbstractState3;
        }
        DisjunctiveAbstractState disjunctiveAbstractState4 = (DisjunctiveAbstractState)AbsIntUtil.synchronizeVariables(disjunctiveAbstractState, disjunctiveAbstractState3);
        assert (this.assertBottomRetained(disjunctiveAbstractState3, null, disjunctiveAbstractState4, () -> {
            IAbstractState iAbstractState = AbsIntUtil.synchronizeVariables((IAbstractState)disjunctiveAbstractState, (IAbstractState)disjunctiveAbstractState3);
        })) : "Bottom was lost";
        return disjunctiveAbstractState4;
    }

    private DisjunctiveAbstractState<STATE> createValidPostOpStateAfterLeaving(ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState3 = this.unifyBottom(disjunctiveAbstractState);
        if (disjunctiveAbstractState3 == this.mBottomState) {
            return disjunctiveAbstractState3;
        }
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState4 = disjunctiveAbstractState2 == null ? null : this.unifyBottom(disjunctiveAbstractState2);
        DisjunctiveAbstractState disjunctiveAbstractState5 = disjunctiveAbstractState3.createValidPostOpStateAfterLeaving(this.mVarProvider, ACTION, disjunctiveAbstractState4);
        assert (this.assertBottomRetained(disjunctiveAbstractState, disjunctiveAbstractState2, disjunctiveAbstractState5, () -> {
            DisjunctiveAbstractState disjunctiveAbstractState3 = disjunctiveAbstractState3.createValidPostOpStateAfterLeaving(this.mVarProvider, (Object)ACTION, disjunctiveAbstractState4);
        })) : "Bottom was lost";
        return disjunctiveAbstractState5;
    }

    private DisjunctiveAbstractState<STATE> createValidPostOpStateHierachicalPre(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState3 = this.unifyBottom(disjunctiveAbstractState);
        if (disjunctiveAbstractState3 == this.mBottomState) {
            return disjunctiveAbstractState3;
        }
        return this.unifyBottom(disjunctiveAbstractState2);
    }

    private DisjunctiveAbstractState<STATE> reducePreState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, ACTION ACTION) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>(this.getVars(ACTION));
        hashSet.addAll((Collection<IProgramVarOrConst>)disjunctiveAbstractState2.getVariables());
        hashSet.addAll(AbsIntHoareTripleChecker.getMissingOldVars(hashSet));
        ImmutableSet immutableSet = disjunctiveAbstractState.getVariables();
        Set set = DataStructureUtils.difference((Set)immutableSet, hashSet);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)String.format("Removing %s of %s vars", set.size(), immutableSet.size()));
            this.mLogger.debug((Object)String.format("Removing %s", set));
        }
        return disjunctiveAbstractState.removeVariables((Collection)set);
    }

    private static Set<IProgramVarOrConst> getMissingOldVars(Set<IProgramVarOrConst> set) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        for (IProgramVarOrConst iProgramVarOrConst : set) {
            if (!iProgramVarOrConst.isGlobal()) continue;
            if (iProgramVarOrConst instanceof IProgramNonOldVar) {
                hashSet.add((IProgramVarOrConst)((IProgramNonOldVar)iProgramVarOrConst).getOldVar());
                continue;
            }
            if (!(iProgramVarOrConst instanceof IProgramOldVar)) continue;
            hashSet.add((IProgramVarOrConst)((IProgramOldVar)iProgramVarOrConst).getNonOldVar());
        }
        return hashSet;
    }

    private DisjunctiveAbstractState<STATE> createValidPostOpStateBeforeLeaving(ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = this.unifyBottom(disjunctiveAbstractState);
        if (disjunctiveAbstractState2 == this.mBottomState) {
            return disjunctiveAbstractState2;
        }
        DisjunctiveAbstractState disjunctiveAbstractState3 = disjunctiveAbstractState2.createValidPostOpStateBeforeLeaving(this.mVarProvider, ACTION);
        assert (this.assertBottomRetained(disjunctiveAbstractState, null, disjunctiveAbstractState3, () -> {
            DisjunctiveAbstractState disjunctiveAbstractState2 = disjunctiveAbstractState2.createValidPostOpStateBeforeLeaving(this.mVarProvider, (Object)ACTION);
        })) : "Bottom was lost";
        return disjunctiveAbstractState3;
    }

    private DisjunctiveAbstractState<STATE> unifyBottom(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        if (disjunctiveAbstractState.isBottom()) {
            return this.mBottomState;
        }
        return disjunctiveAbstractState;
    }

    private IPredicate createPredicateFromState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return this.mPredicateUnifier.getPredicateFactory().newPredicate(disjunctiveAbstractState.getTerm(this.mManagedScript.getScript()));
    }

    private boolean assertBottomRetained(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, DisjunctiveAbstractState<STATE> disjunctiveAbstractState3, IFunPointer iFunPointer) {
        boolean bl;
        boolean bl2 = bl = !disjunctiveAbstractState.isBottom() && (disjunctiveAbstractState2 == null || !disjunctiveAbstractState2.isBottom()) || disjunctiveAbstractState3.isBottom();
        if (!bl) {
            iFunPointer.run();
        }
        return bl;
    }

    private boolean assertValidity(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState3, IncrementalPlicationChecker.Validity validity) {
        IPredicate iPredicate = this.createPredicateFromState(disjunctiveAbstractState);
        IPredicate iPredicate2 = this.createPredicateFromState(disjunctiveAbstractState3);
        IPredicate iPredicate3 = disjunctiveAbstractState2 == null ? null : this.createPredicateFromState(disjunctiveAbstractState2);
        this.mHtcSmt.releaseLock();
        DebuggingHoareTripleChecker debuggingHoareTripleChecker = new DebuggingHoareTripleChecker(this.mServices, this.mLogger, this.mCsToolkit, validity);
        IncrementalPlicationChecker.Validity validity2 = ACTION instanceof ICallAction ? debuggingHoareTripleChecker.checkCall(iPredicate, (ICallAction)ACTION, iPredicate2) : (ACTION instanceof IReturnAction ? debuggingHoareTripleChecker.checkReturn(iPredicate, iPredicate3, (IReturnAction)ACTION, iPredicate2) : debuggingHoareTripleChecker.checkInternal(iPredicate, (IInternalAction)ACTION, iPredicate2));
        debuggingHoareTripleChecker.releaseLock();
        if (debuggingHoareTripleChecker.isLastOk()) {
            this.mLogger.debug((Object)"HTC assert ok");
            return true;
        }
        if (validity == IncrementalPlicationChecker.Validity.INVALID && validity2 == IncrementalPlicationChecker.Validity.VALID) {
            this.mLogger.warn((Object)("Rejecting Hoare triple although it is actually valid (Domain " + this.mDomain.domainDescription() + ")"));
            return true;
        }
        Consumer<Object> consumer = validity == IncrementalPlicationChecker.Validity.UNKNOWN ? arg_0 -> ((ILogger)this.mLogger).warn(arg_0) : arg_0 -> ((ILogger)this.mLogger).fatal(arg_0);
        consumer.accept("--");
        consumer.accept("Abstract states");
        if (iPredicate3 == null) {
            consumer.accept("PreS: {" + String.valueOf(disjunctiveAbstractState) + "}");
        } else {
            consumer.accept(AbsIntHoareTripleChecker.getMsgPreBefore(disjunctiveAbstractState));
            consumer.accept(AbsIntHoareTripleChecker.getMsgPreAfter(disjunctiveAbstractState2));
        }
        consumer.accept(String.valueOf(ACTION.getTransformula().getClosedFormula()) + " (" + String.valueOf(ACTION) + ")");
        consumer.accept(AbsIntHoareTripleChecker.getMsgPost(disjunctiveAbstractState3));
        consumer.accept("--");
        return validity == IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    private static String getMsgPreBefore(Object object) {
        return "PreBefore: {" + String.valueOf(object) + "}";
    }

    private static String getMsgPreAfter(Object object) {
        return "PreAfter: {" + String.valueOf(object) + "}";
    }

    private static String getMsgPost(Object object) {
        return "Post: {" + String.valueOf(object) + "}";
    }

    private boolean assertIsSubsetOf(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, IAbstractState.SubsetResult subsetResult) {
        Term term;
        Script.LBool lBool;
        Term term2;
        Script script = this.mManagedScript.getScript();
        this.mHtcSmt.releaseLock();
        script.echo(new QuotedObject("Start isSubsetOf assertion"));
        Term term3 = disjunctiveAbstractState.getTerm(script);
        Term term4 = disjunctiveAbstractState2.getTerm(script);
        if (subsetResult == IAbstractState.SubsetResult.EQUAL) {
            term2 = script.term("distinct", new Term[]{term3, term4});
            lBool = Script.LBool.UNSAT;
        } else {
            term = script.term("=>", new Term[]{term3, term4});
            term2 = term.getFreeVars().length > 0 ? script.quantifier(1, term.getFreeVars(), term, (Term[][])new Term[0][]) : term;
            lBool = subsetResult == IAbstractState.SubsetResult.NONE ? Script.LBool.UNSAT : Script.LBool.SAT;
        }
        Script.LBool lBool2 = SmtUtils.checkSatTerm((Script)script, (Term)term2);
        if (lBool2 == Script.LBool.UNKNOWN || lBool2 == lBool) {
            script.echo(AbsIntHoareTripleChecker.buildQuoteEndIsSubsetOf());
            return true;
        }
        if (subsetResult == IAbstractState.SubsetResult.NONE) {
            script.echo(AbsIntHoareTripleChecker.buildQuoteEndIsSubsetOf());
            return true;
        }
        term = SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)term3, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        Term term5 = SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)term4, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        Term term6 = SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)term2, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        this.mLogger.fatal((Object)"isSubsetOf assertion failed");
        this.mLogger.fatal((Object)("Checking left isSubsetOrEqual right = " + String.valueOf(subsetResult)));
        this.mLogger.fatal((Object)("leftState  : " + disjunctiveAbstractState.toLogString()));
        this.mLogger.fatal((Object)("rightState : " + disjunctiveAbstractState2.toLogString()));
        this.mLogger.fatal((Object)("left       : " + term3.toStringDirect()));
        this.mLogger.fatal((Object)("right      : " + term4.toStringDirect()));
        this.mLogger.fatal((Object)("leftSim    : " + term.toStringDirect()));
        this.mLogger.fatal((Object)("rightSim   : " + term5.toStringDirect()));
        this.mLogger.fatal((Object)("checking   : " + term2.toStringDirect()));
        this.mLogger.fatal((Object)("checkingSim: " + term6.toStringDirect()));
        this.mLogger.fatal((Object)("Result is " + String.valueOf(lBool2) + " and should be " + String.valueOf(lBool)));
        this.mLogger.fatal((Object)("Solver was " + String.valueOf(script.getInfo(":name")) + " in version " + String.valueOf(script.getInfo(":version"))));
        IAbstractState.SubsetResult subsetResult2 = disjunctiveAbstractState.isSubsetOf(disjunctiveAbstractState2);
        this.mLogger.fatal((Object)subsetResult2);
        script.echo(AbsIntHoareTripleChecker.buildQuoteEndIsSubsetOf());
        return false;
    }

    private static QuotedObject buildQuoteEndIsSubsetOf() {
        return new QuotedObject("End isSubsetOf assertion");
    }

    @FunctionalInterface
    private static interface IFunPointer {
        public void run();
    }
}

