/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IndexedStatement;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefBaseAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVar;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

class DefCollector
extends RCFGEdgeVisitor {
    private HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> mDefs;
    private final IAnnotationProvider<ReachDefStatementAnnotation> mAnnotationProvider;
    private final String mKey;

    DefCollector(IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider, String string) {
        this.mAnnotationProvider = iAnnotationProvider;
        this.mKey = string;
    }

    HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> collect(IcfgEdge icfgEdge) {
        if (this.mDefs == null) {
            this.mDefs = new HashMap();
            this.visit(icfgEdge);
        }
        return this.mDefs;
    }

    protected void visit(SequentialComposition sequentialComposition) {
        List list = sequentialComposition.getCodeBlocks();
        if (list == null || list.isEmpty()) {
            return;
        }
        super.visit((CodeBlock)list.get(list.size() - 1));
    }

    protected void visit(StatementSequence statementSequence) {
        super.visit(statementSequence);
        List list = statementSequence.getStatements();
        if (list == null || list.isEmpty()) {
            return;
        }
        ReachDefBaseAnnotation reachDefBaseAnnotation = this.getAnnotation(list);
        if (reachDefBaseAnnotation != null) {
            this.mDefs = reachDefBaseAnnotation.getDefs();
        }
    }

    private ReachDefBaseAnnotation getAnnotation(List<Statement> list) {
        if (this.mKey == null) {
            return this.mAnnotationProvider.getAnnotation((IElement)list.get(list.size() - 1));
        }
        return this.mAnnotationProvider.getAnnotation((IElement)list.get(list.size() - 1), this.mKey);
    }
}

