/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public class RandomDfsOrder<L, S>
implements IDfsOrder<L, S> {
    private final long mSeed;
    private final boolean mPositional;
    private final Function<S, Object> mNormalizer;

    public RandomDfsOrder(long l, boolean bl) {
        this(l, bl, null);
    }

    public RandomDfsOrder(long l, boolean bl, Function<S, Object> function) {
        this.mSeed = l;
        this.mPositional = bl;
        this.mNormalizer = function;
        assert (bl || function == null) : "Normalization for non-positional order does not make sense";
    }

    public Comparator<L> getOrder(S s) {
        long l = this.mPositional && s != null ? this.mSeed * (long)Objects.hashCode(this.normalize(s)) : this.mSeed;
        return new RandomComparator(l);
    }

    private Object normalize(S s) {
        if (this.mNormalizer == null) {
            return s;
        }
        return this.mNormalizer.apply(s);
    }

    public boolean isPositional() {
        return this.mPositional;
    }

    private static final class RandomComparator<L>
    implements Comparator<L> {
        private final long mSeed;

        public RandomComparator(long l) {
            this.mSeed = l;
        }

        @Override
        public int compare(L l, L l2) {
            if (l == l2) {
                return 0;
            }
            return Integer.compare(this.getRepresentative(l), this.getRepresentative(l2));
        }

        private int getRepresentative(L l) {
            return new Random(this.mSeed * (long)Objects.hashCode(l)).nextInt();
        }

        public int hashCode() {
            return Long.hashCode(this.mSeed);
        }

        @Override
        public boolean equals(Object object) {
            block2: {
                block3: {
                    if (this == object) break block2;
                    if (!(object instanceof RandomComparator)) break block3;
                    RandomComparator randomComparator = (RandomComparator)object;
                    if (this.mSeed == randomComparator.mSeed) break block2;
                }
                return false;
            }
            return true;
        }
    }
}

