/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.DnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryOperationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryStateFactoryAndPredicateHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryTransitionRelationProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SMTTheoryPostOperator
implements IAbstractPostOperator<SMTTheoryState, IcfgEdge> {
    private final SMTTheoryTransitionRelationProvider mTransitionRelationProvider;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredicateTransformer;
    private final SMTTheoryStateFactoryAndPredicateHelper mStateFactory;
    private final SMTTheoryOperationProvider mArrayTheoryOperationProvider;
    private final CfgSmtToolkit mCsToolkit;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;

    public SMTTheoryPostOperator(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit) {
        this.mServices = iUltimateServiceProvider;
        this.mCsToolkit = cfgSmtToolkit;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass());
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mArrayTheoryOperationProvider = new SMTTheoryOperationProvider(iUltimateServiceProvider, cfgSmtToolkit);
        this.mPredicateTransformer = new PredicateTransformer(cfgSmtToolkit.getManagedScript(), (IDomainSpecificOperationProvider)this.mArrayTheoryOperationProvider);
        this.mTransitionRelationProvider = new SMTTheoryTransitionRelationProvider(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript());
        this.mStateFactory = new SMTTheoryStateFactoryAndPredicateHelper(iUltimateServiceProvider, cfgSmtToolkit, this.mArrayTheoryOperationProvider);
    }

    public List<SMTTheoryState> apply(SMTTheoryState sMTTheoryState, IcfgEdge icfgEdge) {
        Set<TransFormula> set = this.mTransitionRelationProvider.getTransitionRelationDNF(icfgEdge);
        ArrayList<SMTTheoryState> arrayList = new ArrayList<SMTTheoryState>();
        for (TransFormula transFormula : set) {
            Term term2 = (Term)this.mPredicateTransformer.strongestPostcondition((IAbstractPredicate)sMTTheoryState.getPredicate(), (ITransitionRelation)transFormula);
            List<Term> list = this.postProcessStrongestPost(term2);
            arrayList.addAll(list.stream().map(term -> this.mStateFactory.getOrConstructState((Term)term, sMTTheoryState.getVariables())).collect(Collectors.toList()));
        }
        return arrayList;
    }

    private List<Term> postProcessStrongestPost(Term term) {
        Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mCsToolkit.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_QUICK, (Term)term);
        List<Term> list = Arrays.asList(SmtUtils.getDisjuncts((Term)new DnfTransformer(this.mMgdScript, this.mServices).transform(term2)));
        return list;
    }

    private Term dropQuantifiedConjuncts(Term term2) {
        List list = Arrays.stream(SmtUtils.getConjuncts((Term)term2)).filter(term -> !(term instanceof QuantifiedFormula)).collect(Collectors.toList());
        Term term3 = SmtUtils.and((Script)this.mCsToolkit.getManagedScript().getScript(), list);
        return term3;
    }

    public List<SMTTheoryState> apply(SMTTheoryState sMTTheoryState, SMTTheoryState sMTTheoryState2, IcfgEdge icfgEdge) {
        assert (sMTTheoryState2.getVariables().containsAll((Collection)this.mCsToolkit.getSymbolTable().getGlobals()));
        assert (sMTTheoryState2.getVariables().containsAll((Collection)this.mCsToolkit.getSymbolTable().getLocals(icfgEdge.getSucceedingProcedure())));
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            return Collections.singletonList(this.mStateFactory.getTopState());
        }
        if (icfgEdge instanceof ICallAction) {
            String string = icfgEdge.getSucceedingProcedure();
            UnmodifiableTransFormula unmodifiableTransFormula = ((ICallAction)icfgEdge).getLocalVarsAssignment();
            UnmodifiableTransFormula unmodifiableTransFormula2 = this.mCsToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(string);
            UnmodifiableTransFormula unmodifiableTransFormula3 = this.mCsToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(string);
            Set set = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(string);
            Term term = (Term)this.mPredicateTransformer.strongestPostconditionCall((IAbstractPredicate)sMTTheoryState.getPredicate(), (ITransitionRelation)unmodifiableTransFormula, (ITransitionRelation)unmodifiableTransFormula2, (ITransitionRelation)unmodifiableTransFormula3, set);
            return Collections.singletonList(this.mStateFactory.getOrConstructState(term, sMTTheoryState2.getVariables()));
        }
        if (icfgEdge instanceof IReturnAction) {
            Set set = sMTTheoryState2.getPredicate().getVars().stream().filter(iProgramVar -> iProgramVar instanceof IProgramVar && iProgramVar.isOldvar()).map(iProgramVar -> iProgramVar).collect(Collectors.toSet());
            Set<TermVariable> set2 = set.stream().map(iProgramVar -> iProgramVar.getTermVariable()).collect(Collectors.toSet());
            Term term = this.mArrayTheoryOperationProvider.projectExistentially(set2, sMTTheoryState2.getPredicate().getFormula());
            SMTTheoryState sMTTheoryState3 = this.mStateFactory.getOrConstructState(term, sMTTheoryState2.getVariables());
            UnmodifiableTransFormula unmodifiableTransFormula = ((IReturnAction)icfgEdge).getTransformula();
            UnmodifiableTransFormula unmodifiableTransFormula4 = ((IReturnAction)icfgEdge).getLocalVarsAssignmentOfCall();
            UnmodifiableTransFormula unmodifiableTransFormula5 = this.mCsToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(icfgEdge.getPrecedingProcedure());
            Set set3 = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(icfgEdge.getPrecedingProcedure());
            Term term2 = (Term)this.mPredicateTransformer.strongestPostconditionReturn((IAbstractPredicate)sMTTheoryState.getPredicate(), (IAbstractPredicate)sMTTheoryState3.getPredicate(), (ITransitionRelation)unmodifiableTransFormula, (ITransitionRelation)unmodifiableTransFormula4, (ITransitionRelation)unmodifiableTransFormula5, set3);
            List<SMTTheoryState> list = Collections.singletonList(this.mStateFactory.getOrConstructState(term2, sMTTheoryState2.getVariables()));
            return list;
        }
        throw new UnsupportedOperationException();
    }

    public SMTTheoryStateFactoryAndPredicateHelper getStateFactory() {
        return this.mStateFactory;
    }

    public IAbstractPostOperator.EvalResult evaluate(SMTTheoryState sMTTheoryState, Term term, Script script) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

