/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.utils.spawner.Spawner;

public class SpawnerOutputStream
extends OutputStream {
    private Spawner.IChannel channel;

    static {
        System.loadLibrary("spawner");
    }

    public SpawnerOutputStream(Spawner.IChannel channel) {
        this.channel = channel;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] tmpBuf = new byte[len];
        System.arraycopy(b, off, tmpBuf, off, len);
        this.write0(this.channel, tmpBuf, len);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void close() throws IOException {
        if (this.channel == null) {
            return;
        }
        int status = this.close0(this.channel);
        if (status == -1) {
            throw new IOException("close error");
        }
        this.channel = null;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private native int write0(Spawner.IChannel var1, byte[] var2, int var3) throws IOException;

    private native int close0(Spawner.IChannel var1);
}

