/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellRepVarConstructor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellReplacementVarInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.CellVariableBuilder;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.EquivalentCells;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.TransFormulaLRWithArrayInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalyzer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransFormulaLRWithArrayCells {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    static final String s_AuxArray = "auxArray";
    private final ManagedScript mScript;
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mForeignReplacementVars = new NestedMap2();
    private final HashRelation<TermVariable, ArrayIndex> mForeignIndices = new HashRelation();
    private final TransFormulaLRWithArrayInformation tflrwai;
    private final ModifiableTransFormula mResult;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final Map<TermVariable, Map<ArrayIndex, TermVariable>> mArrayInstance2Index2CellVariable;
    private final EquivalentCells[] mEquivalentCells;
    private final boolean mOverapproximateByOmmitingDisjointIndices;
    private final HashRelation<Term, ArrayIndex> mFirstGeneration2Indices;
    private final IndexAnalysisResult mIndexAnalysisResult;
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellInVars;
    private NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellOutVars;
    private final Map<List<Term>, ArrayIndex> mIndexInstance2IndexRepresentative = new HashMap<List<Term>, ArrayIndex>();
    private final boolean mConsiderOnlyIndicesThatOccurInFormula = true;
    private final Set<TermVariable> mVariablesThatOccurInFormula;

    private Set<TermVariable> computeVarsThatOccurInFormula() {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(this.tflrwai.getTransFormulaLR().getFormula().getFreeVars()));
        hashSet.addAll(Arrays.asList(SmtUtils.and((Script)this.mScript.getScript(), (Collection)this.mIndexAnalysisResult.constructListOfEqualities(this.mScript.getScript())).getFreeVars()));
        if (!this.mOverapproximateByOmmitingDisjointIndices) {
            hashSet.addAll(Arrays.asList(SmtUtils.and((Script)this.mScript.getScript(), (Collection)this.mIndexAnalysisResult.constructListOfNotEquals(this.mScript.getScript())).getFreeVars()));
        }
        return hashSet;
    }

    public TransFormulaLRWithArrayCells(IUltimateServiceProvider iUltimateServiceProvider, ReplacementVarFactory replacementVarFactory, ManagedScript managedScript, TransFormulaLRWithArrayInformation transFormulaLRWithArrayInformation, EqualityAnalysisResult equalityAnalysisResult, IIcfgSymbolTable iIcfgSymbolTable, ArrayCellRepVarConstructor arrayCellRepVarConstructor, boolean bl, boolean bl2, SmtUtils.SimplificationTechnique simplificationTechnique) {
        Term term;
        Object object;
        EqualityAnalysisResult equalityAnalysisResult2;
        EqualityAnalysisResult equalityAnalysisResult3;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mSimplificationTechnique = simplificationTechnique;
        this.mOverapproximateByOmmitingDisjointIndices = bl;
        this.tflrwai = transFormulaLRWithArrayInformation;
        this.mScript = managedScript;
        this.mReplacementVarFactory = replacementVarFactory;
        if (!this.tflrwai.containsArrays()) {
            this.mResult = this.tflrwai.getTransFormulaLR();
            this.mVariablesThatOccurInFormula = null;
            this.mEquivalentCells = null;
            this.mArrayInstance2Index2CellVariable = null;
            this.mFirstGeneration2Indices = null;
            this.mIndexAnalysisResult = null;
            this.mArrayCellInVars = null;
            return;
        }
        this.mResult = new ModifiableTransFormula(transFormulaLRWithArrayInformation.getTransFormulaLR());
        this.mFirstGeneration2Indices = new HashRelation();
        this.mFirstGeneration2Indices.addAll(transFormulaLRWithArrayInformation.getArrayFirstGeneration2Indices());
        this.mArrayCellInVars = new NestedMap2();
        this.mArrayCellInVars.addAll(transFormulaLRWithArrayInformation.getArrayCellInVars());
        this.mArrayCellInVars.addAll(this.mForeignReplacementVars);
        this.mArrayCellOutVars = new NestedMap2();
        this.mArrayCellOutVars.addAll(transFormulaLRWithArrayInformation.getArrayCellOutVars());
        this.mArrayCellOutVars.addAll(this.mForeignReplacementVars);
        this.doSomething();
        if (bl2) {
            equalityAnalysisResult3 = Collections.emptySet();
            equalityAnalysisResult2 = new EqualityAnalysisResult((Set)equalityAnalysisResult3, (Set)equalityAnalysisResult3, (Set)equalityAnalysisResult3);
        } else {
            equalityAnalysisResult2 = equalityAnalysisResult;
        }
        equalityAnalysisResult3 = equalityAnalysisResult;
        IndexAnalyzer indexAnalyzer = new IndexAnalyzer(this.mResult.getFormula(), this.mFirstGeneration2Indices, iIcfgSymbolTable, this.mResult, equalityAnalysisResult2, equalityAnalysisResult3, this.mLogger, managedScript);
        this.mIndexAnalysisResult = indexAnalyzer.getResult();
        CellVariableBuilder cellVariableBuilder = new CellVariableBuilder(this.mResult, this, replacementVarFactory, this.mLogger, this.mFirstGeneration2Indices, this.mArrayCellInVars, this.mArrayCellOutVars);
        this.mVariablesThatOccurInFormula = this.computeVarsThatOccurInFormula();
        this.mArrayInstance2Index2CellVariable = cellVariableBuilder.getArrayInstance2Index2CellVariable();
        this.mEquivalentCells = new EquivalentCells[transFormulaLRWithArrayInformation.numberOfDisjuncts()];
        int n = 0;
        while (n < transFormulaLRWithArrayInformation.numberOfDisjuncts()) {
            this.mEquivalentCells[n] = new EquivalentCells(this.mScript.getScript(), this.mResult, transFormulaLRWithArrayInformation.getArrayEqualities().get(n), transFormulaLRWithArrayInformation.getArrayUpdates().get(n), this.mIndexAnalysisResult, this.mArrayInstance2Index2CellVariable);
            ++n;
        }
        Map[] mapArray = new Map[transFormulaLRWithArrayInformation.numberOfDisjuncts()];
        int n2 = 0;
        while (n2 < transFormulaLRWithArrayInformation.numberOfDisjuncts()) {
            mapArray[n2] = this.constructIndex2CellVariableSubstitution(this.mEquivalentCells[n2], n2);
            ++n2;
        }
        Term[] termArray = new Term[transFormulaLRWithArrayInformation.numberOfDisjuncts()];
        int n3 = 0;
        while (n3 < transFormulaLRWithArrayInformation.numberOfDisjuncts()) {
            termArray[n3] = this.mEquivalentCells[n3].getInOutEqauality();
            ++n3;
        }
        Term[] termArray2 = new Term[transFormulaLRWithArrayInformation.numberOfDisjuncts()];
        int n4 = 0;
        while (n4 < transFormulaLRWithArrayInformation.numberOfDisjuncts()) {
            termArray2[n4] = this.buildIndexValueConstraints(mapArray[n4], this.mEquivalentCells[n4]);
            ++n4;
        }
        Term[] termArray3 = new Term[transFormulaLRWithArrayInformation.numberOfDisjuncts()];
        int n5 = 0;
        while (n5 < transFormulaLRWithArrayInformation.numberOfDisjuncts()) {
            termArray3[n5] = this.buildArrayUpdateConstraints(transFormulaLRWithArrayInformation.getArrayUpdates().get(n5), mapArray[n5], this.mEquivalentCells[n5]);
            ++n5;
        }
        Term[] termArray4 = new Term[transFormulaLRWithArrayInformation.numberOfDisjuncts()];
        int n6 = 0;
        while (n6 < termArray4.length) {
            object = Substitution.apply((ManagedScript)this.mScript, (Map)mapArray[n6], (Term)transFormulaLRWithArrayInformation.getSunnf()[n6]);
            if (this.mOverapproximateByOmmitingDisjointIndices) {
                term = new Term[5];
            } else {
                term = new Term[6];
                term[5] = SmtUtils.and((Script)this.mScript.getScript(), (Collection)this.mIndexAnalysisResult.constructListOfNotEquals(this.mScript.getScript()));
            }
            term[0] = object;
            term[1] = termArray2[n6];
            term[2] = termArray3[n6];
            term[3] = termArray[n6];
            term[4] = Substitution.apply((ManagedScript)this.mScript, (Map)mapArray[n6], (Term)SmtUtils.and((Script)this.mScript.getScript(), (Collection)this.mIndexAnalysisResult.constructListOfEqualities(this.mScript.getScript())));
            termArray4[n6] = Substitution.apply((ManagedScript)this.mScript, (Map)mapArray[n6], (Term)SmtUtils.and((Script)this.mScript.getScript(), (Term[])term));
            ++n6;
        }
        Term term2 = SmtUtils.or((Script)this.mScript.getScript(), (Term[])termArray4);
        object = new HashSet<TermVariable>(cellVariableBuilder.getAuxVars());
        term = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (Term)term2, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
        assert (SmtUtils.isArrayFree((Term)term)) : "Result contains still arrays!";
        this.removeArrayInOutVars();
        this.mResult.setFormula(term);
        this.mResult.addAuxVars((Set)object);
    }

    private void removeArrayInOutVars() {
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>(this.filterArrays(this.mResult.getInVars().keySet()));
        for (IProgramVar iProgramVar : arrayList) {
            this.mResult.removeInVar(iProgramVar);
        }
        arrayList = new ArrayList<IProgramVar>(this.filterArrays(this.mResult.getOutVars().keySet()));
        for (IProgramVar iProgramVar : arrayList) {
            this.mResult.removeOutVar(iProgramVar);
        }
    }

    private Collection<IProgramVar> filterArrays(Set<IProgramVar> set) {
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        for (IProgramVar iProgramVar : set) {
            Sort sort = ReplacementVarUtils.getDefinition((IProgramVar)iProgramVar).getSort();
            if (!sort.isArraySort()) continue;
            arrayList.add(iProgramVar);
        }
        return arrayList;
    }

    public ArrayIndex getOrConstructIndexRepresentative(ArrayIndex arrayIndex) {
        ArrayIndex arrayIndex2 = this.mIndexInstance2IndexRepresentative.get(arrayIndex);
        if (arrayIndex2 == null) {
            arrayIndex2 = new ArrayIndex(ModifiableTransFormulaUtils.translateTermVariablesToDefinitions((ManagedScript)this.mScript, (ModifiableTransFormula)this.mResult, (List)arrayIndex));
            this.mIndexInstance2IndexRepresentative.put((List<Term>)arrayIndex, arrayIndex2);
        }
        return arrayIndex2;
    }

    public TransFormulaLRWithArrayInformation getTransFormulaLRWithArrayInformation() {
        return this.tflrwai;
    }

    public void doSomething() {
        for (Triple triple : this.mForeignReplacementVars.entrySet()) {
            IProgramVar iProgramVar2;
            ArrayCellReplacementVarInformation arrayCellReplacementVarInformation = (ArrayCellReplacementVarInformation)triple.getThird();
            assert (arrayCellReplacementVarInformation.getArrayRepresentative().equals(triple.getFirst()));
            assert (arrayCellReplacementVarInformation.getIndexRepresentative().equals(triple.getSecond()));
            Collection<IProgramVar> collection = arrayCellReplacementVarInformation.termVariableToRankVarMappingForIndex().values();
            for (IProgramVar iProgramVar2 : collection) {
                if (this.rankVarOccursInThisTransformula(iProgramVar2, this.mResult)) continue;
                this.addRankVar(iProgramVar2);
                throw new AssertionError((Object)"case may not occur any more");
            }
            iProgramVar2 = (TermVariable)this.tflrwai.getTransFormulaLR().getInVars().get(arrayCellReplacementVarInformation.getArrayRankVar());
            ArrayIndex arrayIndex = this.translateIndex(arrayCellReplacementVarInformation.getIndex(), arrayCellReplacementVarInformation.termVariableToRankVarMappingForIndex());
            this.mFirstGeneration2Indices.addPair((Object)iProgramVar2, (Object)arrayIndex);
        }
    }

    private ArrayIndex translateIndex(ArrayIndex arrayIndex, Map<TermVariable, IProgramVar> map) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Term term : arrayIndex) {
            Term term2 = this.translateIndexEntry(term, map);
            arrayList.add(term2);
        }
        return new ArrayIndex(arrayList);
    }

    private Term translateIndexEntry(Term term, Map<TermVariable, IProgramVar> map) {
        TermVariable termVariable;
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            termVariable = termVariableArray[n2];
            IProgramVar iProgramVar = map.get(termVariable);
            TermVariable termVariable2 = (TermVariable)this.mResult.getInVars().get(iProgramVar);
            hashMap.put(termVariable, termVariable2);
            ++n2;
        }
        termVariable = Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)term);
        return termVariable;
    }

    private void addRankVar(IProgramVar iProgramVar) {
        String string = SmtUtils.removeSmtQuoteCharacters((String)(iProgramVar.getGloballyUniqueId() + "_InOut"));
        Sort sort = ReplacementVarUtils.getDefinition((IProgramVar)iProgramVar).getSort();
        TermVariable termVariable = this.mReplacementVarFactory.getOrConstructAuxVar(string, sort);
        this.mResult.addInVar(iProgramVar, termVariable);
        this.mResult.addOutVar(iProgramVar, termVariable);
    }

    private boolean rankVarOccursInThisTransformula(IProgramVar iProgramVar, ModifiableTransFormula modifiableTransFormula) {
        Term term = (Term)modifiableTransFormula.getInVars().get(iProgramVar);
        Term term2 = (Term)modifiableTransFormula.getOutVars().get(iProgramVar);
        if (term == null && term2 == null) {
            return false;
        }
        if (term != null && term2 != null) {
            return true;
        }
        throw new AssertionError((Object)(String.valueOf(iProgramVar) + " occurs only as inVar or only as outVar"));
    }

    private boolean arrayOccursInThisTransFormulaAsInvar(TermVariable termVariable) {
        return this.tflrwai.getArrayCellInVars().keySet().contains(termVariable);
    }

    private boolean arrayCellOccursInThisTransFormula(TermVariable termVariable, List<Term> list) {
        return this.tflrwai.getArrayCellInVars().get((Object)termVariable).containsKey(list);
    }

    private Term buildArrayEqualityConstraints(TermVariable termVariable, TermVariable termVariable2) {
        Map<ArrayIndex, TermVariable> map = this.mArrayInstance2Index2CellVariable.get(termVariable2);
        Map<ArrayIndex, TermVariable> map2 = this.mArrayInstance2Index2CellVariable.get(termVariable);
        if (map == null && map2 == null) {
            return this.mScript.getScript().term("true", new Term[0]);
        }
        Term[] termArray = new Term[map.size()];
        int n = 0;
        for (List list : map.keySet()) {
            Term term = (Term)map.get(list);
            Term term2 = (Term)map2.get(list);
            termArray[n] = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)term2, (Term)term);
            ++n;
        }
        return SmtUtils.and((Script)this.mScript.getScript(), (Term[])termArray);
    }

    private Term buildArrayUpdateConstraints(List<ArrayUpdate> list, Map<Term, Term> map, EquivalentCells equivalentCells) {
        ArrayUpdate arrayUpdate2;
        Term[] termArray = new Term[list.size()];
        int n = 0;
        for (ArrayUpdate arrayUpdate2 : list) {
            termArray[n] = this.buildArrayUpdateConstraints(arrayUpdate2.getNewArray(), (TermVariable)arrayUpdate2.getOldArray(), arrayUpdate2.getIndex(), arrayUpdate2.getValue(), map, equivalentCells);
            ++n;
        }
        arrayUpdate2 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])termArray);
        assert (SmtUtils.extractApplicationTerms((String)"select", (Term)arrayUpdate2, (boolean)true).isEmpty()) : "contains select terms";
        return arrayUpdate2;
    }

    private Term buildArrayUpdateConstraints(TermVariable termVariable, TermVariable termVariable2, ArrayIndex arrayIndex, Term term, Map<Term, Term> map, EquivalentCells equivalentCells) {
        term = Substitution.apply((ManagedScript)this.mScript, map, (Term)term);
        Map<ArrayIndex, TermVariable> map2 = this.mArrayInstance2Index2CellVariable.get(termVariable);
        Map<ArrayIndex, TermVariable> map3 = this.mArrayInstance2Index2CellVariable.get(termVariable2);
        map2 = this.filterNonOccurring(map2);
        map3 = this.filterNonOccurring(map3);
        Term[] termArray = new Term[map2.size()];
        int n = 0;
        for (ArrayIndex arrayIndex2 : map2.keySet()) {
            TermVariable termVariable3 = map2.get(arrayIndex2);
            termVariable3 = equivalentCells.getInOutRepresentative(termVariable3);
            TermVariable termVariable4 = map3.get(arrayIndex2);
            termVariable4 = equivalentCells.getInOutRepresentative(termVariable4);
            Term term2 = this.pairwiseEqualityExploitDoubletons(arrayIndex2, arrayIndex, map);
            Term term3 = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)termVariable3, (Term)term);
            Term term4 = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)termVariable3, (Term)termVariable4);
            Term term5 = SmtUtils.not((Script)this.mScript.getScript(), (Term)term2);
            Term term6 = SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{term5, term3});
            Term term7 = SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{term2, term4});
            termArray[n] = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term6, term7});
            ++n;
        }
        return SmtUtils.and((Script)this.mScript.getScript(), (Term[])termArray);
    }

    private Map<ArrayIndex, TermVariable> filterNonOccurring(Map<ArrayIndex, TermVariable> map) {
        HashMap<ArrayIndex, TermVariable> hashMap = new HashMap<ArrayIndex, TermVariable>();
        for (Map.Entry<ArrayIndex, TermVariable> entry : map.entrySet()) {
            if (!entry.getKey().freeVarsAreSubset(this.mVariablesThatOccurInFormula)) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private Term buildIndexValueConstraints(Map<Term, Term> map, EquivalentCells equivalentCells) {
        Term[] termArray = new Term[this.mArrayInstance2Index2CellVariable.size()];
        int n = 0;
        for (Map.Entry<TermVariable, Map<ArrayIndex, TermVariable>> entry : this.mArrayInstance2Index2CellVariable.entrySet()) {
            Map<ArrayIndex, TermVariable> map2 = entry.getValue();
            map2 = this.filterNonOccurring(map2);
            termArray[n] = this.buildIndexValueConstraints(map2, map, equivalentCells);
            ++n;
        }
        return SmtUtils.and((Script)this.mScript.getScript(), (Term[])termArray);
    }

    private Term buildIndexValueConstraints(Map<ArrayIndex, TermVariable> map, Map<Term, Term> map2, EquivalentCells equivalentCells) {
        ArrayIndex[] arrayIndexArray = new ArrayIndex[map.size()];
        TermVariable[] termVariableArray = new TermVariable[map.size()];
        int n = 0;
        for (Map.Entry<ArrayIndex, TermVariable> entry : map.entrySet()) {
            arrayIndexArray[n] = entry.getKey();
            termVariableArray[n] = entry.getValue();
            ++n;
        }
        int n2 = map.size() * (map.size() - 1) / 2;
        Term[] termArray = new Term[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < map.size()) {
            int n5 = 0;
            while (n5 < n4) {
                ArrayIndex arrayIndex = arrayIndexArray[n4];
                ArrayIndex arrayIndex2 = arrayIndexArray[n5];
                TermVariable termVariable = termVariableArray[n4];
                TermVariable termVariable2 = termVariableArray[n5];
                TermVariable termVariable3 = equivalentCells.getInOutRepresentative(termVariable);
                TermVariable termVariable4 = equivalentCells.getInOutRepresentative(termVariable2);
                termArray[n3] = this.indexEqualityImpliesValueEquality(arrayIndex, arrayIndex2, (Term)termVariable3, (Term)termVariable4, map2);
                ++n3;
                ++n5;
            }
            ++n4;
        }
        Term term = SmtUtils.and((Script)this.mScript.getScript(), (Term[])termArray);
        return term;
    }

    private Term indexEqualityImpliesValueEquality(ArrayIndex arrayIndex, ArrayIndex arrayIndex2, Term term, Term term2, Map<Term, Term> map) {
        Term term3 = this.pairwiseEqualityExploitDoubletons(arrayIndex, arrayIndex2, map);
        Term term4 = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)term, (Term)term2);
        return SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{SmtUtils.not((Script)this.mScript.getScript(), (Term)term3), term4});
    }

    Term pairwiseEqualityExploitDoubletons(ArrayIndex arrayIndex, ArrayIndex arrayIndex2, Map<Term, Term> map) {
        assert (arrayIndex.size() == arrayIndex2.size());
        Term[] termArray = new Term[arrayIndex.size()];
        int n = 0;
        while (n < arrayIndex.size()) {
            Term term;
            Term term2 = arrayIndex.get(n);
            if (term2 == (term = arrayIndex2.get(n)) || this.mIndexAnalysisResult.isEqualDoubleton(term2, term)) {
                termArray[n] = this.mScript.getScript().term("true", new Term[0]);
            } else if (this.mIndexAnalysisResult.isDistinctDoubleton(term2, term)) {
                termArray[n] = this.mScript.getScript().term("false", new Term[0]);
            } else if (this.mIndexAnalysisResult.isUnknownDoubleton(term2, term) || this.mIndexAnalysisResult.isIgnoredDoubleton(term2, term)) {
                Term term3 = Substitution.apply((ManagedScript)this.mScript, map, (Term)term2);
                Term term4 = Substitution.apply((ManagedScript)this.mScript, map, (Term)term);
                termArray[n] = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)term3, (Term)term4);
            } else {
                throw new AssertionError((Object)"unknown doubleton");
            }
            ++n;
        }
        return SmtUtils.and((Script)this.mScript.getScript(), (Term[])termArray);
    }

    private Map<Term, Term> constructIndex2CellVariableSubstitution(EquivalentCells equivalentCells, int n) {
        TermVariable termVariable;
        TermVariable termVariable2;
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (MultiDimensionalSelect multiDimensionalSelect : this.tflrwai.getArrayReads().get(n)) {
            termVariable2 = this.mArrayInstance2Index2CellVariable.get(multiDimensionalSelect.getArray()).get(multiDimensionalSelect.getIndex());
            termVariable = equivalentCells.getInOutRepresentative(termVariable2);
            assert (termVariable != null);
            hashMap.put(multiDimensionalSelect.toTerm(this.mScript.getScript()), (Term)termVariable);
        }
        for (MultiDimensionalSelect multiDimensionalSelect : this.tflrwai.getAdditionalArrayReads()) {
            termVariable2 = this.mArrayInstance2Index2CellVariable.get(multiDimensionalSelect.getArray()).get(multiDimensionalSelect.getIndex());
            termVariable = equivalentCells.getInOutRepresentative(termVariable2);
            assert (termVariable != null);
            hashMap.put(multiDimensionalSelect.toTerm(this.mScript.getScript()), (Term)termVariable);
        }
        return hashMap;
    }

    public ModifiableTransFormula getResult() {
        return this.mResult;
    }
}

