/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation;

import de.uni_freiburg.informatik.ultimate.cdt.translation.LineDirectiveMapping;
import de.uni_freiburg.informatik.ultimate.cdt.translation.LineOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.CdtASTUtils;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.MergedLocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import java.util.HashSet;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class CLocation
extends CACSLLocation {
    private static final long serialVersionUID = -7497131349540138810L;
    private final IASTNode mNode;
    private final LineDirectiveMapping mLineDirectiveMapping;
    private final LineOffsetComputer mLineOffsetComputer;

    protected CLocation(IASTNode iASTNode, boolean bl, LineDirectiveMapping lineDirectiveMapping, LineOffsetComputer lineOffsetComputer) {
        super(bl);
        this.mNode = iASTNode;
        this.mLineDirectiveMapping = lineDirectiveMapping;
        this.mLineOffsetComputer = lineOffsetComputer;
    }

    public String getFileName() {
        if (this.mNode != null) {
            if (this.mLineDirectiveMapping == null) {
                return this.mNode.getFileLocation().getFileName();
            }
            int n = this.mNode.getFileLocation().getStartingLineNumber();
            String string = this.mNode.getFileLocation().getFileName();
            return (String)this.mLineDirectiveMapping.getOriginal(n, string).getSecond();
        }
        return null;
    }

    public int getStartLine() {
        if (this.mNode != null && this.mNode.getFileLocation() != null) {
            if (this.mLineDirectiveMapping == null) {
                return this.mNode.getFileLocation().getStartingLineNumber();
            }
            int n = this.mNode.getFileLocation().getStartingLineNumber();
            String string = this.mNode.getFileLocation().getFileName();
            return (Integer)this.mLineDirectiveMapping.getOriginal(n, string).getFirst();
        }
        return -1;
    }

    public int getEndLine() {
        if (this.mNode != null && this.mNode.getFileLocation() != null) {
            if (this.mLineDirectiveMapping == null) {
                return this.mNode.getFileLocation().getEndingLineNumber();
            }
            int n = this.mNode.getFileLocation().getEndingLineNumber();
            String string = this.mNode.getFileLocation().getFileName();
            return (Integer)this.mLineDirectiveMapping.getOriginal(n, string).getFirst();
        }
        return -1;
    }

    public int getStartColumn() {
        int n = this.getStartLine();
        if (this.mLineOffsetComputer == null || n == -1) {
            return -1;
        }
        int n2 = this.mLineOffsetComputer.getOffset(n);
        return this.mNode.getFileLocation().getNodeOffset() - n2 + 1;
    }

    public int getEndColumn() {
        int n = this.getEndLine();
        if (this.mLineOffsetComputer == null || n == -1) {
            return -1;
        }
        int n2 = this.mLineOffsetComputer.getOffset(n);
        return this.mNode.getFileLocation().getNodeOffset() + this.mNode.getFileLocation().getNodeLength() - n2 + 1;
    }

    public IASTNode getNode() {
        return this.mNode;
    }

    public LineDirectiveMapping getLineDirectiveMapping() {
        return this.mLineDirectiveMapping;
    }

    public LineOffsetComputer getLineOffsetComputer() {
        return this.mLineOffsetComputer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mNode != null) {
            stringBuilder.append("C: ");
            stringBuilder.append(this.mNode.getRawSignature());
            stringBuilder.append(" [");
            if (this.getStartLine() == this.getEndLine()) {
                stringBuilder.append(this.getStartLine());
            } else {
                stringBuilder.append(this.getStartLine());
                stringBuilder.append("-");
                stringBuilder.append(this.getEndLine());
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations == null) {
            return this;
        }
        if (iAnnotations instanceof CLocation) {
            CLocation cLocation = (CLocation)iAnnotations;
            boolean bl = this.ignoreDuringBacktranslation() && cLocation.ignoreDuringBacktranslation();
            IASTNode iASTNode = this.getMergedNode(cLocation);
            LineDirectiveMapping lineDirectiveMapping = this.mLineDirectiveMapping == null ? cLocation.getLineDirectiveMapping() : this.mLineDirectiveMapping;
            LineOffsetComputer lineOffsetComputer = this.mLineOffsetComputer == null ? cLocation.getLineOffsetComputer() : this.mLineOffsetComputer;
            return new CLocation(iASTNode, bl, lineDirectiveMapping, lineOffsetComputer);
        }
        if (iAnnotations instanceof ILocation) {
            return MergedLocation.mergeToMergeLocation((ILocation)this, (ILocation)((ILocation)iAnnotations));
        }
        throw new IAnnotations.UnmergeableAnnotationsException((IAnnotations)this, iAnnotations);
    }

    private IASTNode getMergedNode(CLocation cLocation) {
        IASTNode iASTNode = cLocation.getNode();
        IASTNode iASTNode2 = this.getNode();
        if (iASTNode2 == null && iASTNode == null) {
            return null;
        }
        if (iASTNode2 == null) {
            return iASTNode;
        }
        if (iASTNode == null) {
            return iASTNode2;
        }
        if (iASTNode2 instanceof IASTTranslationUnit) {
            return iASTNode;
        }
        if (iASTNode instanceof IASTTranslationUnit) {
            return iASTNode2;
        }
        HashSet<IASTNode> hashSet = new HashSet<IASTNode>();
        hashSet.add(iASTNode2);
        hashSet.add(iASTNode);
        return CdtASTUtils.findCommonParent(hashSet);
    }

    public String getFunction() {
        IASTFunctionDefinition iASTFunctionDefinition = CdtASTUtils.findScope(this.mNode);
        if (iASTFunctionDefinition == null) {
            return null;
        }
        return iASTFunctionDefinition.getDeclarator().getName().toString();
    }

    public CLocation getParent() {
        return new CLocation(this.mNode.getParent(), this.ignoreDuringBacktranslation(), this.mLineDirectiveMapping, this.mLineOffsetComputer);
    }
}

