/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.weakener;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.AbsIntPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarAbsIntRunner;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.weakener.InterpolantSequenceWeakener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AbsIntPredicateInterpolantSequenceWeakener<STATE extends IAbstractState<STATE>, LETTER extends IIcfgTransition<?>>
extends InterpolantSequenceWeakener<IHoareTripleChecker, AbsIntPredicate<STATE>, LETTER> {
    private Set<IProgramVar> mVarsToKeep = null;

    public AbsIntPredicateInterpolantSequenceWeakener(ILogger iLogger, IHoareTripleChecker iHoareTripleChecker, List<AbsIntPredicate<STATE>> list, List<LETTER> list2, AbsIntPredicate<STATE> absIntPredicate, AbsIntPredicate<STATE> absIntPredicate2, Script script, BasicPredicateFactory basicPredicateFactory, CegarAbsIntRunner.AbsIntStatisticsGenerator absIntStatisticsGenerator) {
        super(iLogger, iHoareTripleChecker, list, list2, absIntPredicate, absIntPredicate2, script, basicPredicateFactory, absIntStatisticsGenerator);
    }

    @Override
    protected AbsIntPredicate<STATE> refinePreState(AbsIntPredicate<STATE> absIntPredicate, LETTER LETTER, AbsIntPredicate<STATE> absIntPredicate2, int n) {
        AbsIntPredicate<STATE> absIntPredicate3 = this.removeUnneededVariables(absIntPredicate, LETTER);
        boolean bl = this.determineInductivity(absIntPredicate3, LETTER, absIntPredicate2, n);
        if (bl) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Result of weakening: Number of variables in state before: " + absIntPredicate.getVars().size() + ", Now: " + absIntPredicate3.getVars().size()));
            }
            return absIntPredicate3;
        }
        this.mLogger.debug((Object)"Unable to weaken prestate. Returning old prestate.");
        return absIntPredicate;
    }

    private boolean determineInductivity(AbsIntPredicate<STATE> absIntPredicate, LETTER LETTER, AbsIntPredicate<STATE> absIntPredicate2, int n) {
        IncrementalPlicationChecker.Validity validity;
        if (LETTER instanceof IInternalAction) {
            validity = this.mHtc.checkInternal(absIntPredicate, (IInternalAction)LETTER, absIntPredicate2);
        } else if (LETTER instanceof ICallAction) {
            validity = this.mHtc.checkCall(absIntPredicate, (ICallAction)LETTER, absIntPredicate2);
        } else if (LETTER instanceof IReturnAction) {
            AbsIntPredicate absIntPredicate3 = (AbsIntPredicate)this.mHierarchicalPreStates.get(n);
            assert (absIntPredicate3 != null);
            validity = this.mHtc.checkReturn(absIntPredicate, (IPredicate)absIntPredicate3, (IReturnAction)LETTER, absIntPredicate2);
        } else {
            throw new IllegalStateException("Transition type " + LETTER.getClass().getSimpleName() + " not supported.");
        }
        return validity == IncrementalPlicationChecker.Validity.VALID;
    }

    private AbsIntPredicate<STATE> removeUnneededVariables(AbsIntPredicate<STATE> absIntPredicate, LETTER LETTER) {
        String string;
        IAbstractState iAbstractState2;
        Set<Term> set;
        Object object2;
        if (this.mVarsToKeep == null) {
            this.mVarsToKeep = new HashSet<IProgramVar>();
        }
        Set set2 = LETTER.getTransformula().getInVars().keySet();
        Set set3 = LETTER.getTransformula().getOutVars().keySet();
        this.mVarsToKeep.addAll(set2);
        Set set4 = set3.stream().filter(iProgramVar -> !set2.contains(iProgramVar)).collect(Collectors.toSet());
        this.mVarsToKeep.removeAll(set4);
        this.mLogger.debug((Object)("Keeping variables " + String.valueOf(this.mVarsToKeep) + " for transition " + String.valueOf(LETTER)));
        HashSet<Object> hashSet = new HashSet<Object>();
        assert (absIntPredicate.getAbstractStates().size() > 0);
        int n = ((IAbstractState)absIntPredicate.getAbstractStates().stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("No states in preState."))).getVariables().size();
        int n2 = set4.size();
        this.reportWeakeningVarsNumRemoved(n2);
        int n3 = n - n2;
        if (n == 0 || n3 == n) {
            this.reportWeakeningRatio(1.0);
        } else {
            this.reportWeakeningRatio((double)n3 / (double)n);
        }
        for (Object object2 : absIntPredicate.getAbstractStates()) {
            if (object2.isBottom()) {
                hashSet.add(object2);
                continue;
            }
            set = object2.getVariables().stream().filter(iProgramVarOrConst -> !this.mVarsToKeep.contains(iProgramVarOrConst)).collect(Collectors.toSet());
            iAbstractState2 = object2.removeVariables(set);
            this.mLogger.debug((Object)("State before removing: " + String.valueOf(object2)));
            this.mLogger.debug((Object)("State after removing : " + String.valueOf(iAbstractState2)));
            hashSet.add(iAbstractState2);
        }
        object2 = hashSet.stream().map(iAbstractState -> iAbstractState.getTerm(this.mScript)).collect(Collectors.toSet());
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(SmtUtils.or((Script)this.mScript, (Collection)object2));
        set = absIntPredicate.getAbstractStates().stream().map(iAbstractState -> iAbstractState.getTerm(this.mScript)).collect(Collectors.toSet());
        if (this.mLogger.isDebugEnabled()) {
            iAbstractState2 = set.toArray(new Term[set.size()])[0];
            Term[] termArray = SmtUtils.getConjuncts((Term)iAbstractState2);
            Stream<Term> stream = Arrays.stream(termArray);
            string = stream.map(term -> term.toString()).collect(Collectors.joining("\n   "));
            this.mLogger.debug((Object)("PRE CONJUNCTS (" + termArray.length + "):"));
            this.mLogger.debug((Object)("   " + string));
            Term term2 = object2.toArray(new Term[object2.size()])[0];
            Term[] termArray2 = SmtUtils.getConjuncts((Term)term2);
            Stream<Term> stream2 = Arrays.stream(termArray2);
            String string2 = stream2.map(term -> term.toString()).collect(Collectors.joining("\n   "));
            this.mLogger.debug((Object)("POST CONJUNCTS (" + termArray2.length + "):"));
            this.mLogger.debug((Object)("   " + string2));
        }
        int n4 = set.stream().mapToInt(term -> SmtUtils.getConjuncts((Term)term).length).sum();
        int n5 = object2.stream().mapToInt(term -> SmtUtils.getConjuncts((Term)term).length).sum();
        int n6 = n4 - n5;
        this.reportConjunctReduction(n6);
        string = new AbsIntPredicate((IPredicate)basicPredicate, hashSet);
        return string;
    }
}

