/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PathProgramDumper;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.HistogramOfIterable;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class PathProgramDumpController<L extends IIcfgTransition<?>> {
    private static final PathProgramDumper.InputMode DUMP_PATH_PROGRAMS_INPUT_MODE = PathProgramDumper.InputMode.ICFG;
    private final IUltimateServiceProvider mServices;
    private final TAPreferences mPref;
    private final IIcfg<?> mIcfg;
    private final Set<Set<L>> mAlreadyDumped = new HashSet<Set<L>>();
    private final boolean mEnabled;
    private final boolean mDumpIfNotPerfect;
    private final int mDumpIfAnalyzedTooOften;
    private final TraceAbstractionPreferenceInitializer.PathProgramDumpStop mDumpStopMode;

    public PathProgramDumpController(IUltimateServiceProvider iUltimateServiceProvider, TAPreferences tAPreferences, IIcfg<?> iIcfg) {
        this.mServices = iUltimateServiceProvider;
        this.mPref = tAPreferences;
        this.mIcfg = iIcfg;
        this.mDumpIfNotPerfect = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Dump path programs if interpolant sequence is not perfect");
        this.mDumpIfAnalyzedTooOften = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getInt("Dump path programs if already analyzed N times");
        this.mEnabled = this.mDumpIfNotPerfect || this.mDumpIfAnalyzedTooOften > 0;
        this.mDumpStopMode = (TraceAbstractionPreferenceInitializer.PathProgramDumpStop)iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("Stop after dumping path program", TraceAbstractionPreferenceInitializer.PathProgramDumpStop.class);
    }

    public void reportPathProgram(IRun<L, ?> iRun, boolean bl, int n) {
        if (this.shouldDumpPathProgram(bl, iRun)) {
            this.doDump(iRun, n);
        }
    }

    private boolean shouldDumpPathProgram(boolean bl, IRun<L, ?> iRun) {
        if (!this.mEnabled) {
            return false;
        }
        if (this.mDumpIfNotPerfect && !bl) {
            return true;
        }
        if (this.mDumpIfAnalyzedTooOften > 0) {
            HistogramOfIterable histogramOfIterable = new HistogramOfIterable((Iterable)iRun.getWord());
            return histogramOfIterable.getMax() > this.mDumpIfAnalyzedTooOften;
        }
        return false;
    }

    private void doDump(IRun<L, ?> iRun, int n) {
        boolean bl = this.mAlreadyDumped.add(new HashSet(iRun.getWord().asList()));
        if (this.mDumpStopMode == TraceAbstractionPreferenceInitializer.PathProgramDumpStop.BEFORE_FIRST_DUPLICATE && !bl) {
            throw this.createToolchainCanceledException("stopped before dumping similar path program twice", n);
        }
        String string = this.mPref.dumpPath() + File.separator + this.mIcfg.getIdentifier() + "_" + n + ".bpl";
        new PathProgramDumper(this.mIcfg, this.mServices, iRun, string, DUMP_PATH_PROGRAMS_INPUT_MODE);
        if (this.mDumpStopMode == TraceAbstractionPreferenceInitializer.PathProgramDumpStop.AFTER_FIRST_DUMP) {
            throw this.createToolchainCanceledException("stopping after dumping path program", n);
        }
    }

    private ToolchainCanceledException createToolchainCanceledException(String string, int n) {
        String string2 = "trying to verify (iteration " + n + ")";
        return new ToolchainCanceledException(string, this.getClass(), string2);
    }
}

