/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqOperationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqStateFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqTransitionRelation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.TransFormulaConverterCache;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.VPDomainSettings;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EqPostOperator<ACTION extends IIcfgTransition<IcfgLocation>>
implements IAbstractPostOperator<EqState, ACTION> {
    private final ManagedScript mMgdScript;
    private final PredicateTransformer<EqDisjunctiveConstraint<EqNode>, EqPredicate, EqTransitionRelation> mPredicateTransformer;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mDoubleCheckPredicateTransformer;
    private final MonolithicImplicationChecker mDoubleCheckImplicationChecker;
    private final TransFormulaConverterCache mTransFormulaConverter;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final EqConstraintFactory<EqNode> mEqConstraintFactory;
    private final EqNodeAndFunctionFactory mEqNodeAndFunctionFactory;
    private final boolean mDebug = true;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final EqStateFactory mEqStateFactory;
    private final VPDomainSettings mSettings;
    private final BenchmarkWithCounters mBenchmark;

    public EqPostOperator(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, EqNodeAndFunctionFactory eqNodeAndFunctionFactory, EqConstraintFactory<EqNode> eqConstraintFactory, EqStateFactory eqStateFactory, VPDomainSettings vPDomainSettings) {
        this.mEqNodeAndFunctionFactory = eqNodeAndFunctionFactory;
        this.mEqConstraintFactory = eqConstraintFactory;
        this.mCfgSmtToolkit = cfgSmtToolkit;
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mEqStateFactory = eqStateFactory;
        this.mSettings = vPDomainSettings;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mPredicateTransformer = new PredicateTransformer(this.mMgdScript, (IDomainSpecificOperationProvider)new EqOperationProvider(eqConstraintFactory));
        this.mTransFormulaConverter = new TransFormulaConverterCache(this.mServices, this.mMgdScript, this.mEqNodeAndFunctionFactory, this.mEqConstraintFactory, this.mSettings);
        this.mEqStateFactory.registerTransformulaConverter(this.mTransFormulaConverter);
        this.mDoubleCheckPredicateTransformer = new PredicateTransformer(this.mMgdScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mMgdScript));
        this.mDoubleCheckImplicationChecker = new MonolithicImplicationChecker(this.mServices, this.mMgdScript);
        this.mBenchmark = new BenchmarkWithCounters();
        this.mBenchmark.registerCountersAndWatches(BmNames.getNames());
    }

    public List<EqState> apply(EqState eqState, ACTION ACTION) {
        this.debugStart(BmNames.APPLY_NORMAL);
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            this.debugEnd(BmNames.APPLY_NORMAL);
            return this.toEqStates((EqDisjunctiveConstraint<EqNode>)this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(false), (Set<IProgramVarOrConst>)eqState.getVariables());
        }
        EqTransitionRelation eqTransitionRelation = this.mTransFormulaConverter.getOrConstructEqTransitionRelationFromTransformula((TransFormula)ACTION.getTransformula());
        EqDisjunctiveConstraint eqDisjunctiveConstraint = (EqDisjunctiveConstraint)this.mPredicateTransformer.strongestPostcondition((IAbstractPredicate)eqState.toEqPredicate(), (ITransitionRelation)eqTransitionRelation);
        List<EqState> list = this.toEqStates((EqDisjunctiveConstraint<EqNode>)eqDisjunctiveConstraint, (Set<IProgramVarOrConst>)eqState.getVariables());
        assert (list.stream().allMatch(eqState2 -> eqState2.getVariables().containsAll(eqState.getVariables())));
        if (this.mSettings.isCheckPostCorrectness()) {
            this.mLogger.debug((Object)eqDisjunctiveConstraint.getDebugInfo());
            assert (this.preciseStrongestPostImpliesAbstractPost(eqState, ACTION, this.mEqStateFactory.statesToPredicate(list))) : "soundness check failed!";
        }
        this.debugEnd(BmNames.APPLY_NORMAL);
        return list;
    }

    private List<EqState> toEqStates(EqDisjunctiveConstraint<EqNode> eqDisjunctiveConstraint, Set<IProgramVarOrConst> set) {
        return eqDisjunctiveConstraint.getConstraints().stream().map(eqConstraint -> this.mEqStateFactory.getEqState((EqConstraint<EqNode>)eqConstraint, set)).collect(Collectors.toList());
    }

    private boolean preciseStrongestPostImpliesAbstractPost(EqState eqState, ACTION ACTION, IPredicate iPredicate) {
        Term term = (Term)this.mDoubleCheckPredicateTransformer.strongestPostcondition((IAbstractPredicate)eqState.toEqPredicate(), (ITransitionRelation)ACTION.getTransformula());
        EqPredicate eqPredicate = this.mEqStateFactory.termToPredicate(term, iPredicate);
        IncrementalPlicationChecker.Validity validity = this.mDoubleCheckImplicationChecker.checkImplication((IPredicate)eqPredicate, false, iPredicate, false);
        assert (validity != IncrementalPlicationChecker.Validity.INVALID) : "soundness check failed!";
        return validity != IncrementalPlicationChecker.Validity.INVALID;
    }

    public List<EqState> apply(EqState eqState, EqState eqState2, ACTION ACTION) {
        this.debugStart(BmNames.APPLY_RETURN);
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            this.debugEnd(BmNames.APPLY_RETURN);
            return this.toEqStates((EqDisjunctiveConstraint<EqNode>)this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(false), (Set<IProgramVarOrConst>)eqState2.getVariables());
        }
        if (ACTION instanceof ICallAction) {
            String string = ACTION.getSucceedingProcedure();
            EqTransitionRelation eqTransitionRelation = this.mTransFormulaConverter.getOrConstructEqTransitionRelationFromTransformula((TransFormula)((ICallAction)ACTION).getLocalVarsAssignment());
            EqTransitionRelation eqTransitionRelation2 = this.mTransFormulaConverter.getOrConstructEqTransitionRelationFromTransformula((TransFormula)this.mCfgSmtToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(string));
            EqTransitionRelation eqTransitionRelation3 = this.mTransFormulaConverter.getOrConstructEqTransitionRelationFromTransformula((TransFormula)this.mCfgSmtToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(string));
            Set set = this.mCfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(string);
            EqDisjunctiveConstraint eqDisjunctiveConstraint = (EqDisjunctiveConstraint)this.mPredicateTransformer.strongestPostconditionCall((IAbstractPredicate)eqState.toEqPredicate(), (ITransitionRelation)eqTransitionRelation, (ITransitionRelation)eqTransitionRelation2, (ITransitionRelation)eqTransitionRelation3, set);
            List<EqState> list = this.toEqStates((EqDisjunctiveConstraint<EqNode>)eqDisjunctiveConstraint, (Set<IProgramVarOrConst>)eqState2.getVariables());
            this.debugEnd(BmNames.APPLY_RETURN);
            return list;
        }
        if (ACTION instanceof IReturnAction) {
            EqPredicate eqPredicate = eqState.toEqPredicate();
            Set set = eqState2.getConstraint().getVariables(this.mCfgSmtToolkit.getSymbolTable()).stream().filter(iProgramVar -> iProgramVar.isOldvar()).collect(Collectors.toSet());
            Set set2 = set.stream().map(iProgramVar -> iProgramVar.getTermVariable()).collect(Collectors.toSet());
            EqConstraint eqConstraint = this.mEqConstraintFactory.projectExistentially(set2, eqState2.getConstraint(), false);
            EqState eqState3 = this.mEqStateFactory.getEqState((EqConstraint<EqNode>)eqConstraint, (Set<IProgramVarOrConst>)eqState2.getVariables());
            EqPredicate eqPredicate2 = eqState3.toEqPredicate();
            EqTransitionRelation eqTransitionRelation = this.mTransFormulaConverter.getOrConstructEqTransitionRelationFromTransformula((TransFormula)((IReturnAction)ACTION).getAssignmentOfReturn());
            EqTransitionRelation eqTransitionRelation4 = this.mTransFormulaConverter.getOrConstructEqTransitionRelationFromTransformula((TransFormula)((IReturnAction)ACTION).getLocalVarsAssignmentOfCall());
            EqTransitionRelation eqTransitionRelation5 = this.mTransFormulaConverter.getOrConstructEqTransitionRelationFromTransformula((TransFormula)this.mCfgSmtToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(ACTION.getPrecedingProcedure()));
            Set set3 = this.mCfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(ACTION.getPrecedingProcedure());
            EqDisjunctiveConstraint eqDisjunctiveConstraint = (EqDisjunctiveConstraint)this.mPredicateTransformer.strongestPostconditionReturn((IAbstractPredicate)eqPredicate, (IAbstractPredicate)eqPredicate2, (ITransitionRelation)eqTransitionRelation, (ITransitionRelation)eqTransitionRelation4, (ITransitionRelation)eqTransitionRelation5, set3);
            List<EqState> list = this.toEqStates((EqDisjunctiveConstraint<EqNode>)eqDisjunctiveConstraint, (Set<IProgramVarOrConst>)eqState2.getVariables());
            this.debugEnd(BmNames.APPLY_RETURN);
            return list;
        }
        this.debugEnd(BmNames.APPLY_RETURN);
        throw new UnsupportedOperationException();
    }

    public TransFormulaConverterCache getTransformulaConverterCache() {
        return this.mTransFormulaConverter;
    }

    public BenchmarkWithCounters getBenchmark() {
        return this.mBenchmark;
    }

    private void debugStart(BmNames bmNames) {
        this.mBenchmark.incrementCounter(bmNames.name());
        this.mBenchmark.unpauseWatch(bmNames.name());
    }

    private void debugEnd(BmNames bmNames) {
        this.mBenchmark.pauseWatch(bmNames.name());
    }

    public IAbstractPostOperator.EvalResult evaluate(EqState eqState, Term term, Script script) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private static enum BmNames {
        APPLY_NORMAL,
        APPLY_RETURN;


        static String[] getNames() {
            String[] stringArray = new String[BmNames.values().length];
            int n = 0;
            while (n < BmNames.values().length) {
                stringArray[n] = BmNames.values()[n].name();
                ++n;
            }
            return stringArray;
        }
    }
}

