/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class HavocStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(HavocStatement.class);
    VariableLHS[] identifiers;

    public HavocStatement(ILocation iLocation, VariableLHS[] variableLHSArray) {
        super(iLocation);
        this.identifiers = variableLHSArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid HavocStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HavocStatement").append('[');
        if (this.identifiers == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.identifiers.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.identifiers[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public VariableLHS[] getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.identifiers != null) {
            list.addAll(Arrays.asList(this.identifiers));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.identifiers != null) {
            VariableLHS[] variableLHSArray = this.identifiers;
            int n = this.identifiers.length;
            int n2 = 0;
            while (n2 < n) {
                VariableLHS variableLHS = variableLHSArray[n2];
                variableLHS.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        boolean bl = false;
        ArrayList<VariableLHS> arrayList = new ArrayList<VariableLHS>();
        if (this.identifiers != null) {
            VariableLHS[] variableLHSArray = this.identifiers;
            int n = this.identifiers.length;
            int n2 = 0;
            while (n2 < n) {
                VariableLHS variableLHS = variableLHSArray[n2];
                VariableLHS variableLHS2 = (VariableLHS)variableLHS.accept(generatedBoogieAstTransformer);
                bl = bl || variableLHS2 != variableLHS;
                arrayList.add(variableLHS2);
                ++n2;
            }
        }
        if (bl) {
            return new HavocStatement(this.loc, arrayList.toArray(new VariableLHS[0]));
        }
        return this;
    }
}

