/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;

public class NCSB {
    private final IntSet mNSet;
    private final IntSet mCSet;
    private final IntSet mSSet;
    private final IntSet mBSet;
    private IntSet mAllSets = null;
    private int hashCode;
    private boolean hasCode = false;

    public NCSB(IntSet intSet, IntSet intSet2, IntSet intSet3, IntSet intSet4) {
        this.mNSet = intSet;
        this.mCSet = intSet2;
        this.mSSet = intSet3;
        this.mBSet = intSet4;
    }

    public NCSB() {
        this.mNSet = UtilIntSet.newIntSet();
        this.mCSet = UtilIntSet.newIntSet();
        this.mSSet = UtilIntSet.newIntSet();
        this.mBSet = UtilIntSet.newIntSet();
    }

    public IntSet getNSet() {
        return this.mNSet;
    }

    public IntSet getCSet() {
        return this.mCSet;
    }

    public IntSet getSSet() {
        return this.mSSet;
    }

    public IntSet getBSet() {
        return this.mBSet;
    }

    public IntSet copyNSet() {
        return this.mNSet.clone();
    }

    public IntSet copyCSet() {
        return this.mCSet.clone();
    }

    public IntSet copySSet() {
        return this.mSSet.clone();
    }

    public IntSet copyBSet() {
        return this.mBSet.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NCSB nCSB = (NCSB)object;
        return this.contentEqual(nCSB);
    }

    private boolean contentEqual(NCSB nCSB) {
        return this.mNSet.equals(nCSB.mNSet) && this.mCSet.equals(nCSB.mCSet) && this.mSSet.equals(nCSB.mSSet) && this.mBSet.equals(nCSB.mBSet);
    }

    public boolean coveredBy(NCSB nCSB) {
        if (Options.lazyS && !nCSB.mBSet.subsetOf(this.mBSet)) {
            return false;
        }
        return nCSB.mNSet.subsetOf(this.mNSet) && nCSB.mCSet.subsetOf(this.mCSet) && nCSB.mSSet.subsetOf(this.mSSet);
    }

    public boolean strictlyCoveredBy(NCSB nCSB) {
        return nCSB.mNSet.subsetOf(this.mNSet) && nCSB.mCSet.subsetOf(this.mCSet) && nCSB.mSSet.subsetOf(this.mSSet) && nCSB.mBSet.subsetOf(this.mBSet);
    }

    private void initializeAllSets() {
        this.mAllSets = this.copyNSet();
        this.mAllSets.or(this.mCSet);
        this.mAllSets.or(this.mSSet);
    }

    public boolean subsetOf(NCSB nCSB) {
        if (this.mAllSets == null) {
            this.initializeAllSets();
        }
        if (nCSB.mAllSets == null) {
            nCSB.initializeAllSets();
        }
        return this.mAllSets.subsetOf(nCSB.mAllSets);
    }

    public NCSB clone() {
        return new NCSB(this.mNSet.clone(), this.mCSet.clone(), this.mSSet.clone(), this.mBSet.clone());
    }

    public String toString() {
        return "(" + this.mNSet.toString() + "," + this.mCSet.toString() + "," + this.mSSet.toString() + "," + this.mBSet.toString() + ")";
    }

    public int hashCode() {
        if (this.hasCode) {
            return this.hashCode;
        }
        this.hasCode = true;
        this.hashCode = 1;
        this.hashCode = 31 * this.hashCode + this.hashValue(this.mNSet);
        this.hashCode = 31 * this.hashCode + this.hashValue(this.mCSet);
        this.hashCode = 31 * this.hashCode + this.hashValue(this.mSSet);
        this.hashCode = 31 * this.hashCode + this.hashValue(this.mBSet);
        return this.hashCode;
    }

    private int hashValue(IntSet intSet) {
        int n = 1;
        for (int n2 : intSet.iterable()) {
            n = 31 * n + n2;
        }
        return n;
    }
}

