/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Converter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Generator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Hist;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Horn3Array;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.NwaWithArrays;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Partition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Solver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;

public class MinimizeNwaMaxSAT<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;

    public MinimizeNwaMaxSAT(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        ILogger iLogger = automataLibraryServices.getLoggingService().getLogger("Converter");
        ILogger iLogger2 = automataLibraryServices.getLoggingService().getLogger("NwaMinimizationClausesGenerator");
        ILogger iLogger3 = automataLibraryServices.getLoggingService().getLogger("Solver");
        iLogger.info((Object)"starting conversion");
        Converter<LETTER, STATE> converter = new Converter<LETTER, STATE>(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton);
        NwaWithArrays nwaWithArrays = converter.getNwa();
        ArrayList<Hist> arrayList = converter.computeHistoryStates();
        iLogger.info((Object)("finished conversion. " + nwaWithArrays.mNumStates + " states, " + nwaWithArrays.mNumISyms + " iSyms, " + nwaWithArrays.mNumCSyms + " cSyms, " + nwaWithArrays.mNumRSyms + " rSyms, " + nwaWithArrays.mITrans.length + " iTrans, " + nwaWithArrays.mCTrans.length + " cTrans, " + nwaWithArrays.mRTrans.length + " rTrans."));
        iLogger2.info((Object)"starting clauses generation");
        Horn3Array horn3Array = Generator.generateClauses(this.mServices, nwaWithArrays, arrayList);
        iLogger2.info((Object)("finished clauses generation. " + horn3Array.size() + " clauses"));
        iLogger3.info((Object)"starting Solver");
        char[] cArray = new Solver(this.mServices, horn3Array).solve();
        iLogger3.info((Object)"finished Solver");
        iLogger2.info((Object)"making equivalence classes from assignments");
        Partition partition = Generator.makeMergeRelation(nwaWithArrays.mNumStates, cArray);
        iLogger2.info((Object)"finished making equivalence classes");
        this.directResultConstruction(converter.constructMerged(partition));
        iLogger.info((Object)"constructed minimized automaton");
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }
}

