/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.ltl2aut;

import de.uni_freiburg.informatik.ultimate.acsl.parser.Parser;
import de.uni_freiburg.informatik.ultimate.core.lib.models.ObjectContainer;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GlobalLTLInvariant;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class LTLFileParser {
    private final ILogger mLogger;

    public LTLFileParser(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public IElement parse(File file) throws Exception {
        ACSLNode aCSLNode;
        Object object;
        this.mLogger.info((Object)"Using LTL file parser");
        String string = null;
        String string2 = null;
        try {
            object = null;
            aCSLNode = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("//") || string.isEmpty()) continue;
                    string2 = string;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException iOException) {
            string = null;
            throw iOException;
        }
        if (string2 == null) {
            throw new RuntimeException("LTL invariant file supplied but no LTL invariant found!");
        }
        object = this.transformToACSLComment(string2);
        aCSLNode = Parser.parseComment((String)object, (int)0, (int)0);
        if (!(aCSLNode instanceof GlobalLTLInvariant)) {
            throw new RuntimeException("Some ACSL Annotation, but no LTL Invariant found!");
        }
        this.mLogger.info((Object)("LTLInvariant: " + ((GlobalLTLInvariant)aCSLNode).getFormula().toString()));
        return new ObjectContainer((Object)aCSLNode);
    }

    private String transformToACSLComment(String string) {
        String string2 = this.transformToACSLLTLSyntax(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("gstart");
        stringBuilder.append('\n');
        stringBuilder.append("ltl invariant positive: ");
        stringBuilder.append(string2);
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    private String transformToACSLLTLSyntax(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"') {
                if (bl) {
                    stringBuilder.append(")");
                    bl = false;
                } else {
                    stringBuilder.append("AP(");
                    bl = true;
                }
            } else {
                stringBuilder.append(c);
            }
            ++n;
        }
        assert (!bl);
        string = stringBuilder.toString();
        string = string.replace("G", "[]");
        string = string.replace("F", "<>");
        return string;
    }
}

