/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.IdentityTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.IcfgLoop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.IcfgLoopDetection;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IcfgLoopTransformerMohr<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final IIcfg<OUTLOC> mResult;
    private final TransformedIcfgBuilder<INLOC, OUTLOC> mTib;
    private final ManagedScript mManagedScript;
    private final IIcfgSymbolTable mSymbolTable;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final Map<INLOC, Boolean> mOverApproximation = new HashMap<INLOC, Boolean>();

    public IcfgLoopTransformerMohr(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string) {
        this.mManagedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mSymbolTable = iIcfg.getCfgSmtToolkit().getSymbolTable();
        BasicIcfg basicIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), clazz);
        IdentityTransformer identityTransformer = new IdentityTransformer(iIcfg.getCfgSmtToolkit());
        this.mTib = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, iLocationFactory, icfgTransformationBacktranslator, identityTransformer, iIcfg, basicIcfg);
        this.transform(iIcfg);
        this.mTib.finish();
        this.mResult = basicIcfg;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug(this.mResult);
        }
    }

    private void transform(IIcfg<INLOC> iIcfg) {
        Object object;
        IcfgLoopDetection<INLOC> icfgLoopDetection = new IcfgLoopDetection<INLOC>(this.mLogger, this.mServices, iIcfg);
        Set<IcfgLoop<INLOC>> set = icfgLoopDetection.getResult();
        HashSet<INLOC> hashSet = new HashSet<INLOC>();
        HashSet<INLOC> hashSet2 = new HashSet<INLOC>();
        HashMap<INLOC, UnmodifiableTransFormula> hashMap = new HashMap<INLOC, UnmodifiableTransFormula>();
        HashMap hashMap2 = new HashMap();
        if (!set.isEmpty()) {
            for (IcfgLoop<INLOC> object22 : set) {
                hashSet.add(object22.getHead());
                hashSet2.addAll(object22.getLoopbody());
                hashMap.put(object22.getHead(), this.transformLoop(object22));
                hashMap2.put(object22.getHead(), new HashSet());
                for (Pair pair : object22.getLoopExits()) {
                    object = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (List)((List)pair.getFirst()));
                    this.mLogger.info((Object)("Found exit path: " + String.valueOf(object)));
                    ((Set)hashMap2.get(object22.getHead())).add(new Pair(object, (Object)((IcfgLocation)pair.getSecond())));
                }
            }
        }
        ArrayDeque<IcfgLocation> arrayDeque = new ArrayDeque<IcfgLocation>();
        HashSet hashSet3 = new HashSet();
        arrayDeque.add((IcfgLocation)iIcfg.getInitialNodes().iterator().next());
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            hashSet3.add(icfgLocation);
            object = this.mTib.createNewLocation(icfgLocation);
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                if (hashSet2.contains(icfgEdge.getTarget()) && !hashSet.contains(icfgEdge.getTarget()) || icfgLocation.equals((Object)icfgEdge.getTarget())) continue;
                if (!hashSet3.contains(icfgEdge.getTarget())) {
                    arrayDeque.add((IcfgLocation)icfgEdge.getTarget());
                }
                OUTLOC OUTLOC = this.mTib.createNewLocation((IcfgLocation)icfgEdge.getTarget());
                if (hashSet.contains(icfgLocation)) {
                    UnmodifiableTransFormula unmodifiableTransFormula = (UnmodifiableTransFormula)hashMap.get(icfgLocation);
                    UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, Arrays.asList(unmodifiableTransFormula, icfgEdge.getTransformula()));
                    this.mLogger.info((Object)("Loop Summary Transformula: " + String.valueOf(unmodifiableTransFormula2)));
                    IcfgInternalTransition icfgInternalTransition = this.mTib.createNewInternalTransition(object, OUTLOC, unmodifiableTransFormula2, this.mOverApproximation.get(icfgLocation));
                    new Overapprox("Because of loop acceleration", null).annotate((IElement)icfgInternalTransition);
                    for (Pair pair : (Set)hashMap2.get(icfgLocation)) {
                        OUTLOC OUTLOC2 = this.mTib.createNewLocation((IcfgLocation)pair.getSecond());
                        UnmodifiableTransFormula unmodifiableTransFormula3 = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, Arrays.asList(unmodifiableTransFormula, (UnmodifiableTransFormula)pair.getFirst()));
                        IcfgInternalTransition icfgInternalTransition2 = this.mTib.createNewInternalTransition(object, OUTLOC2, unmodifiableTransFormula3, this.mOverApproximation.get(icfgLocation));
                        new Overapprox("Because of loop acceleration", null).annotate((IElement)icfgInternalTransition2);
                    }
                    continue;
                }
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    this.mLogger.info((Object)("Return: " + String.valueOf(object) + " - " + String.valueOf(icfgEdge) + " -> " + String.valueOf(OUTLOC)));
                    arrayList.add(new Triple(object, OUTLOC, (Object)icfgEdge));
                    continue;
                }
                if (icfgEdge instanceof IIcfgCallTransition) {
                    this.mLogger.info((Object)("Call: " + String.valueOf(object) + " - " + String.valueOf(icfgEdge) + " -> " + String.valueOf(OUTLOC)));
                }
                this.mLogger.info((Object)("Internal: " + String.valueOf(object) + " - " + String.valueOf(icfgEdge) + " -> " + String.valueOf(OUTLOC)));
                this.mTib.createNewTransition(object, OUTLOC, icfgEdge);
            }
        }
        arrayList.forEach(triple -> {
            IcfgEdge icfgEdge = this.mTib.createNewTransition((IcfgLocation)triple.getFirst(), (IcfgLocation)triple.getSecond(), (IcfgEdge)triple.getThird());
        });
    }

    private UnmodifiableTransFormula transformLoop(IcfgLoop<INLOC> icfgLoop) {
        Set<TermVariable> set;
        Object object3;
        Object object2;
        ArrayList arrayList = new ArrayList();
        ArrayList<UnmodifiableTransFormula> arrayList2 = new ArrayList<UnmodifiableTransFormula>();
        SymbolicMemory symbolicMemory = new SymbolicMemory(this.mManagedScript, this.mLogger);
        int n = 0;
        ArrayDeque<TransFormula> arrayDeque = new ArrayDeque<TransFormula>();
        for (ArrayList<IcfgEdge> transFormula2 : icfgLoop.getPaths()) {
            object2 = new ArrayList<UnmodifiableTransFormula>();
            for (Object object3 : transFormula2) {
                if (icfgLoop.getNestedLoopHeads().contains(object3.getSource())) {
                    object2.add(this.transformLoop(icfgLoop.getNestedLoop((IcfgLocation)object3.getSource())));
                    this.mLogger.debug((Object)("nested Loop @" + String.valueOf(object3.getSource()) + " : " + String.valueOf(object2.get(object2.size() - 1))));
                }
                object2.add(object3.getTransformula());
            }
            object3 = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, object2);
            this.mLogger.debug((Object)("Path formulas: " + String.valueOf(object2)));
            this.mLogger.debug((Object)("Composition: " + String.valueOf(object3)));
            arrayDeque.addAll(this.getDisjunctsFromTransformula((TransFormula)object3));
        }
        while (!arrayDeque.isEmpty()) {
            SimultaneousUpdate simultaneousUpdate;
            TransFormula transFormula = (TransFormula)arrayDeque.remove();
            symbolicMemory.newPath();
            arrayList.add(new HashMap());
            try {
                simultaneousUpdate = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)this.mServices, (TransFormula)transFormula, (ManagedScript)this.mManagedScript);
            }
            catch (SimultaneousUpdate.SimultaneousUpdateException simultaneousUpdateException) {
                throw new IllegalArgumentException(simultaneousUpdateException.getMessage());
            }
            object2 = simultaneousUpdate.getDeterministicAssignment();
            object3 = simultaneousUpdate.getHavocedVars();
            this.mLogger.debug((Object)("Updates: " + String.valueOf(object2) + " havocs: " + String.valueOf(object3)));
            if (!object3.isEmpty()) {
                this.mOverApproximation.put(icfgLoop.getHead(), true);
            }
            arrayList2.add(TransFormulaUtils.computeGuard((UnmodifiableTransFormula)((UnmodifiableTransFormula)transFormula), (ManagedScript)this.mManagedScript, (IUltimateServiceProvider)this.mServices));
            for (Map.Entry entry : object2.entrySet()) {
                if (entry.getValue() instanceof ConstantTerm || entry.getValue() instanceof TermVariable) {
                    symbolicMemory.updateConst((IProgramVar)entry.getKey(), (Term)entry.getValue(), this.mSymbolTable);
                    continue;
                }
                if (entry.getValue() instanceof ApplicationTerm && ("+".equals(((ApplicationTerm)entry.getValue()).getFunction().getName()) || "-".equals(((ApplicationTerm)entry.getValue()).getFunction().getName()))) {
                    set = new HashSet<TermVariable>(Arrays.asList(((Term)entry.getValue()).getFreeVars()));
                    if (set.contains(((IProgramVar)entry.getKey()).getTermVariable())) {
                        symbolicMemory.updateInc((IProgramVar)entry.getKey(), (Term)entry.getValue(), this.mSymbolTable);
                        continue;
                    }
                    symbolicMemory.updateConst((IProgramVar)entry.getKey(), (Term)entry.getValue(), this.mSymbolTable);
                    continue;
                }
                symbolicMemory.updateUndefined((IProgramVar)entry.getKey(), this.mSymbolTable);
            }
            ++n;
        }
        ArrayList<Term> arrayList3 = new ArrayList<Term>();
        int n2 = 0;
        while (n2 < n) {
            arrayList3.add(symbolicMemory.getFormula(n2, (TransFormula)arrayList2.get(n2)));
            ++n2;
        }
        Term term = symbolicMemory.getVarUpdateTerm();
        if (term != null) {
            arrayList3.add(term);
        }
        arrayList3.add(symbolicMemory.getKappaMin());
        object2 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])arrayList3.toArray(new Term[arrayList3.size()]));
        object3 = symbolicMemory.getInVars();
        Map<IProgramVar, TermVariable> map = symbolicMemory.getOutVars();
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder((Map)object3, map, true, null, true, null, false);
        set = symbolicMemory.getKappas();
        set.addAll(symbolicMemory.getTaus());
        Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)object2);
        transFormulaBuilder.setFormula(term2);
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(set, this.mManagedScript);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        if (symbolicMemory.containsUndefined().booleanValue()) {
            this.mOverApproximation.put(icfgLoop.getHead(), true);
        } else {
            this.mOverApproximation.put(icfgLoop.getHead(), false);
        }
        return transFormulaBuilder.finishConstruction(this.mManagedScript);
    }

    private List<TransFormula> getDisjunctsFromTransformula(TransFormula transFormula) {
        Term[] termArray;
        Term term = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (Term)transFormula.getFormula());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("DNF: " + term.toStringDirect()));
        }
        if ((termArray = SmtUtils.getDisjuncts((Term)term)).length == 1) {
            return Collections.singletonList(transFormula);
        }
        ArrayList<TransFormula> arrayList = new ArrayList<TransFormula>(termArray.length);
        Map map = transFormula.getInVars();
        Map map2 = transFormula.getOutVars();
        Set set = transFormula.getNonTheoryConsts();
        Set set2 = Collections.emptySet();
        boolean bl = transFormula.getAuxVars().isEmpty();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray2[n2];
            Term term3 = SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)term2, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, map2, set.isEmpty(), set, set2.isEmpty(), set2, bl);
            transFormulaBuilder.setFormula(term3);
            transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
            UnmodifiableTransFormula unmodifiableTransFormula = transFormulaBuilder.finishConstruction(this.mManagedScript);
            arrayList.add((TransFormula)unmodifiableTransFormula);
            ++n2;
        }
        return arrayList;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }
}

