/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser.yaml;

import java.util.Objects;

public class FormatVersion
implements Comparable<FormatVersion> {
    protected final int mMajor;
    protected final int mMinor;

    public FormatVersion(int n, int n2) {
        FormatVersion.validateVersionNumber(n < 0, "Major number of FormatVersion cannot be negative!");
        FormatVersion.validateVersionNumber(n2 < 0, "Minor number of FormatVersion cannot be negative!");
        this.mMajor = n;
        this.mMinor = n2;
    }

    public static FormatVersion fromString(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid format version " + string);
        }
        try {
            return new FormatVersion(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid format version " + string);
        }
    }

    private static void validateVersionNumber(boolean bl, String string) {
        if (bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public int getMajor() {
        return this.mMajor;
    }

    public int getMinor() {
        return this.mMinor;
    }

    public int hashCode() {
        return Objects.hash(this.mMajor, this.mMinor);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FormatVersion formatVersion = (FormatVersion)object;
        return this.mMajor == formatVersion.mMajor && this.mMinor == formatVersion.mMinor;
    }

    @Override
    public int compareTo(FormatVersion formatVersion) {
        int n = Integer.compare(this.getMajor(), formatVersion.getMajor());
        if (n == 0) {
            return Integer.compare(this.getMinor(), formatVersion.getMinor());
        }
        return n;
    }

    public String toString() {
        return this.mMajor + "." + this.mMinor;
    }
}

